from src.util.make_test_constants import make_test_constants_without_genesis

test_constants = make_test_constants_without_genesis(
    {
        "DIFFICULTY_STARTING": 1,
        "DISCRIMINANT_SIZE_BITS": 8,
        "BLOCK_TIME_TARGET": 10,
        "DIFFICULTY_EPOCH": 12,  # The number of blocks per epoch
        "DIFFICULTY_DELAY": 3,  # EPOCH / WARP_FACTOR
        "PROPAGATION_THRESHOLD": 10,
        "PROPAGATION_DELAY_THRESHOLD": 20,
        "TX_PER_SEC": 1,
        "MEMPOOL_BLOCK_BUFFER": 10,
        "MIN_ITERS_STARTING": 50 * 1,
        "NUMBER_ZERO_BITS_CHALLENGE_SIG": 1,
        "CLVM_COST_RATIO_CONSTANT": 108,
        "COINBASE_FREEZE_PERIOD": 0,
        "GENESIS_BLOCK": b"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6D\x9c,h\xdf\x97\xc1\x9e\x88D'\xe4.\xe75\t\x82\xd4\x02\x05q\xea\xd0\x872a_\xf3\x9b\xd2\x16\xbf\xd60\xb6F\x07\x84\x98+\xec\x98\xb4\x9f\xeay\xd0\x85\xee5\xc5\xa6\x9b[\xac5\xd1\xb2\x11|c\xc5\xe3\x01\xe2\xf7\xd2e\x11\xda\x91\xbaH\xa5'\xb1\xd1e5=\xc3O\xcdr\xbaR\x0bD\xfe;\x00\xc3)\xea\xd3\x12\x00\x00\x00\x90\xbf\xef\xd3MQ]\xd2\xa0Kg\xb0\x83\xad\xd3?\xf7<\xb6\xb3s\xb8|n\xc0\xa5m\xbf{\x0b\x0b\x9f<\xffLF\xd9w/\xf0\x98\xf8\x870x\x1a\xd1P\xf5\xa4\x925,\xde{\x86\x87\t\x1b\x1fo\xe4^\x0e-\xa8\x17}\xb7/O\xd4\x13\x1d\x9b\xe0\xb4\x10:\x03\xe6j\xfb\xd0\x99\x1d]\xff\xe7\xc5\xf5K\xb9\xf2\xe6\x7fM\x04\x01\xcf\x95L\xb2I\xd7\x8f\x9e\xcd\xc1'\xefL dn\xef\xbd\xbf\xf0x\x18\x8f\x06u\x92BOVQ\xb5\x83\x03\xf2\x10\x00\x7f\xf8\xaa$\xd7\xb5li]\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xc4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x02\x01\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00_\x1e\xe6K\xe01\xecA\xe2p:\xc1\x04h\x81\xe9`\x97\xd4q\xee\xc7\xf1\x0f\x17*#n%\x0f2^\xcf\xf0\x80-\xb0\x02D\xda\xb7\x88q\xa7\x17)`\xb3\xca\x7f&\xc1\xc9\xf6\xd6\xec\xffg\xeb\x8f\x1e\xa6\xba\x9a\x14vH\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x06\xc4>\x0b\xaee\xf4\x13\x8ebH\xdff\xe60lFc\xe0\xf5N\xbb\x8e\xe7\xf5G\x17\x14\x9a\xe6\x90\xc70T\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00X\xdf*`\xd9.^k\xa0\xff\x1e\x1c\xb6`\x1c\xfbl\x81\xf0\xf6(.j\xd4\xc2\xc1[_\xc7~Oe\x00\x00\x01\xd1\xa9J \x00\x8b\x0f&\x19<\x9ac\r\x1e\xbf\xc5\x06\x9b@J\xaes\xe1E\x83\xa97\xe7H\x9e\xa3\xf9\x96y\xea\xb5\xcb\x00\x00\x00\x00\x8aA\xd5\x1b\xb8\xb4*\"\x1ej$\x8eO\xf1*\x1f[\xa6\xf8\xb9=\xe8\xc1\x98\x95`W\xd2\xea\xb4\x1e\xceZ\x1eL\x8e\x19\xdeT\x7f]\xdb\xa3?\xcb\xad\x97C\x18\xff/\xe1T\x8fVK\xc38\x87\xa1\xa4e\x1d\xc0v\xf4\x15\xfb(\xb6!\xe1KF\xf6\x998\xd2P\x8e\x0en\x81r}\x9dq\x161\nX\xbf^}uB\x00\x00\x00\x00\x00\x00\x00\x00\x83\xb9l!2\x0fz\xc0o\x86\x19\xdd\xb2{\x8c\xa7`a42\xf5\xaa\x87\xa0\rQQB\x1ah*\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6BWV\xaf\xdaf!%\x117\xe84tw\x87\x00\xc3\xfa\x1ah\xd8\xc4|\x9c\xae\xfb\xd4\x08\x93_In\xce7\xe4\xc9\xd8\xa3Z\xa5V =\xb6\xf2\t\xe8\x10\x18\xe8\\\x1c\xcc\xf4\xb6\x9f\xae\x96\xd7\x14<\x05w\xe6\x8a\x9d\xfaJ\xf8\"\xb0\xf0Q\x89\xd6b]&\xe2\xad'\x07c'\xacy\\\x8ezNw\xb3\x7f8f\x00\x00\x00\x00\x07\x02\x92E\x80A9\xa0",  # noqa: E501
    }
)

if __name__ == "__main__":
    from src.util.default_root import DEFAULT_ROOT_PATH
    from src.util.block_tools import BlockTools

    bt = BlockTools(root_path=DEFAULT_ROOT_PATH)
    new_genesis_block = bt.create_genesis_block(test_constants, bytes([0] * 32), b"0")

    print(bytes(new_genesis_block))
