"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
describe('Athena Workgroup Tags', () => {
    test('test tag spec correction', () => {
        const stack = new cdk.Stack();
        new lib_1.CfnWorkGroup(stack, 'Athena-Workgroup', {
            name: 'HelloWorld',
            description: 'A WorkGroup',
            recursiveDeleteOption: true,
            state: 'ENABLED',
            tags: [
                {
                    key: 'key1',
                    value: 'value1',
                },
                {
                    key: 'key2',
                    value: 'value2',
                }
            ],
            workGroupConfiguration: {
                requesterPaysEnabled: true,
                resultConfiguration: {
                    outputLocation: 's3://fakebucketme/athena/results/',
                },
            },
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Athena::WorkGroup', {
            Tags: [
                {
                    Key: 'key1',
                    Value: 'value1',
                },
                {
                    Key: 'key2',
                    Value: 'value2',
                },
            ],
        }));
    });
    test('test tag aspect spec correction', () => {
        const stack = new cdk.Stack();
        cdk.Tag.add(stack, 'key1', 'value1');
        cdk.Tag.add(stack, 'key2', 'value2');
        new lib_1.CfnWorkGroup(stack, 'Athena-Workgroup', {
            name: 'HelloWorld',
            description: 'A WorkGroup',
            recursiveDeleteOption: true,
            state: 'ENABLED',
            workGroupConfiguration: {
                requesterPaysEnabled: true,
                resultConfiguration: {
                    outputLocation: 's3://fakebucketme/athena/results/',
                },
            },
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::Athena::WorkGroup', {
            Tags: [
                {
                    Key: 'key1',
                    Value: 'value1',
                },
                {
                    Key: 'key2',
                    Value: 'value2',
                },
            ],
        }));
    });
});
//# sourceMappingURL=data:application/json;base64,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