# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['stac_api_validator']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.1',
 'pystac-client>=0.5.0,<0.6.0',
 'pystac[orjson]>=1.6.1,<2.0.0',
 'requests>=2.28.1,<3.0.0']

entry_points = \
{'console_scripts': ['stac-api-validator = stac_api_validator.__main__:main']}

setup_kwargs = {
    'name': 'stac-api-validator',
    'version': '0.0.0',
    'description': 'STAC API Validator',
    'long_description': '# STAC API Validator\n\n[![PyPI](https://img.shields.io/pypi/v/stac-api-validator.svg)][pypi_]\n[![Status](https://img.shields.io/pypi/status/stac-api-validator.svg)][status]\n[![Python Version](https://img.shields.io/pypi/pyversions/stac-api-validator)][python version]\n[![License](https://img.shields.io/pypi/l/stac-api-validator)][license]\n\n[![Read the documentation at https://stac-api-validator.readthedocs.io/](https://img.shields.io/readthedocs/stac-api-validator/latest.svg?label=Read%20the%20Docs)][read the docs]\n[![Tests](https://github.com/philvarner/stac-api-validator/workflows/Tests/badge.svg)][tests]\n[![Codecov](https://codecov.io/gh/philvarner/stac-api-validator/branch/main/graph/badge.svg)][codecov]\n\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][pre-commit]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/stac-api-validator/\n[status]: https://pypi.org/project/stac-api-validator/\n[python version]: https://pypi.org/project/stac-api-validator\n[read the docs]: https://stac-api-validator.readthedocs.io/\n[tests]: https://github.com/philvarner/stac-api-validator/actions?workflow=Tests\n[codecov]: https://app.codecov.io/gh/philvarner/stac-api-validator\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n\n## Installation\n\nSTAC API Validator requires Python 3.10 and [Poetry 1.2](https://python-poetry.org/docs/).\n\nInstall the package with development requirements:\n\n```console\n$ poetry install\n```\n\nNote: if `poetry update` or `poetry install` hang, try running `poetry cache clear --all pypi` to fix the issue.\n\nYou can now run the command-line interface:\n\n```console\n$ poetry run stac-api-validator\n```\n\n**Future Work** You can install _STAC API Validator_ via [pip] from [PyPI]:\n\n```console\n$ pip install stac-api-validator\n```\n\n## Usage\n\nPlease see the [Command-line Reference] for details.\n\n## Contributing\n\nContributions are very welcome.\nTo learn more, see the [Contributor Guide].\n\n## Features\n\n**Work in Progress** -- this currently only validates a subset of behavior\n\nThis validation suite focuses on validating STAC API interactions. Tools such as\n[pystac](https://github.com/stac-utils/pystac) and [stac4s](https://github.com/azavea/stac4s) do a\ngood job of validating STAC objects (Catalog, Collection, Item). This suite focuses on the STAC API behavior\nvalidation.\n\nThe three key concepts within a STAC API are:\n\n1. _Conformance classes_ advertising the capabilities of the API\n2. _Link relations_ between resources within the web API (hypermedia)\n3. _Parameters_ that filter search results\n\nThe conformance classes, as defined in the `conformsTo` field of the Landing Page (root, `/`), advertise to\nclients which capabilities are available in the API. Without this field, a client would not even be able to tell that a\nroot URI was a STAC API.\n\nThe link relations define how to navigate a STAC catalog through parent-child links and find resources such as the OpenAPI specification. While many OGC API and STAC API endpoint have a fixed value (e.g., `/collections`), it is preferable for clients discover the paths via hypermedia.\n\nThe parameters that filter results apply to the Items resource and Item Search endpoints.\n\nThe current validity status of several popular STAC API implementations can be found [here](../stac-api-validator/COMPLIANCE_REPORT.md).\n\n## Command-line Reference\n\nUsage:\n\n```\nUsage: stac-api-validator [OPTIONS]\n\n  STAC API Validator.\n\nOptions:\n  --version                       Show the version and exit.\n  --log-level TEXT                Logging level, one of DEBUG, INFO, WARN,\n                                  ERROR, CRITICAL\n  --root-url TEXT                 STAC API Root / Landing Page URL  [required]\n  --post / --no-post              Test all validations with POST method for\n                                  requests in addition to GET\n  --conformance [core|browseable|item-search|features|collections|children]\n                                  Conformance class URIs to validate\n                                  [required]\n  --help                          Show this message and exit.\n```\n\nExample:\n\n```\npoetry run stac-api-validator \\\n    --root-url https://cmr.earthdata.nasa.gov/stac/LARC_ASDC \\\n    --conformance core --conformance item-search --conformance features\n```\n\nExample output:\n\n```\nValidating https://cmr.earthdata.nasa.gov/stac/LARC_ASDC ...\nSTAC API - Core conformance class found.\nSTAC API - Item Search conformance class found.\nwarnings: none\nerrors:\n- service-desc (https://api.stacspec.org/v1.0.0-beta.1/openapi.yaml): should have content-type header \'application/vnd.oai.openapi+json;version=3.0\'\', actually \'text/yaml\'\n- service-desc (https://api.stacspec.org/v1.0.0-beta.1/openapi.yaml): should return JSON, instead got non-JSON text\n- GET Search with bbox=100.0, 0.0, 105.0, 1.0 returned status code 400\n- POST Search with bbox:[100.0, 0.0, 105.0, 1.0] returned status code 502\n- GET Search with bbox=100.0,0.0,0.0,105.0,1.0,1.0 returned status code 400\n- POST Search with bbox:[100.0, 0.0, 0.0, 105.0, 1.0, 1.0] returned status code 400\n```\n\nAdditionally, the `--no-post` option can be specified to only test GET requests, instead of the default of using\nboth GET and POST.\n\n## Validating OGC API Features - Part 1 compliance\n\nA STAC API that conforms to the "STAC API - Features" conformance class will also be a valid implementation\nof OGC API Features - Part 1. In general, this validator focuses on those aspects of API behavior that are\ndifferent between STAC and OGC. It is recommended that implementers also use the [OGC API Features - Part 1\nvalidation test suite](https://cite.opengeospatial.org/teamengine/about/ogcapi-features-1.0/1.0/site/) to\nvalidate conformance.\n\nFull instructions are available at the link above, but the simplest way to run this is with:\n\n```\ndocker run -p 8081:8080 ogccite/ets-ogcapi-features10\n```\n\nThen, open [http://localhost:8081/teamengine/](http://localhost:8081/teamengine/) and login with the\nusername and password `ogctest`, `Create a new session`, with Organization `OGC`, Specification `OGC API - Features`, `Start a new test session`, input he root URL for the service, and `Start`.\n\n## Common Mistakes\n\n- incorrect `conformsTo` in the Landing Page. This was added between STAC API 0.9 and 1.0. It should be the same as the value in the `conformsTo` in the OAFeat `/conformance` endpoint.\n- OGC API Features uses `data` relation link relation at the root to point to the Collections endpoint (`/collections`), not `collections` relation\n- media type for link relation `service-desc` and endpoint is `application/vnd.oai.openapi+json;version=3.0` (not `application/json`) and link relation `search` and endpoint is `application/geo+json` (not `application/json`)\n- Use of OCG API "req" urls instead of "conf" urls, e.g. `http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core` should be used, not `http://www.opengis.net/spec/ogcapi-features-1/1.0/req/core`\n\n## License\n\nDistributed under the terms of the [Apache 2.0 license][license],\n_STAC API Validator_ is free and open source software.\n\n## Issues\n\nIf you encounter any problems,\nplease [file an issue] along with a detailed description.\n\n## Credits\n\nThis project was generated from [@cjolowicz]\'s [Hypermodern Python Cookiecutter] template.\n\n[@cjolowicz]: https://github.com/cjolowicz\n[pypi]: https://pypi.org/\n[hypermodern python cookiecutter]: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n[file an issue]: https://github.com/philvarner/stac-api-validator/issues\n[pip]: https://pip.pypa.io/\n\n<!-- github-only -->\n\n[license]: https://github.com/philvarner/stac-api-validator/blob/main/LICENSE\n[contributor guide]: https://github.com/philvarner/stac-api-validator/blob/main/CONTRIBUTING.md\n[command-line reference]: https://stac-api-validator.readthedocs.io/en/latest/usage.html\n',
    'author': 'Phil Varner',
    'author_email': 'phil@philvarner.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/philvarner/stac-api-validator',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
