# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_container.api_client import ApiClient
from pulpcore.client.pulp_container.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RepositoriesContainerApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add(self, container_container_repository_href, recursive_manage, **kwargs):  # noqa: E501
        """Add content  # noqa: E501

        Trigger an asynchronous task to recursively add container content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add(container_container_repository_href, recursive_manage, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RecursiveManage recursive_manage: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_with_http_info(container_container_repository_href, recursive_manage, **kwargs)  # noqa: E501

    def add_with_http_info(self, container_container_repository_href, recursive_manage, **kwargs):  # noqa: E501
        """Add content  # noqa: E501

        Trigger an asynchronous task to recursively add container content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_with_http_info(container_container_repository_href, recursive_manage, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RecursiveManage recursive_manage: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'recursive_manage'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `add`")  # noqa: E501
        # verify the required parameter 'recursive_manage' is set
        if self.api_client.client_side_validation and ('recursive_manage' not in local_var_params or  # noqa: E501
                                                        local_var_params['recursive_manage'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recursive_manage` when calling `add`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recursive_manage' in local_var_params:
            body_params = local_var_params['recursive_manage']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}add/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def build_image(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Build an Image  # noqa: E501

        Trigger an asynchronous task to build an OCI image from a Containerfile. A new repository version is created with the new image and tag. This API is tech preview in Pulp Container 1.1. Backwards compatibility when upgrading is not guaranteed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.build_image(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param str containerfile_artifact: Artifact representing the Containerfile that should be used to run buildah.
        :param file containerfile: An uploaded Containerfile that should be used to run buildah.
        :param str tag: A tag name for the new image being built.
        :param object artifacts: A JSON string where each key is an artifact href and the value is it's relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.build_image_with_http_info(container_container_repository_href, **kwargs)  # noqa: E501

    def build_image_with_http_info(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Build an Image  # noqa: E501

        Trigger an asynchronous task to build an OCI image from a Containerfile. A new repository version is created with the new image and tag. This API is tech preview in Pulp Container 1.1. Backwards compatibility when upgrading is not guaranteed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.build_image_with_http_info(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param str containerfile_artifact: Artifact representing the Containerfile that should be used to run buildah.
        :param file containerfile: An uploaded Containerfile that should be used to run buildah.
        :param str tag: A tag name for the new image being built.
        :param object artifacts: A JSON string where each key is an artifact href and the value is it's relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'containerfile_artifact',
            'containerfile',
            'tag',
            'artifacts'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method build_image" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `build_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'containerfile_artifact' in local_var_params:
            form_params.append(('containerfile_artifact', local_var_params['containerfile_artifact']))  # noqa: E501
        if 'containerfile' in local_var_params:
            local_var_files['containerfile'] = local_var_params['containerfile']  # noqa: E501
        if 'tag' in local_var_params:
            form_params.append(('tag', local_var_params['tag']))  # noqa: E501
        if 'artifacts' in local_var_params:
            form_params.append(('artifacts', local_var_params['artifacts']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}build_image/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_manifests(self, container_container_repository_href, manifest_copy, **kwargs):  # noqa: E501
        """Copy manifests  # noqa: E501

        Trigger an asynchronous task to copy manifests  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_manifests(container_container_repository_href, manifest_copy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param ManifestCopy manifest_copy: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_manifests_with_http_info(container_container_repository_href, manifest_copy, **kwargs)  # noqa: E501

    def copy_manifests_with_http_info(self, container_container_repository_href, manifest_copy, **kwargs):  # noqa: E501
        """Copy manifests  # noqa: E501

        Trigger an asynchronous task to copy manifests  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_manifests_with_http_info(container_container_repository_href, manifest_copy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param ManifestCopy manifest_copy: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'manifest_copy'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_manifests" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `copy_manifests`")  # noqa: E501
        # verify the required parameter 'manifest_copy' is set
        if self.api_client.client_side_validation and ('manifest_copy' not in local_var_params or  # noqa: E501
                                                        local_var_params['manifest_copy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `manifest_copy` when calling `copy_manifests`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'manifest_copy' in local_var_params:
            body_params = local_var_params['manifest_copy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}copy_manifests/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_tags(self, container_container_repository_href, tag_copy, **kwargs):  # noqa: E501
        """Copy tags  # noqa: E501

        Trigger an asynchronous task to copy tags  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_tags(container_container_repository_href, tag_copy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param TagCopy tag_copy: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.copy_tags_with_http_info(container_container_repository_href, tag_copy, **kwargs)  # noqa: E501

    def copy_tags_with_http_info(self, container_container_repository_href, tag_copy, **kwargs):  # noqa: E501
        """Copy tags  # noqa: E501

        Trigger an asynchronous task to copy tags  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_tags_with_http_info(container_container_repository_href, tag_copy, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param TagCopy tag_copy: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'tag_copy'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_tags" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `copy_tags`")  # noqa: E501
        # verify the required parameter 'tag_copy' is set
        if self.api_client.client_side_validation and ('tag_copy' not in local_var_params or  # noqa: E501
                                                        local_var_params['tag_copy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tag_copy` when calling `copy_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tag_copy' in local_var_params:
            body_params = local_var_params['tag_copy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}copy_tags/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create(self, container_container_repository, **kwargs):  # noqa: E501
        """Create a container repository  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(container_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContainerContainerRepository container_container_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerContainerRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(container_container_repository, **kwargs)  # noqa: E501

    def create_with_http_info(self, container_container_repository, **kwargs):  # noqa: E501
        """Create a container repository  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(container_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ContainerContainerRepository container_container_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerContainerRepositoryResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository' is set
        if self.api_client.client_side_validation and ('container_container_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_container_repository' in local_var_params:
            body_params = local_var_params['container_container_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/repositories/container/container/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerContainerRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Delete a container repository  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(container_container_repository_href, **kwargs)  # noqa: E501

    def delete_with_http_info(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Delete a container repository  # noqa: E501

        Trigger an asynchronous delete task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List container repositorys  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name: name
        :param str name__in: name__in
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedcontainerContainerRepositoryResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(**kwargs)  # noqa: E501

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List container repositorys  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name: name
        :param str name__in: name__in
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedcontainerContainerRepositoryResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'name',
            'name__in',
            'offset',
            'ordering',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/repositories/container/container/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedcontainerContainerRepositoryResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update(self, container_container_repository_href, patchedcontainer_container_repository, **kwargs):  # noqa: E501
        """Update a container repository  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update(container_container_repository_href, patchedcontainer_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param PatchedcontainerContainerRepository patchedcontainer_container_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_with_http_info(container_container_repository_href, patchedcontainer_container_repository, **kwargs)  # noqa: E501

    def partial_update_with_http_info(self, container_container_repository_href, patchedcontainer_container_repository, **kwargs):  # noqa: E501
        """Update a container repository  # noqa: E501

        Trigger an asynchronous partial update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_with_http_info(container_container_repository_href, patchedcontainer_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param PatchedcontainerContainerRepository patchedcontainer_container_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'patchedcontainer_container_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'patchedcontainer_container_repository' is set
        if self.api_client.client_side_validation and ('patchedcontainer_container_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['patchedcontainer_container_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patchedcontainer_container_repository` when calling `partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patchedcontainer_container_repository' in local_var_params:
            body_params = local_var_params['patchedcontainer_container_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Inspect a container repository  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ContainerContainerRepositoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(container_container_repository_href, **kwargs)  # noqa: E501

    def read_with_http_info(self, container_container_repository_href, **kwargs):  # noqa: E501
        """Inspect a container repository  # noqa: E501

        ViewSet for container repo.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(container_container_repository_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ContainerContainerRepositoryResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContainerContainerRepositoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove(self, container_container_repository_href, recursive_manage, **kwargs):  # noqa: E501
        """Remove content  # noqa: E501

        Trigger an async task to recursively remove container content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove(container_container_repository_href, recursive_manage, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RecursiveManage recursive_manage: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_with_http_info(container_container_repository_href, recursive_manage, **kwargs)  # noqa: E501

    def remove_with_http_info(self, container_container_repository_href, recursive_manage, **kwargs):  # noqa: E501
        """Remove content  # noqa: E501

        Trigger an async task to recursively remove container content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_with_http_info(container_container_repository_href, recursive_manage, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RecursiveManage recursive_manage: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'recursive_manage'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `remove`")  # noqa: E501
        # verify the required parameter 'recursive_manage' is set
        if self.api_client.client_side_validation and ('recursive_manage' not in local_var_params or  # noqa: E501
                                                        local_var_params['recursive_manage'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recursive_manage` when calling `remove`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recursive_manage' in local_var_params:
            body_params = local_var_params['recursive_manage']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}remove/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sync(self, container_container_repository_href, repository_sync_url, **kwargs):  # noqa: E501
        """Sync from a remote  # noqa: E501

        Trigger an asynchronous task to sync content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync(container_container_repository_href, repository_sync_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RepositorySyncURL repository_sync_url: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sync_with_http_info(container_container_repository_href, repository_sync_url, **kwargs)  # noqa: E501

    def sync_with_http_info(self, container_container_repository_href, repository_sync_url, **kwargs):  # noqa: E501
        """Sync from a remote  # noqa: E501

        Trigger an asynchronous task to sync content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sync_with_http_info(container_container_repository_href, repository_sync_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param RepositorySyncURL repository_sync_url: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'repository_sync_url'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sync" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `sync`")  # noqa: E501
        # verify the required parameter 'repository_sync_url' is set
        if self.api_client.client_side_validation and ('repository_sync_url' not in local_var_params or  # noqa: E501
                                                        local_var_params['repository_sync_url'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repository_sync_url` when calling `sync`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'repository_sync_url' in local_var_params:
            body_params = local_var_params['repository_sync_url']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}sync/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tag(self, container_container_repository_href, tag_image, **kwargs):  # noqa: E501
        """Create a Tag  # noqa: E501

        Trigger an asynchronous task to tag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag(container_container_repository_href, tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param TagImage tag_image: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.tag_with_http_info(container_container_repository_href, tag_image, **kwargs)  # noqa: E501

    def tag_with_http_info(self, container_container_repository_href, tag_image, **kwargs):  # noqa: E501
        """Create a Tag  # noqa: E501

        Trigger an asynchronous task to tag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tag_with_http_info(container_container_repository_href, tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param TagImage tag_image: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'tag_image'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `tag`")  # noqa: E501
        # verify the required parameter 'tag_image' is set
        if self.api_client.client_side_validation and ('tag_image' not in local_var_params or  # noqa: E501
                                                        local_var_params['tag_image'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tag_image` when calling `tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tag_image' in local_var_params:
            body_params = local_var_params['tag_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}tag/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def untag(self, container_container_repository_href, un_tag_image, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        Trigger an asynchronous task to untag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untag(container_container_repository_href, un_tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param UnTagImage un_tag_image: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.untag_with_http_info(container_container_repository_href, un_tag_image, **kwargs)  # noqa: E501

    def untag_with_http_info(self, container_container_repository_href, un_tag_image, **kwargs):  # noqa: E501
        """Delete a tag  # noqa: E501

        Trigger an asynchronous task to untag an image in the repository  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.untag_with_http_info(container_container_repository_href, un_tag_image, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param UnTagImage un_tag_image: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'un_tag_image'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method untag" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `untag`")  # noqa: E501
        # verify the required parameter 'un_tag_image' is set
        if self.api_client.client_side_validation and ('un_tag_image' not in local_var_params or  # noqa: E501
                                                        local_var_params['un_tag_image'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `un_tag_image` when calling `untag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'un_tag_image' in local_var_params:
            body_params = local_var_params['un_tag_image']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}untag/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, container_container_repository_href, container_container_repository, **kwargs):  # noqa: E501
        """Update a container repository  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(container_container_repository_href, container_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param ContainerContainerRepository container_container_repository: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AsyncOperationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_with_http_info(container_container_repository_href, container_container_repository, **kwargs)  # noqa: E501

    def update_with_http_info(self, container_container_repository_href, container_container_repository, **kwargs):  # noqa: E501
        """Update a container repository  # noqa: E501

        Trigger an asynchronous update task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(container_container_repository_href, container_container_repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str container_container_repository_href: (required)
        :param ContainerContainerRepository container_container_repository: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AsyncOperationResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'container_container_repository_href',
            'container_container_repository'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'container_container_repository_href' is set
        if self.api_client.client_side_validation and ('container_container_repository_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository_href` when calling `update`")  # noqa: E501
        # verify the required parameter 'container_container_repository' is set
        if self.api_client.client_side_validation and ('container_container_repository' not in local_var_params or  # noqa: E501
                                                        local_var_params['container_container_repository'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `container_container_repository` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_container_repository_href' in local_var_params:
            path_params['container_container_repository_href'] = local_var_params['container_container_repository_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'container_container_repository' in local_var_params:
            body_params = local_var_params['container_container_repository']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{container_container_repository_href}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncOperationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
