"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.d_source_hooks import DSourceHooks
    from delphix.api.gateway.model.name_value_pair import NameValuePair
    from delphix.api.gateway.model.oracle_logsync_mode_type_enum import OracleLogsyncModeTypeEnum
    globals()['DSourceHooks'] = DSourceHooks
    globals()['NameValuePair'] = NameValuePair
    globals()['OracleLogsyncModeTypeEnum'] = OracleLogsyncModeTypeEnum


class UpdateOracleDsourceParameters(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('db_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('db_password',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('environment_user_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('rman_channels',): {
            'inclusive_maximum': 32,
            'inclusive_minimum': 1,
        },
        ('files_per_set',): {
            'inclusive_maximum': 64,
            'inclusive_minimum': 1,
        },
        ('external_file_path',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('template_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('logsync_interval',): {
            'inclusive_minimum': 5,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'name': (str,),  # noqa: E501
            'db_username': (str,),  # noqa: E501
            'db_password': (str,),  # noqa: E501
            'validate_db_credentials': (bool,),  # noqa: E501
            'environment_user_id': (str,),  # noqa: E501
            'backup_level_enabled': (bool,),  # noqa: E501
            'rman_channels': (int,),  # noqa: E501
            'files_per_set': (int,),  # noqa: E501
            'check_logical': (bool,),  # noqa: E501
            'encrypted_linking_enabled': (bool,),  # noqa: E501
            'compressed_linking_enabled': (bool,),  # noqa: E501
            'bandwidth_limit': (int,),  # noqa: E501
            'number_of_connections': (int,),  # noqa: E501
            'validate_by_opening_db_in_read_only_mode': (bool,),  # noqa: E501
            'pre_provisioning_enabled': (bool,),  # noqa: E501
            'diagnose_no_logging_faults': (bool,),  # noqa: E501
            'rac_max_instance_lag': (int,),  # noqa: E501
            'allow_auto_staging_restart_on_host_reboot': (bool,),  # noqa: E501
            'physical_standby': (bool,),  # noqa: E501
            'external_file_path': (str,),  # noqa: E501
            'hooks': (DSourceHooks,),  # noqa: E501
            'custom_env_variables_pairs': ([NameValuePair],),  # noqa: E501
            'custom_env_variables_paths': ([str],),  # noqa: E501
            'staging_database_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'template_id': (str,),  # noqa: E501
            'logsync_enabled': (bool,),  # noqa: E501
            'logsync_mode': (OracleLogsyncModeTypeEnum,),  # noqa: E501
            'logsync_interval': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'db_username': 'db_username',  # noqa: E501
        'db_password': 'db_password',  # noqa: E501
        'validate_db_credentials': 'validate_db_credentials',  # noqa: E501
        'environment_user_id': 'environment_user_id',  # noqa: E501
        'backup_level_enabled': 'backup_level_enabled',  # noqa: E501
        'rman_channels': 'rman_channels',  # noqa: E501
        'files_per_set': 'files_per_set',  # noqa: E501
        'check_logical': 'check_logical',  # noqa: E501
        'encrypted_linking_enabled': 'encrypted_linking_enabled',  # noqa: E501
        'compressed_linking_enabled': 'compressed_linking_enabled',  # noqa: E501
        'bandwidth_limit': 'bandwidth_limit',  # noqa: E501
        'number_of_connections': 'number_of_connections',  # noqa: E501
        'validate_by_opening_db_in_read_only_mode': 'validate_by_opening_db_in_read_only_mode',  # noqa: E501
        'pre_provisioning_enabled': 'pre_provisioning_enabled',  # noqa: E501
        'diagnose_no_logging_faults': 'diagnose_no_logging_faults',  # noqa: E501
        'rac_max_instance_lag': 'rac_max_instance_lag',  # noqa: E501
        'allow_auto_staging_restart_on_host_reboot': 'allow_auto_staging_restart_on_host_reboot',  # noqa: E501
        'physical_standby': 'physical_standby',  # noqa: E501
        'external_file_path': 'external_file_path',  # noqa: E501
        'hooks': 'hooks',  # noqa: E501
        'custom_env_variables_pairs': 'custom_env_variables_pairs',  # noqa: E501
        'custom_env_variables_paths': 'custom_env_variables_paths',  # noqa: E501
        'staging_database_config_params': 'staging_database_config_params',  # noqa: E501
        'template_id': 'template_id',  # noqa: E501
        'logsync_enabled': 'logsync_enabled',  # noqa: E501
        'logsync_mode': 'logsync_mode',  # noqa: E501
        'logsync_interval': 'logsync_interval',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """UpdateOracleDsourceParameters - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The unique name of the dSource within a group.. [optional]  # noqa: E501
            db_username (str): The username of the database user.. [optional]  # noqa: E501
            db_password (str): The password of the database user.. [optional]  # noqa: E501
            validate_db_credentials (bool): Whether db_username and db_password must be validated, if present, against the dSource. This must be set to false when credentials validation is not possible, for instance if the dSource is known to be disabled.. [optional] if omitted the server will use the default value of True  # noqa: E501
            environment_user_id (str): The environment user ID to use to connect to the target environment.. [optional]  # noqa: E501
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional]  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional]  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this dSource.. [optional]  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional]  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional]  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional]  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Whether the snaphots of this dSource's staging database will be validated by opening it in read-only mode.. [optional]  # noqa: E501
            pre_provisioning_enabled (bool): Boolean flag indicating whether or not pre-provisioning is turned on for this dSource.. [optional]  # noqa: E501
            diagnose_no_logging_faults (bool): If true, NOLOGGING operations on this dSource are treated as faults and cannot be resolved manually.. [optional]  # noqa: E501
            rac_max_instance_lag (int): Maximum number of log sequences to allow a RAC instance to lag before considering the instance offline.. [optional]  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Allow auto restart of staging source on host reboot.. [optional]  # noqa: E501
            physical_standby (bool): If true, convert this dSource's staging database to a physical standby.. [optional]  # noqa: E501
            external_file_path (str): External file path.. [optional]  # noqa: E501
            hooks (DSourceHooks): [optional]  # noqa: E501
            custom_env_variables_pairs ([NameValuePair]): An array of name value pair of environment variables.. [optional]  # noqa: E501
            custom_env_variables_paths ([str]): An array of strings of whitespace-separated parameters to be passed to the source command. The first parameter must be an absolute path to a file that exists on the target environment. Every subsequent parameter will be treated as an argument interpreted by the environment file.. [optional]  # noqa: E501
            staging_database_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Database configuration parameter overrides.. [optional]  # noqa: E501
            template_id (str): The template ID of the target Oracle Staging Push dSource.. [optional]  # noqa: E501
            logsync_enabled (bool): True if LogSync is enabled for this dSource.. [optional]  # noqa: E501
            logsync_mode (OracleLogsyncModeTypeEnum): [optional]  # noqa: E501
            logsync_interval (int): Interval between LogSync requests, in seconds.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """UpdateOracleDsourceParameters - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The unique name of the dSource within a group.. [optional]  # noqa: E501
            db_username (str): The username of the database user.. [optional]  # noqa: E501
            db_password (str): The password of the database user.. [optional]  # noqa: E501
            validate_db_credentials (bool): Whether db_username and db_password must be validated, if present, against the dSource. This must be set to false when credentials validation is not possible, for instance if the dSource is known to be disabled.. [optional] if omitted the server will use the default value of True  # noqa: E501
            environment_user_id (str): The environment user ID to use to connect to the target environment.. [optional]  # noqa: E501
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional]  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional]  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this dSource.. [optional]  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional]  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional]  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional]  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Whether the snaphots of this dSource's staging database will be validated by opening it in read-only mode.. [optional]  # noqa: E501
            pre_provisioning_enabled (bool): Boolean flag indicating whether or not pre-provisioning is turned on for this dSource.. [optional]  # noqa: E501
            diagnose_no_logging_faults (bool): If true, NOLOGGING operations on this dSource are treated as faults and cannot be resolved manually.. [optional]  # noqa: E501
            rac_max_instance_lag (int): Maximum number of log sequences to allow a RAC instance to lag before considering the instance offline.. [optional]  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Allow auto restart of staging source on host reboot.. [optional]  # noqa: E501
            physical_standby (bool): If true, convert this dSource's staging database to a physical standby.. [optional]  # noqa: E501
            external_file_path (str): External file path.. [optional]  # noqa: E501
            hooks (DSourceHooks): [optional]  # noqa: E501
            custom_env_variables_pairs ([NameValuePair]): An array of name value pair of environment variables.. [optional]  # noqa: E501
            custom_env_variables_paths ([str]): An array of strings of whitespace-separated parameters to be passed to the source command. The first parameter must be an absolute path to a file that exists on the target environment. Every subsequent parameter will be treated as an argument interpreted by the environment file.. [optional]  # noqa: E501
            staging_database_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): Database configuration parameter overrides.. [optional]  # noqa: E501
            template_id (str): The template ID of the target Oracle Staging Push dSource.. [optional]  # noqa: E501
            logsync_enabled (bool): True if LogSync is enabled for this dSource.. [optional]  # noqa: E501
            logsync_mode (OracleLogsyncModeTypeEnum): [optional]  # noqa: E501
            logsync_interval (int): Interval between LogSync requests, in seconds.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
