"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError



class UpdateMaskingJobParameters(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('retain_execution_data',): {
            'NO': "NO",
            'ON_ERROR': "ON_ERROR",
            'ALWAYS': "ALWAYS",
        },
    }

    validations = {
        ('name',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('connector_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('connector_password',): {
            'max_length': 4096,
            'min_length': 1,
        },
        ('on_the_fly_source_connector_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('on_the_fly_source_connector_password',): {
            'max_length': 4096,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'name': (str,),  # noqa: E501
            'connector_username': (str,),  # noqa: E501
            'connector_password': (str,),  # noqa: E501
            'on_the_fly_source_connector_username': (str,),  # noqa: E501
            'on_the_fly_source_connector_password': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'dataset_id': (str,),  # noqa: E501
            'retain_execution_data': (str,),  # noqa: E501
            'max_memory': (int,),  # noqa: E501
            'min_memory': (int,),  # noqa: E501
            'feedback_size': (int,),  # noqa: E501
            'stream_row_limit': (int,),  # noqa: E501
            'num_input_streams': (int,),  # noqa: E501
            'max_concurrent_source_connections': (int,),  # noqa: E501
            'max_concurrent_target_connections': (int,),  # noqa: E501
            'parallelism_degree': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'name': 'name',  # noqa: E501
        'connector_username': 'connector_username',  # noqa: E501
        'connector_password': 'connector_password',  # noqa: E501
        'on_the_fly_source_connector_username': 'on_the_fly_source_connector_username',  # noqa: E501
        'on_the_fly_source_connector_password': 'on_the_fly_source_connector_password',  # noqa: E501
        'description': 'description',  # noqa: E501
        'dataset_id': 'dataset_id',  # noqa: E501
        'retain_execution_data': 'retain_execution_data',  # noqa: E501
        'max_memory': 'max_memory',  # noqa: E501
        'min_memory': 'min_memory',  # noqa: E501
        'feedback_size': 'feedback_size',  # noqa: E501
        'stream_row_limit': 'stream_row_limit',  # noqa: E501
        'num_input_streams': 'num_input_streams',  # noqa: E501
        'max_concurrent_source_connections': 'max_concurrent_source_connections',  # noqa: E501
        'max_concurrent_target_connections': 'max_concurrent_target_connections',  # noqa: E501
        'parallelism_degree': 'parallelism_degree',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """UpdateMaskingJobParameters - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The name of the MaskingJob.. [optional]  # noqa: E501
            connector_username (str): The username of the Connector used by the MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            connector_password (str): The password of the Connector used by the MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            on_the_fly_source_connector_username (str): The username of the source Connector used by the on-the-fly MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            on_the_fly_source_connector_password (str): The password of the source Connector used by the on-the-fly MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            description (str): Description of the Job (Hyperscale Job only).. [optional]  # noqa: E501
            dataset_id (str): Dataset of the Hyperscale Job (Hyperscale Job only).. [optional]  # noqa: E501
            retain_execution_data (str): Defines whether execution data will be stored after execution is complete (Hyperscale Job only).. [optional]  # noqa: E501
            max_memory (int): Maximum memory to be allocated for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            min_memory (int): Minimum memory to be allocated for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            feedback_size (int): Feedback Size for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            stream_row_limit (int): Stream Row Limit for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            num_input_streams (int): Number of input streams to be configured for Masking Job (Hyperscale Job only).. [optional]  # noqa: E501
            max_concurrent_source_connections (int): Maximum number of parallel connection that the Hyperscale instance can have with the source datasource (Hyperscale Job only).. [optional]  # noqa: E501
            max_concurrent_target_connections (int): Maximum number of parallel connection that the Hyperscale instance can have with the target datasource (Hyperscale Job only).. [optional]  # noqa: E501
            parallelism_degree (int): The degree of parallelism (DOP) per Oracle job to recreate the index in the post-load process (Hyperscale Job only).. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """UpdateMaskingJobParameters - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The name of the MaskingJob.. [optional]  # noqa: E501
            connector_username (str): The username of the Connector used by the MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            connector_password (str): The password of the Connector used by the MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            on_the_fly_source_connector_username (str): The username of the source Connector used by the on-the-fly MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            on_the_fly_source_connector_password (str): The password of the source Connector used by the on-the-fly MaskingJob. (Standard Job only).. [optional]  # noqa: E501
            description (str): Description of the Job (Hyperscale Job only).. [optional]  # noqa: E501
            dataset_id (str): Dataset of the Hyperscale Job (Hyperscale Job only).. [optional]  # noqa: E501
            retain_execution_data (str): Defines whether execution data will be stored after execution is complete (Hyperscale Job only).. [optional]  # noqa: E501
            max_memory (int): Maximum memory to be allocated for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            min_memory (int): Minimum memory to be allocated for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            feedback_size (int): Feedback Size for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            stream_row_limit (int): Stream Row Limit for each Masking job (Hyperscale Job only).. [optional]  # noqa: E501
            num_input_streams (int): Number of input streams to be configured for Masking Job (Hyperscale Job only).. [optional]  # noqa: E501
            max_concurrent_source_connections (int): Maximum number of parallel connection that the Hyperscale instance can have with the source datasource (Hyperscale Job only).. [optional]  # noqa: E501
            max_concurrent_target_connections (int): Maximum number of parallel connection that the Hyperscale instance can have with the target datasource (Hyperscale Job only).. [optional]  # noqa: E501
            parallelism_degree (int): The degree of parallelism (DOP) per Oracle job to recreate the index in the post-load process (Hyperscale Job only).. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
