"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.ssh_verification_strategy import SSHVerificationStrategy
    globals()['SSHVerificationStrategy'] = SSHVerificationStrategy


class TimeflowRepairRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('host',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('directory',): {
            'max_length': 2048,
            'min_length': 1,
        },
        ('start_location',): {
            'max_length': 20,
            'min_length': 1,
        },
        ('end_location',): {
            'max_length': 20,
            'min_length': 1,
        },
        ('port',): {
            'inclusive_maximum': 65535,
            'inclusive_minimum': 1,
        },
        ('password',): {
            'max_length': 255,
            'min_length': 1,
        },
        ('key_pair_private_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('key_pair_public_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('vault_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('hashicorp_vault_engine',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('hashicorp_vault_secret_path',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('hashicorp_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('hashicorp_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('azure_vault_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('azure_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('azure_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('cyberark_vault_query_string',): {
            'max_length': 256,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'host': (str,),  # noqa: E501
            'username': (str,),  # noqa: E501
            'directory': (str,),  # noqa: E501
            'start_location': (str,),  # noqa: E501
            'end_location': (str,),  # noqa: E501
            'port': (int,),  # noqa: E501
            'use_engine_public_key': (bool,),  # noqa: E501
            'password': (str,),  # noqa: E501
            'key_pair_private_key': (str,),  # noqa: E501
            'key_pair_public_key': (str,),  # noqa: E501
            'vault_id': (str,),  # noqa: E501
            'hashicorp_vault_engine': (str,),  # noqa: E501
            'hashicorp_vault_secret_path': (str,),  # noqa: E501
            'hashicorp_vault_username_key': (str,),  # noqa: E501
            'hashicorp_vault_secret_key': (str,),  # noqa: E501
            'azure_vault_name': (str,),  # noqa: E501
            'azure_vault_username_key': (str,),  # noqa: E501
            'azure_vault_secret_key': (str,),  # noqa: E501
            'cyberark_vault_query_string': (str,),  # noqa: E501
            'use_kerberos_authentication': (bool,),  # noqa: E501
            'ssh_verification_strategy': (SSHVerificationStrategy,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'host': 'host',  # noqa: E501
        'username': 'username',  # noqa: E501
        'directory': 'directory',  # noqa: E501
        'start_location': 'start_location',  # noqa: E501
        'end_location': 'end_location',  # noqa: E501
        'port': 'port',  # noqa: E501
        'use_engine_public_key': 'use_engine_public_key',  # noqa: E501
        'password': 'password',  # noqa: E501
        'key_pair_private_key': 'key_pair_private_key',  # noqa: E501
        'key_pair_public_key': 'key_pair_public_key',  # noqa: E501
        'vault_id': 'vault_id',  # noqa: E501
        'hashicorp_vault_engine': 'hashicorp_vault_engine',  # noqa: E501
        'hashicorp_vault_secret_path': 'hashicorp_vault_secret_path',  # noqa: E501
        'hashicorp_vault_username_key': 'hashicorp_vault_username_key',  # noqa: E501
        'hashicorp_vault_secret_key': 'hashicorp_vault_secret_key',  # noqa: E501
        'azure_vault_name': 'azure_vault_name',  # noqa: E501
        'azure_vault_username_key': 'azure_vault_username_key',  # noqa: E501
        'azure_vault_secret_key': 'azure_vault_secret_key',  # noqa: E501
        'cyberark_vault_query_string': 'cyberark_vault_query_string',  # noqa: E501
        'use_kerberos_authentication': 'use_kerberos_authentication',  # noqa: E501
        'ssh_verification_strategy': 'sshVerificationStrategy',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, host, username, directory, start_location, end_location, *args, **kwargs):  # noqa: E501
        """TimeflowRepairRequest - a model defined in OpenAPI

        Args:
            host (str): Hostname of the remote host.
            username (str): Username to connect to remote host.
            directory (str): Location of the missing logs on the host.
            start_location (str): The database specific identifier specifying the start location of the missing log.
            end_location (str): The database specific identifier specifying the end location of the missing log.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            port (int): Port to connect to remote host.. [optional] if omitted the server will use the default value of 22  # noqa: E501
            use_engine_public_key (bool): Whether to use public key authentication.. [optional]  # noqa: E501
            password (str): The password of the user to connect to remote host machine.. [optional]  # noqa: E501
            key_pair_private_key (str): The private key of the key pair credentials.. [optional]  # noqa: E501
            key_pair_public_key (str): The public key of the key pair credentials.. [optional]  # noqa: E501
            vault_id (str): The DCT id or name of the vault from which to read the host credentials.. [optional]  # noqa: E501
            hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            hashicorp_vault_username_key (str): Key for the username in the key-value store.. [optional]  # noqa: E501
            hashicorp_vault_secret_key (str): Key for the password in the key-value store.. [optional]  # noqa: E501
            azure_vault_name (str): Azure key vault name (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            azure_vault_username_key (str): Azure vault key for the username in the key-value store (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            azure_vault_secret_key (str): Azure vault key for the password in the key-value store (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            use_kerberos_authentication (bool): Whether to use kerberos authentication.. [optional]  # noqa: E501
            ssh_verification_strategy (SSHVerificationStrategy): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.host = host
        self.username = username
        self.directory = directory
        self.start_location = start_location
        self.end_location = end_location
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, host, username, directory, start_location, end_location, *args, **kwargs):  # noqa: E501
        """TimeflowRepairRequest - a model defined in OpenAPI

        Args:
            host (str): Hostname of the remote host.
            username (str): Username to connect to remote host.
            directory (str): Location of the missing logs on the host.
            start_location (str): The database specific identifier specifying the start location of the missing log.
            end_location (str): The database specific identifier specifying the end location of the missing log.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            port (int): Port to connect to remote host.. [optional] if omitted the server will use the default value of 22  # noqa: E501
            use_engine_public_key (bool): Whether to use public key authentication.. [optional]  # noqa: E501
            password (str): The password of the user to connect to remote host machine.. [optional]  # noqa: E501
            key_pair_private_key (str): The private key of the key pair credentials.. [optional]  # noqa: E501
            key_pair_public_key (str): The public key of the key pair credentials.. [optional]  # noqa: E501
            vault_id (str): The DCT id or name of the vault from which to read the host credentials.. [optional]  # noqa: E501
            hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            hashicorp_vault_username_key (str): Key for the username in the key-value store.. [optional]  # noqa: E501
            hashicorp_vault_secret_key (str): Key for the password in the key-value store.. [optional]  # noqa: E501
            azure_vault_name (str): Azure key vault name (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            azure_vault_username_key (str): Azure vault key for the username in the key-value store (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            azure_vault_secret_key (str): Azure vault key for the password in the key-value store (ORACLE, ASE and MSSQL_DOMAIN_USER only).. [optional]  # noqa: E501
            cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            use_kerberos_authentication (bool): Whether to use kerberos authentication.. [optional]  # noqa: E501
            ssh_verification_strategy (SSHVerificationStrategy): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.host = host
        self.username = username
        self.directory = directory
        self.start_location = start_location
        self.end_location = end_location
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
