"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.name_value_pair import NameValuePair
    from delphix.api.gateway.model.source_operation import SourceOperation
    globals()['NameValuePair'] = NameValuePair
    globals()['SourceOperation'] = SourceOperation


class OracleStagingPushDSourceLinkSourceParametersAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('container_type',): {
            'ROOT_CDB': "ROOT_CDB",
            'NON_CDB': "NON_CDB",
        },
        ('tde_keystore_config_type',): {
            'FILE': "FILE",
            'OKV': "OKV",
            'HSM': "HSM",
        },
    }

    validations = {
        ('engine_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('environment_user_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('repository',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('database_name',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('database_unique_name',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('sid',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('mount_base',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('staging_container_database_reference',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('template_id',): {
            'max_length': 256,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'engine_id': (str,),  # noqa: E501
            'container_type': (str,),  # noqa: E501
            'environment_user_id': (str,),  # noqa: E501
            'repository': (str,),  # noqa: E501
            'database_name': (str,),  # noqa: E501
            'database_unique_name': (str,),  # noqa: E501
            'sid': (str,),  # noqa: E501
            'mount_base': (str,),  # noqa: E501
            'custom_env_variables_pairs': ([NameValuePair],),  # noqa: E501
            'custom_env_variables_paths': ([str],),  # noqa: E501
            'auto_staging_restart': (bool,),  # noqa: E501
            'allow_auto_staging_restart_on_host_reboot': (bool,),  # noqa: E501
            'physical_standby': (bool,),  # noqa: E501
            'validate_snapshot_in_readonly': (bool,),  # noqa: E501
            'validate_by_opening_db_in_read_only_mode': (bool,),  # noqa: E501
            'staging_database_templates': ([NameValuePair],),  # noqa: E501
            'staging_database_config_params': ({str: (str,)}, none_type,),  # noqa: E501
            'staging_container_database_reference': (str,),  # noqa: E501
            'ops_pre_log_sync': ([SourceOperation],),  # noqa: E501
            'tde_keystore_config_type': (str,),  # noqa: E501
            'template_id': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'engine_id': 'engine_id',  # noqa: E501
        'container_type': 'container_type',  # noqa: E501
        'environment_user_id': 'environment_user_id',  # noqa: E501
        'repository': 'repository',  # noqa: E501
        'database_name': 'database_name',  # noqa: E501
        'database_unique_name': 'database_unique_name',  # noqa: E501
        'sid': 'sid',  # noqa: E501
        'mount_base': 'mount_base',  # noqa: E501
        'custom_env_variables_pairs': 'custom_env_variables_pairs',  # noqa: E501
        'custom_env_variables_paths': 'custom_env_variables_paths',  # noqa: E501
        'auto_staging_restart': 'auto_staging_restart',  # noqa: E501
        'allow_auto_staging_restart_on_host_reboot': 'allow_auto_staging_restart_on_host_reboot',  # noqa: E501
        'physical_standby': 'physical_standby',  # noqa: E501
        'validate_snapshot_in_readonly': 'validate_snapshot_in_readonly',  # noqa: E501
        'validate_by_opening_db_in_read_only_mode': 'validate_by_opening_db_in_read_only_mode',  # noqa: E501
        'staging_database_templates': 'staging_database_templates',  # noqa: E501
        'staging_database_config_params': 'staging_database_config_params',  # noqa: E501
        'staging_container_database_reference': 'staging_container_database_reference',  # noqa: E501
        'ops_pre_log_sync': 'ops_pre_log_sync',  # noqa: E501
        'tde_keystore_config_type': 'tde_keystore_config_type',  # noqa: E501
        'template_id': 'template_id',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """OracleStagingPushDSourceLinkSourceParametersAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            engine_id (str): The ID of the engine to link staging push database on.. [optional]  # noqa: E501
            container_type (str): The container type of this database.If not provided the request would be considered as a PDB database.. [optional]  # noqa: E501
            environment_user_id (str): Id of the environment user to use for linking.. [optional]  # noqa: E501
            repository (str): The repository reference to link.. [optional]  # noqa: E501
            database_name (str): The name of the database.. [optional]  # noqa: E501
            database_unique_name (str): The unique name of the database.. [optional]  # noqa: E501
            sid (str): The name (sid) of the instance.. [optional]  # noqa: E501
            mount_base (str): The base mount point to use for the NFS mounts.. [optional]  # noqa: E501
            custom_env_variables_pairs ([NameValuePair]): An array of name value pair of environment variables.. [optional]  # noqa: E501
            custom_env_variables_paths ([str]): An array of strings of whitespace-separated parameters to be passed to the source command. The first parameter must be an absolute path to a file that exists on the target environment. Every subsequent parameter will be treated as an argument interpreted by the environment file.. [optional]  # noqa: E501
            auto_staging_restart (bool): Boolean value indicates whether this staging database should automatically be restarted when staging host reboot is detected.. [optional] if omitted the server will use the default value of False  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Boolean value indicates whether this staging database should automatically be restarted when staging host reboot is detected.. [optional]  # noqa: E501
            physical_standby (bool): Boolean value indicates whether this staging database will be configured as a physical standby.. [optional] if omitted the server will use the default value of False  # noqa: E501
            validate_snapshot_in_readonly (bool): Boolean value indicates whether this staging database snapshot will be validated by opening it in read-only.. [optional] if omitted the server will use the default value of False  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Boolean value indicates whether this staging database snapshot will be validated by opening it in read-only.. [optional]  # noqa: E501
            staging_database_templates ([NameValuePair]): An array of name value pair of Oracle database configuration parameter overrides. This property is deprecated. Use staging_database_config_params instead.. [optional]  # noqa: E501
            staging_database_config_params ({str: (str,)}, none_type): Oracle database configuration parameter overrides. If both staging_database_templates and staging_database_config_params are specified, staging_database_config_params will be used.. [optional]  # noqa: E501
            staging_container_database_reference (str): Reference of the CDB source config.. [optional]  # noqa: E501
            ops_pre_log_sync ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
            tde_keystore_config_type (str): The type of TDE keystore configuration to use for the staging database.. [optional]  # noqa: E501
            template_id (str): The template ID of the target Oracle Staging Push dSource.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """OracleStagingPushDSourceLinkSourceParametersAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            engine_id (str): The ID of the engine to link staging push database on.. [optional]  # noqa: E501
            container_type (str): The container type of this database.If not provided the request would be considered as a PDB database.. [optional]  # noqa: E501
            environment_user_id (str): Id of the environment user to use for linking.. [optional]  # noqa: E501
            repository (str): The repository reference to link.. [optional]  # noqa: E501
            database_name (str): The name of the database.. [optional]  # noqa: E501
            database_unique_name (str): The unique name of the database.. [optional]  # noqa: E501
            sid (str): The name (sid) of the instance.. [optional]  # noqa: E501
            mount_base (str): The base mount point to use for the NFS mounts.. [optional]  # noqa: E501
            custom_env_variables_pairs ([NameValuePair]): An array of name value pair of environment variables.. [optional]  # noqa: E501
            custom_env_variables_paths ([str]): An array of strings of whitespace-separated parameters to be passed to the source command. The first parameter must be an absolute path to a file that exists on the target environment. Every subsequent parameter will be treated as an argument interpreted by the environment file.. [optional]  # noqa: E501
            auto_staging_restart (bool): Boolean value indicates whether this staging database should automatically be restarted when staging host reboot is detected.. [optional] if omitted the server will use the default value of False  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Boolean value indicates whether this staging database should automatically be restarted when staging host reboot is detected.. [optional]  # noqa: E501
            physical_standby (bool): Boolean value indicates whether this staging database will be configured as a physical standby.. [optional] if omitted the server will use the default value of False  # noqa: E501
            validate_snapshot_in_readonly (bool): Boolean value indicates whether this staging database snapshot will be validated by opening it in read-only.. [optional] if omitted the server will use the default value of False  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Boolean value indicates whether this staging database snapshot will be validated by opening it in read-only.. [optional]  # noqa: E501
            staging_database_templates ([NameValuePair]): An array of name value pair of Oracle database configuration parameter overrides. This property is deprecated. Use staging_database_config_params instead.. [optional]  # noqa: E501
            staging_database_config_params ({str: (str,)}, none_type): Oracle database configuration parameter overrides. If both staging_database_templates and staging_database_config_params are specified, staging_database_config_params will be used.. [optional]  # noqa: E501
            staging_container_database_reference (str): Reference of the CDB source config.. [optional]  # noqa: E501
            ops_pre_log_sync ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
            tde_keystore_config_type (str): The type of TDE keystore configuration to use for the staging database.. [optional]  # noqa: E501
            template_id (str): The template ID of the target Oracle Staging Push dSource.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
