"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.source_operation import SourceOperation
    globals()['SourceOperation'] = SourceOperation


class OracleDSourceLinkSourceParametersAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('log_sync_mode',): {
            'ARCHIVE_ONLY_MODE': "ARCHIVE_ONLY_MODE",
            'ARCHIVE_REDO_MODE': "ARCHIVE_REDO_MODE",
            'UNDEFINED': "UNDEFINED",
        },
    }

    validations = {
        ('external_file_path',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('environment_user_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('rman_channels',): {
            'inclusive_maximum': 32,
            'inclusive_minimum': 1,
        },
        ('files_per_set',): {
            'inclusive_maximum': 64,
            'inclusive_minimum': 1,
        },
        ('non_sys_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_password',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_vault_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_vault',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_hashicorp_vault_engine',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_hashicorp_vault_secret_path',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_hashicorp_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_hashicorp_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_azure_vault_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_azure_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_azure_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('non_sys_cyberark_vault_query_string',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_password',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_vault_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_vault',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_hashicorp_vault_engine',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_hashicorp_vault_secret_path',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_hashicorp_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_hashicorp_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_azure_vault_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_azure_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_azure_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('fallback_cyberark_vault_query_string',): {
            'max_length': 256,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'external_file_path': (str,),  # noqa: E501
            'environment_user_id': (str,),  # noqa: E501
            'backup_level_enabled': (bool,),  # noqa: E501
            'rman_channels': (int,),  # noqa: E501
            'files_per_set': (int,),  # noqa: E501
            'check_logical': (bool,),  # noqa: E501
            'encrypted_linking_enabled': (bool,),  # noqa: E501
            'compressed_linking_enabled': (bool,),  # noqa: E501
            'bandwidth_limit': (int,),  # noqa: E501
            'number_of_connections': (int,),  # noqa: E501
            'diagnose_no_logging_faults': (bool,),  # noqa: E501
            'pre_provisioning_enabled': (bool,),  # noqa: E501
            'link_now': (bool,),  # noqa: E501
            'force_full_backup': (bool,),  # noqa: E501
            'double_sync': (bool,),  # noqa: E501
            'skip_space_check': (bool,),  # noqa: E501
            'do_not_resume': (bool,),  # noqa: E501
            'files_for_full_backup': ([int],),  # noqa: E501
            'log_sync_mode': (str,),  # noqa: E501
            'log_sync_interval': (int,),  # noqa: E501
            'non_sys_username': (str,),  # noqa: E501
            'non_sys_password': (str,),  # noqa: E501
            'non_sys_vault_username': (str,),  # noqa: E501
            'non_sys_vault': (str,),  # noqa: E501
            'non_sys_hashicorp_vault_engine': (str,),  # noqa: E501
            'non_sys_hashicorp_vault_secret_path': (str,),  # noqa: E501
            'non_sys_hashicorp_vault_username_key': (str,),  # noqa: E501
            'non_sys_hashicorp_vault_secret_key': (str,),  # noqa: E501
            'non_sys_azure_vault_name': (str,),  # noqa: E501
            'non_sys_azure_vault_username_key': (str,),  # noqa: E501
            'non_sys_azure_vault_secret_key': (str,),  # noqa: E501
            'non_sys_cyberark_vault_query_string': (str,),  # noqa: E501
            'fallback_username': (str,),  # noqa: E501
            'fallback_password': (str,),  # noqa: E501
            'fallback_vault_username': (str,),  # noqa: E501
            'fallback_vault': (str,),  # noqa: E501
            'fallback_hashicorp_vault_engine': (str,),  # noqa: E501
            'fallback_hashicorp_vault_secret_path': (str,),  # noqa: E501
            'fallback_hashicorp_vault_username_key': (str,),  # noqa: E501
            'fallback_hashicorp_vault_secret_key': (str,),  # noqa: E501
            'fallback_azure_vault_name': (str,),  # noqa: E501
            'fallback_azure_vault_username_key': (str,),  # noqa: E501
            'fallback_azure_vault_secret_key': (str,),  # noqa: E501
            'fallback_cyberark_vault_query_string': (str,),  # noqa: E501
            'ops_pre_log_sync': ([SourceOperation],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'external_file_path': 'external_file_path',  # noqa: E501
        'environment_user_id': 'environment_user_id',  # noqa: E501
        'backup_level_enabled': 'backup_level_enabled',  # noqa: E501
        'rman_channels': 'rman_channels',  # noqa: E501
        'files_per_set': 'files_per_set',  # noqa: E501
        'check_logical': 'check_logical',  # noqa: E501
        'encrypted_linking_enabled': 'encrypted_linking_enabled',  # noqa: E501
        'compressed_linking_enabled': 'compressed_linking_enabled',  # noqa: E501
        'bandwidth_limit': 'bandwidth_limit',  # noqa: E501
        'number_of_connections': 'number_of_connections',  # noqa: E501
        'diagnose_no_logging_faults': 'diagnose_no_logging_faults',  # noqa: E501
        'pre_provisioning_enabled': 'pre_provisioning_enabled',  # noqa: E501
        'link_now': 'link_now',  # noqa: E501
        'force_full_backup': 'force_full_backup',  # noqa: E501
        'double_sync': 'double_sync',  # noqa: E501
        'skip_space_check': 'skip_space_check',  # noqa: E501
        'do_not_resume': 'do_not_resume',  # noqa: E501
        'files_for_full_backup': 'files_for_full_backup',  # noqa: E501
        'log_sync_mode': 'log_sync_mode',  # noqa: E501
        'log_sync_interval': 'log_sync_interval',  # noqa: E501
        'non_sys_username': 'non_sys_username',  # noqa: E501
        'non_sys_password': 'non_sys_password',  # noqa: E501
        'non_sys_vault_username': 'non_sys_vault_username',  # noqa: E501
        'non_sys_vault': 'non_sys_vault',  # noqa: E501
        'non_sys_hashicorp_vault_engine': 'non_sys_hashicorp_vault_engine',  # noqa: E501
        'non_sys_hashicorp_vault_secret_path': 'non_sys_hashicorp_vault_secret_path',  # noqa: E501
        'non_sys_hashicorp_vault_username_key': 'non_sys_hashicorp_vault_username_key',  # noqa: E501
        'non_sys_hashicorp_vault_secret_key': 'non_sys_hashicorp_vault_secret_key',  # noqa: E501
        'non_sys_azure_vault_name': 'non_sys_azure_vault_name',  # noqa: E501
        'non_sys_azure_vault_username_key': 'non_sys_azure_vault_username_key',  # noqa: E501
        'non_sys_azure_vault_secret_key': 'non_sys_azure_vault_secret_key',  # noqa: E501
        'non_sys_cyberark_vault_query_string': 'non_sys_cyberark_vault_query_string',  # noqa: E501
        'fallback_username': 'fallback_username',  # noqa: E501
        'fallback_password': 'fallback_password',  # noqa: E501
        'fallback_vault_username': 'fallback_vault_username',  # noqa: E501
        'fallback_vault': 'fallback_vault',  # noqa: E501
        'fallback_hashicorp_vault_engine': 'fallback_hashicorp_vault_engine',  # noqa: E501
        'fallback_hashicorp_vault_secret_path': 'fallback_hashicorp_vault_secret_path',  # noqa: E501
        'fallback_hashicorp_vault_username_key': 'fallback_hashicorp_vault_username_key',  # noqa: E501
        'fallback_hashicorp_vault_secret_key': 'fallback_hashicorp_vault_secret_key',  # noqa: E501
        'fallback_azure_vault_name': 'fallback_azure_vault_name',  # noqa: E501
        'fallback_azure_vault_username_key': 'fallback_azure_vault_username_key',  # noqa: E501
        'fallback_azure_vault_secret_key': 'fallback_azure_vault_secret_key',  # noqa: E501
        'fallback_cyberark_vault_query_string': 'fallback_cyberark_vault_query_string',  # noqa: E501
        'ops_pre_log_sync': 'ops_pre_log_sync',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """OracleDSourceLinkSourceParametersAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            external_file_path (str): External file path.. [optional]  # noqa: E501
            environment_user_id (str): Id of the environment user to use for linking.. [optional]  # noqa: E501
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional] if omitted the server will use the default value of 2  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this linked database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional] if omitted the server will use the default value of False  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional] if omitted the server will use the default value of True  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            diagnose_no_logging_faults (bool): If true, NOLOGGING operations on this container are treated as faults and cannot be resolved manually.. [optional] if omitted the server will use the default value of True  # noqa: E501
            pre_provisioning_enabled (bool): If true, pre-provisioning will be performed after every sync.. [optional] if omitted the server will use the default value of False  # noqa: E501
            link_now (bool): True if initial load should be done immediately.. [optional] if omitted the server will use the default value of False  # noqa: E501
            force_full_backup (bool): Whether or not to take another full backup of the source database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            double_sync (bool): True if two SnapSyncs should be performed in immediate succession to reduce the number of logs required to provision the snapshot. This may significantly reduce the time necessary to provision from a snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            skip_space_check (bool): Skip check that tests if there is enough space available to store the database in the Delphix Engine. The Delphix Engine estimates how much space a database will occupy after compression and prevents SnapSync if insufficient space is available. This safeguard can be overridden using this option. This may be useful when linking highly compressible databases.. [optional] if omitted the server will use the default value of False  # noqa: E501
            do_not_resume (bool): Indicates whether a fresh SnapSync must be started regardless if it was possible to resume the current SnapSync. If true, we will not resume but instead ignore previous progress and backup all datafiles even if already completed from previous failed SnapSync. This does not force a full backup, if an incremental was in progress this will start a new incremental snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            files_for_full_backup ([int]): List of datafiles to take a full backup of. This would be useful in situations where certain datafiles could not be backed up during previous SnapSync due to corruption or because they went offline.. [optional]  # noqa: E501
            log_sync_mode (str): LogSync operation mode for this database.. [optional] if omitted the server will use the default value of "UNDEFINED"  # noqa: E501
            log_sync_interval (int): Interval between LogSync requests, in seconds.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            non_sys_username (str): Non-SYS database user to access this database. Only required for username-password auth (Single tenant only).. [optional]  # noqa: E501
            non_sys_password (str): Password for non sys user authentication (Single tenant only).. [optional]  # noqa: E501
            non_sys_vault_username (str): Delphix display name for the non sys vault user(Single tenant only).. [optional]  # noqa: E501
            non_sys_vault (str): The name or reference of the vault from which to read the database credentials (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_engine (str): Vault engine name where the credential is stored (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_name (str): Azure key vault name (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_username_key (str): Azure vault key for the username in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_secret_key (str): Azure vault key for the password in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault (Single tenant only).. [optional]  # noqa: E501
            fallback_username (str): The database fallback username. Optional if bequeath connections are enabled (to be used in case of bequeath connection failures). Only required for username-password auth.. [optional]  # noqa: E501
            fallback_password (str): Password for fallback username.. [optional]  # noqa: E501
            fallback_vault_username (str): Delphix display name for the fallback vault user.. [optional]  # noqa: E501
            fallback_vault (str): The name or reference of the vault from which to read the database credentials.. [optional]  # noqa: E501
            fallback_hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            fallback_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            fallback_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store.. [optional]  # noqa: E501
            fallback_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store.. [optional]  # noqa: E501
            fallback_azure_vault_name (str): Azure key vault name.. [optional]  # noqa: E501
            fallback_azure_vault_username_key (str): Azure vault key for the username in the key-value store.. [optional]  # noqa: E501
            fallback_azure_vault_secret_key (str): Azure vault key for the password in the key-value store.. [optional]  # noqa: E501
            fallback_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            ops_pre_log_sync ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """OracleDSourceLinkSourceParametersAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            external_file_path (str): External file path.. [optional]  # noqa: E501
            environment_user_id (str): Id of the environment user to use for linking.. [optional]  # noqa: E501
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional] if omitted the server will use the default value of 2  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this linked database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional] if omitted the server will use the default value of False  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional] if omitted the server will use the default value of True  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            diagnose_no_logging_faults (bool): If true, NOLOGGING operations on this container are treated as faults and cannot be resolved manually.. [optional] if omitted the server will use the default value of True  # noqa: E501
            pre_provisioning_enabled (bool): If true, pre-provisioning will be performed after every sync.. [optional] if omitted the server will use the default value of False  # noqa: E501
            link_now (bool): True if initial load should be done immediately.. [optional] if omitted the server will use the default value of False  # noqa: E501
            force_full_backup (bool): Whether or not to take another full backup of the source database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            double_sync (bool): True if two SnapSyncs should be performed in immediate succession to reduce the number of logs required to provision the snapshot. This may significantly reduce the time necessary to provision from a snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            skip_space_check (bool): Skip check that tests if there is enough space available to store the database in the Delphix Engine. The Delphix Engine estimates how much space a database will occupy after compression and prevents SnapSync if insufficient space is available. This safeguard can be overridden using this option. This may be useful when linking highly compressible databases.. [optional] if omitted the server will use the default value of False  # noqa: E501
            do_not_resume (bool): Indicates whether a fresh SnapSync must be started regardless if it was possible to resume the current SnapSync. If true, we will not resume but instead ignore previous progress and backup all datafiles even if already completed from previous failed SnapSync. This does not force a full backup, if an incremental was in progress this will start a new incremental snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            files_for_full_backup ([int]): List of datafiles to take a full backup of. This would be useful in situations where certain datafiles could not be backed up during previous SnapSync due to corruption or because they went offline.. [optional]  # noqa: E501
            log_sync_mode (str): LogSync operation mode for this database.. [optional] if omitted the server will use the default value of "UNDEFINED"  # noqa: E501
            log_sync_interval (int): Interval between LogSync requests, in seconds.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            non_sys_username (str): Non-SYS database user to access this database. Only required for username-password auth (Single tenant only).. [optional]  # noqa: E501
            non_sys_password (str): Password for non sys user authentication (Single tenant only).. [optional]  # noqa: E501
            non_sys_vault_username (str): Delphix display name for the non sys vault user(Single tenant only).. [optional]  # noqa: E501
            non_sys_vault (str): The name or reference of the vault from which to read the database credentials (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_engine (str): Vault engine name where the credential is stored (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_name (str): Azure key vault name (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_username_key (str): Azure vault key for the username in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_azure_vault_secret_key (str): Azure vault key for the password in the key-value store (Single tenant only).. [optional]  # noqa: E501
            non_sys_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault (Single tenant only).. [optional]  # noqa: E501
            fallback_username (str): The database fallback username. Optional if bequeath connections are enabled (to be used in case of bequeath connection failures). Only required for username-password auth.. [optional]  # noqa: E501
            fallback_password (str): Password for fallback username.. [optional]  # noqa: E501
            fallback_vault_username (str): Delphix display name for the fallback vault user.. [optional]  # noqa: E501
            fallback_vault (str): The name or reference of the vault from which to read the database credentials.. [optional]  # noqa: E501
            fallback_hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            fallback_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            fallback_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store.. [optional]  # noqa: E501
            fallback_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store.. [optional]  # noqa: E501
            fallback_azure_vault_name (str): Azure key vault name.. [optional]  # noqa: E501
            fallback_azure_vault_username_key (str): Azure vault key for the username in the key-value store.. [optional]  # noqa: E501
            fallback_azure_vault_secret_key (str): Azure vault key for the password in the key-value store.. [optional]  # noqa: E501
            fallback_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            ops_pre_log_sync ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
