"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.oracle_attach_parameters import OracleAttachParameters
    from delphix.api.gateway.model.source_operation import SourceOperation
    globals()['OracleAttachParameters'] = OracleAttachParameters
    globals()['SourceOperation'] = SourceOperation


class OracleAttachCdbParameters(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('dsource_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_file_path',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('files_per_set',): {
            'inclusive_maximum': 64,
            'inclusive_minimum': 1,
        },
        ('oracle_fallback_user',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('oracle_fallback_credentials',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('rman_channels',): {
            'inclusive_maximum': 32,
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'dsource_id': (str,),  # noqa: E501
            'backup_level_enabled': (bool,),  # noqa: E501
            'bandwidth_limit': (int,),  # noqa: E501
            'check_logical': (bool,),  # noqa: E501
            'compressed_linking_enabled': (bool,),  # noqa: E501
            'double_sync': (bool,),  # noqa: E501
            'encrypted_linking_enabled': (bool,),  # noqa: E501
            'environment_user': (str,),  # noqa: E501
            'external_file_path': (str,),  # noqa: E501
            'files_per_set': (int,),  # noqa: E501
            'force': (bool,),  # noqa: E501
            'link_now': (bool,),  # noqa: E501
            'number_of_connections': (int,),  # noqa: E501
            'operations': ([SourceOperation],),  # noqa: E501
            'oracle_fallback_user': (str,),  # noqa: E501
            'oracle_fallback_credentials': (str,),  # noqa: E501
            'rman_channels': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'dsource_id': 'dsource_id',  # noqa: E501
        'backup_level_enabled': 'backup_level_enabled',  # noqa: E501
        'bandwidth_limit': 'bandwidth_limit',  # noqa: E501
        'check_logical': 'check_logical',  # noqa: E501
        'compressed_linking_enabled': 'compressed_linking_enabled',  # noqa: E501
        'double_sync': 'double_sync',  # noqa: E501
        'encrypted_linking_enabled': 'encrypted_linking_enabled',  # noqa: E501
        'environment_user': 'environment_user',  # noqa: E501
        'external_file_path': 'external_file_path',  # noqa: E501
        'files_per_set': 'files_per_set',  # noqa: E501
        'force': 'force',  # noqa: E501
        'link_now': 'link_now',  # noqa: E501
        'number_of_connections': 'number_of_connections',  # noqa: E501
        'operations': 'operations',  # noqa: E501
        'oracle_fallback_user': 'oracle_fallback_user',  # noqa: E501
        'oracle_fallback_credentials': 'oracle_fallback_credentials',  # noqa: E501
        'rman_channels': 'rman_channels',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """OracleAttachCdbParameters - a model defined in OpenAPI

        Keyword Args:
            dsource_id (str): Id of the dsource to attach.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this linked database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional] if omitted the server will use the default value of True  # noqa: E501
            double_sync (bool): True if two SnapSyncs should be performed in immediate succession to reduce the number of logs required to provision the snapshot. This may significantly reduce the time necessary to provision from a snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional] if omitted the server will use the default value of False  # noqa: E501
            environment_user (str): Reference to the user that should be used in the host.. [optional]  # noqa: E501
            external_file_path (str): External file path.. [optional]  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            force (bool): If true, attach will succeed even if the resetlogs of the new database does not match the resetlogs information of the original database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            link_now (bool): True if initial load should be done immediately.. [optional] if omitted the server will use the default value of False  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            operations ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
            oracle_fallback_user (str): The database fallback username. Optional if bequeath connections are enabled (to be used in case of bequeath connection failures). Only required for username-password auth.. [optional]  # noqa: E501
            oracle_fallback_credentials (str): Password for fallback username.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional] if omitted the server will use the default value of 2  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """OracleAttachCdbParameters - a model defined in OpenAPI

        Keyword Args:
            dsource_id (str): Id of the dsource to attach.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            backup_level_enabled (bool): Boolean value indicates whether LEVEL-based incremental backups can be used on the source database.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for SnapSync and LogSync network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            check_logical (bool): True if extended block checking should be used for this linked database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            compressed_linking_enabled (bool): True if SnapSync data from the source should be compressed over the network. Enabling this feature will reduce network bandwidth consumption and may significantly improve throughput, especially over slow network.. [optional] if omitted the server will use the default value of True  # noqa: E501
            double_sync (bool): True if two SnapSyncs should be performed in immediate succession to reduce the number of logs required to provision the snapshot. This may significantly reduce the time necessary to provision from a snapshot.. [optional] if omitted the server will use the default value of False  # noqa: E501
            encrypted_linking_enabled (bool): True if SnapSync data from the source should be retrieved through an encrypted connection. Enabling this feature can decrease the performance of SnapSync from the source but has no impact on the performance of VDBs created from the retrieved data.. [optional] if omitted the server will use the default value of False  # noqa: E501
            environment_user (str): Reference to the user that should be used in the host.. [optional]  # noqa: E501
            external_file_path (str): External file path.. [optional]  # noqa: E501
            files_per_set (int): Number of data files to include in each RMAN backup set.. [optional] if omitted the server will use the default value of 5  # noqa: E501
            force (bool): If true, attach will succeed even if the resetlogs of the new database does not match the resetlogs information of the original database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            link_now (bool): True if initial load should be done immediately.. [optional] if omitted the server will use the default value of False  # noqa: E501
            number_of_connections (int): Total number of transport connections to use during SnapSync.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            operations ([SourceOperation]): Operations to perform after syncing a created dSource and before running the LogSync.. [optional]  # noqa: E501
            oracle_fallback_user (str): The database fallback username. Optional if bequeath connections are enabled (to be used in case of bequeath connection failures). Only required for username-password auth.. [optional]  # noqa: E501
            oracle_fallback_credentials (str): Password for fallback username.. [optional]  # noqa: E501
            rman_channels (int): Number of parallel channels to use.. [optional] if omitted the server will use the default value of 2  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              OracleAttachParameters,
          ],
          'oneOf': [
          ],
        }
