"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError



class Namespace(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('failback_capability',): {
            'FAILBACK_READY': "FAILBACK_READY",
            'FAILBACK_COMPATIBLE': "FAILBACK_COMPATIBLE",
            'FAILBACK_INCOMPATIBLE': "FAILBACK_INCOMPATIBLE",
            'FAILBACK_UNSUPPORTED': "FAILBACK_UNSUPPORTED",
            'FAILOVER_COMMITED_CANNOT_FAILBACK': "FAILOVER_COMMITED_CANNOT_FAILBACK",
        },
        ('replication_mode',): {
            'ENGINE_DATA_REPLICATION': "ENGINE_DATA_REPLICATION",
            'MASKED_DATA_DISTRIBUTION': "MASKED_DATA_DISTRIBUTION",
            'CONTINUOUS_VAULT': "CONTINUOUS_VAULT",
        },
        ('last_execution_status',): {
            'RUNNING': "RUNNING",
            'COMPLETED': "COMPLETED",
            'SUSPENDED': "SUSPENDED",
            'CANCELED': "CANCELED",
            'FAILED': "FAILED",
        },
    }

    validations = {
        ('name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('description',): {
            'max_length': 4096,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'tag': (str,),  # noqa: E501
            'engine_id': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'secure_namespace': (bool,),  # noqa: E501
            'failed_over': (bool,),  # noqa: E501
            'failover_report': (str,),  # noqa: E501
            'locked': (bool,),  # noqa: E501
            'failback_possible': (bool,),  # noqa: E501
            'failback_capability': (str,),  # noqa: E501
            'failback_incapability_reason': (str,),  # noqa: E501
            'replication_mode': (str,),  # noqa: E501
            'last_execution_status': (str,),  # noqa: E501
            'last_execution_status_timestamp': (datetime,),  # noqa: E501
            'source_engine_id': (str,),  # noqa: E501
            'source_engine_name': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'tag': 'tag',  # noqa: E501
        'engine_id': 'engine_id',  # noqa: E501
        'description': 'description',  # noqa: E501
        'secure_namespace': 'secure_namespace',  # noqa: E501
        'failed_over': 'failed_over',  # noqa: E501
        'failover_report': 'failover_report',  # noqa: E501
        'locked': 'locked',  # noqa: E501
        'failback_possible': 'failback_possible',  # noqa: E501
        'failback_capability': 'failback_capability',  # noqa: E501
        'failback_incapability_reason': 'failback_incapability_reason',  # noqa: E501
        'replication_mode': 'replication_mode',  # noqa: E501
        'last_execution_status': 'last_execution_status',  # noqa: E501
        'last_execution_status_timestamp': 'last_execution_status_timestamp',  # noqa: E501
        'source_engine_id': 'source_engine_id',  # noqa: E501
        'source_engine_name': 'source_engine_name',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Namespace - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The Namespace ID.. [optional]  # noqa: E501
            name (str): The Namespace name.. [optional]  # noqa: E501
            tag (str): This is the tag of the Replication profile that created this namespace.. [optional]  # noqa: E501
            engine_id (str): The ID of the engine that the Namespace belongs to.. [optional]  # noqa: E501
            description (str): A description of the namespace.. [optional]  # noqa: E501
            secure_namespace (bool): True if the source data stream was generated from a ReplicationProfile with mode CONTINUOUS_VAULT.. [optional]  # noqa: E501
            failed_over (bool): True if the namespace has been failed over into the live environment.. [optional]  # noqa: E501
            failover_report (str): If the namespace has been failed over, this contains a report about objects affected by the failover.. [optional]  # noqa: E501
            locked (bool): True if the namespace is locked.. [optional]  # noqa: E501
            failback_possible (bool): True if the namespace can be failed back.. [optional]  # noqa: E501
            failback_capability (str): Whether the namespace is capable of failback. [optional]  # noqa: E501
            failback_incapability_reason (str): When incapable, the reason why the namespace is incompatible with failback.. [optional]  # noqa: E501
            replication_mode (str): The replication mode of the associated ReplicationProfile that created the Namespace.. [optional]  # noqa: E501
            last_execution_status (str): The status of the last execution of the ReplicationProfile associated with the Namespace.. [optional]  # noqa: E501
            last_execution_status_timestamp (datetime): The timestamp of the last execution status of the ReplicationProfile associated with the Namespace.. [optional]  # noqa: E501
            source_engine_id (str): The ID of the source engine that the ReplicationProfile that created the Namespace belongs to.. [optional]  # noqa: E501
            source_engine_name (str): The name of the source engine that the ReplicationProfile that created the Namespace belongs to.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Namespace - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The Namespace ID.. [optional]  # noqa: E501
            name (str): The Namespace name.. [optional]  # noqa: E501
            tag (str): This is the tag of the Replication profile that created this namespace.. [optional]  # noqa: E501
            engine_id (str): The ID of the engine that the Namespace belongs to.. [optional]  # noqa: E501
            description (str): A description of the namespace.. [optional]  # noqa: E501
            secure_namespace (bool): True if the source data stream was generated from a ReplicationProfile with mode CONTINUOUS_VAULT.. [optional]  # noqa: E501
            failed_over (bool): True if the namespace has been failed over into the live environment.. [optional]  # noqa: E501
            failover_report (str): If the namespace has been failed over, this contains a report about objects affected by the failover.. [optional]  # noqa: E501
            locked (bool): True if the namespace is locked.. [optional]  # noqa: E501
            failback_possible (bool): True if the namespace can be failed back.. [optional]  # noqa: E501
            failback_capability (str): Whether the namespace is capable of failback. [optional]  # noqa: E501
            failback_incapability_reason (str): When incapable, the reason why the namespace is incompatible with failback.. [optional]  # noqa: E501
            replication_mode (str): The replication mode of the associated ReplicationProfile that created the Namespace.. [optional]  # noqa: E501
            last_execution_status (str): The status of the last execution of the ReplicationProfile associated with the Namespace.. [optional]  # noqa: E501
            last_execution_status_timestamp (datetime): The timestamp of the last execution status of the ReplicationProfile associated with the Namespace.. [optional]  # noqa: E501
            source_engine_id (str): The ID of the source engine that the ReplicationProfile that created the Namespace belongs to.. [optional]  # noqa: E501
            source_engine_name (str): The name of the source engine that the ReplicationProfile that created the Namespace belongs to.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
