"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.base_d_source_link_source_parameters import BaseDSourceLinkSourceParameters
    from delphix.api.gateway.model.mssqld_source_link_source_parameters_all_of import MSSQLDSourceLinkSourceParametersAllOf
    from delphix.api.gateway.model.source_operation import SourceOperation
    from delphix.api.gateway.model.tag import Tag
    globals()['BaseDSourceLinkSourceParameters'] = BaseDSourceLinkSourceParameters
    globals()['MSSQLDSourceLinkSourceParametersAllOf'] = MSSQLDSourceLinkSourceParametersAllOf
    globals()['SourceOperation'] = SourceOperation
    globals()['Tag'] = Tag


class MSSQLDSourceLinkSourceParameters(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('sync_strategy',): {
            'LATEST_BACKUP': "latest_backup",
            'NEW_BACKUP': "new_backup",
            'SPECIFIC_BACKUP': "specific_backup",
            'NO_BACKUP': "no_backup",
        },
        ('availability_group_backup_policy',): {
            'PRIMARY': "primary",
            'SECONDARY_ONLY': "secondary_only",
            'PREFER_SECONDARY': "prefer_secondary",
        },
        ('sync_strategy_managed_type',): {
            'EXTERNAL': "external",
            'DELPHIX': "delphix",
            'STAGING_PUSH': "staging_push",
        },
        ('delphix_managed_backup_policy',): {
            'PRIMARY': "primary",
            'SECONDARY_ONLY': "secondary_only",
            'PREFER_SECONDARY': "prefer_secondary",
        },
        ('external_managed_validate_sync_mode',): {
            'TRANSACTION_LOG': "TRANSACTION_LOG",
            'FULL_OR_DIFFERENTIAL': "FULL_OR_DIFFERENTIAL",
            'FULL': "FULL",
            'NONE': "NONE",
        },
    }

    validations = {
        ('source_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('group_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('description',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('sync_policy_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('retention_policy_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('tags',): {
            'max_items': 1000,
            'min_items': 1,
        },
        ('mssql_backup_uuid',): {
            'max_length': 4096,
            'min_length': 1,
        },
        ('source_host_user',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('ppt_repository',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('ppt_host_user',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('staging_pre_script',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('staging_post_script',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('mssql_user_environment_reference',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('mssql_user_domain_username',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('mssql_user_domain_password',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_vault_username',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_vault',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_hashicorp_vault_engine',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_hashicorp_vault_secret_path',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_hashicorp_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_hashicorp_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_azure_vault_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_azure_vault_username_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_azure_vault_secret_key',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_user_domain_cyberark_vault_query_string',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('mssql_database_username',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('mssql_database_password',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_managed_shared_backup_locations',): {
            'max_items': 260,
        },
        ('external_netbackup_config_master_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_netbackup_config_source_client_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_commserve_host_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_commvault_config_source_client_name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('external_commvault_config_staging_client_name',): {
            'max_length': 256,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'source_id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'group_id': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'log_sync_enabled': (bool,),  # noqa: E501
            'sync_policy_id': (str,),  # noqa: E501
            'retention_policy_id': (str,),  # noqa: E501
            'make_current_account_owner': (bool,),  # noqa: E501
            'tags': ([Tag],),  # noqa: E501
            'ops_pre_sync': ([SourceOperation],),  # noqa: E501
            'ops_post_sync': ([SourceOperation],),  # noqa: E501
            'encryption_key': (str,),  # noqa: E501
            'sync_strategy': (str,),  # noqa: E501
            'mssql_backup_uuid': (str,),  # noqa: E501
            'compression_enabled': (bool,),  # noqa: E501
            'availability_group_backup_policy': (str,),  # noqa: E501
            'source_host_user': (str,),  # noqa: E501
            'ppt_repository': (str,),  # noqa: E501
            'ppt_host_user': (str,),  # noqa: E501
            'staging_pre_script': (str,),  # noqa: E501
            'staging_post_script': (str,),  # noqa: E501
            'sync_strategy_managed_type': (str,),  # noqa: E501
            'mssql_user_environment_reference': (str,),  # noqa: E501
            'mssql_user_domain_username': (str,),  # noqa: E501
            'mssql_user_domain_password': (str,),  # noqa: E501
            'mssql_user_domain_vault_username': (str,),  # noqa: E501
            'mssql_user_domain_vault': (str,),  # noqa: E501
            'mssql_user_domain_hashicorp_vault_engine': (str,),  # noqa: E501
            'mssql_user_domain_hashicorp_vault_secret_path': (str,),  # noqa: E501
            'mssql_user_domain_hashicorp_vault_username_key': (str,),  # noqa: E501
            'mssql_user_domain_hashicorp_vault_secret_key': (str,),  # noqa: E501
            'mssql_user_domain_azure_vault_name': (str,),  # noqa: E501
            'mssql_user_domain_azure_vault_username_key': (str,),  # noqa: E501
            'mssql_user_domain_azure_vault_secret_key': (str,),  # noqa: E501
            'mssql_user_domain_cyberark_vault_query_string': (str,),  # noqa: E501
            'mssql_database_username': (str,),  # noqa: E501
            'mssql_database_password': (str,),  # noqa: E501
            'delphix_managed_backup_compression_enabled': (bool,),  # noqa: E501
            'delphix_managed_backup_policy': (str,),  # noqa: E501
            'external_managed_validate_sync_mode': (str,),  # noqa: E501
            'external_managed_shared_backup_locations': ([str],),  # noqa: E501
            'external_netbackup_config_master_name': (str,),  # noqa: E501
            'external_netbackup_config_source_client_name': (str,),  # noqa: E501
            'external_netbackup_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'external_netbackup_config_templates': (str,),  # noqa: E501
            'external_commserve_host_name': (str,),  # noqa: E501
            'external_commvault_config_source_client_name': (str,),  # noqa: E501
            'external_commvault_config_staging_client_name': (str,),  # noqa: E501
            'external_commvault_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'external_commvault_config_templates': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'source_id': 'source_id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'group_id': 'group_id',  # noqa: E501
        'description': 'description',  # noqa: E501
        'log_sync_enabled': 'log_sync_enabled',  # noqa: E501
        'sync_policy_id': 'sync_policy_id',  # noqa: E501
        'retention_policy_id': 'retention_policy_id',  # noqa: E501
        'make_current_account_owner': 'make_current_account_owner',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'ops_pre_sync': 'ops_pre_sync',  # noqa: E501
        'ops_post_sync': 'ops_post_sync',  # noqa: E501
        'encryption_key': 'encryption_key',  # noqa: E501
        'sync_strategy': 'sync_strategy',  # noqa: E501
        'mssql_backup_uuid': 'mssql_backup_uuid',  # noqa: E501
        'compression_enabled': 'compression_enabled',  # noqa: E501
        'availability_group_backup_policy': 'availability_group_backup_policy',  # noqa: E501
        'source_host_user': 'source_host_user',  # noqa: E501
        'ppt_repository': 'ppt_repository',  # noqa: E501
        'ppt_host_user': 'ppt_host_user',  # noqa: E501
        'staging_pre_script': 'staging_pre_script',  # noqa: E501
        'staging_post_script': 'staging_post_script',  # noqa: E501
        'sync_strategy_managed_type': 'sync_strategy_managed_type',  # noqa: E501
        'mssql_user_environment_reference': 'mssql_user_environment_reference',  # noqa: E501
        'mssql_user_domain_username': 'mssql_user_domain_username',  # noqa: E501
        'mssql_user_domain_password': 'mssql_user_domain_password',  # noqa: E501
        'mssql_user_domain_vault_username': 'mssql_user_domain_vault_username',  # noqa: E501
        'mssql_user_domain_vault': 'mssql_user_domain_vault',  # noqa: E501
        'mssql_user_domain_hashicorp_vault_engine': 'mssql_user_domain_hashicorp_vault_engine',  # noqa: E501
        'mssql_user_domain_hashicorp_vault_secret_path': 'mssql_user_domain_hashicorp_vault_secret_path',  # noqa: E501
        'mssql_user_domain_hashicorp_vault_username_key': 'mssql_user_domain_hashicorp_vault_username_key',  # noqa: E501
        'mssql_user_domain_hashicorp_vault_secret_key': 'mssql_user_domain_hashicorp_vault_secret_key',  # noqa: E501
        'mssql_user_domain_azure_vault_name': 'mssql_user_domain_azure_vault_name',  # noqa: E501
        'mssql_user_domain_azure_vault_username_key': 'mssql_user_domain_azure_vault_username_key',  # noqa: E501
        'mssql_user_domain_azure_vault_secret_key': 'mssql_user_domain_azure_vault_secret_key',  # noqa: E501
        'mssql_user_domain_cyberark_vault_query_string': 'mssql_user_domain_cyberark_vault_query_string',  # noqa: E501
        'mssql_database_username': 'mssql_database_username',  # noqa: E501
        'mssql_database_password': 'mssql_database_password',  # noqa: E501
        'delphix_managed_backup_compression_enabled': 'delphix_managed_backup_compression_enabled',  # noqa: E501
        'delphix_managed_backup_policy': 'delphix_managed_backup_policy',  # noqa: E501
        'external_managed_validate_sync_mode': 'external_managed_validate_sync_mode',  # noqa: E501
        'external_managed_shared_backup_locations': 'external_managed_shared_backup_locations',  # noqa: E501
        'external_netbackup_config_master_name': 'external_netbackup_config_master_name',  # noqa: E501
        'external_netbackup_config_source_client_name': 'external_netbackup_config_source_client_name',  # noqa: E501
        'external_netbackup_config_params': 'external_netbackup_config_params',  # noqa: E501
        'external_netbackup_config_templates': 'external_netbackup_config_templates',  # noqa: E501
        'external_commserve_host_name': 'external_commserve_host_name',  # noqa: E501
        'external_commvault_config_source_client_name': 'external_commvault_config_source_client_name',  # noqa: E501
        'external_commvault_config_staging_client_name': 'external_commvault_config_staging_client_name',  # noqa: E501
        'external_commvault_config_params': 'external_commvault_config_params',  # noqa: E501
        'external_commvault_config_templates': 'external_commvault_config_templates',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """MSSQLDSourceLinkSourceParameters - a model defined in OpenAPI

        Keyword Args:
            source_id (str): Id of the source to link.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Name of the dSource to be created.. [optional]  # noqa: E501
            group_id (str): Id of the dataset group where this dSource should belong to.. [optional]  # noqa: E501
            description (str): The notes/description for the dSource.. [optional]  # noqa: E501
            log_sync_enabled (bool): True if LogSync should run for this database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            sync_policy_id (str): The ID of the SnapSync policy for the dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The ID of the Retention policy for the dSource.. [optional]  # noqa: E501
            make_current_account_owner (bool): Whether the account creating this reporting schedule must be configured as owner of the reporting schedule.. [optional] if omitted the server will use the default value of True  # noqa: E501
            tags ([Tag]): The tags to be created for dSource.. [optional]  # noqa: E501
            ops_pre_sync ([SourceOperation]): Operations to perform before syncing the created dSource. These operations can quiesce any data prior to syncing.. [optional]  # noqa: E501
            ops_post_sync ([SourceOperation]): Operations to perform after syncing a created dSource.. [optional]  # noqa: E501
            encryption_key (str): The encryption key to use when restoring encrypted backups.. [optional]  # noqa: E501
            sync_strategy (str): Determines how the Delphix Engine will take a backup: * `latest_backup` - Use the most recent backup. * `new_backup` - Delphix will take a new backup of your source database. * `specific_backup` - Use a specific backup. Using this option requires setting `ase_backup_files`. * `no_backup` - Use as input to sync MSSQL databases without a backup. Default is `new_backup`. . [optional] if omitted the server will use the default value of "new_backup"  # noqa: E501
            mssql_backup_uuid (str): When using the `specific_backup` sync_strategy, determines the Backup Set UUID.. [optional]  # noqa: E501
            compression_enabled (bool): When using the `new_backup` sync_strategy, determines if compression must be enabled. Defaults to the configuration of the ingestion strategy configured on the Delphix Engine for this dSource.. [optional] if omitted the server will use the default value of False  # noqa: E501
            availability_group_backup_policy (str): When using the `new_backup` sync_strategy for an MSSql Availability Group, determines the backup policy: * `primary` - Backups only go to the primary node. * `secondary_only` - Backups only go to secondary nodes. If secondary nodes are down, backups will fail. * `prefer_secondary` - Backups go to secondary nodes, but if secondary nodes are down, backups will go to the primary node. . [optional] if omitted the server will use the default value of "primary"  # noqa: E501
            source_host_user (str): ID or user reference of the host OS user to use for linking.. [optional]  # noqa: E501
            ppt_repository (str): Reference of the SQL instance on the PPT environment that we want to use for pre-provisioning.. [optional]  # noqa: E501
            ppt_host_user (str): Reference of the host OS user on the PPT host to use for linking.. [optional]  # noqa: E501
            staging_pre_script (str): A user-provided PowerShell script or executable to run prior to restoring from a backup during pre-provisioning.. [optional]  # noqa: E501
            staging_post_script (str): A user-provided PowerShell script or executable to run after restoring from a backup during pre-provisioning.. [optional]  # noqa: E501
            sync_strategy_managed_type (str): MSSQL specific parameters for source based sync strategy.: * `external` - MSSQL specific parameters for externally managed source based sync strategy. * `delphix` - MSSQL specific parameters for delphix managed source based sync strategy. * `staging_push` - MSSQL specific parameters for staging push based sync strategy. . [optional] if omitted the server will use the default value of "external"  # noqa: E501
            mssql_user_environment_reference (str): Reference to the source environment user to use for linking.. [optional]  # noqa: E501
            mssql_user_domain_username (str): The username for the source DB user.. [optional]  # noqa: E501
            mssql_user_domain_password (str): Password for the database user.. [optional]  # noqa: E501
            mssql_user_domain_vault_username (str): Delphix display name for the vault user.. [optional]  # noqa: E501
            mssql_user_domain_vault (str): The name or reference of the vault from which to read the database credentials.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_name (str): Azure key vault name.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_username_key (str): Azure vault key for the username in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_secret_key (str): Azure vault key for the password in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            mssql_database_username (str): The username for the source DB user.. [optional]  # noqa: E501
            mssql_database_password (str): Password for the database user.. [optional]  # noqa: E501
            delphix_managed_backup_compression_enabled (bool): Specify whether the backups taken should be compressed or uncompressed when Delphix managed option is selected.. [optional] if omitted the server will use the default value of False  # noqa: E501
            delphix_managed_backup_policy (str): Specify which node of an availability group to run the copy-only full backup on: * `primary` - Backups only go to the primary node. * `secondary_only` - Backups only go to secondary nodes. If secondary nodes are down, backups will fail. * `prefer_secondary` - Backups go to secondary nodes, but if secondary nodes are down, backups will go to the primary node. . [optional] if omitted the server will use the default value of "primary"  # noqa: E501
            external_managed_validate_sync_mode (str): Specifies the backup types ValidatedSync will use to synchronize the dSource with the source database. [optional] if omitted the server will use the default value of "TRANSACTION_LOG"  # noqa: E501
            external_managed_shared_backup_locations ([str]): Shared source database backup locations.. [optional]  # noqa: E501
            external_netbackup_config_master_name (str): The master server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_source_client_name (str): The source's client server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NetBackup configuration parameter overrides.. [optional]  # noqa: E501
            external_netbackup_config_templates (str): Optional config template selection for NetBackup configurations. If set, external_netbackup_config_params will be ignored.. [optional]  # noqa: E501
            external_commserve_host_name (str): The commserve host name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_source_client_name (str): The source client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_staging_client_name (str): The staging client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Commvault configuration parameter overrides.. [optional]  # noqa: E501
            external_commvault_config_templates (str): Optional config template selection for Commvault configurations. If set, configParams will be ignored.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """MSSQLDSourceLinkSourceParameters - a model defined in OpenAPI

        Keyword Args:
            source_id (str): Id of the source to link.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Name of the dSource to be created.. [optional]  # noqa: E501
            group_id (str): Id of the dataset group where this dSource should belong to.. [optional]  # noqa: E501
            description (str): The notes/description for the dSource.. [optional]  # noqa: E501
            log_sync_enabled (bool): True if LogSync should run for this database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            sync_policy_id (str): The ID of the SnapSync policy for the dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The ID of the Retention policy for the dSource.. [optional]  # noqa: E501
            make_current_account_owner (bool): Whether the account creating this reporting schedule must be configured as owner of the reporting schedule.. [optional] if omitted the server will use the default value of True  # noqa: E501
            tags ([Tag]): The tags to be created for dSource.. [optional]  # noqa: E501
            ops_pre_sync ([SourceOperation]): Operations to perform before syncing the created dSource. These operations can quiesce any data prior to syncing.. [optional]  # noqa: E501
            ops_post_sync ([SourceOperation]): Operations to perform after syncing a created dSource.. [optional]  # noqa: E501
            encryption_key (str): The encryption key to use when restoring encrypted backups.. [optional]  # noqa: E501
            sync_strategy (str): Determines how the Delphix Engine will take a backup: * `latest_backup` - Use the most recent backup. * `new_backup` - Delphix will take a new backup of your source database. * `specific_backup` - Use a specific backup. Using this option requires setting `ase_backup_files`. * `no_backup` - Use as input to sync MSSQL databases without a backup. Default is `new_backup`. . [optional] if omitted the server will use the default value of "new_backup"  # noqa: E501
            mssql_backup_uuid (str): When using the `specific_backup` sync_strategy, determines the Backup Set UUID.. [optional]  # noqa: E501
            compression_enabled (bool): When using the `new_backup` sync_strategy, determines if compression must be enabled. Defaults to the configuration of the ingestion strategy configured on the Delphix Engine for this dSource.. [optional] if omitted the server will use the default value of False  # noqa: E501
            availability_group_backup_policy (str): When using the `new_backup` sync_strategy for an MSSql Availability Group, determines the backup policy: * `primary` - Backups only go to the primary node. * `secondary_only` - Backups only go to secondary nodes. If secondary nodes are down, backups will fail. * `prefer_secondary` - Backups go to secondary nodes, but if secondary nodes are down, backups will go to the primary node. . [optional] if omitted the server will use the default value of "primary"  # noqa: E501
            source_host_user (str): ID or user reference of the host OS user to use for linking.. [optional]  # noqa: E501
            ppt_repository (str): Reference of the SQL instance on the PPT environment that we want to use for pre-provisioning.. [optional]  # noqa: E501
            ppt_host_user (str): Reference of the host OS user on the PPT host to use for linking.. [optional]  # noqa: E501
            staging_pre_script (str): A user-provided PowerShell script or executable to run prior to restoring from a backup during pre-provisioning.. [optional]  # noqa: E501
            staging_post_script (str): A user-provided PowerShell script or executable to run after restoring from a backup during pre-provisioning.. [optional]  # noqa: E501
            sync_strategy_managed_type (str): MSSQL specific parameters for source based sync strategy.: * `external` - MSSQL specific parameters for externally managed source based sync strategy. * `delphix` - MSSQL specific parameters for delphix managed source based sync strategy. * `staging_push` - MSSQL specific parameters for staging push based sync strategy. . [optional] if omitted the server will use the default value of "external"  # noqa: E501
            mssql_user_environment_reference (str): Reference to the source environment user to use for linking.. [optional]  # noqa: E501
            mssql_user_domain_username (str): The username for the source DB user.. [optional]  # noqa: E501
            mssql_user_domain_password (str): Password for the database user.. [optional]  # noqa: E501
            mssql_user_domain_vault_username (str): Delphix display name for the vault user.. [optional]  # noqa: E501
            mssql_user_domain_vault (str): The name or reference of the vault from which to read the database credentials.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_engine (str): Vault engine name where the credential is stored.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_secret_path (str): Path in the vault engine where the credential is stored.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_username_key (str): Hashicorp vault key for the username in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_hashicorp_vault_secret_key (str): Hashicorp vault key for the password in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_name (str): Azure key vault name.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_username_key (str): Azure vault key for the username in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_azure_vault_secret_key (str): Azure vault key for the password in the key-value store.. [optional]  # noqa: E501
            mssql_user_domain_cyberark_vault_query_string (str): Query to find a credential in the CyberArk vault.. [optional]  # noqa: E501
            mssql_database_username (str): The username for the source DB user.. [optional]  # noqa: E501
            mssql_database_password (str): Password for the database user.. [optional]  # noqa: E501
            delphix_managed_backup_compression_enabled (bool): Specify whether the backups taken should be compressed or uncompressed when Delphix managed option is selected.. [optional] if omitted the server will use the default value of False  # noqa: E501
            delphix_managed_backup_policy (str): Specify which node of an availability group to run the copy-only full backup on: * `primary` - Backups only go to the primary node. * `secondary_only` - Backups only go to secondary nodes. If secondary nodes are down, backups will fail. * `prefer_secondary` - Backups go to secondary nodes, but if secondary nodes are down, backups will go to the primary node. . [optional] if omitted the server will use the default value of "primary"  # noqa: E501
            external_managed_validate_sync_mode (str): Specifies the backup types ValidatedSync will use to synchronize the dSource with the source database. [optional] if omitted the server will use the default value of "TRANSACTION_LOG"  # noqa: E501
            external_managed_shared_backup_locations ([str]): Shared source database backup locations.. [optional]  # noqa: E501
            external_netbackup_config_master_name (str): The master server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_source_client_name (str): The source's client server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NetBackup configuration parameter overrides.. [optional]  # noqa: E501
            external_netbackup_config_templates (str): Optional config template selection for NetBackup configurations. If set, external_netbackup_config_params will be ignored.. [optional]  # noqa: E501
            external_commserve_host_name (str): The commserve host name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_source_client_name (str): The source client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_staging_client_name (str): The staging client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Commvault configuration parameter overrides.. [optional]  # noqa: E501
            external_commvault_config_templates (str): Optional config template selection for Commvault configurations. If set, configParams will be ignored.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              BaseDSourceLinkSourceParameters,
              MSSQLDSourceLinkSourceParametersAllOf,
          ],
          'oneOf': [
          ],
        }
