"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError



class HyperscaleMountPoint(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('mount_type',): {
            'CIFS': "CIFS",
            'NFS3': "NFS3",
            'NFS4': "NFS4",
        },
        ('staging_storage_type',): {
            'MOUNT': "MOUNT",
            'AWS_S3': "AWS_S3",
        },
        ('auth_mechanism',): {
            'ROLE': "AWS_ROLE",
            'SECRET': "AWS_SECRET",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'hyperscale_instance_id': (str,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'hostname': (str,),  # noqa: E501
            'mount_path': (str,),  # noqa: E501
            'mount_type': (str,),  # noqa: E501
            'options': (str,),  # noqa: E501
            'staging_storage_type': (str,),  # noqa: E501
            'auth_mechanism': (str,),  # noqa: E501
            'aws_bucket_name': (str,),  # noqa: E501
            'aws_bucket_region': (str,),  # noqa: E501
            'aws_bucket_prefix': (str,),  # noqa: E501
            'aws_bucket_delimiter': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'hyperscale_instance_id': 'hyperscale_instance_id',  # noqa: E501
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'hostname': 'hostname',  # noqa: E501
        'mount_path': 'mount_path',  # noqa: E501
        'mount_type': 'mount_type',  # noqa: E501
        'options': 'options',  # noqa: E501
        'staging_storage_type': 'staging_storage_type',  # noqa: E501
        'auth_mechanism': 'auth_mechanism',  # noqa: E501
        'aws_bucket_name': 'aws_bucket_name',  # noqa: E501
        'aws_bucket_region': 'aws_bucket_region',  # noqa: E501
        'aws_bucket_prefix': 'aws_bucket_prefix',  # noqa: E501
        'aws_bucket_delimiter': 'aws_bucket_delimiter',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, hyperscale_instance_id, *args, **kwargs):  # noqa: E501
        """HyperscaleMountPoint - a model defined in OpenAPI

        Args:
            hyperscale_instance_id (str): The ID of the Hyperscale instance of this Mount Point.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The ID of the Hyperscale Mount Point.. [optional]  # noqa: E501
            name (str): Name of the mount, unique for a hyperscale instance. This name will be used as a directory name by the Hyperscale instance.. [optional]  # noqa: E501
            hostname (str): The host name of the server.. [optional]  # noqa: E501
            mount_path (str): The path to the directory on the filesystem to mount.. [optional]  # noqa: E501
            mount_type (str): The type of mount filesystem. Enum having values- CIFS, NFS3, NFS4.. [optional]  # noqa: E501
            options (str): The options for mount. The endpoint will return all default options and user specified options.. [optional]  # noqa: E501
            staging_storage_type (str): The type of staging storage.. [optional]  # noqa: E501
            auth_mechanism (str): The authentication mechanism for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_name (str): The aws bucket name for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_region (str): The aws bucket region for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_prefix (str): The aws bucket prefix for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_delimiter (str): The aws bucket delimiter for AWS_S3 storage.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.hyperscale_instance_id = hyperscale_instance_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, hyperscale_instance_id, *args, **kwargs):  # noqa: E501
        """HyperscaleMountPoint - a model defined in OpenAPI

        Args:
            hyperscale_instance_id (str): The ID of the Hyperscale instance of this Mount Point.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The ID of the Hyperscale Mount Point.. [optional]  # noqa: E501
            name (str): Name of the mount, unique for a hyperscale instance. This name will be used as a directory name by the Hyperscale instance.. [optional]  # noqa: E501
            hostname (str): The host name of the server.. [optional]  # noqa: E501
            mount_path (str): The path to the directory on the filesystem to mount.. [optional]  # noqa: E501
            mount_type (str): The type of mount filesystem. Enum having values- CIFS, NFS3, NFS4.. [optional]  # noqa: E501
            options (str): The options for mount. The endpoint will return all default options and user specified options.. [optional]  # noqa: E501
            staging_storage_type (str): The type of staging storage.. [optional]  # noqa: E501
            auth_mechanism (str): The authentication mechanism for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_name (str): The aws bucket name for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_region (str): The aws bucket region for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_prefix (str): The aws bucket prefix for AWS_S3 storage.. [optional]  # noqa: E501
            aws_bucket_delimiter (str): The aws bucket delimiter for AWS_S3 storage.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.hyperscale_instance_id = hyperscale_instance_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
