"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.hyperscale_column_or_field import HyperscaleColumnOrField
    globals()['HyperscaleColumnOrField'] = HyperscaleColumnOrField


class HyperscaleDatasetTableOrFile(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'schema_name': (str,),  # noqa: E501
            'table_name': (str,),  # noqa: E501
            'collection_name': (str,),  # noqa: E501
            'database_name': (str,),  # noqa: E501
            'filter_key': (str,),  # noqa: E501
            'column_array_rows': (int,),  # noqa: E501
            'unload_split': (int,),  # noqa: E501
            'stream_size': (int,),  # noqa: E501
            'end_of_record': (str,),  # noqa: E501
            'delimiter': (str,),  # noqa: E501
            'enclosure': (str,),  # noqa: E501
            'enclosure_escape_character': (str,),  # noqa: E501
            'escape_enclosure_escape_character': (bool,),  # noqa: E501
            'has_headers': (bool,),  # noqa: E501
            'unique_source_files_identifier': (str,),  # noqa: E501
            'source_files': ([str],),  # noqa: E501
            'perform_join': (bool,),  # noqa: E501
            'masking_inventory': ([HyperscaleColumnOrField],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'schema_name': 'schema_name',  # noqa: E501
        'table_name': 'table_name',  # noqa: E501
        'collection_name': 'collection_name',  # noqa: E501
        'database_name': 'database_name',  # noqa: E501
        'filter_key': 'filter_key',  # noqa: E501
        'column_array_rows': 'column_array_rows',  # noqa: E501
        'unload_split': 'unload_split',  # noqa: E501
        'stream_size': 'stream_size',  # noqa: E501
        'end_of_record': 'end_of_record',  # noqa: E501
        'delimiter': 'delimiter',  # noqa: E501
        'enclosure': 'enclosure',  # noqa: E501
        'enclosure_escape_character': 'enclosure_escape_character',  # noqa: E501
        'escape_enclosure_escape_character': 'escape_enclosure_escape_character',  # noqa: E501
        'has_headers': 'has_headers',  # noqa: E501
        'unique_source_files_identifier': 'unique_source_files_identifier',  # noqa: E501
        'source_files': 'source_files',  # noqa: E501
        'perform_join': 'perform_join',  # noqa: E501
        'masking_inventory': 'masking_inventory',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """HyperscaleDatasetTableOrFile - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The ID of the Hyperscale Dataset table or file.. [optional]  # noqa: E501
            schema_name (str): Name of the table schema (Oracle/MSSql only).. [optional]  # noqa: E501
            table_name (str): Name of the table (Oracle/MSSql only).. [optional]  # noqa: E501
            collection_name (str): Name of the collection (MongoDB only).. [optional]  # noqa: E501
            database_name (str): Name of the database (MongoDB only).. [optional]  # noqa: E501
            filter_key (str): The unique database column field to filter the source data.. [optional]  # noqa: E501
            column_array_rows (int): The number of column array rows to be used by the sqlldr oracle utility which determines the number of rows loaded before the stream buffer is built.. [optional]  # noqa: E501
            unload_split (int): The number of unloaded files to be generated from the source database.. [optional]  # noqa: E501
            stream_size (int): Long The stream size to be used by the sqlldr oracle utility which specifies the size (in bytes) of the data stream sent from the client to the server.. [optional]  # noqa: E501
            end_of_record (str): The end of line character. Support values are \\n, \\r  and \\r\\n (Delimited files only).. [optional]  # noqa: E501
            delimiter (str): The single character length delimiter used in source files (Delimited files only).. [optional]  # noqa: E501
            enclosure (str): The single character length quote character used in the source files (Delimited files only).. [optional]  # noqa: E501
            enclosure_escape_character (str): The escape character used to escape quote characters (Delimited files only).. [optional]  # noqa: E501
            escape_enclosure_escape_character (bool): Whether to escape the enclosure escape character (Delimited files only).. [optional]  # noqa: E501
            has_headers (bool): Whether source files have header column names or not (Delimited files only). If set to true, format files with the same column names are created and the same can be used for the masking inventory. If set to false, the column names of pattern f0, f1, f2, and so on are used to create the format files for delimited file masking.. [optional]  # noqa: E501
            unique_source_files_identifier (str): This is the source key that maps the load-service and masking-service data sets with the unload-service data set (Delimited files only). Please ensure that this value is different for each HyperscaleDatasetTableOrFile.. [optional]  # noqa: E501
            source_files ([str]): List of all source files that need to be masked (Delimited files only). All files should have the same delimiter character and other helper characters. All files should have the same number of columns and same column names if it has a header line.. [optional]  # noqa: E501
            perform_join (bool): Whether the split files must be joined (Delimited files only).. [optional]  # noqa: E501
            masking_inventory ([HyperscaleColumnOrField]): DataSet information for masking inventory.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperscaleDatasetTableOrFile - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The ID of the Hyperscale Dataset table or file.. [optional]  # noqa: E501
            schema_name (str): Name of the table schema (Oracle/MSSql only).. [optional]  # noqa: E501
            table_name (str): Name of the table (Oracle/MSSql only).. [optional]  # noqa: E501
            collection_name (str): Name of the collection (MongoDB only).. [optional]  # noqa: E501
            database_name (str): Name of the database (MongoDB only).. [optional]  # noqa: E501
            filter_key (str): The unique database column field to filter the source data.. [optional]  # noqa: E501
            column_array_rows (int): The number of column array rows to be used by the sqlldr oracle utility which determines the number of rows loaded before the stream buffer is built.. [optional]  # noqa: E501
            unload_split (int): The number of unloaded files to be generated from the source database.. [optional]  # noqa: E501
            stream_size (int): Long The stream size to be used by the sqlldr oracle utility which specifies the size (in bytes) of the data stream sent from the client to the server.. [optional]  # noqa: E501
            end_of_record (str): The end of line character. Support values are \\n, \\r  and \\r\\n (Delimited files only).. [optional]  # noqa: E501
            delimiter (str): The single character length delimiter used in source files (Delimited files only).. [optional]  # noqa: E501
            enclosure (str): The single character length quote character used in the source files (Delimited files only).. [optional]  # noqa: E501
            enclosure_escape_character (str): The escape character used to escape quote characters (Delimited files only).. [optional]  # noqa: E501
            escape_enclosure_escape_character (bool): Whether to escape the enclosure escape character (Delimited files only).. [optional]  # noqa: E501
            has_headers (bool): Whether source files have header column names or not (Delimited files only). If set to true, format files with the same column names are created and the same can be used for the masking inventory. If set to false, the column names of pattern f0, f1, f2, and so on are used to create the format files for delimited file masking.. [optional]  # noqa: E501
            unique_source_files_identifier (str): This is the source key that maps the load-service and masking-service data sets with the unload-service data set (Delimited files only). Please ensure that this value is different for each HyperscaleDatasetTableOrFile.. [optional]  # noqa: E501
            source_files ([str]): List of all source files that need to be masked (Delimited files only). All files should have the same delimiter character and other helper characters. All files should have the same number of columns and same column names if it has a header line.. [optional]  # noqa: E501
            perform_join (bool): Whether the split files must be joined (Delimited files only).. [optional]  # noqa: E501
            masking_inventory ([HyperscaleColumnOrField]): DataSet information for masking inventory.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
