"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.d_source_hooks import DSourceHooks
    from delphix.api.gateway.model.oracle_logsync_mode_type_enum import OracleLogsyncModeTypeEnum
    from delphix.api.gateway.model.replica import Replica
    from delphix.api.gateway.model.tag import Tag
    globals()['DSourceHooks'] = DSourceHooks
    globals()['OracleLogsyncModeTypeEnum'] = OracleLogsyncModeTypeEnum
    globals()['Replica'] = Replica
    globals()['Tag'] = Tag


class DSource(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('mssql_sync_strategy_managed_type',): {
            'EXTERNAL': "external",
            'DELPHIX': "delphix",
            'STAGING_PUSH': "staging_push",
        },
        ('validated_sync_mode',): {
            'TRANSACTION_LOG': "TRANSACTION_LOG",
            'FULL_OR_DIFFERENTIAL': "FULL_OR_DIFFERENTIAL",
            'FULL': "FULL",
            'NONE': "NONE",
        },
        ('backup_policy',): {
            'PRIMARY': "PRIMARY",
            'SECONDARY_ONLY': "SECONDARY_ONLY",
            'PREFER_SECONDARY': "PREFER_SECONDARY",
        },
        ('db_state',): {
            'ONLINE': "ONLINE",
            'RESTORING': "RESTORING",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'database_type': (str, none_type,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'namespace_id': (str, none_type,),  # noqa: E501
            'namespace_name': (str, none_type,),  # noqa: E501
            'is_replica': (bool, none_type,),  # noqa: E501
            'database_version': (str, none_type,),  # noqa: E501
            'content_type': (str, none_type,),  # noqa: E501
            'data_uuid': (str, none_type,),  # noqa: E501
            'storage_size': (int, none_type,),  # noqa: E501
            'plugin_version': (str, none_type,),  # noqa: E501
            'creation_date': (datetime, none_type,),  # noqa: E501
            'group_name': (str, none_type,),  # noqa: E501
            'enabled': (bool, none_type,),  # noqa: E501
            'is_detached': (bool, none_type,),  # noqa: E501
            'engine_id': (str,),  # noqa: E501
            'source_id': (str, none_type,),  # noqa: E501
            'status': (str, none_type,),  # noqa: E501
            'engine_name': (str, none_type,),  # noqa: E501
            'cdb_id': (str, none_type,),  # noqa: E501
            'current_timeflow_id': (str,),  # noqa: E501
            'previous_timeflow_id': (str,),  # noqa: E501
            'is_appdata': (bool,),  # noqa: E501
            'toolkit_id': (str,),  # noqa: E501
            'unvirtualized_space': (int,),  # noqa: E501
            'dependant_vdbs': (int,),  # noqa: E501
            'appdata_source_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'appdata_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type,),  # noqa: E501
            'tags': ([Tag],),  # noqa: E501
            'primary_object_id': (str,),  # noqa: E501
            'primary_engine_id': (str,),  # noqa: E501
            'primary_engine_name': (str,),  # noqa: E501
            'replicas': ([Replica],),  # noqa: E501
            'hooks': (DSourceHooks,),  # noqa: E501
            'sync_policy_id': (str,),  # noqa: E501
            'retention_policy_id': (str,),  # noqa: E501
            'replica_retention_policy_id': (str,),  # noqa: E501
            'quota_policy_id': (str,),  # noqa: E501
            'logsync_enabled': (bool,),  # noqa: E501
            'logsync_mode': (OracleLogsyncModeTypeEnum,),  # noqa: E501
            'logsync_interval': (int,),  # noqa: E501
            'exported_data_directory': (str,),  # noqa: E501
            'template_id': (str, none_type,),  # noqa: E501
            'allow_auto_staging_restart_on_host_reboot': (bool,),  # noqa: E501
            'physical_standby': (bool,),  # noqa: E501
            'validate_by_opening_db_in_read_only_mode': (bool,),  # noqa: E501
            'mssql_sync_strategy_managed_type': (str,),  # noqa: E501
            'validated_sync_mode': (str,),  # noqa: E501
            'shared_backup_locations': ([str],),  # noqa: E501
            'backup_policy': (str,),  # noqa: E501
            'compression_enabled': (bool,),  # noqa: E501
            'staging_database_name': (str,),  # noqa: E501
            'db_state': (str,),  # noqa: E501
            'encryption_key': (str,),  # noqa: E501
            'external_netbackup_config_master_name': (str,),  # noqa: E501
            'external_netbackup_config_source_client_name': (str,),  # noqa: E501
            'external_netbackup_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'external_netbackup_config_templates': (str,),  # noqa: E501
            'external_commserve_host_name': (str,),  # noqa: E501
            'external_commvault_config_source_client_name': (str,),  # noqa: E501
            'external_commvault_config_staging_client_name': (str,),  # noqa: E501
            'external_commvault_config_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'external_commvault_config_templates': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'database_type': 'database_type',  # noqa: E501
        'name': 'name',  # noqa: E501
        'namespace_id': 'namespace_id',  # noqa: E501
        'namespace_name': 'namespace_name',  # noqa: E501
        'is_replica': 'is_replica',  # noqa: E501
        'database_version': 'database_version',  # noqa: E501
        'content_type': 'content_type',  # noqa: E501
        'data_uuid': 'data_uuid',  # noqa: E501
        'storage_size': 'storage_size',  # noqa: E501
        'plugin_version': 'plugin_version',  # noqa: E501
        'creation_date': 'creation_date',  # noqa: E501
        'group_name': 'group_name',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'is_detached': 'is_detached',  # noqa: E501
        'engine_id': 'engine_id',  # noqa: E501
        'source_id': 'source_id',  # noqa: E501
        'status': 'status',  # noqa: E501
        'engine_name': 'engine_name',  # noqa: E501
        'cdb_id': 'cdb_id',  # noqa: E501
        'current_timeflow_id': 'current_timeflow_id',  # noqa: E501
        'previous_timeflow_id': 'previous_timeflow_id',  # noqa: E501
        'is_appdata': 'is_appdata',  # noqa: E501
        'toolkit_id': 'toolkit_id',  # noqa: E501
        'unvirtualized_space': 'unvirtualized_space',  # noqa: E501
        'dependant_vdbs': 'dependant_vdbs',  # noqa: E501
        'appdata_source_params': 'appdata_source_params',  # noqa: E501
        'appdata_config_params': 'appdata_config_params',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'primary_object_id': 'primary_object_id',  # noqa: E501
        'primary_engine_id': 'primary_engine_id',  # noqa: E501
        'primary_engine_name': 'primary_engine_name',  # noqa: E501
        'replicas': 'replicas',  # noqa: E501
        'hooks': 'hooks',  # noqa: E501
        'sync_policy_id': 'sync_policy_id',  # noqa: E501
        'retention_policy_id': 'retention_policy_id',  # noqa: E501
        'replica_retention_policy_id': 'replica_retention_policy_id',  # noqa: E501
        'quota_policy_id': 'quota_policy_id',  # noqa: E501
        'logsync_enabled': 'logsync_enabled',  # noqa: E501
        'logsync_mode': 'logsync_mode',  # noqa: E501
        'logsync_interval': 'logsync_interval',  # noqa: E501
        'exported_data_directory': 'exported_data_directory',  # noqa: E501
        'template_id': 'template_id',  # noqa: E501
        'allow_auto_staging_restart_on_host_reboot': 'allow_auto_staging_restart_on_host_reboot',  # noqa: E501
        'physical_standby': 'physical_standby',  # noqa: E501
        'validate_by_opening_db_in_read_only_mode': 'validate_by_opening_db_in_read_only_mode',  # noqa: E501
        'mssql_sync_strategy_managed_type': 'mssql_sync_strategy_managed_type',  # noqa: E501
        'validated_sync_mode': 'validated_sync_mode',  # noqa: E501
        'shared_backup_locations': 'shared_backup_locations',  # noqa: E501
        'backup_policy': 'backup_policy',  # noqa: E501
        'compression_enabled': 'compression_enabled',  # noqa: E501
        'staging_database_name': 'staging_database_name',  # noqa: E501
        'db_state': 'db_state',  # noqa: E501
        'encryption_key': 'encryption_key',  # noqa: E501
        'external_netbackup_config_master_name': 'external_netbackup_config_master_name',  # noqa: E501
        'external_netbackup_config_source_client_name': 'external_netbackup_config_source_client_name',  # noqa: E501
        'external_netbackup_config_params': 'external_netbackup_config_params',  # noqa: E501
        'external_netbackup_config_templates': 'external_netbackup_config_templates',  # noqa: E501
        'external_commserve_host_name': 'external_commserve_host_name',  # noqa: E501
        'external_commvault_config_source_client_name': 'external_commvault_config_source_client_name',  # noqa: E501
        'external_commvault_config_staging_client_name': 'external_commvault_config_staging_client_name',  # noqa: E501
        'external_commvault_config_params': 'external_commvault_config_params',  # noqa: E501
        'external_commvault_config_templates': 'external_commvault_config_templates',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """DSource - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The dSource object entity ID.. [optional]  # noqa: E501
            database_type (str, none_type): The database type of this dSource.. [optional]  # noqa: E501
            name (str, none_type): The container name of this dSource.. [optional]  # noqa: E501
            namespace_id (str, none_type): The namespace id of this dSource.. [optional]  # noqa: E501
            namespace_name (str, none_type): The namespace name of this dSource.. [optional]  # noqa: E501
            is_replica (bool, none_type): Is this a replicated object.. [optional]  # noqa: E501
            database_version (str, none_type): The database version of this dSource.. [optional]  # noqa: E501
            content_type (str, none_type): The content type of the dSource.. [optional]  # noqa: E501
            data_uuid (str, none_type): A universal ID that uniquely identifies the dSource database.. [optional]  # noqa: E501
            storage_size (int, none_type): The actual space used by this dSource, in bytes.. [optional]  # noqa: E501
            plugin_version (str, none_type): The version of the plugin associated with this source database.. [optional]  # noqa: E501
            creation_date (datetime, none_type): The date this dSource was created.. [optional]  # noqa: E501
            group_name (str, none_type): The name of the group containing this dSource.. [optional]  # noqa: E501
            enabled (bool, none_type): A value indicating whether this dSource is enabled.. [optional]  # noqa: E501
            is_detached (bool, none_type): A value indicating whether this dSource is detached.. [optional]  # noqa: E501
            engine_id (str): A reference to the Engine that this dSource belongs to.. [optional]  # noqa: E501
            source_id (str, none_type): A reference to the Source associated with this dSource.. [optional]  # noqa: E501
            status (str, none_type): The runtime status of the dSource. 'Unknown' if all attempts to connect to the source failed.. [optional]  # noqa: E501
            engine_name (str, none_type): Name of the Engine where this DSource is hosted. [optional]  # noqa: E501
            cdb_id (str, none_type): A reference to the CDB associated with this dSource.. [optional]  # noqa: E501
            current_timeflow_id (str): A reference to the currently active timeflow for this dSource.. [optional]  # noqa: E501
            previous_timeflow_id (str): A reference to the previous timeflow for this dSource.. [optional]  # noqa: E501
            is_appdata (bool): Indicates whether this dSource has an AppData database.. [optional]  # noqa: E501
            toolkit_id (str): The ID of the toolkit associated with this dSource(AppData only).. [optional]  # noqa: E501
            unvirtualized_space (int): This is the sum of unvirtualized space from the dependants VDBs of the dSource.. [optional]  # noqa: E501
            dependant_vdbs (int): The number of VDBs that are dependant on this dSource. This includes all VDB descendants that have this dSource as an ancestor.. [optional]  # noqa: E501
            appdata_source_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): The JSON payload conforming to the DraftV4 schema based on the type of application data being manipulated.. [optional]  # noqa: E501
            appdata_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): The parameters specified by the source config schema in the toolkit. [optional]  # noqa: E501
            tags ([Tag]): [optional]  # noqa: E501
            primary_object_id (str): The ID of the parent object from which replication was done.. [optional]  # noqa: E501
            primary_engine_id (str): The ID of the parent engine from which replication was done.. [optional]  # noqa: E501
            primary_engine_name (str): The name of the parent engine from which replication was done.. [optional]  # noqa: E501
            replicas ([Replica]): The list of replicas replicated from this object.. [optional]  # noqa: E501
            hooks (DSourceHooks): [optional]  # noqa: E501
            sync_policy_id (str): The id of the snapshot policy associated with this dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The id of the retention policy associated with this dSource.. [optional]  # noqa: E501
            replica_retention_policy_id (str): The id of the replica retention policy associated with this dSource.. [optional]  # noqa: E501
            quota_policy_id (str): The id of the quota policy associated with this dSource.. [optional]  # noqa: E501
            logsync_enabled (bool): True if LogSync is enabled for this dSource.. [optional]  # noqa: E501
            logsync_mode (OracleLogsyncModeTypeEnum): [optional]  # noqa: E501
            logsync_interval (int): Interval between LogSync requests, in seconds.. [optional]  # noqa: E501
            exported_data_directory (str): ZFS exported data directory path.. [optional]  # noqa: E501
            template_id (str, none_type): A reference to the Non Virtual Database Template.. [optional]  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Indicates whether Delphix should automatically restart this staging database when staging host reboot is detected.. [optional]  # noqa: E501
            physical_standby (bool): Indicates whether this staging database is configured as a physical standby.. [optional]  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Indicates whether this staging database snapshot is validated by opening it in read-only mode.. [optional]  # noqa: E501
            mssql_sync_strategy_managed_type (str): [optional]  # noqa: E501
            validated_sync_mode (str): Specifies the backup types ValidatedSync will use to synchronize the dSource with the source database.. [optional]  # noqa: E501
            shared_backup_locations ([str]): Shared source database backup locations.. [optional]  # noqa: E501
            backup_policy (str): Specify which node of an availability group to run the copy-only full backup on. [optional]  # noqa: E501
            compression_enabled (bool): Specify whether the backups taken should be compressed or uncompressed.. [optional]  # noqa: E501
            staging_database_name (str): The name of the staging database. [optional]  # noqa: E501
            db_state (str): User provided db state that is used to create staging push db. [optional]  # noqa: E501
            encryption_key (str): The encryption key to use when restoring encrypted backups.. [optional]  # noqa: E501
            external_netbackup_config_master_name (str): The master server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_source_client_name (str): The source's client server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NetBackup configuration parameter overrides.. [optional]  # noqa: E501
            external_netbackup_config_templates (str): Optional config template selection for NetBackup configurations.. [optional]  # noqa: E501
            external_commserve_host_name (str): The commserve host name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_source_client_name (str): The source client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_staging_client_name (str): The staging client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Commvault configuration parameter overrides.. [optional]  # noqa: E501
            external_commvault_config_templates (str): Optional config template selection for Commvault configurations.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """DSource - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The dSource object entity ID.. [optional]  # noqa: E501
            database_type (str, none_type): The database type of this dSource.. [optional]  # noqa: E501
            name (str, none_type): The container name of this dSource.. [optional]  # noqa: E501
            namespace_id (str, none_type): The namespace id of this dSource.. [optional]  # noqa: E501
            namespace_name (str, none_type): The namespace name of this dSource.. [optional]  # noqa: E501
            is_replica (bool, none_type): Is this a replicated object.. [optional]  # noqa: E501
            database_version (str, none_type): The database version of this dSource.. [optional]  # noqa: E501
            content_type (str, none_type): The content type of the dSource.. [optional]  # noqa: E501
            data_uuid (str, none_type): A universal ID that uniquely identifies the dSource database.. [optional]  # noqa: E501
            storage_size (int, none_type): The actual space used by this dSource, in bytes.. [optional]  # noqa: E501
            plugin_version (str, none_type): The version of the plugin associated with this source database.. [optional]  # noqa: E501
            creation_date (datetime, none_type): The date this dSource was created.. [optional]  # noqa: E501
            group_name (str, none_type): The name of the group containing this dSource.. [optional]  # noqa: E501
            enabled (bool, none_type): A value indicating whether this dSource is enabled.. [optional]  # noqa: E501
            is_detached (bool, none_type): A value indicating whether this dSource is detached.. [optional]  # noqa: E501
            engine_id (str): A reference to the Engine that this dSource belongs to.. [optional]  # noqa: E501
            source_id (str, none_type): A reference to the Source associated with this dSource.. [optional]  # noqa: E501
            status (str, none_type): The runtime status of the dSource. 'Unknown' if all attempts to connect to the source failed.. [optional]  # noqa: E501
            engine_name (str, none_type): Name of the Engine where this DSource is hosted. [optional]  # noqa: E501
            cdb_id (str, none_type): A reference to the CDB associated with this dSource.. [optional]  # noqa: E501
            current_timeflow_id (str): A reference to the currently active timeflow for this dSource.. [optional]  # noqa: E501
            previous_timeflow_id (str): A reference to the previous timeflow for this dSource.. [optional]  # noqa: E501
            is_appdata (bool): Indicates whether this dSource has an AppData database.. [optional]  # noqa: E501
            toolkit_id (str): The ID of the toolkit associated with this dSource(AppData only).. [optional]  # noqa: E501
            unvirtualized_space (int): This is the sum of unvirtualized space from the dependants VDBs of the dSource.. [optional]  # noqa: E501
            dependant_vdbs (int): The number of VDBs that are dependant on this dSource. This includes all VDB descendants that have this dSource as an ancestor.. [optional]  # noqa: E501
            appdata_source_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): The JSON payload conforming to the DraftV4 schema based on the type of application data being manipulated.. [optional]  # noqa: E501
            appdata_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type): The parameters specified by the source config schema in the toolkit. [optional]  # noqa: E501
            tags ([Tag]): [optional]  # noqa: E501
            primary_object_id (str): The ID of the parent object from which replication was done.. [optional]  # noqa: E501
            primary_engine_id (str): The ID of the parent engine from which replication was done.. [optional]  # noqa: E501
            primary_engine_name (str): The name of the parent engine from which replication was done.. [optional]  # noqa: E501
            replicas ([Replica]): The list of replicas replicated from this object.. [optional]  # noqa: E501
            hooks (DSourceHooks): [optional]  # noqa: E501
            sync_policy_id (str): The id of the snapshot policy associated with this dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The id of the retention policy associated with this dSource.. [optional]  # noqa: E501
            replica_retention_policy_id (str): The id of the replica retention policy associated with this dSource.. [optional]  # noqa: E501
            quota_policy_id (str): The id of the quota policy associated with this dSource.. [optional]  # noqa: E501
            logsync_enabled (bool): True if LogSync is enabled for this dSource.. [optional]  # noqa: E501
            logsync_mode (OracleLogsyncModeTypeEnum): [optional]  # noqa: E501
            logsync_interval (int): Interval between LogSync requests, in seconds.. [optional]  # noqa: E501
            exported_data_directory (str): ZFS exported data directory path.. [optional]  # noqa: E501
            template_id (str, none_type): A reference to the Non Virtual Database Template.. [optional]  # noqa: E501
            allow_auto_staging_restart_on_host_reboot (bool): Indicates whether Delphix should automatically restart this staging database when staging host reboot is detected.. [optional]  # noqa: E501
            physical_standby (bool): Indicates whether this staging database is configured as a physical standby.. [optional]  # noqa: E501
            validate_by_opening_db_in_read_only_mode (bool): Indicates whether this staging database snapshot is validated by opening it in read-only mode.. [optional]  # noqa: E501
            mssql_sync_strategy_managed_type (str): [optional]  # noqa: E501
            validated_sync_mode (str): Specifies the backup types ValidatedSync will use to synchronize the dSource with the source database.. [optional]  # noqa: E501
            shared_backup_locations ([str]): Shared source database backup locations.. [optional]  # noqa: E501
            backup_policy (str): Specify which node of an availability group to run the copy-only full backup on. [optional]  # noqa: E501
            compression_enabled (bool): Specify whether the backups taken should be compressed or uncompressed.. [optional]  # noqa: E501
            staging_database_name (str): The name of the staging database. [optional]  # noqa: E501
            db_state (str): User provided db state that is used to create staging push db. [optional]  # noqa: E501
            encryption_key (str): The encryption key to use when restoring encrypted backups.. [optional]  # noqa: E501
            external_netbackup_config_master_name (str): The master server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_source_client_name (str): The source's client server name of this NetBackup configuration.. [optional]  # noqa: E501
            external_netbackup_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): NetBackup configuration parameter overrides.. [optional]  # noqa: E501
            external_netbackup_config_templates (str): Optional config template selection for NetBackup configurations.. [optional]  # noqa: E501
            external_commserve_host_name (str): The commserve host name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_source_client_name (str): The source client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_staging_client_name (str): The staging client name of this Commvault configuration.. [optional]  # noqa: E501
            external_commvault_config_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Commvault configuration parameter overrides.. [optional]  # noqa: E501
            external_commvault_config_templates (str): Optional config template selection for Commvault configurations.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
