"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.tag import Tag
    globals()['Tag'] = Tag


class CreateReplicationProfileParameters(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('replication_mode',): {
            'ENGINE_DATA_REPLICATION': "ENGINE_DATA_REPLICATION",
            'MASKED_DATA_DISTRIBUTION': "MASKED_DATA_DISTRIBUTION",
            'CONTINUOUS_VAULT': "CONTINUOUS_VAULT",
        },
    }

    validations = {
        ('target_port',): {
            'inclusive_maximum': 65535,
            'inclusive_minimum': 0,
        },
        ('description',): {
            'max_length': 4096,
        },
        ('schedule',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('bandwidth_limit',): {
            'inclusive_minimum': 0,
        },
        ('number_of_connections',): {
            'inclusive_maximum': 16,
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'replication_mode': (str,),  # noqa: E501
            'engine_id': (str,),  # noqa: E501
            'target_engine_id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'target_host': (str,),  # noqa: E501
            'target_port': (int,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'schedule': (str,),  # noqa: E501
            'tags': ([Tag],),  # noqa: E501
            'enable_tag_replication': (bool,),  # noqa: E501
            'bandwidth_limit': (int,),  # noqa: E501
            'number_of_connections': (int,),  # noqa: E501
            'encrypted': (bool,),  # noqa: E501
            'automatic_replication': (bool,),  # noqa: E501
            'use_system_socks_setting': (bool,),  # noqa: E501
            'vdb_ids': ([str],),  # noqa: E501
            'dsource_ids': ([str],),  # noqa: E501
            'cdb_ids': ([str],),  # noqa: E501
            'vcdb_ids': ([str],),  # noqa: E501
            'group_ids': ([str],),  # noqa: E501
            'replicate_entire_engine': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'replication_mode': 'replication_mode',  # noqa: E501
        'engine_id': 'engine_id',  # noqa: E501
        'target_engine_id': 'target_engine_id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'target_host': 'target_host',  # noqa: E501
        'target_port': 'target_port',  # noqa: E501
        'description': 'description',  # noqa: E501
        'schedule': 'schedule',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'enable_tag_replication': 'enable_tag_replication',  # noqa: E501
        'bandwidth_limit': 'bandwidth_limit',  # noqa: E501
        'number_of_connections': 'number_of_connections',  # noqa: E501
        'encrypted': 'encrypted',  # noqa: E501
        'automatic_replication': 'automatic_replication',  # noqa: E501
        'use_system_socks_setting': 'use_system_socks_setting',  # noqa: E501
        'vdb_ids': 'vdb_ids',  # noqa: E501
        'dsource_ids': 'dsource_ids',  # noqa: E501
        'cdb_ids': 'cdb_ids',  # noqa: E501
        'vcdb_ids': 'vcdb_ids',  # noqa: E501
        'group_ids': 'group_ids',  # noqa: E501
        'replicate_entire_engine': 'replicate_entire_engine',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, replication_mode, engine_id, target_engine_id, *args, **kwargs):  # noqa: E501
        """CreateReplicationProfileParameters - a model defined in OpenAPI

        Args:
            replication_mode (str): The ReplicationProfile mode.
            engine_id (str): The ID of the engine that the ReplicationProfile belongs to.
            target_engine_id (str): The ID of the replication target engine.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The ReplicationProfile name.. [optional]  # noqa: E501
            target_host (str): Hostname of the replication target engine. If none is provided, the hostname for the engine referenced by target_engine_id will be used.. [optional]  # noqa: E501
            target_port (int): Target TCP port number for the Delphix Session Protocol.. [optional] if omitted the server will use the default value of 8415  # noqa: E501
            description (str): The ReplicationProfile description.. [optional]  # noqa: E501
            schedule (str): Replication schedule in the form of a quartz-formatted string.. [optional]  # noqa: E501
            tags ([Tag]): The tags that are applied to this ReplicationProfile.. [optional]  # noqa: E501
            enable_tag_replication (bool): Indicates whether tag replication from primary object to replica object is enabled or disabled for this ReplicationProfile.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for replication network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            number_of_connections (int): Total number of transport connections to use.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            encrypted (bool): Encrypt replication network traffic.. [optional] if omitted the server will use the default value of False  # noqa: E501
            automatic_replication (bool): Indication whether the replication spec schedule is enabled or not.. [optional] if omitted the server will use the default value of False  # noqa: E501
            use_system_socks_setting (bool): Connect to the replication target host via the system-wide SOCKS proxy.. [optional] if omitted the server will use the default value of False  # noqa: E501
            vdb_ids ([str]): The VDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            dsource_ids ([str]): The dSources that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            cdb_ids ([str]): The CDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            vcdb_ids ([str]): The vCDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            group_ids ([str]): The groups that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            replicate_entire_engine (bool): Whether to replicate the entire engine. This is mutually exclusive with the vdb_ids, dsource_ids, cdb_ids, vcdb_ids, and group_ids properties.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.replication_mode = replication_mode
        self.engine_id = engine_id
        self.target_engine_id = target_engine_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, replication_mode, engine_id, target_engine_id, *args, **kwargs):  # noqa: E501
        """CreateReplicationProfileParameters - a model defined in OpenAPI

        Args:
            replication_mode (str): The ReplicationProfile mode.
            engine_id (str): The ID of the engine that the ReplicationProfile belongs to.
            target_engine_id (str): The ID of the replication target engine.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): The ReplicationProfile name.. [optional]  # noqa: E501
            target_host (str): Hostname of the replication target engine. If none is provided, the hostname for the engine referenced by target_engine_id will be used.. [optional]  # noqa: E501
            target_port (int): Target TCP port number for the Delphix Session Protocol.. [optional] if omitted the server will use the default value of 8415  # noqa: E501
            description (str): The ReplicationProfile description.. [optional]  # noqa: E501
            schedule (str): Replication schedule in the form of a quartz-formatted string.. [optional]  # noqa: E501
            tags ([Tag]): The tags that are applied to this ReplicationProfile.. [optional]  # noqa: E501
            enable_tag_replication (bool): Indicates whether tag replication from primary object to replica object is enabled or disabled for this ReplicationProfile.. [optional]  # noqa: E501
            bandwidth_limit (int): Bandwidth limit (MB/s) for replication network traffic. A value of 0 means no limit.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            number_of_connections (int): Total number of transport connections to use.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            encrypted (bool): Encrypt replication network traffic.. [optional] if omitted the server will use the default value of False  # noqa: E501
            automatic_replication (bool): Indication whether the replication spec schedule is enabled or not.. [optional] if omitted the server will use the default value of False  # noqa: E501
            use_system_socks_setting (bool): Connect to the replication target host via the system-wide SOCKS proxy.. [optional] if omitted the server will use the default value of False  # noqa: E501
            vdb_ids ([str]): The VDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            dsource_ids ([str]): The dSources that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            cdb_ids ([str]): The CDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            vcdb_ids ([str]): The vCDBs that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            group_ids ([str]): The groups that are replicated by this ReplicationProfile.. [optional]  # noqa: E501
            replicate_entire_engine (bool): Whether to replicate the entire engine. This is mutually exclusive with the vdb_ids, dsource_ids, cdb_ids, vcdb_ids, and group_ids properties.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.replication_mode = replication_mode
        self.engine_id = engine_id
        self.target_engine_id = target_engine_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
