"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.bookmark_d_sources import BookmarkDSources
    from delphix.api.gateway.model.bookmark_vdbs import BookmarkVDBs
    from delphix.api.gateway.model.tag import Tag
    globals()['BookmarkDSources'] = BookmarkDSources
    globals()['BookmarkVDBs'] = BookmarkVDBs
    globals()['Tag'] = Tag


class Bookmark(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('bookmark_source',): {
            'DCT': "DCT",
            'ENGINE': "ENGINE",
        },
        ('bookmark_status',): {
            'ACTIVE': "ACTIVE",
            'INACTIVE': "INACTIVE",
        },
        ('bookmark_type',): {
            'PUBLIC': "PUBLIC",
            'PRIVATE': "PRIVATE",
        },
    }

    validations = {
        ('name',): {
            'max_length': 256,
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'creation_date': (datetime,),  # noqa: E501
            'data_timestamp': (datetime,),  # noqa: E501
            'timeflow_id': (str,),  # noqa: E501
            'location': (str,),  # noqa: E501
            'vdb_ids': ([str],),  # noqa: E501
            'dsource_ids': ([str],),  # noqa: E501
            'vdb_group_id': (str,),  # noqa: E501
            'vdb_group_name': (str,),  # noqa: E501
            'vdbs': ([BookmarkVDBs],),  # noqa: E501
            'dsources': ([BookmarkDSources],),  # noqa: E501
            'retention': (int,),  # noqa: E501
            'expiration': (date,),  # noqa: E501
            'status': (str, none_type,),  # noqa: E501
            'replicated_dataset': (bool,),  # noqa: E501
            'bookmark_source': (str,),  # noqa: E501
            'bookmark_status': (str,),  # noqa: E501
            'ss_data_layout_id': (str,),  # noqa: E501
            'ss_bookmark_reference': (str,),  # noqa: E501
            'ss_bookmark_errors': ([str],),  # noqa: E501
            'bookmark_type': (str,),  # noqa: E501
            'tags': ([Tag],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'creation_date': 'creation_date',  # noqa: E501
        'data_timestamp': 'data_timestamp',  # noqa: E501
        'timeflow_id': 'timeflow_id',  # noqa: E501
        'location': 'location',  # noqa: E501
        'vdb_ids': 'vdb_ids',  # noqa: E501
        'dsource_ids': 'dsource_ids',  # noqa: E501
        'vdb_group_id': 'vdb_group_id',  # noqa: E501
        'vdb_group_name': 'vdb_group_name',  # noqa: E501
        'vdbs': 'vdbs',  # noqa: E501
        'dsources': 'dsources',  # noqa: E501
        'retention': 'retention',  # noqa: E501
        'expiration': 'expiration',  # noqa: E501
        'status': 'status',  # noqa: E501
        'replicated_dataset': 'replicated_dataset',  # noqa: E501
        'bookmark_source': 'bookmark_source',  # noqa: E501
        'bookmark_status': 'bookmark_status',  # noqa: E501
        'ss_data_layout_id': 'ss_data_layout_id',  # noqa: E501
        'ss_bookmark_reference': 'ss_bookmark_reference',  # noqa: E501
        'ss_bookmark_errors': 'ss_bookmark_errors',  # noqa: E501
        'bookmark_type': 'bookmark_type',  # noqa: E501
        'tags': 'tags',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'creation_date',  # noqa: E501
        'data_timestamp',  # noqa: E501
        'status',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """Bookmark - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The Bookmark object entity ID.. [optional]  # noqa: E501
            name (str): The user-defined name of this bookmark.. [optional]  # noqa: E501
            creation_date (datetime): The date and time that this bookmark was created.. [optional]  # noqa: E501
            data_timestamp (datetime): The timestamp for the data that the bookmark refers to.. [optional]  # noqa: E501
            timeflow_id (str): The timeflow for the snapshot that the bookmark was created of.. [optional]  # noqa: E501
            location (str): The location for the data that the bookmark refers to.. [optional]  # noqa: E501
            vdb_ids ([str]): The list of VDB IDs associated with this bookmark.. [optional]  # noqa: E501
            dsource_ids ([str]): The list of dSource IDs associated with this bookmark.. [optional]  # noqa: E501
            vdb_group_id (str): The ID of the VDB group on which bookmark is created.. [optional]  # noqa: E501
            vdb_group_name (str): The name of the VDB group on which bookmark is created.. [optional]  # noqa: E501
            vdbs ([BookmarkVDBs]): The list of VDB IDs and VDB names associated with this bookmark.. [optional]  # noqa: E501
            dsources ([BookmarkDSources]): The list of dSource IDs and dSource names associated with this bookmark.. [optional]  # noqa: E501
            retention (int): The retention policy for this bookmark, in days. A value of -1 indicates the bookmark should be kept forever. Deprecated in favor of expiration.. [optional]  # noqa: E501
            expiration (date): The expiration for this bookmark. When unset, indicates the bookmark is kept forever except for bookmarks of replicated datasets. Expiration cannot be set for bookmarks of replicated datasets.. [optional]  # noqa: E501
            status (str, none_type): A message with details about operation progress or state of this bookmark.. [optional]  # noqa: E501
            replicated_dataset (bool): Whether this bookmark is created from a replicated dataset or not.. [optional]  # noqa: E501
            bookmark_source (str): Source of the bookmark, default is DCT. In case of self-service bookmarks, this value would be ENGINE.. [optional]  # noqa: E501
            bookmark_status (str): Status of the bookmark. It can have INACTIVE value for engine bookmarks only. If this value is INACTIVE then ss_bookmark_errors would have the list of associated errors.. [optional]  # noqa: E501
            ss_data_layout_id (str): Data-layout Id for engine-managed bookmarks.. [optional]  # noqa: E501
            ss_bookmark_reference (str): Engine reference of the self-service bookmark.. [optional]  # noqa: E501
            ss_bookmark_errors ([str]): List of errors if any, during bookmark creation in DCT from self-service.. [optional]  # noqa: E501
            bookmark_type (str): Type of the bookmark, either PUBLIC or PRIVATE.. [optional] if omitted the server will use the default value of "PRIVATE"  # noqa: E501
            tags ([Tag]): The tags to be created for this Bookmark.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """Bookmark - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): The Bookmark object entity ID.. [optional]  # noqa: E501
            name (str): The user-defined name of this bookmark.. [optional]  # noqa: E501
            creation_date (datetime): The date and time that this bookmark was created.. [optional]  # noqa: E501
            data_timestamp (datetime): The timestamp for the data that the bookmark refers to.. [optional]  # noqa: E501
            timeflow_id (str): The timeflow for the snapshot that the bookmark was created of.. [optional]  # noqa: E501
            location (str): The location for the data that the bookmark refers to.. [optional]  # noqa: E501
            vdb_ids ([str]): The list of VDB IDs associated with this bookmark.. [optional]  # noqa: E501
            dsource_ids ([str]): The list of dSource IDs associated with this bookmark.. [optional]  # noqa: E501
            vdb_group_id (str): The ID of the VDB group on which bookmark is created.. [optional]  # noqa: E501
            vdb_group_name (str): The name of the VDB group on which bookmark is created.. [optional]  # noqa: E501
            vdbs ([BookmarkVDBs]): The list of VDB IDs and VDB names associated with this bookmark.. [optional]  # noqa: E501
            dsources ([BookmarkDSources]): The list of dSource IDs and dSource names associated with this bookmark.. [optional]  # noqa: E501
            retention (int): The retention policy for this bookmark, in days. A value of -1 indicates the bookmark should be kept forever. Deprecated in favor of expiration.. [optional]  # noqa: E501
            expiration (date): The expiration for this bookmark. When unset, indicates the bookmark is kept forever except for bookmarks of replicated datasets. Expiration cannot be set for bookmarks of replicated datasets.. [optional]  # noqa: E501
            status (str, none_type): A message with details about operation progress or state of this bookmark.. [optional]  # noqa: E501
            replicated_dataset (bool): Whether this bookmark is created from a replicated dataset or not.. [optional]  # noqa: E501
            bookmark_source (str): Source of the bookmark, default is DCT. In case of self-service bookmarks, this value would be ENGINE.. [optional]  # noqa: E501
            bookmark_status (str): Status of the bookmark. It can have INACTIVE value for engine bookmarks only. If this value is INACTIVE then ss_bookmark_errors would have the list of associated errors.. [optional]  # noqa: E501
            ss_data_layout_id (str): Data-layout Id for engine-managed bookmarks.. [optional]  # noqa: E501
            ss_bookmark_reference (str): Engine reference of the self-service bookmark.. [optional]  # noqa: E501
            ss_bookmark_errors ([str]): List of errors if any, during bookmark creation in DCT from self-service.. [optional]  # noqa: E501
            bookmark_type (str): Type of the bookmark, either PUBLIC or PRIVATE.. [optional] if omitted the server will use the default value of "PRIVATE"  # noqa: E501
            tags ([Tag]): The tags to be created for this Bookmark.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
