"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from delphix.api.gateway.exceptions import ApiAttributeError


def lazy_import():
    from delphix.api.gateway.model.app_data_d_source_link_source_parameters_all_of import AppDataDSourceLinkSourceParametersAllOf
    from delphix.api.gateway.model.base_d_source_link_source_parameters import BaseDSourceLinkSourceParameters
    from delphix.api.gateway.model.source_operation import SourceOperation
    from delphix.api.gateway.model.tag import Tag
    globals()['AppDataDSourceLinkSourceParametersAllOf'] = AppDataDSourceLinkSourceParametersAllOf
    globals()['BaseDSourceLinkSourceParameters'] = BaseDSourceLinkSourceParameters
    globals()['SourceOperation'] = SourceOperation
    globals()['Tag'] = Tag


class AppDataDSourceLinkSourceParameters(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('link_type',): {
            'APPDATADIRECT': "AppDataDirect",
            'APPDATASTAGED': "AppDataStaged",
        },
    }

    validations = {
        ('environment_user',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('name',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('source_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('group_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('description',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('sync_policy_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('retention_policy_id',): {
            'max_length': 256,
            'min_length': 1,
        },
        ('tags',): {
            'max_items': 1000,
            'min_items': 1,
        },
        ('staging_mount_base',): {
            'max_length': 256,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'environment_user': (str,),  # noqa: E501
            'parameters': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'sync_parameters': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'name': (str,),  # noqa: E501
            'source_id': (str,),  # noqa: E501
            'group_id': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'log_sync_enabled': (bool,),  # noqa: E501
            'sync_policy_id': (str,),  # noqa: E501
            'retention_policy_id': (str,),  # noqa: E501
            'make_current_account_owner': (bool,),  # noqa: E501
            'tags': ([Tag],),  # noqa: E501
            'ops_pre_sync': ([SourceOperation],),  # noqa: E501
            'ops_post_sync': ([SourceOperation],),  # noqa: E501
            'link_type': (str,),  # noqa: E501
            'staging_mount_base': (str,),  # noqa: E501
            'staging_environment': (str,),  # noqa: E501
            'staging_environment_user': (str,),  # noqa: E501
            'excludes': ([str],),  # noqa: E501
            'follow_symlinks': ([str],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'environment_user': 'environment_user',  # noqa: E501
        'parameters': 'parameters',  # noqa: E501
        'sync_parameters': 'sync_parameters',  # noqa: E501
        'name': 'name',  # noqa: E501
        'source_id': 'source_id',  # noqa: E501
        'group_id': 'group_id',  # noqa: E501
        'description': 'description',  # noqa: E501
        'log_sync_enabled': 'log_sync_enabled',  # noqa: E501
        'sync_policy_id': 'sync_policy_id',  # noqa: E501
        'retention_policy_id': 'retention_policy_id',  # noqa: E501
        'make_current_account_owner': 'make_current_account_owner',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'ops_pre_sync': 'ops_pre_sync',  # noqa: E501
        'ops_post_sync': 'ops_post_sync',  # noqa: E501
        'link_type': 'link_type',  # noqa: E501
        'staging_mount_base': 'staging_mount_base',  # noqa: E501
        'staging_environment': 'staging_environment',  # noqa: E501
        'staging_environment_user': 'staging_environment_user',  # noqa: E501
        'excludes': 'excludes',  # noqa: E501
        'follow_symlinks': 'follow_symlinks',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AppDataDSourceLinkSourceParameters - a model defined in OpenAPI

        Keyword Args:
            environment_user (str): The OS user to use for linking.
            parameters ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The JSON payload conforming to the DraftV4 schema based on the type of application data being manipulated.
            sync_parameters ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The JSON payload conforming to the snapshot parameters definition in a LUA toolkit or platform plugin.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Name of the dSource to be created.. [optional]  # noqa: E501
            source_id (str): Id of the source to link.. [optional]  # noqa: E501
            group_id (str): Id of the dataset group where this dSource should belong to.. [optional]  # noqa: E501
            description (str): The notes/description for the dSource.. [optional]  # noqa: E501
            log_sync_enabled (bool): True if LogSync should run for this database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            sync_policy_id (str): The ID of the SnapSync policy for the dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The ID of the Retention policy for the dSource.. [optional]  # noqa: E501
            make_current_account_owner (bool): Whether the account creating this reporting schedule must be configured as owner of the reporting schedule.. [optional] if omitted the server will use the default value of True  # noqa: E501
            tags ([Tag]): The tags to be created for dSource.. [optional]  # noqa: E501
            ops_pre_sync ([SourceOperation]): Operations to perform before syncing the created dSource. These operations can quiesce any data prior to syncing.. [optional]  # noqa: E501
            ops_post_sync ([SourceOperation]): Operations to perform after syncing a created dSource.. [optional]  # noqa: E501
            link_type (str): The type of link to create. Default is AppDataDirect. * `AppDataDirect` - Represents the AppData specific parameters of a link request for a source directly replicated into the Delphix Engine. * `AppDataStaged` - Represents the AppData specific parameters of a link request for a source with a staging source. . [optional] if omitted the server will use the default value of "AppDataDirect"  # noqa: E501
            staging_mount_base (str): The base mount point for the NFS mount on the staging environment [AppDataStaged only].. [optional]  # noqa: E501
            staging_environment (str): The environment used as an intermediate stage to pull data into Delphix [AppDataStaged only].. [optional]  # noqa: E501
            staging_environment_user (str): The environment user used to access the staging environment [AppDataStaged only].. [optional]  # noqa: E501
            excludes ([str]): List of subdirectories in the source to exclude when syncing data. These paths are relative to the root of the source directory. [AppDataDirect only]. [optional]  # noqa: E501
            follow_symlinks ([str]): List of symlinks in the source to follow when syncing data. These paths are relative to the root of the source directory. All other symlinks are preserved. [AppDataDirect only]. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AppDataDSourceLinkSourceParameters - a model defined in OpenAPI

        Keyword Args:
            environment_user (str): The OS user to use for linking.
            parameters ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The JSON payload conforming to the DraftV4 schema based on the type of application data being manipulated.
            sync_parameters ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): The JSON payload conforming to the snapshot parameters definition in a LUA toolkit or platform plugin.
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Name of the dSource to be created.. [optional]  # noqa: E501
            source_id (str): Id of the source to link.. [optional]  # noqa: E501
            group_id (str): Id of the dataset group where this dSource should belong to.. [optional]  # noqa: E501
            description (str): The notes/description for the dSource.. [optional]  # noqa: E501
            log_sync_enabled (bool): True if LogSync should run for this database.. [optional] if omitted the server will use the default value of False  # noqa: E501
            sync_policy_id (str): The ID of the SnapSync policy for the dSource.. [optional]  # noqa: E501
            retention_policy_id (str): The ID of the Retention policy for the dSource.. [optional]  # noqa: E501
            make_current_account_owner (bool): Whether the account creating this reporting schedule must be configured as owner of the reporting schedule.. [optional] if omitted the server will use the default value of True  # noqa: E501
            tags ([Tag]): The tags to be created for dSource.. [optional]  # noqa: E501
            ops_pre_sync ([SourceOperation]): Operations to perform before syncing the created dSource. These operations can quiesce any data prior to syncing.. [optional]  # noqa: E501
            ops_post_sync ([SourceOperation]): Operations to perform after syncing a created dSource.. [optional]  # noqa: E501
            link_type (str): The type of link to create. Default is AppDataDirect. * `AppDataDirect` - Represents the AppData specific parameters of a link request for a source directly replicated into the Delphix Engine. * `AppDataStaged` - Represents the AppData specific parameters of a link request for a source with a staging source. . [optional] if omitted the server will use the default value of "AppDataDirect"  # noqa: E501
            staging_mount_base (str): The base mount point for the NFS mount on the staging environment [AppDataStaged only].. [optional]  # noqa: E501
            staging_environment (str): The environment used as an intermediate stage to pull data into Delphix [AppDataStaged only].. [optional]  # noqa: E501
            staging_environment_user (str): The environment user used to access the staging environment [AppDataStaged only].. [optional]  # noqa: E501
            excludes ([str]): List of subdirectories in the source to exclude when syncing data. These paths are relative to the root of the source directory. [AppDataDirect only]. [optional]  # noqa: E501
            follow_symlinks ([str]): List of symlinks in the source to follow when syncing data. These paths are relative to the root of the source directory. All other symlinks are preserved. [AppDataDirect only]. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              AppDataDSourceLinkSourceParametersAllOf,
              BaseDSourceLinkSourceParameters,
          ],
          'oneOf': [
          ],
        }
