"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.create_virtualization_policy_parameters import CreateVirtualizationPolicyParameters
from delphix.api.gateway.model.create_virtualization_policy_response import CreateVirtualizationPolicyResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_virtualization_policies_response import ListVirtualizationPoliciesResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_virtualization_policies_response import SearchVirtualizationPoliciesResponse
from delphix.api.gateway.model.search_virtualization_policy_targets_response import SearchVirtualizationPolicyTargetsResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_virtualization_policy_parameters import UpdateVirtualizationPolicyParameters
from delphix.api.gateway.model.virtualization_policy import VirtualizationPolicy
from delphix.api.gateway.model.virtualization_policy_apply_params import VirtualizationPolicyApplyParams
from delphix.api.gateway.model.virtualization_policy_apply_response import VirtualizationPolicyApplyResponse
from delphix.api.gateway.model.virtualization_policy_convert_job_response import VirtualizationPolicyConvertJobResponse
from delphix.api.gateway.model.virtualization_policy_delete_job_response import VirtualizationPolicyDeleteJobResponse
from delphix.api.gateway.model.virtualization_policy_unapply_response import VirtualizationPolicyUnapplyResponse
from delphix.api.gateway.model.virtualization_policy_update_job_response import VirtualizationPolicyUpdateJobResponse


class VirtualizationPoliciesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __apply_virtualization_policy_by_id_or_name(
            self,
            policy_id,
            **kwargs
        ):
            """Apply a virtualization policy to the given list of objects.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.apply_virtualization_policy_by_id_or_name(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                virtualization_policy_apply_params (VirtualizationPolicyApplyParams): The parameters to apply virtualization policy to a target.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicyApplyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.apply_virtualization_policy_by_id_or_name = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicyApplyResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/apply',
                'operation_id': 'apply_virtualization_policy_by_id_or_name',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                    'virtualization_policy_apply_params',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                    'virtualization_policy_apply_params':
                        (VirtualizationPolicyApplyParams,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                    'virtualization_policy_apply_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__apply_virtualization_policy_by_id_or_name
        )

        def __convert_virtualization_policy(
            self,
            policy_id,
            **kwargs
        ):
            """Convert a virtualization policy to a DCT-managed policy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.convert_virtualization_policy(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicyConvertJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.convert_virtualization_policy = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicyConvertJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/convert',
                'operation_id': 'convert_virtualization_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__convert_virtualization_policy
        )

        def __create_virtualization_policy(
            self,
            **kwargs
        ):
            """Create a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_virtualization_policy(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                create_virtualization_policy_parameters (CreateVirtualizationPolicyParameters): The parameters to create a DCT-managed VirtualizationPolicy.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateVirtualizationPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_virtualization_policy = _Endpoint(
            settings={
                'response_type': (CreateVirtualizationPolicyResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies',
                'operation_id': 'create_virtualization_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_virtualization_policy_parameters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_virtualization_policy_parameters':
                        (CreateVirtualizationPolicyParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_virtualization_policy_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_virtualization_policy
        )

        def __create_virtualization_policy_tags(
            self,
            policy_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_virtualization_policy_tags(policy_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.
                tags_request (TagsRequest): Tags information for VirtualizationPolicies.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_virtualization_policy_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/tags',
                'operation_id': 'create_virtualization_policy_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                    'tags_request',
                ],
                'required': [
                    'policy_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_virtualization_policy_tags
        )

        def __delete_virtualization_policy(
            self,
            policy_id,
            **kwargs
        ):
            """Delete a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_virtualization_policy(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicyDeleteJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.delete_virtualization_policy = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicyDeleteJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}',
                'operation_id': 'delete_virtualization_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_virtualization_policy
        )

        def __delete_virtualization_policy_tags(
            self,
            policy_id,
            **kwargs
        ):
            """Delete tags for a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_virtualization_policy_tags(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.delete_virtualization_policy_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/tags/delete',
                'operation_id': 'delete_virtualization_policy_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                    'delete_tag',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_virtualization_policy_tags
        )

        def __get_virtualization_policy_by_id(
            self,
            policy_id,
            **kwargs
        ):
            """Fetch a virtualization policy by Id.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_virtualization_policy_by_id(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.get_virtualization_policy_by_id = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicy,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}',
                'operation_id': 'get_virtualization_policy_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_virtualization_policy_by_id
        )

        def __get_virtualization_policy_tags(
            self,
            policy_id,
            **kwargs
        ):
            """Get tags for a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_virtualization_policy_tags(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.get_virtualization_policy_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/tags',
                'operation_id': 'get_virtualization_policy_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_virtualization_policy_tags
        )

        def __list_virtualization_policies(
            self,
            **kwargs
        ):
            """Fetch a list of all virtualization policies  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_virtualization_policies(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVirtualizationPoliciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_virtualization_policies = _Endpoint(
            settings={
                'response_type': (ListVirtualizationPoliciesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies',
                'operation_id': 'list_virtualization_policies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DCT_MANAGED": "dct_managed",
                        "-DCT_MANAGED": "-dct_managed",
                        "CREATE_USER": "create_user",
                        "-CREATE_USER": "-create_user",
                        "CREATE_TIMESTAMP": "create_timestamp",
                        "-CREATE_TIMESTAMP": "-create_timestamp",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "POLICY_TYPE": "policy_type",
                        "-POLICY_TYPE": "-policy_type",
                        "TIMEZONE_ID": "timezone_id",
                        "-TIMEZONE_ID": "-timezone_id",
                        "DEFAULT_POLICY": "default_policy",
                        "-DEFAULT_POLICY": "-default_policy",
                        "EFFECTIVE_TYPE": "effective_type",
                        "-EFFECTIVE_TYPE": "-effective_type",
                        "DATA_DURATION": "data_duration",
                        "-DATA_DURATION": "-data_duration",
                        "DATA_UNIT": "data_unit",
                        "-DATA_UNIT": "-data_unit",
                        "LOG_DURATION": "log_duration",
                        "-LOG_DURATION": "-log_duration",
                        "LOG_UNIT": "log_unit",
                        "-LOG_UNIT": "-log_unit",
                        "NUM_OF_DAILY": "num_of_daily",
                        "-NUM_OF_DAILY": "-num_of_daily",
                        "NUM_OF_WEEKLY": "num_of_weekly",
                        "-NUM_OF_WEEKLY": "-num_of_weekly",
                        "DAY_OF_WEEK": "day_of_week",
                        "-DAY_OF_WEEK": "-day_of_week",
                        "NUM_OF_MONTHLY": "num_of_monthly",
                        "-NUM_OF_MONTHLY": "-num_of_monthly",
                        "DAY_OF_MONTH": "day_of_month",
                        "-DAY_OF_MONTH": "-day_of_month",
                        "NUM_OF_YEARLY": "num_of_yearly",
                        "-NUM_OF_YEARLY": "-num_of_yearly",
                        "DAY_OF_YEAR": "day_of_year",
                        "-DAY_OF_YEAR": "-day_of_year",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "PROVISION_SOURCE": "provision_source",
                        "-PROVISION_SOURCE": "-provision_source",
                        "NUM_TARGETS": "num_targets",
                        "-NUM_TARGETS": "-num_targets"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_virtualization_policies
        )

        def __search_virtualization_policies(
            self,
            **kwargs
        ):
            """Search Virtualization Policies.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_virtualization_policies(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchVirtualizationPoliciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_virtualization_policies = _Endpoint(
            settings={
                'response_type': (SearchVirtualizationPoliciesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/search',
                'operation_id': 'search_virtualization_policies',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DCT_MANAGED": "dct_managed",
                        "-DCT_MANAGED": "-dct_managed",
                        "CREATE_USER": "create_user",
                        "-CREATE_USER": "-create_user",
                        "CREATE_TIMESTAMP": "create_timestamp",
                        "-CREATE_TIMESTAMP": "-create_timestamp",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "POLICY_TYPE": "policy_type",
                        "-POLICY_TYPE": "-policy_type",
                        "TIMEZONE_ID": "timezone_id",
                        "-TIMEZONE_ID": "-timezone_id",
                        "DEFAULT_POLICY": "default_policy",
                        "-DEFAULT_POLICY": "-default_policy",
                        "EFFECTIVE_TYPE": "effective_type",
                        "-EFFECTIVE_TYPE": "-effective_type",
                        "DATA_DURATION": "data_duration",
                        "-DATA_DURATION": "-data_duration",
                        "DATA_UNIT": "data_unit",
                        "-DATA_UNIT": "-data_unit",
                        "LOG_DURATION": "log_duration",
                        "-LOG_DURATION": "-log_duration",
                        "LOG_UNIT": "log_unit",
                        "-LOG_UNIT": "-log_unit",
                        "NUM_OF_DAILY": "num_of_daily",
                        "-NUM_OF_DAILY": "-num_of_daily",
                        "NUM_OF_WEEKLY": "num_of_weekly",
                        "-NUM_OF_WEEKLY": "-num_of_weekly",
                        "DAY_OF_WEEK": "day_of_week",
                        "-DAY_OF_WEEK": "-day_of_week",
                        "NUM_OF_MONTHLY": "num_of_monthly",
                        "-NUM_OF_MONTHLY": "-num_of_monthly",
                        "DAY_OF_MONTH": "day_of_month",
                        "-DAY_OF_MONTH": "-day_of_month",
                        "NUM_OF_YEARLY": "num_of_yearly",
                        "-NUM_OF_YEARLY": "-num_of_yearly",
                        "DAY_OF_YEAR": "day_of_year",
                        "-DAY_OF_YEAR": "-day_of_year",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "PROVISION_SOURCE": "provision_source",
                        "-PROVISION_SOURCE": "-provision_source",
                        "NUM_TARGETS": "num_targets",
                        "-NUM_TARGETS": "-num_targets"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_virtualization_policies
        )

        def __search_virtualization_policy_targets(
            self,
            **kwargs
        ):
            """Search Virtualization Policy Target Objects.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_virtualization_policy_targets(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchVirtualizationPolicyTargetsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_virtualization_policy_targets = _Endpoint(
            settings={
                'response_type': (SearchVirtualizationPolicyTargetsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/targets/search',
                'operation_id': 'search_virtualization_policy_targets',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "POLICY_ID": "policy_id",
                        "-POLICY_ID": "-policy_id",
                        "TARGET_ID": "target_id",
                        "-TARGET_ID": "-target_id",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "POLICY_TYPE": "policy_type",
                        "-POLICY_TYPE": "-policy_type",
                        "TARGET_TYPE": "target_type",
                        "-TARGET_TYPE": "-target_type",
                        "TARGET_NAME": "target_name",
                        "-TARGET_NAME": "-target_name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_virtualization_policy_targets
        )

        def __unapply_virtualization_policy_by_id_or_name(
            self,
            policy_id,
            **kwargs
        ):
            """Unapply a virtualization policy to the given list of objects.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.unapply_virtualization_policy_by_id_or_name(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.

            Keyword Args:
                virtualization_policy_apply_params (VirtualizationPolicyApplyParams): The parameters to apply virtualization policy to a target.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicyUnapplyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        self.unapply_virtualization_policy_by_id_or_name = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicyUnapplyResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}/unapply',
                'operation_id': 'unapply_virtualization_policy_by_id_or_name',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                    'virtualization_policy_apply_params',
                ],
                'required': [
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                    'virtualization_policy_apply_params':
                        (VirtualizationPolicyApplyParams,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                    'virtualization_policy_apply_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__unapply_virtualization_policy_by_id_or_name
        )

        def __update_virtualization_policy(
            self,
            policy_id,
            update_virtualization_policy_parameters,
            **kwargs
        ):
            """Update a VirtualizationPolicy.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_virtualization_policy(policy_id, update_virtualization_policy_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): The ID of the Virtualization Policy.
                update_virtualization_policy_parameters (UpdateVirtualizationPolicyParameters):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationPolicyUpdateJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['update_virtualization_policy_parameters'] = \
                update_virtualization_policy_parameters
            return self.call_with_http_info(**kwargs)

        self.update_virtualization_policy = _Endpoint(
            settings={
                'response_type': (VirtualizationPolicyUpdateJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-policies/{policyId}',
                'operation_id': 'update_virtualization_policy',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'policy_id',
                    'update_virtualization_policy_parameters',
                ],
                'required': [
                    'policy_id',
                    'update_virtualization_policy_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'policy_id',
                ]
            },
            root_map={
                'validations': {
                    ('policy_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'policy_id':
                        (str,),
                    'update_virtualization_policy_parameters':
                        (UpdateVirtualizationPolicyParameters,),
                },
                'attribute_map': {
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'policy_id': 'path',
                    'update_virtualization_policy_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_virtualization_policy
        )
