"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.list_virtualization_faults_response import ListVirtualizationFaultsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_virtualization_faults_response import SearchVirtualizationFaultsResponse
from delphix.api.gateway.model.virtualization_fault_resolve_all_job_response import VirtualizationFaultResolveAllJobResponse
from delphix.api.gateway.model.virtualization_fault_resolve_job_response import VirtualizationFaultResolveJobResponse
from delphix.api.gateway.model.virtualization_fault_resolve_or_ignore_job_response import VirtualizationFaultResolveOrIgnoreJobResponse
from delphix.api.gateway.model.virtualization_fault_resolve_or_ignore_parameters import VirtualizationFaultResolveOrIgnoreParameters
from delphix.api.gateway.model.virtualization_fault_resolve_parameters import VirtualizationFaultResolveParameters


class VirtualizationFaultsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_virtualization_faults_history(
            self,
            **kwargs
        ):
            """Fetch a list of all virtualization faults  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_virtualization_faults_history(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVirtualizationFaultsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_virtualization_faults_history = _Endpoint(
            settings={
                'response_type': (ListVirtualizationFaultsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-faults/history',
                'operation_id': 'get_virtualization_faults_history',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "BUNDLE_ID": "bundle_id",
                        "-BUNDLE_ID": "-bundle_id",
                        "TARGET_NAME": "target_name",
                        "-TARGET_NAME": "-target_name",
                        "TARGET_OBJECT_TYPE": "target_object_type",
                        "-TARGET_OBJECT_TYPE": "-target_object_type",
                        "TARGET_OBJECT_ID": "target_object_id",
                        "-TARGET_OBJECT_ID": "-target_object_id",
                        "TITLE": "title",
                        "-TITLE": "-title",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "FAULT_ACTION": "fault_action",
                        "-FAULT_ACTION": "-fault_action",
                        "RESPONSE": "response",
                        "-RESPONSE": "-response",
                        "SEVERITY": "severity",
                        "-SEVERITY": "-severity",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATE_DIAGNOSED": "date_diagnosed",
                        "-DATE_DIAGNOSED": "-date_diagnosed",
                        "DATE_RESOLVED": "date_resolved",
                        "-DATE_RESOLVED": "-date_resolved",
                        "RESOLUTION_COMMENTS": "resolution_comments",
                        "-RESOLUTION_COMMENTS": "-resolution_comments"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_virtualization_faults_history
        )

        def __resolve_all_virtualization_faults(
            self,
            engine_id,
            **kwargs
        ):
            """Marks all active faults of an engine that the user has permissions over as resolved.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.resolve_all_virtualization_faults(engine_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (str): The ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationFaultResolveAllJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            return self.call_with_http_info(**kwargs)

        self.resolve_all_virtualization_faults = _Endpoint(
            settings={
                'response_type': (VirtualizationFaultResolveAllJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-faults/{engineId}/resolveAll',
                'operation_id': 'resolve_all_virtualization_faults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                ],
                'required': [
                    'engine_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (str,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__resolve_all_virtualization_faults
        )

        def __resolve_or_ignore_virtualization_faults(
            self,
            **kwargs
        ):
            """Marks selected faults as resolved or ignored.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.resolve_or_ignore_virtualization_faults(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                virtualization_fault_resolve_or_ignore_parameters (VirtualizationFaultResolveOrIgnoreParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationFaultResolveOrIgnoreJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.resolve_or_ignore_virtualization_faults = _Endpoint(
            settings={
                'response_type': (VirtualizationFaultResolveOrIgnoreJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-faults/resolveOrIgnore',
                'operation_id': 'resolve_or_ignore_virtualization_faults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'virtualization_fault_resolve_or_ignore_parameters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'virtualization_fault_resolve_or_ignore_parameters':
                        (VirtualizationFaultResolveOrIgnoreParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'virtualization_fault_resolve_or_ignore_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__resolve_or_ignore_virtualization_faults
        )

        def __resolve_virtualization_fault(
            self,
            fault_id,
            **kwargs
        ):
            """Marks the fault as resolved. The Delphix engine will attempt to automatically detect cases where the fault has been resolved; but this is not always possible and may only occur on periodic intervals. In these cases, the user can proactively mark the fault resolved. This does not change the underlying disposition of the fault - if the problem is still present the system may immediately diagnose the same problem again. This should only be used to notify the system of resolution after the underlying problem has been resolved.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.resolve_virtualization_fault(fault_id, async_req=True)
            >>> result = thread.get()

            Args:
                fault_id (str): The ID of the Virtualization Fault.

            Keyword Args:
                virtualization_fault_resolve_parameters (VirtualizationFaultResolveParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationFaultResolveJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['fault_id'] = \
                fault_id
            return self.call_with_http_info(**kwargs)

        self.resolve_virtualization_fault = _Endpoint(
            settings={
                'response_type': (VirtualizationFaultResolveJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-fault/{faultId}/resolve',
                'operation_id': 'resolve_virtualization_fault',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'fault_id',
                    'virtualization_fault_resolve_parameters',
                ],
                'required': [
                    'fault_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'fault_id',
                ]
            },
            root_map={
                'validations': {
                    ('fault_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'fault_id':
                        (str,),
                    'virtualization_fault_resolve_parameters':
                        (VirtualizationFaultResolveParameters,),
                },
                'attribute_map': {
                    'fault_id': 'faultId',
                },
                'location_map': {
                    'fault_id': 'path',
                    'virtualization_fault_resolve_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__resolve_virtualization_fault
        )

        def __search_virtualization_faults_history(
            self,
            **kwargs
        ):
            """Search virtualization faults  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_virtualization_faults_history(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchVirtualizationFaultsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_virtualization_faults_history = _Endpoint(
            settings={
                'response_type': (SearchVirtualizationFaultsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/virtualization-faults/history/search',
                'operation_id': 'search_virtualization_faults_history',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "BUNDLE_ID": "bundle_id",
                        "-BUNDLE_ID": "-bundle_id",
                        "TARGET_NAME": "target_name",
                        "-TARGET_NAME": "-target_name",
                        "TARGET_OBJECT_TYPE": "target_object_type",
                        "-TARGET_OBJECT_TYPE": "-target_object_type",
                        "TARGET_OBJECT_ID": "target_object_id",
                        "-TARGET_OBJECT_ID": "-target_object_id",
                        "TITLE": "title",
                        "-TITLE": "-title",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "FAULT_ACTION": "fault_action",
                        "-FAULT_ACTION": "-fault_action",
                        "RESPONSE": "response",
                        "-RESPONSE": "-response",
                        "SEVERITY": "severity",
                        "-SEVERITY": "-severity",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATE_DIAGNOSED": "date_diagnosed",
                        "-DATE_DIAGNOSED": "-date_diagnosed",
                        "DATE_RESOLVED": "date_resolved",
                        "-DATE_RESOLVED": "-date_resolved",
                        "RESOLUTION_COMMENTS": "resolution_comments",
                        "-RESOLUTION_COMMENTS": "-resolution_comments"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_virtualization_faults_history
        )
