"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.connectivity_check_response import ConnectivityCheckResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.delete_vdb_parameters import DeleteVDBParameters
from delphix.api.gateway.model.delete_vdb_response import DeleteVDBResponse
from delphix.api.gateway.model.deletion_dependencies_response import DeletionDependenciesResponse
from delphix.api.gateway.model.disable_vdb_parameters import DisableVDBParameters
from delphix.api.gateway.model.disable_vdb_response import DisableVDBResponse
from delphix.api.gateway.model.enable_vdb_parameters import EnableVDBParameters
from delphix.api.gateway.model.enable_vdb_response import EnableVDBResponse
from delphix.api.gateway.model.list_bookmarks_by_vdb_response import ListBookmarksByVDBResponse
from delphix.api.gateway.model.list_snapshots_response import ListSnapshotsResponse
from delphix.api.gateway.model.list_vdbs_response import ListVDBsResponse
from delphix.api.gateway.model.lock_vdb_parameters import LockVDBParameters
from delphix.api.gateway.model.migrate_vdb_parameters import MigrateVDBParameters
from delphix.api.gateway.model.migrate_vdb_response import MigrateVDBResponse
from delphix.api.gateway.model.oracle_asm_in_place_export_parameters import OracleAsmInPlaceExportParameters
from delphix.api.gateway.model.oracle_asm_in_place_vdb_export_response import OracleAsmInPlaceVDBExportResponse
from delphix.api.gateway.model.oracle_verify_jdbc_connection_string_params import OracleVerifyJdbcConnectionStringParams
from delphix.api.gateway.model.permission_enum import PermissionEnum
from delphix.api.gateway.model.provision_vdbby_location_defaults_request import ProvisionVDBByLocationDefaultsRequest
from delphix.api.gateway.model.provision_vdbby_location_parameters import ProvisionVDBByLocationParameters
from delphix.api.gateway.model.provision_vdbby_snapshot_defaults_request import ProvisionVDBBySnapshotDefaultsRequest
from delphix.api.gateway.model.provision_vdbby_snapshot_parameters import ProvisionVDBBySnapshotParameters
from delphix.api.gateway.model.provision_vdbby_timestamp_defaults_request import ProvisionVDBByTimestampDefaultsRequest
from delphix.api.gateway.model.provision_vdbby_timestamp_parameters import ProvisionVDBByTimestampParameters
from delphix.api.gateway.model.provision_vdb_from_bookmark_defaults_request import ProvisionVDBFromBookmarkDefaultsRequest
from delphix.api.gateway.model.provision_vdb_from_bookmark_parameters import ProvisionVDBFromBookmarkParameters
from delphix.api.gateway.model.provision_vdb_response import ProvisionVDBResponse
from delphix.api.gateway.model.refresh_vdbby_location_parameters import RefreshVDBByLocationParameters
from delphix.api.gateway.model.refresh_vdbby_location_response import RefreshVDBByLocationResponse
from delphix.api.gateway.model.refresh_vdbby_snapshot_parameters import RefreshVDBBySnapshotParameters
from delphix.api.gateway.model.refresh_vdbby_snapshot_response import RefreshVDBBySnapshotResponse
from delphix.api.gateway.model.refresh_vdbby_timestamp_parameters import RefreshVDBByTimestampParameters
from delphix.api.gateway.model.refresh_vdbby_timestamp_response import RefreshVDBByTimestampResponse
from delphix.api.gateway.model.refresh_vdb_from_bookmark_parameters import RefreshVDBFromBookmarkParameters
from delphix.api.gateway.model.refresh_vdb_from_bookmark_response import RefreshVDBFromBookmarkResponse
from delphix.api.gateway.model.rollback_vdbby_snapshot_parameters import RollbackVDBBySnapshotParameters
from delphix.api.gateway.model.rollback_vdbby_snapshot_response import RollbackVDBBySnapshotResponse
from delphix.api.gateway.model.rollback_vdbby_timestamp_parameters import RollbackVDBByTimestampParameters
from delphix.api.gateway.model.rollback_vdbby_timestamp_response import RollbackVDBByTimestampResponse
from delphix.api.gateway.model.rollback_vdb_from_bookmark_parameters import RollbackVDBFromBookmarkParameters
from delphix.api.gateway.model.rollback_vdb_from_bookmark_response import RollbackVDBFromBookmarkResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_bookmarks_by_vdb_response import SearchBookmarksByVDBResponse
from delphix.api.gateway.model.search_vdbs_response import SearchVDBsResponse
from delphix.api.gateway.model.snapshot_vdb_response import SnapshotVDBResponse
from delphix.api.gateway.model.start_vdb_parameters import StartVDBParameters
from delphix.api.gateway.model.start_vdb_response import StartVDBResponse
from delphix.api.gateway.model.stop_vdb_parameters import StopVDBParameters
from delphix.api.gateway.model.stop_vdb_response import StopVDBResponse
from delphix.api.gateway.model.switch_timeflow_parameters import SwitchTimeflowParameters
from delphix.api.gateway.model.switch_timeflow_response import SwitchTimeflowResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.undo_refresh_vdb_response import UndoRefreshVDBResponse
from delphix.api.gateway.model.update_vdb_parameters import UpdateVDBParameters
from delphix.api.gateway.model.update_vdb_response import UpdateVDBResponse
from delphix.api.gateway.model.upgrade_database_parameters import UpgradeDatabaseParameters
from delphix.api.gateway.model.upgrade_oracle_database_parameters import UpgradeOracleDatabaseParameters
from delphix.api.gateway.model.upgrade_vdb_response import UpgradeVDBResponse
from delphix.api.gateway.model.vdb import VDB


class VDBsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_vdb_tags(
            self,
            vdb_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_vdb_tags(vdb_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.
                tags_request (TagsRequest): Tags information for VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_vdb_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/tags',
                'operation_id': 'create_vdb_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'tags_request',
                ],
                'required': [
                    'vdb_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_vdb_tags
        )

        def __delete_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Delete a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                delete_vdb_parameters (DeleteVDBParameters): The parameters to delete a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.delete_vdb = _Endpoint(
            settings={
                'response_type': (DeleteVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/delete',
                'operation_id': 'delete_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'delete_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'delete_vdb_parameters':
                        (DeleteVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'delete_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_vdb
        )

        def __delete_vdb_tags(
            self,
            vdb_id,
            **kwargs
        ):
            """Delete tags for a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vdb_tags(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.delete_vdb_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/tags/delete',
                'operation_id': 'delete_vdb_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'delete_tag',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_vdb_tags
        )

        def __disable_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Disable a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.disable_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                disable_vdb_parameters (DisableVDBParameters): The parameters to disable a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DisableVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.disable_vdb = _Endpoint(
            settings={
                'response_type': (DisableVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/disable',
                'operation_id': 'disable_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'disable_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'disable_vdb_parameters':
                        (DisableVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'disable_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__disable_vdb
        )

        def __enable_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Enable a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.enable_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                enable_vdb_parameters (EnableVDBParameters): The parameters to enable a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnableVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.enable_vdb = _Endpoint(
            settings={
                'response_type': (EnableVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/enable',
                'operation_id': 'enable_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'enable_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'enable_vdb_parameters':
                        (EnableVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'enable_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__enable_vdb
        )

        def __get_bookmarks_by_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """List Bookmarks compatible with this VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_bookmarks_by_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBookmarksByVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_bookmarks_by_vdb = _Endpoint(
            settings={
                'response_type': (ListBookmarksByVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/bookmarks',
                'operation_id': 'get_bookmarks_by_vdb',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'vdb_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "VDB_IDS": "vdb_ids",
                        "-VDB_IDS": "-vdb_ids",
                        "RETENTION": "retention",
                        "-RETENTION": "-retention",
                        "EXPIRATION": "expiration",
                        "-EXPIRATION": "-expiration",
                        "DATA_TIMESTAMP": "data_timestamp",
                        "-DATA_TIMESTAMP": "-data_timestamp",
                        "TIMEFLOW_ID": "timeflow_id",
                        "-TIMEFLOW_ID": "-timeflow_id",
                        "LOCATION": "location",
                        "-LOCATION": "-location",
                        "VDB_GROUP_NAME": "vdb_group_name",
                        "-VDB_GROUP_NAME": "-vdb_group_name"
                    },
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_bookmarks_by_vdb
        )

        def __get_tags_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Get tags for a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tags_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_tags_vdb = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/tags',
                'operation_id': 'get_tags_vdb',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tags_vdb
        )

        def __get_vdb_by_id(
            self,
            vdb_id,
            **kwargs
        ):
            """Get a VDB by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_by_id(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDB
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vdb_by_id = _Endpoint(
            settings={
                'response_type': (VDB,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}',
                'operation_id': 'get_vdb_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_by_id
        )

        def __get_vdb_deletion_dependencies(
            self,
            vdb_id,
            **kwargs
        ):
            """Get deletion dependencies of a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_deletion_dependencies(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeletionDependenciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vdb_deletion_dependencies = _Endpoint(
            settings={
                'response_type': (DeletionDependenciesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/deletion-dependencies',
                'operation_id': 'get_vdb_deletion_dependencies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_deletion_dependencies
        )

        def __get_vdb_snapshots(
            self,
            vdb_id,
            **kwargs
        ):
            """List Snapshots for a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_snapshots(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSnapshotsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vdb_snapshots = _Endpoint(
            settings={
                'response_type': (ListSnapshotsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/snapshots',
                'operation_id': 'get_vdb_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'limit',
                    'cursor',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_snapshots
        )

        def __get_vdbs(
            self,
            **kwargs
        ):
            """List all vdbs.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdbs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                permission (PermissionEnum): Restrict the objects, which are allowed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVDBsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_vdbs = _Endpoint(
            settings={
                'response_type': (ListVDBsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs',
                'operation_id': 'get_vdbs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'permission',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "IP_ADDRESS": "ip_address",
                        "-IP_ADDRESS": "-ip_address",
                        "FQDN": "fqdn",
                        "-FQDN": "-fqdn",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "PARENT_DSOURCE_ID": "parent_dsource_id",
                        "-PARENT_DSOURCE_ID": "-parent_dsource_id",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "LAST_REFRESHED_DATE": "last_refreshed_date",
                        "-LAST_REFRESHED_DATE": "-last_refreshed_date",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size",
                        "LOCKED_BY": "locked_by",
                        "-LOCKED_BY": "-locked_by",
                        "LOCKED_BY_NAME": "locked_by_name",
                        "-LOCKED_BY_NAME": "-locked_by_name",
                        "PRIMARY_OBJECT_ID": "primary_object_id",
                        "-PRIMARY_OBJECT_ID": "-primary_object_id",
                        "PRIMARY_ENGINE_ID": "primary_engine_id",
                        "-PRIMARY_ENGINE_ID": "-primary_engine_id",
                        "PRIMARY_ENGINE_NAME": "primary_engine_name",
                        "-PRIMARY_ENGINE_NAME": "-primary_engine_name",
                        "CONTENT_TYPE": "content_type",
                        "-CONTENT_TYPE": "-content_type",
                        "EXPORTED_DATA_DIRECTORY": "exported_data_directory",
                        "-EXPORTED_DATA_DIRECTORY": "-exported_data_directory",
                        "VCDB_EXPORTED_DATA_DIRECTORY": "vcdb_exported_data_directory",
                        "-VCDB_EXPORTED_DATA_DIRECTORY": "-vcdb_exported_data_directory",
                        "INVOKE_DATAPATCH": "invoke_datapatch",
                        "-INVOKE_DATAPATCH": "-invoke_datapatch",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "REPOSITORY_ID": "repository_id",
                        "-REPOSITORY_ID": "-repository_id",
                        "CONTAINERIZATION_STATE": "containerization_state",
                        "-CONTAINERIZATION_STATE": "-containerization_state",
                        "PARENT_TDE_KEYSTORE_PATH": "parent_tde_keystore_path",
                        "-PARENT_TDE_KEYSTORE_PATH": "-parent_tde_keystore_path",
                        "TARGET_VCDB_TDE_KEYSTORE_PATH": "target_vcdb_tde_keystore_path",
                        "-TARGET_VCDB_TDE_KEYSTORE_PATH": "-target_vcdb_tde_keystore_path",
                        "TDE_KEY_IDENTIFIER": "tde_key_identifier",
                        "-TDE_KEY_IDENTIFIER": "-tde_key_identifier",
                        "ENVIRONMENT_USER_REF": "environment_user_ref",
                        "-ENVIRONMENT_USER_REF": "-environment_user_ref"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'permission':
                        (PermissionEnum,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                    'permission': 'permission',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'permission': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdbs
        )

        def __lock_vdb(
            self,
            vdb_id,
            lock_vdb_parameters,
            **kwargs
        ):
            """Lock a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.lock_vdb(vdb_id, lock_vdb_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.
                lock_vdb_parameters (LockVDBParameters):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDB
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            kwargs['lock_vdb_parameters'] = \
                lock_vdb_parameters
            return self.call_with_http_info(**kwargs)

        self.lock_vdb = _Endpoint(
            settings={
                'response_type': (VDB,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/lock',
                'operation_id': 'lock_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'lock_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                    'lock_vdb_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'lock_vdb_parameters':
                        (LockVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'lock_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__lock_vdb
        )

        def __migrate_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Migrate a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.migrate_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                migrate_vdb_parameters (MigrateVDBParameters): The parameters to migrate a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MigrateVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.migrate_vdb = _Endpoint(
            settings={
                'response_type': (MigrateVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/migrate',
                'operation_id': 'migrate_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'migrate_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'migrate_vdb_parameters':
                        (MigrateVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'migrate_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__migrate_vdb
        )

        def __oracle_asm_in_place_vdb_export(
            self,
            vdb_id,
            oracle_asm_in_place_export_parameters,
            **kwargs
        ):
            """Convert a VDB/vPDB to a physical DB/PDB on Oracle ASM file system.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.oracle_asm_in_place_vdb_export(vdb_id, oracle_asm_in_place_export_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.
                oracle_asm_in_place_export_parameters (OracleAsmInPlaceExportParameters): The parameters to perform Oracle ASM inplace VDB/VPDB export.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OracleAsmInPlaceVDBExportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            kwargs['oracle_asm_in_place_export_parameters'] = \
                oracle_asm_in_place_export_parameters
            return self.call_with_http_info(**kwargs)

        self.oracle_asm_in_place_vdb_export = _Endpoint(
            settings={
                'response_type': (OracleAsmInPlaceVDBExportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/asm-in-place-export',
                'operation_id': 'oracle_asm_in_place_vdb_export',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'oracle_asm_in_place_export_parameters',
                ],
                'required': [
                    'vdb_id',
                    'oracle_asm_in_place_export_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'oracle_asm_in_place_export_parameters':
                        (OracleAsmInPlaceExportParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'oracle_asm_in_place_export_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__oracle_asm_in_place_vdb_export
        )

        def __provision_vdb_by_location(
            self,
            provision_vdbby_location_parameters,
            **kwargs
        ):
            """Provision a new VDB by location.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_location(provision_vdbby_location_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_location_parameters (ProvisionVDBByLocationParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_location_parameters'] = \
                provision_vdbby_location_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_location = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_location',
                'operation_id': 'provision_vdb_by_location',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_location_parameters',
                ],
                'required': [
                    'provision_vdbby_location_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_location_parameters':
                        (ProvisionVDBByLocationParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_location_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_location
        )

        def __provision_vdb_by_location_defaults(
            self,
            provision_vdbby_location_defaults_request,
            **kwargs
        ):
            """Get default provision parameters for provisioning a new VDB by location.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_location_defaults(provision_vdbby_location_defaults_request, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_location_defaults_request (ProvisionVDBByLocationDefaultsRequest): The request to get default VDB provision parameters for provisioning a new VDB by location.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBByLocationParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_location_defaults_request'] = \
                provision_vdbby_location_defaults_request
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_location_defaults = _Endpoint(
            settings={
                'response_type': (ProvisionVDBByLocationParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_location/defaults',
                'operation_id': 'provision_vdb_by_location_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_location_defaults_request',
                ],
                'required': [
                    'provision_vdbby_location_defaults_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_location_defaults_request':
                        (ProvisionVDBByLocationDefaultsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_location_defaults_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_location_defaults
        )

        def __provision_vdb_by_snapshot(
            self,
            provision_vdbby_snapshot_parameters,
            **kwargs
        ):
            """Provision a new VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_snapshot(provision_vdbby_snapshot_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_snapshot_parameters (ProvisionVDBBySnapshotParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_snapshot_parameters'] = \
                provision_vdbby_snapshot_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_snapshot',
                'operation_id': 'provision_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_snapshot_parameters',
                ],
                'required': [
                    'provision_vdbby_snapshot_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_snapshot_parameters':
                        (ProvisionVDBBySnapshotParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_snapshot
        )

        def __provision_vdb_by_snapshot_defaults(
            self,
            provision_vdbby_snapshot_defaults_request,
            **kwargs
        ):
            """Get default provision parameters for provisioning a new VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_snapshot_defaults(provision_vdbby_snapshot_defaults_request, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_snapshot_defaults_request (ProvisionVDBBySnapshotDefaultsRequest): The request to get default VDB provision parameters for provisioning a new VDB by snapshot.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBBySnapshotParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_snapshot_defaults_request'] = \
                provision_vdbby_snapshot_defaults_request
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_snapshot_defaults = _Endpoint(
            settings={
                'response_type': (ProvisionVDBBySnapshotParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_snapshot/defaults',
                'operation_id': 'provision_vdb_by_snapshot_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_snapshot_defaults_request',
                ],
                'required': [
                    'provision_vdbby_snapshot_defaults_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_snapshot_defaults_request':
                        (ProvisionVDBBySnapshotDefaultsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_snapshot_defaults_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_snapshot_defaults
        )

        def __provision_vdb_by_timestamp(
            self,
            provision_vdbby_timestamp_parameters,
            **kwargs
        ):
            """Provision a new VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_timestamp(provision_vdbby_timestamp_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_timestamp_parameters (ProvisionVDBByTimestampParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_timestamp_parameters'] = \
                provision_vdbby_timestamp_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_timestamp',
                'operation_id': 'provision_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_timestamp_parameters',
                ],
                'required': [
                    'provision_vdbby_timestamp_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_timestamp_parameters':
                        (ProvisionVDBByTimestampParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_timestamp
        )

        def __provision_vdb_by_timestamp_defaults(
            self,
            provision_vdbby_timestamp_defaults_request,
            **kwargs
        ):
            """Get default provision parameters for provisioning a new VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_timestamp_defaults(provision_vdbby_timestamp_defaults_request, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_timestamp_defaults_request (ProvisionVDBByTimestampDefaultsRequest): The request to get default VDB provision parameters for provisioning a new VDB by timestamp.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBByTimestampParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_timestamp_defaults_request'] = \
                provision_vdbby_timestamp_defaults_request
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_timestamp_defaults = _Endpoint(
            settings={
                'response_type': (ProvisionVDBByTimestampParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_timestamp/defaults',
                'operation_id': 'provision_vdb_by_timestamp_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_timestamp_defaults_request',
                ],
                'required': [
                    'provision_vdbby_timestamp_defaults_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_timestamp_defaults_request':
                        (ProvisionVDBByTimestampDefaultsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_timestamp_defaults_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_timestamp_defaults
        )

        def __provision_vdb_from_bookmark(
            self,
            provision_vdb_from_bookmark_parameters,
            **kwargs
        ):
            """Provision a new VDB from a bookmark with a single VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_from_bookmark(provision_vdb_from_bookmark_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdb_from_bookmark_parameters (ProvisionVDBFromBookmarkParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdb_from_bookmark_parameters'] = \
                provision_vdb_from_bookmark_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_from_bookmark = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_from_bookmark',
                'operation_id': 'provision_vdb_from_bookmark',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdb_from_bookmark_parameters',
                ],
                'required': [
                    'provision_vdb_from_bookmark_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdb_from_bookmark_parameters':
                        (ProvisionVDBFromBookmarkParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdb_from_bookmark_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_from_bookmark
        )

        def __provision_vdb_from_bookmark_defaults(
            self,
            provision_vdb_from_bookmark_defaults_request,
            **kwargs
        ):
            """Get default provision parameters for provisioning a new VDB from a bookmark.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_from_bookmark_defaults(provision_vdb_from_bookmark_defaults_request, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdb_from_bookmark_defaults_request (ProvisionVDBFromBookmarkDefaultsRequest): The request to get default VDB provision parameters for provisioning a new VDB from a bookmark.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBFromBookmarkParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdb_from_bookmark_defaults_request'] = \
                provision_vdb_from_bookmark_defaults_request
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_from_bookmark_defaults = _Endpoint(
            settings={
                'response_type': (ProvisionVDBFromBookmarkParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_from_bookmark/defaults',
                'operation_id': 'provision_vdb_from_bookmark_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdb_from_bookmark_defaults_request',
                ],
                'required': [
                    'provision_vdb_from_bookmark_defaults_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdb_from_bookmark_defaults_request':
                        (ProvisionVDBFromBookmarkDefaultsRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdb_from_bookmark_defaults_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_from_bookmark_defaults
        )

        def __refresh_vdb_by_location(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB by location.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_by_location(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdbby_location_parameters (RefreshVDBByLocationParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBByLocationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_by_location = _Endpoint(
            settings={
                'response_type': (RefreshVDBByLocationResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_by_location',
                'operation_id': 'refresh_vdb_by_location',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdbby_location_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdbby_location_parameters':
                        (RefreshVDBByLocationParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdbby_location_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_by_location
        )

        def __refresh_vdb_by_snapshot(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_by_snapshot(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdbby_snapshot_parameters (RefreshVDBBySnapshotParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBBySnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (RefreshVDBBySnapshotResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_by_snapshot',
                'operation_id': 'refresh_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdbby_snapshot_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdbby_snapshot_parameters':
                        (RefreshVDBBySnapshotParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_by_snapshot
        )

        def __refresh_vdb_by_timestamp(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_by_timestamp(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdbby_timestamp_parameters (RefreshVDBByTimestampParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBByTimestampResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (RefreshVDBByTimestampResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_by_timestamp',
                'operation_id': 'refresh_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdbby_timestamp_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdbby_timestamp_parameters':
                        (RefreshVDBByTimestampParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_by_timestamp
        )

        def __refresh_vdb_from_bookmark(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB from bookmark with a single VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_from_bookmark(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdb_from_bookmark_parameters (RefreshVDBFromBookmarkParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBFromBookmarkResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_from_bookmark = _Endpoint(
            settings={
                'response_type': (RefreshVDBFromBookmarkResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_from_bookmark',
                'operation_id': 'refresh_vdb_from_bookmark',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdb_from_bookmark_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdb_from_bookmark_parameters':
                        (RefreshVDBFromBookmarkParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdb_from_bookmark_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_from_bookmark
        )

        def __rollback_vdb_by_snapshot(
            self,
            vdb_id,
            **kwargs
        ):
            """Rollback a VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_by_snapshot(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                rollback_vdbby_snapshot_parameters (RollbackVDBBySnapshotParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBBySnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (RollbackVDBBySnapshotResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/rollback_by_snapshot',
                'operation_id': 'rollback_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'rollback_vdbby_snapshot_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'rollback_vdbby_snapshot_parameters':
                        (RollbackVDBBySnapshotParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'rollback_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_by_snapshot
        )

        def __rollback_vdb_by_timestamp(
            self,
            vdb_id,
            **kwargs
        ):
            """Rollback a VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_by_timestamp(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                rollback_vdbby_timestamp_parameters (RollbackVDBByTimestampParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBByTimestampResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (RollbackVDBByTimestampResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/rollback_by_timestamp',
                'operation_id': 'rollback_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'rollback_vdbby_timestamp_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'rollback_vdbby_timestamp_parameters':
                        (RollbackVDBByTimestampParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'rollback_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_by_timestamp
        )

        def __rollback_vdb_from_bookmark(
            self,
            vdb_id,
            **kwargs
        ):
            """Rollback a VDB from a bookmark with only the same VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_from_bookmark(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                rollback_vdb_from_bookmark_parameters (RollbackVDBFromBookmarkParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBFromBookmarkResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_from_bookmark = _Endpoint(
            settings={
                'response_type': (RollbackVDBFromBookmarkResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/rollback_from_bookmark',
                'operation_id': 'rollback_vdb_from_bookmark',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'rollback_vdb_from_bookmark_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'rollback_vdb_from_bookmark_parameters':
                        (RollbackVDBFromBookmarkParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'rollback_vdb_from_bookmark_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_from_bookmark
        )

        def __search_bookmarks_by_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Search Bookmarks compatible with this VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_bookmarks_by_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchBookmarksByVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.search_bookmarks_by_vdb = _Endpoint(
            settings={
                'response_type': (SearchBookmarksByVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/bookmarks/search',
                'operation_id': 'search_bookmarks_by_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'vdb_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "VDB_IDS": "vdb_ids",
                        "-VDB_IDS": "-vdb_ids",
                        "RETENTION": "retention",
                        "-RETENTION": "-retention",
                        "EXPIRATION": "expiration",
                        "-EXPIRATION": "-expiration",
                        "DATA_TIMESTAMP": "data_timestamp",
                        "-DATA_TIMESTAMP": "-data_timestamp",
                        "TIMEFLOW_ID": "timeflow_id",
                        "-TIMEFLOW_ID": "-timeflow_id",
                        "LOCATION": "location",
                        "-LOCATION": "-location",
                        "VDB_GROUP_NAME": "vdb_group_name",
                        "-VDB_GROUP_NAME": "-vdb_group_name"
                    },
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_bookmarks_by_vdb
        )

        def __search_vdbs(
            self,
            **kwargs
        ):
            """Search for VDBs.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_vdbs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                permission (PermissionEnum): Restrict the objects, which are allowed.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchVDBsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_vdbs = _Endpoint(
            settings={
                'response_type': (SearchVDBsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/search',
                'operation_id': 'search_vdbs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'permission',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "IP_ADDRESS": "ip_address",
                        "-IP_ADDRESS": "-ip_address",
                        "FQDN": "fqdn",
                        "-FQDN": "-fqdn",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "PARENT_DSOURCE_ID": "parent_dsource_id",
                        "-PARENT_DSOURCE_ID": "-parent_dsource_id",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "LAST_REFRESHED_DATE": "last_refreshed_date",
                        "-LAST_REFRESHED_DATE": "-last_refreshed_date",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size",
                        "LOCKED_BY": "locked_by",
                        "-LOCKED_BY": "-locked_by",
                        "LOCKED_BY_NAME": "locked_by_name",
                        "-LOCKED_BY_NAME": "-locked_by_name",
                        "PRIMARY_OBJECT_ID": "primary_object_id",
                        "-PRIMARY_OBJECT_ID": "-primary_object_id",
                        "PRIMARY_ENGINE_ID": "primary_engine_id",
                        "-PRIMARY_ENGINE_ID": "-primary_engine_id",
                        "PRIMARY_ENGINE_NAME": "primary_engine_name",
                        "-PRIMARY_ENGINE_NAME": "-primary_engine_name",
                        "CONTENT_TYPE": "content_type",
                        "-CONTENT_TYPE": "-content_type",
                        "EXPORTED_DATA_DIRECTORY": "exported_data_directory",
                        "-EXPORTED_DATA_DIRECTORY": "-exported_data_directory",
                        "VCDB_EXPORTED_DATA_DIRECTORY": "vcdb_exported_data_directory",
                        "-VCDB_EXPORTED_DATA_DIRECTORY": "-vcdb_exported_data_directory",
                        "INVOKE_DATAPATCH": "invoke_datapatch",
                        "-INVOKE_DATAPATCH": "-invoke_datapatch",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "REPOSITORY_ID": "repository_id",
                        "-REPOSITORY_ID": "-repository_id",
                        "CONTAINERIZATION_STATE": "containerization_state",
                        "-CONTAINERIZATION_STATE": "-containerization_state",
                        "PARENT_TDE_KEYSTORE_PATH": "parent_tde_keystore_path",
                        "-PARENT_TDE_KEYSTORE_PATH": "-parent_tde_keystore_path",
                        "TARGET_VCDB_TDE_KEYSTORE_PATH": "target_vcdb_tde_keystore_path",
                        "-TARGET_VCDB_TDE_KEYSTORE_PATH": "-target_vcdb_tde_keystore_path",
                        "TDE_KEY_IDENTIFIER": "tde_key_identifier",
                        "-TDE_KEY_IDENTIFIER": "-tde_key_identifier",
                        "ENVIRONMENT_USER_REF": "environment_user_ref",
                        "-ENVIRONMENT_USER_REF": "-environment_user_ref"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'permission':
                        (PermissionEnum,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                    'permission': 'permission',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'permission': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_vdbs
        )

        def __snapshot_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Snapshot a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.snapshot_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SnapshotVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.snapshot_vdb = _Endpoint(
            settings={
                'response_type': (SnapshotVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/snapshots',
                'operation_id': 'snapshot_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__snapshot_vdb
        )

        def __start_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Start a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.start_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                start_vdb_parameters (StartVDBParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StartVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.start_vdb = _Endpoint(
            settings={
                'response_type': (StartVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/start',
                'operation_id': 'start_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'start_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'start_vdb_parameters':
                        (StartVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'start_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__start_vdb
        )

        def __stop_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Stop a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.stop_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                stop_vdb_parameters (StopVDBParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StopVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.stop_vdb = _Endpoint(
            settings={
                'response_type': (StopVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/stop',
                'operation_id': 'stop_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'stop_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'stop_vdb_parameters':
                        (StopVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'stop_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__stop_vdb
        )

        def __switch_timeflow(
            self,
            vdb_id,
            **kwargs
        ):
            """Switches the current timeflow of a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.switch_timeflow(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                switch_timeflow_parameters (SwitchTimeflowParameters): The parameters to switch the timeflow of a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SwitchTimeflowResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.switch_timeflow = _Endpoint(
            settings={
                'response_type': (SwitchTimeflowResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/switch_timeflow',
                'operation_id': 'switch_timeflow',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'switch_timeflow_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'switch_timeflow_parameters':
                        (SwitchTimeflowParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'switch_timeflow_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__switch_timeflow
        )

        def __undo_refresh(
            self,
            vdb_id,
            **kwargs
        ):
            """Undo the last refresh operation.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.undo_refresh(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UndoRefreshVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.undo_refresh = _Endpoint(
            settings={
                'response_type': (UndoRefreshVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/undo_refresh',
                'operation_id': 'undo_refresh',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__undo_refresh
        )

        def __unlock_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Unlock a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.unlock_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDB
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.unlock_vdb = _Endpoint(
            settings={
                'response_type': (VDB,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/unlock',
                'operation_id': 'unlock_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__unlock_vdb
        )

        def __update_vdb_by_id(
            self,
            vdb_id,
            **kwargs
        ):
            """Update values of a VDB  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_vdb_by_id(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                update_vdb_parameters (UpdateVDBParameters): The new data to update a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.update_vdb_by_id = _Endpoint(
            settings={
                'response_type': (UpdateVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}',
                'operation_id': 'update_vdb_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'update_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'update_vdb_parameters':
                        (UpdateVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'update_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_vdb_by_id
        )

        def __upgrade_oracle_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Upgrade Oracle VDB  # noqa: E501

            This API is marked as deprecated in favour of generalized API '/vdbs/{vdbId}/upgrade'  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upgrade_oracle_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                upgrade_oracle_database_parameters (UpgradeOracleDatabaseParameters): The new API to upgrade Oracle VDB. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpgradeVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.upgrade_oracle_vdb = _Endpoint(
            settings={
                'response_type': (UpgradeVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/oracle/{vdbId}/upgrade',
                'operation_id': 'upgrade_oracle_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'upgrade_oracle_database_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'upgrade_oracle_database_parameters':
                        (UpgradeOracleDatabaseParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'upgrade_oracle_database_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upgrade_oracle_vdb
        )

        def __upgrade_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Upgrade VDB  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upgrade_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                upgrade_database_parameters (UpgradeDatabaseParameters): The new API to upgrade VDB. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpgradeVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.upgrade_vdb = _Endpoint(
            settings={
                'response_type': (UpgradeVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/upgrade',
                'operation_id': 'upgrade_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'upgrade_database_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'upgrade_database_parameters':
                        (UpgradeDatabaseParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'upgrade_database_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upgrade_vdb
        )

        def __verify_vdb_jdbc_connection_string(
            self,
            vdb_id,
            **kwargs
        ):
            """Verify JDBC connection string for VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_vdb_jdbc_connection_string(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                oracle_verify_jdbc_connection_string_params (OracleVerifyJdbcConnectionStringParams): The parameters to verify oracle jdbc connection string.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectivityCheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.verify_vdb_jdbc_connection_string = _Endpoint(
            settings={
                'response_type': (ConnectivityCheckResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/jdbc-check',
                'operation_id': 'verify_vdb_jdbc_connection_string',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'oracle_verify_jdbc_connection_string_params',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'oracle_verify_jdbc_connection_string_params':
                        (OracleVerifyJdbcConnectionStringParams,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'oracle_verify_jdbc_connection_string_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_vdb_jdbc_connection_string
        )
