"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.connectivity_check_response import ConnectivityCheckResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.delete_vcdb_parameters import DeleteVCDBParameters
from delphix.api.gateway.model.delete_vcdb_response import DeleteVCDBResponse
from delphix.api.gateway.model.deletion_dependencies_response import DeletionDependenciesResponse
from delphix.api.gateway.model.disable_vcdb_parameters import DisableVCDBParameters
from delphix.api.gateway.model.disable_vcdb_response import DisableVCDBResponse
from delphix.api.gateway.model.enable_vcdb_parameters import EnableVCDBParameters
from delphix.api.gateway.model.enable_vcdb_response import EnableVCDBResponse
from delphix.api.gateway.model.list_vcdbs_response import ListVCDBsResponse
from delphix.api.gateway.model.oracle_verify_jdbc_connection_string_params import OracleVerifyJdbcConnectionStringParams
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_vcdbs_response import SearchVCDBsResponse
from delphix.api.gateway.model.start_vcdb_parameters import StartVCDBParameters
from delphix.api.gateway.model.start_vcdb_response import StartVCDBResponse
from delphix.api.gateway.model.stop_vcdb_parameters import StopVCDBParameters
from delphix.api.gateway.model.stop_vcdb_response import StopVCDBResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_vcdb_parameters import UpdateVCDBParameters
from delphix.api.gateway.model.update_vcdb_response import UpdateVCDBResponse
from delphix.api.gateway.model.upgrade_oracle_container_database_parameters import UpgradeOracleContainerDatabaseParameters
from delphix.api.gateway.model.upgrade_vcdb_response import UpgradeVCDBResponse
from delphix.api.gateway.model.vcdb import VCDB


class VCDBsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_vcdb_tags(
            self,
            vcdb_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_vcdb_tags(vcdb_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.
                tags_request (TagsRequest): Tags information for vCDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_vcdb_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/tags',
                'operation_id': 'create_vcdb_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'tags_request',
                ],
                'required': [
                    'vcdb_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_vcdb_tags
        )

        def __delete_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Delete a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                delete_vcdb_parameters (DeleteVCDBParameters): The parameters to delete a vCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.delete_vcdb = _Endpoint(
            settings={
                'response_type': (DeleteVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/delete',
                'operation_id': 'delete_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'delete_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'delete_vcdb_parameters':
                        (DeleteVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'delete_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_vcdb
        )

        def __delete_vcdb_tags(
            self,
            vcdb_id,
            **kwargs
        ):
            """Delete tags for a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vcdb_tags(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.delete_vcdb_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/tags/delete',
                'operation_id': 'delete_vcdb_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'delete_tag',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_vcdb_tags
        )

        def __disable_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Disable a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.disable_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                disable_vcdb_parameters (DisableVCDBParameters): The parameters to disable a vCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DisableVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.disable_vcdb = _Endpoint(
            settings={
                'response_type': (DisableVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/disable',
                'operation_id': 'disable_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'disable_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'disable_vcdb_parameters':
                        (DisableVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'disable_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__disable_vcdb
        )

        def __enable_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Enable a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.enable_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                enable_vcdb_parameters (EnableVCDBParameters): The parameters to enable a vCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnableVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.enable_vcdb = _Endpoint(
            settings={
                'response_type': (EnableVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/enable',
                'operation_id': 'enable_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'enable_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'enable_vcdb_parameters':
                        (EnableVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'enable_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__enable_vcdb
        )

        def __get_tags_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Get tags for a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tags_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.get_tags_vcdb = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/tags',
                'operation_id': 'get_tags_vcdb',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tags_vcdb
        )

        def __get_vcdb_by_id(
            self,
            vcdb_id,
            **kwargs
        ):
            """Get a CDB by ID (Oracle only).  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vcdb_by_id(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VCDB
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vcdb_by_id = _Endpoint(
            settings={
                'response_type': (VCDB,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}',
                'operation_id': 'get_vcdb_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vcdb_by_id
        )

        def __get_vcdb_deletion_dependencies(
            self,
            vcdb_id,
            **kwargs
        ):
            """Get deletion dependencies of a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vcdb_deletion_dependencies(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeletionDependenciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vcdb_deletion_dependencies = _Endpoint(
            settings={
                'response_type': (DeletionDependenciesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/deletion-dependencies',
                'operation_id': 'get_vcdb_deletion_dependencies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vcdb_deletion_dependencies
        )

        def __get_vcdbs(
            self,
            **kwargs
        ):
            """List all vCDBs (Oracle only).  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vcdbs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVCDBsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_vcdbs = _Endpoint(
            settings={
                'response_type': (ListVCDBsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs',
                'operation_id': 'get_vcdbs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "INVOKE_DATAPATCH": "invoke_datapatch",
                        "-INVOKE_DATAPATCH": "-invoke_datapatch",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "REPOSITORY_ID": "repository_id",
                        "-REPOSITORY_ID": "-repository_id",
                        "CONTAINERIZATION_STATE": "containerization_state",
                        "-CONTAINERIZATION_STATE": "-containerization_state",
                        "TDE_KEY_IDENTIFIER": "tde_key_identifier",
                        "-TDE_KEY_IDENTIFIER": "-tde_key_identifier",
                        "TDE_KEYSTORE_CONFIG_TYPE": "tde_keystore_config_type",
                        "-TDE_KEYSTORE_CONFIG_TYPE": "-tde_keystore_config_type"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vcdbs
        )

        def __search_vcdbs(
            self,
            **kwargs
        ):
            """Search for vCDBs (Oracle only).  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_vcdbs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchVCDBsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_vcdbs = _Endpoint(
            settings={
                'response_type': (SearchVCDBsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/search',
                'operation_id': 'search_vcdbs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "INVOKE_DATAPATCH": "invoke_datapatch",
                        "-INVOKE_DATAPATCH": "-invoke_datapatch",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "REPOSITORY_ID": "repository_id",
                        "-REPOSITORY_ID": "-repository_id",
                        "CONTAINERIZATION_STATE": "containerization_state",
                        "-CONTAINERIZATION_STATE": "-containerization_state",
                        "TDE_KEY_IDENTIFIER": "tde_key_identifier",
                        "-TDE_KEY_IDENTIFIER": "-tde_key_identifier",
                        "TDE_KEYSTORE_CONFIG_TYPE": "tde_keystore_config_type",
                        "-TDE_KEYSTORE_CONFIG_TYPE": "-tde_keystore_config_type"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_vcdbs
        )

        def __start_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Start a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.start_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                start_vcdb_parameters (StartVCDBParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StartVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.start_vcdb = _Endpoint(
            settings={
                'response_type': (StartVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/start',
                'operation_id': 'start_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'start_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'start_vcdb_parameters':
                        (StartVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'start_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__start_vcdb
        )

        def __stop_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Stop a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.stop_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                stop_vcdb_parameters (StopVCDBParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StopVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.stop_vcdb = _Endpoint(
            settings={
                'response_type': (StopVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/stop',
                'operation_id': 'stop_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'stop_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'stop_vcdb_parameters':
                        (StopVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'stop_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__stop_vcdb
        )

        def __update_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Update values of a VCDB  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                update_vcdb_parameters (UpdateVCDBParameters): The parameters to update a VCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.update_vcdb = _Endpoint(
            settings={
                'response_type': (UpdateVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}',
                'operation_id': 'update_vcdb',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'update_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'update_vcdb_parameters':
                        (UpdateVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'update_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_vcdb
        )

        def __update_vcdb_by_id(
            self,
            vcdb_id,
            **kwargs
        ):
            """Update a VCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_vcdb_by_id(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                update_vcdb_parameters (UpdateVCDBParameters): The parameters to update a VCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.update_vcdb_by_id = _Endpoint(
            settings={
                'response_type': (UpdateVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/update',
                'operation_id': 'update_vcdb_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'update_vcdb_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'update_vcdb_parameters':
                        (UpdateVCDBParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'update_vcdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_vcdb_by_id
        )

        def __upgrade_vcdb(
            self,
            vcdb_id,
            **kwargs
        ):
            """Upgrade Oracle vCDB  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upgrade_vcdb(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                upgrade_oracle_container_database_parameters (UpgradeOracleContainerDatabaseParameters): The new data to upgrade an Oracle vCDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpgradeVCDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.upgrade_vcdb = _Endpoint(
            settings={
                'response_type': (UpgradeVCDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/upgrade',
                'operation_id': 'upgrade_vcdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'upgrade_oracle_container_database_parameters',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'upgrade_oracle_container_database_parameters':
                        (UpgradeOracleContainerDatabaseParameters,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'upgrade_oracle_container_database_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upgrade_vcdb
        )

        def __verify_vcdb_jdbc_connection_string(
            self,
            vcdb_id,
            **kwargs
        ):
            """Verify JDBC connection string for a vCDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_vcdb_jdbc_connection_string(vcdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vcdb_id (str): The ID of the vCDB.

            Keyword Args:
                oracle_verify_jdbc_connection_string_params (OracleVerifyJdbcConnectionStringParams): The parameters to verify oracle jdbc connection string.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectivityCheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vcdb_id'] = \
                vcdb_id
            return self.call_with_http_info(**kwargs)

        self.verify_vcdb_jdbc_connection_string = _Endpoint(
            settings={
                'response_type': (ConnectivityCheckResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vcdbs/{vcdbId}/jdbc-check',
                'operation_id': 'verify_vcdb_jdbc_connection_string',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vcdb_id',
                    'oracle_verify_jdbc_connection_string_params',
                ],
                'required': [
                    'vcdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vcdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vcdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vcdb_id':
                        (str,),
                    'oracle_verify_jdbc_connection_string_params':
                        (OracleVerifyJdbcConnectionStringParams,),
                },
                'attribute_map': {
                    'vcdb_id': 'vcdbId',
                },
                'location_map': {
                    'vcdb_id': 'path',
                    'oracle_verify_jdbc_connection_string_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_vcdb_jdbc_connection_string
        )
