"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.historical_storage_summary import HistoricalStorageSummary
from delphix.api.gateway.model.historical_storage_summary_aggregate import HistoricalStorageSummaryAggregate


class StorageUsageApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_historical_storage_summary_aggregate(
            self,
            **kwargs
        ):
            """Returns the aggregated historical storage usage of all registered engines over time, optionally with a projection of future storage usage.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_historical_storage_summary_aggregate(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                start_date (datetime): Report start date/time. Defaults to first API request.. [optional]
                end_date (datetime): Report end date/time. Defaults to current time.. [optional]
                include_projection (bool): Whether to compute a projection of future storage usage.. [optional]
                engine_ids ([str]): The list of engine ids to aggregate data for. By default aggregating data for all engines.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HistoricalStorageSummaryAggregate
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_historical_storage_summary_aggregate = _Endpoint(
            settings={
                'response_type': (HistoricalStorageSummaryAggregate,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/historical-storage-summary-aggregate',
                'operation_id': 'get_historical_storage_summary_aggregate',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'include_projection',
                    'engine_ids',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'include_projection':
                        (bool,),
                    'engine_ids':
                        ([str],),
                },
                'attribute_map': {
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'include_projection': 'include_projection',
                    'engine_ids': 'engine_ids',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'include_projection': 'query',
                    'engine_ids': 'query',
                },
                'collection_format_map': {
                    'engine_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_historical_storage_summary_aggregate
        )

        def __get_historical_storage_summary_by_engine(
            self,
            **kwargs
        ):
            """Returns the historical storage usage by engine over time, optionally with a projection of future storage usage.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_historical_storage_summary_by_engine(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                start_date (datetime): Report start date/time. Defaults to first API request.. [optional]
                end_date (datetime): Report end date/time. Defaults to current time.. [optional]
                include_projection (bool): Whether to compute a projection of future storage usage.. [optional]
                engine_ids ([str]): The list of engine ids to include in the response. By default returning data for all engines.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HistoricalStorageSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_historical_storage_summary_by_engine = _Endpoint(
            settings={
                'response_type': (HistoricalStorageSummary,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/historical-storage-summary-by-engine',
                'operation_id': 'get_historical_storage_summary_by_engine',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'include_projection',
                    'engine_ids',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'include_projection':
                        (bool,),
                    'engine_ids':
                        ([str],),
                },
                'attribute_map': {
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'include_projection': 'include_projection',
                    'engine_ids': 'engine_ids',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'include_projection': 'query',
                    'engine_ids': 'query',
                },
                'collection_format_map': {
                    'engine_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_historical_storage_summary_by_engine
        )
