"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.app_data_source_create_parameters import AppDataSourceCreateParameters
from delphix.api.gateway.model.connectivity_check_response import ConnectivityCheckResponse
from delphix.api.gateway.model.create_app_data_source_response import CreateAppDataSourceResponse
from delphix.api.gateway.model.create_oracle_source_response import CreateOracleSourceResponse
from delphix.api.gateway.model.create_postgres_source_response import CreatePostgresSourceResponse
from delphix.api.gateway.model.delete_source_response import DeleteSourceResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_sources_response import ListSourcesResponse
from delphix.api.gateway.model.oracle_source_create_parameters import OracleSourceCreateParameters
from delphix.api.gateway.model.oracle_source_update_parameters import OracleSourceUpdateParameters
from delphix.api.gateway.model.oracle_verify_jdbc_connection_string_params import OracleVerifyJdbcConnectionStringParams
from delphix.api.gateway.model.postgres_source_create_parameters import PostgresSourceCreateParameters
from delphix.api.gateway.model.postgres_source_update_parameters import PostgresSourceUpdateParameters
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_sources_response import SearchSourcesResponse
from delphix.api.gateway.model.source import Source
from delphix.api.gateway.model.staging_compatible_environments_response import StagingCompatibleEnvironmentsResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_oracle_source_response import UpdateOracleSourceResponse
from delphix.api.gateway.model.update_postgres_source_response import UpdatePostgresSourceResponse
from delphix.api.gateway.model.update_source_parameters import UpdateSourceParameters
from delphix.api.gateway.model.update_source_response import UpdateSourceResponse


class SourcesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_app_data_source(
            self,
            app_data_source_create_parameters,
            **kwargs
        ):
            """Create an AppData source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_app_data_source(app_data_source_create_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                app_data_source_create_parameters (AppDataSourceCreateParameters): The parameters to create a AppData source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateAppDataSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_data_source_create_parameters'] = \
                app_data_source_create_parameters
            return self.call_with_http_info(**kwargs)

        self.create_app_data_source = _Endpoint(
            settings={
                'response_type': (CreateAppDataSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/appdata',
                'operation_id': 'create_app_data_source',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_data_source_create_parameters',
                ],
                'required': [
                    'app_data_source_create_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_data_source_create_parameters':
                        (AppDataSourceCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'app_data_source_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_app_data_source
        )

        def __create_oracle_source(
            self,
            **kwargs
        ):
            """Create an Oracle Source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_oracle_source(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                oracle_source_create_parameters (OracleSourceCreateParameters): The parameters to create an Oracle source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateOracleSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.create_oracle_source = _Endpoint(
            settings={
                'response_type': (CreateOracleSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/oracle',
                'operation_id': 'create_oracle_source',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'oracle_source_create_parameters',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'oracle_source_create_parameters':
                        (OracleSourceCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'oracle_source_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_oracle_source
        )

        def __create_postgres_source(
            self,
            postgres_source_create_parameters,
            **kwargs
        ):
            """Create a PostgreSQL source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_postgres_source(postgres_source_create_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                postgres_source_create_parameters (PostgresSourceCreateParameters): The parameters to create a PostgreSQL source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreatePostgresSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['postgres_source_create_parameters'] = \
                postgres_source_create_parameters
            return self.call_with_http_info(**kwargs)

        self.create_postgres_source = _Endpoint(
            settings={
                'response_type': (CreatePostgresSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/postgres',
                'operation_id': 'create_postgres_source',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'postgres_source_create_parameters',
                ],
                'required': [
                    'postgres_source_create_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'postgres_source_create_parameters':
                        (PostgresSourceCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'postgres_source_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_postgres_source
        )

        def __create_source_tags(
            self,
            source_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a Source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_source_tags(source_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.
                tags_request (TagsRequest): Tags information for Source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_source_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/tags',
                'operation_id': 'create_source_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'tags_request',
                ],
                'required': [
                    'source_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_source_tags
        )

        def __delete_source(
            self,
            source_id,
            **kwargs
        ):
            """Delete a source by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_source(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.delete_source = _Endpoint(
            settings={
                'response_type': (DeleteSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}',
                'operation_id': 'delete_source',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_source
        )

        def __delete_source_tags(
            self,
            source_id,
            **kwargs
        ):
            """Delete tags for a Source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_source_tags(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.delete_source_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/tags/delete',
                'operation_id': 'delete_source_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'delete_tag',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_source_tags
        )

        def __get_source_by_id(
            self,
            source_id,
            **kwargs
        ):
            """Get a source by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_source_by_id(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Source
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.get_source_by_id = _Endpoint(
            settings={
                'response_type': (Source,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}',
                'operation_id': 'get_source_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_source_by_id
        )

        def __get_source_compatible_repo(
            self,
            source_id,
            **kwargs
        ):
            """Returns a list of repositories that match the specified source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_source_compatible_repo(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StagingCompatibleEnvironmentsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.get_source_compatible_repo = _Endpoint(
            settings={
                'response_type': (StagingCompatibleEnvironmentsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/staging_compatible_repositories',
                'operation_id': 'get_source_compatible_repo',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_source_compatible_repo
        )

        def __get_source_tags(
            self,
            source_id,
            **kwargs
        ):
            """Get tags for a Source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_source_tags(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.get_source_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/tags',
                'operation_id': 'get_source_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_source_tags
        )

        def __get_sources(
            self,
            **kwargs
        ):
            """List all sources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_sources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_sources = _Endpoint(
            settings={
                'response_type': (ListSourcesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources',
                'operation_id': 'get_sources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "DATA_UUID": "data_uuid",
                        "-DATA_UUID": "-data_uuid",
                        "IP_ADDRESS": "ip_address",
                        "-IP_ADDRESS": "-ip_address",
                        "FQDN": "fqdn",
                        "-FQDN": "-fqdn",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "JDBC_CONNECTION_STRING": "jdbc_connection_string",
                        "-JDBC_CONNECTION_STRING": "-jdbc_connection_string",
                        "PLUGIN_VERSION": "plugin_version",
                        "-PLUGIN_VERSION": "-plugin_version",
                        "IS_DSOURCE": "is_dsource",
                        "-IS_DSOURCE": "-is_dsource",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "USER": "user",
                        "-USER": "-user",
                        "NON_SYS_USER": "non_sys_user",
                        "-NON_SYS_USER": "-non_sys_user",
                        "DISCOVERED": "discovered",
                        "-DISCOVERED": "-discovered",
                        "LINKING_ENABLED": "linking_enabled",
                        "-LINKING_ENABLED": "-linking_enabled",
                        "REPOSITORY": "repository",
                        "-REPOSITORY": "-repository",
                        "CDB_TYPE": "cdb_type",
                        "-CDB_TYPE": "-cdb_type",
                        "ENVIRONMENT_USER_REF": "environment_user_ref",
                        "-ENVIRONMENT_USER_REF": "-environment_user_ref"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_sources
        )

        def __search_sources(
            self,
            **kwargs
        ):
            """Search for Sources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_sources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchSourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_sources = _Endpoint(
            settings={
                'response_type': (SearchSourcesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/search',
                'operation_id': 'search_sources',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "ENVIRONMENT_ID": "environment_id",
                        "-ENVIRONMENT_ID": "-environment_id",
                        "DATA_UUID": "data_uuid",
                        "-DATA_UUID": "-data_uuid",
                        "IP_ADDRESS": "ip_address",
                        "-IP_ADDRESS": "-ip_address",
                        "FQDN": "fqdn",
                        "-FQDN": "-fqdn",
                        "SIZE": "size",
                        "-SIZE": "-size",
                        "JDBC_CONNECTION_STRING": "jdbc_connection_string",
                        "-JDBC_CONNECTION_STRING": "-jdbc_connection_string",
                        "PLUGIN_VERSION": "plugin_version",
                        "-PLUGIN_VERSION": "-plugin_version",
                        "IS_DSOURCE": "is_dsource",
                        "-IS_DSOURCE": "-is_dsource",
                        "INSTANCE_NAME": "instance_name",
                        "-INSTANCE_NAME": "-instance_name",
                        "INSTANCE_NUMBER": "instance_number",
                        "-INSTANCE_NUMBER": "-instance_number",
                        "USER": "user",
                        "-USER": "-user",
                        "NON_SYS_USER": "non_sys_user",
                        "-NON_SYS_USER": "-non_sys_user",
                        "DISCOVERED": "discovered",
                        "-DISCOVERED": "-discovered",
                        "LINKING_ENABLED": "linking_enabled",
                        "-LINKING_ENABLED": "-linking_enabled",
                        "REPOSITORY": "repository",
                        "-REPOSITORY": "-repository",
                        "CDB_TYPE": "cdb_type",
                        "-CDB_TYPE": "-cdb_type",
                        "ENVIRONMENT_USER_REF": "environment_user_ref",
                        "-ENVIRONMENT_USER_REF": "-environment_user_ref"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_sources
        )

        def __update_oracle_source_by_id(
            self,
            source_id,
            **kwargs
        ):
            """Update an Oracle source by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_oracle_source_by_id(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                oracle_source_update_parameters (OracleSourceUpdateParameters): The parameters to update a Oracle source. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateOracleSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.update_oracle_source_by_id = _Endpoint(
            settings={
                'response_type': (UpdateOracleSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/oracle/{sourceId}',
                'operation_id': 'update_oracle_source_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'oracle_source_update_parameters',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'oracle_source_update_parameters':
                        (OracleSourceUpdateParameters,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'oracle_source_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_oracle_source_by_id
        )

        def __update_postgres_source_by_id(
            self,
            source_id,
            **kwargs
        ):
            """Update a PostgreSQL source by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_postgres_source_by_id(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                postgres_source_update_parameters (PostgresSourceUpdateParameters): The parameters to update a PostgreSQL source. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdatePostgresSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.update_postgres_source_by_id = _Endpoint(
            settings={
                'response_type': (UpdatePostgresSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/postgres/{sourceId}',
                'operation_id': 'update_postgres_source_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'postgres_source_update_parameters',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'postgres_source_update_parameters':
                        (PostgresSourceUpdateParameters,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'postgres_source_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_postgres_source_by_id
        )

        def __update_source_by_id(
            self,
            source_id,
            **kwargs
        ):
            """Update a Source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_source_by_id(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                update_source_parameters (UpdateSourceParameters): The parameters to update a Source.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.update_source_by_id = _Endpoint(
            settings={
                'response_type': (UpdateSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/update',
                'operation_id': 'update_source_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'update_source_parameters',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'update_source_parameters':
                        (UpdateSourceParameters,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'update_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_source_by_id
        )

        def __verify_source_jdbc_connection_string(
            self,
            source_id,
            **kwargs
        ):
            """Verify JDBC connection string for a source.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.verify_source_jdbc_connection_string(source_id, async_req=True)
            >>> result = thread.get()

            Args:
                source_id (str): The ID of the Source.

            Keyword Args:
                oracle_verify_jdbc_connection_string_params (OracleVerifyJdbcConnectionStringParams): The parameters to verify oracle jdbc connection string.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectivityCheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['source_id'] = \
                source_id
            return self.call_with_http_info(**kwargs)

        self.verify_source_jdbc_connection_string = _Endpoint(
            settings={
                'response_type': (ConnectivityCheckResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/sources/{sourceId}/jdbc-check',
                'operation_id': 'verify_source_jdbc_connection_string',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'source_id',
                    'oracle_verify_jdbc_connection_string_params',
                ],
                'required': [
                    'source_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'source_id',
                ]
            },
            root_map={
                'validations': {
                    ('source_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'source_id':
                        (str,),
                    'oracle_verify_jdbc_connection_string_params':
                        (OracleVerifyJdbcConnectionStringParams,),
                },
                'attribute_map': {
                    'source_id': 'sourceId',
                },
                'location_map': {
                    'source_id': 'path',
                    'oracle_verify_jdbc_connection_string_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__verify_source_jdbc_connection_string
        )
