"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.api_usage_report_response import ApiUsageReportResponse
from delphix.api.gateway.model.audit_logs_summary_report_response import AuditLogsSummaryReportResponse
from delphix.api.gateway.model.d_source_consumption_report_response import DSourceConsumptionReportResponse
from delphix.api.gateway.model.d_source_usage_report_response import DSourceUsageReportResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.engine_performance_analytic_report_response import EnginePerformanceAnalyticReportResponse
from delphix.api.gateway.model.engine_performance_analytic_trend_response import EnginePerformanceAnalyticTrendResponse
from delphix.api.gateway.model.engine_storage_capacity_data_response import EngineStorageCapacityDataResponse
from delphix.api.gateway.model.get_data_risk_report_response import GetDataRiskReportResponse
from delphix.api.gateway.model.get_engine_global_object_state_report_response import GetEngineGlobalObjectStateReportResponse
from delphix.api.gateway.model.list_reporting_schedule_response import ListReportingScheduleResponse
from delphix.api.gateway.model.masking_execution_metrics_report_response import MaskingExecutionMetricsReportResponse
from delphix.api.gateway.model.product_info import ProductInfo
from delphix.api.gateway.model.reporting_schedule import ReportingSchedule
from delphix.api.gateway.model.reporting_schedule_create_parameters import ReportingScheduleCreateParameters
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_data_risk_report_response import SearchDataRiskReportResponse
from delphix.api.gateway.model.search_engine_global_object_state_report_response import SearchEngineGlobalObjectStateReportResponse
from delphix.api.gateway.model.search_reporting_schedule_response import SearchReportingScheduleResponse
from delphix.api.gateway.model.storage_savings_summary_report_response import StorageSavingsSummaryReportResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.vdb_inventory_report_response import VDBInventoryReportResponse
from delphix.api.gateway.model.virtualization_storage_summary_report_response import VirtualizationStorageSummaryReportResponse


class ReportingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_reporting_schedule(
            self,
            reporting_schedule_create_parameters,
            **kwargs
        ):
            """Create a new report schedule.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_reporting_schedule(reporting_schedule_create_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                reporting_schedule_create_parameters (ReportingScheduleCreateParameters): The parameters to create a reporting schedule.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ReportingSchedule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['reporting_schedule_create_parameters'] = \
                reporting_schedule_create_parameters
            return self.call_with_http_info(**kwargs)

        self.create_reporting_schedule = _Endpoint(
            settings={
                'response_type': (ReportingSchedule,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule',
                'operation_id': 'create_reporting_schedule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'reporting_schedule_create_parameters',
                ],
                'required': [
                    'reporting_schedule_create_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reporting_schedule_create_parameters':
                        (ReportingScheduleCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'reporting_schedule_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_reporting_schedule
        )

        def __create_reporting_schedule_tags(
            self,
            report_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a report schedule.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_reporting_schedule_tags(report_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.
                tags_request (TagsRequest): Tags information for report schedule.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_reporting_schedule_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}/tags',
                'operation_id': 'create_reporting_schedule_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                    'tags_request',
                ],
                'required': [
                    'report_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_reporting_schedule_tags
        )

        def __delete_reporting_schedule(
            self,
            report_id,
            **kwargs
        ):
            """Delete report schedule by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_reporting_schedule(report_id, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.delete_reporting_schedule = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}',
                'operation_id': 'delete_reporting_schedule',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                ],
                'required': [
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_reporting_schedule
        )

        def __delete_reporting_schedule_tag(
            self,
            report_id,
            **kwargs
        ):
            """Delete tags for a report schedule.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_reporting_schedule_tag(report_id, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.delete_reporting_schedule_tag = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}/tags/delete',
                'operation_id': 'delete_reporting_schedule_tag',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                    'delete_tag',
                ],
                'required': [
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_reporting_schedule_tag
        )

        def __get_api_usage_report(
            self,
            **kwargs
        ):
            """Gets the report of API usage metrics over a given time period. This API returns at the most 10000 results in the response to protect against the server running out of memory. Users might not hit this limit with the default report without any 'apiUsageReportGroupByParam' param but can hit this limit if the groupBy is by too granular like by 'client_name' or 'user_agent' only. Hence it is advisable to use startDate and endDate to 'limit' the scope of the report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_usage_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                start_date (datetime): Report start date/time. Defaults to first API request.. [optional]
                end_date (datetime): Report end date/time. Defaults to current time.. [optional]
                api_metric_kind (str): Restrict the list to API usage metric of the given kind. [optional]
                group_by ([str]): The field to group results by.. [optional]
                client_name ([str]): The Client names to be included in the report.. [optional]
                user_agent ([str]): The UserAgent names to be included in the report.. [optional]
                dct_version ([str]): The DCT versions to be included in the report.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApiUsageReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_api_usage_report = _Endpoint(
            settings={
                'response_type': (ApiUsageReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/api-usage-report',
                'operation_id': 'get_api_usage_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_date',
                    'end_date',
                    'api_metric_kind',
                    'group_by',
                    'client_name',
                    'user_agent',
                    'dct_version',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'api_metric_kind',
                    'group_by',
                ],
                'validation': [
                    'group_by',
                    'client_name',
                    'user_agent',
                    'dct_version',
                ]
            },
            root_map={
                'validations': {
                    ('group_by',): {

                        'min_items': 1,
                    },
                    ('client_name',): {

                        'min_length': 1,
                    },
                    ('user_agent',): {

                        'min_length': 1,
                    },
                    ('dct_version',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('api_metric_kind',): {

                        "AUTOMATION": "automation",
                        "GOVERNANCE": "governance"
                    },
                    ('group_by',): {

                        "API_ENDPOINT": "api_endpoint",
                        "API_METHOD": "api_method",
                        "KIND": "kind",
                        "CLIENT_NAME": "client_name",
                        "USER_AGENT": "user_agent",
                        "DCT_VERSION": "dct_version"
                    },
                },
                'openapi_types': {
                    'start_date':
                        (datetime,),
                    'end_date':
                        (datetime,),
                    'api_metric_kind':
                        (str,),
                    'group_by':
                        ([str],),
                    'client_name':
                        ([str],),
                    'user_agent':
                        ([str],),
                    'dct_version':
                        ([str],),
                },
                'attribute_map': {
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'api_metric_kind': 'api_metric_kind',
                    'group_by': 'group_by',
                    'client_name': 'client_name',
                    'user_agent': 'user_agent',
                    'dct_version': 'dct_version',
                },
                'location_map': {
                    'start_date': 'query',
                    'end_date': 'query',
                    'api_metric_kind': 'query',
                    'group_by': 'query',
                    'client_name': 'query',
                    'user_agent': 'query',
                    'dct_version': 'query',
                },
                'collection_format_map': {
                    'group_by': 'multi',
                    'client_name': 'multi',
                    'user_agent': 'multi',
                    'dct_version': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_usage_report
        )

        def __get_audit_logs_summary_report(
            self,
            **kwargs
        ):
            """Gets the audit log summary report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_audit_logs_summary_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuditLogsSummaryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_audit_logs_summary_report = _Endpoint(
            settings={
                'response_type': (AuditLogsSummaryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/audit-logs-summary-report',
                'operation_id': 'get_audit_logs_summary_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ACCOUNT_ID": "account_id",
                        "-ACCOUNT_ID": "-account_id",
                        "ACCOUNT_FIRST_NAME": "account_first_name",
                        "-ACCOUNT_FIRST_NAME": "-account_first_name",
                        "ACCOUNT_LAST_NAME": "account_last_name",
                        "-ACCOUNT_LAST_NAME": "-account_last_name",
                        "VDB_REFRESHES": "vdb_refreshes",
                        "-VDB_REFRESHES": "-vdb_refreshes",
                        "MASKING_JOBS": "masking_jobs",
                        "-MASKING_JOBS": "-masking_jobs"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_audit_logs_summary_report
        )

        def __get_data_risk_report(
            self,
            **kwargs
        ):
            """Get the masking data risk report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_data_risk_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetDataRiskReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_data_risk_report = _Endpoint(
            settings={
                'response_type': (GetDataRiskReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/data-risk-report',
                'operation_id': 'get_data_risk_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "CONNECTOR_ID": "connector_id",
                        "-CONNECTOR_ID": "-connector_id",
                        "ENGINE_CONNECTOR_ID": "engine_connector_id",
                        "-ENGINE_CONNECTOR_ID": "-engine_connector_id",
                        "CONNECTOR_NAME": "connector_name",
                        "-CONNECTOR_NAME": "-connector_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "LAST_PROFILED_DATE": "last_profiled_date",
                        "-LAST_PROFILED_DATE": "-last_profiled_date",
                        "LAST_MASKED_DATE": "last_masked_date",
                        "-LAST_MASKED_DATE": "-last_masked_date",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "IS_PROFILED": "is_profiled",
                        "-IS_PROFILED": "-is_profiled",
                        "IS_SENSITIVE_DATA": "is_sensitive_data",
                        "-IS_SENSITIVE_DATA": "-is_sensitive_data",
                        "IS_MASKED": "is_masked",
                        "-IS_MASKED": "-is_masked",
                        "IS_AT_RISK": "is_at_risk",
                        "-IS_AT_RISK": "-is_at_risk",
                        "DATA_ELEMENTS_TOTAL": "data_elements_total",
                        "-DATA_ELEMENTS_TOTAL": "-data_elements_total",
                        "DATA_ELEMENTS_NOT_SENSITIVE": "data_elements_not_sensitive",
                        "-DATA_ELEMENTS_NOT_SENSITIVE": "-data_elements_not_sensitive",
                        "DATA_ELEMENTS_SENSITIVE_MASKED": "data_elements_sensitive_masked",
                        "-DATA_ELEMENTS_SENSITIVE_MASKED": "-data_elements_sensitive_masked",
                        "DATA_ELEMENTS_SENSITIVE_UNMASKED": "data_elements_sensitive_unmasked",
                        "-DATA_ELEMENTS_SENSITIVE_UNMASKED": "-data_elements_sensitive_unmasked",
                        "RECORDS_TOTAL": "records_total",
                        "-RECORDS_TOTAL": "-records_total",
                        "RECORDS_NOT_SENSITIVE": "records_not_sensitive",
                        "-RECORDS_NOT_SENSITIVE": "-records_not_sensitive",
                        "RECORDS_SENSITIVE_MASKED": "records_sensitive_masked",
                        "-RECORDS_SENSITIVE_MASKED": "-records_sensitive_masked",
                        "RECORDS_SENSITIVE_UNMASKED": "records_sensitive_unmasked",
                        "-RECORDS_SENSITIVE_UNMASKED": "-records_sensitive_unmasked"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_data_risk_report
        )

        def __get_dsource_consumption_report(
            self,
            **kwargs
        ):
            """Gets the consumption report for virtualization engine dSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsource_consumption_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DSourceConsumptionReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_dsource_consumption_report = _Endpoint(
            settings={
                'response_type': (DSourceConsumptionReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/dsource-consumption-report',
                'operation_id': 'get_dsource_consumption_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "LAST_CONSUMPTION_DATE": "last_consumption_date",
                        "-LAST_CONSUMPTION_DATE": "-last_consumption_date",
                        "INGESTED_SIZE": "ingested_size",
                        "-INGESTED_SIZE": "-ingested_size"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsource_consumption_report
        )

        def __get_dsource_usage_report(
            self,
            **kwargs
        ):
            """Gets the usage report for virtualization engine dSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsource_usage_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DSourceUsageReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_dsource_usage_report = _Endpoint(
            settings={
                'response_type': (DSourceUsageReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/dsource-usage-report',
                'operation_id': 'get_dsource_usage_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "UNVIRTUALIZED_SPACE": "unvirtualized_space",
                        "-UNVIRTUALIZED_SPACE": "-unvirtualized_space",
                        "ACTUAL_SPACE": "actual_space",
                        "-ACTUAL_SPACE": "-actual_space",
                        "DEPENDANT_VDBS": "dependant_vdbs",
                        "-DEPENDANT_VDBS": "-dependant_vdbs",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsource_usage_report
        )

        def __get_engine_global_object_state_report(
            self,
            **kwargs
        ):
            """Get the masking engine global object state report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_engine_global_object_state_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetEngineGlobalObjectStateReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_engine_global_object_state_report = _Endpoint(
            settings={
                'response_type': (GetEngineGlobalObjectStateReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/engine-global-object-state-report',
                'operation_id': 'get_engine_global_object_state_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "JOBS_COUNT": "jobs_count",
                        "-JOBS_COUNT": "-jobs_count",
                        "CONNECTORS_COUNT": "connectors_count",
                        "-CONNECTORS_COUNT": "-connectors_count",
                        "RULESETS_COUNT": "rulesets_count",
                        "-RULESETS_COUNT": "-rulesets_count",
                        "GLOBAL_OBJECT_REVISION_HASH": "global_object_revision_hash",
                        "-GLOBAL_OBJECT_REVISION_HASH": "-global_object_revision_hash"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_engine_global_object_state_report
        )

        def __get_engine_performance_analytics_report(
            self,
            **kwargs
        ):
            """Gets the performance analytics report for engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_engine_performance_analytics_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnginePerformanceAnalyticReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_engine_performance_analytics_report = _Endpoint(
            settings={
                'response_type': (EnginePerformanceAnalyticReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/engine-performance-analytic-report',
                'operation_id': 'get_engine_performance_analytics_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "CPU_CORES_COUNT": "cpu_cores_count",
                        "-CPU_CORES_COUNT": "-cpu_cores_count",
                        "CPU_UTILIZATION": "cpu_utilization",
                        "-CPU_UTILIZATION": "-cpu_utilization",
                        "TOTAL_MEMORY": "total_memory",
                        "-TOTAL_MEMORY": "-total_memory",
                        "AVERAGE_DISK_LATENCY_READ": "average_disk_latency_read",
                        "-AVERAGE_DISK_LATENCY_READ": "-average_disk_latency_read",
                        "AVERAGE_DISK_LATENCY_WRITE": "average_disk_latency_write",
                        "-AVERAGE_DISK_LATENCY_WRITE": "-average_disk_latency_write",
                        "AVERAGE_DISK_LATENCY_TOTAL": "average_disk_latency_total",
                        "-AVERAGE_DISK_LATENCY_TOTAL": "-average_disk_latency_total",
                        "AVERAGE_DISK_THROUGHPUT_READ": "average_disk_throughput_read",
                        "-AVERAGE_DISK_THROUGHPUT_READ": "-average_disk_throughput_read",
                        "AVERAGE_DISK_THROUGHPUT_WRITE": "average_disk_throughput_write",
                        "-AVERAGE_DISK_THROUGHPUT_WRITE": "-average_disk_throughput_write",
                        "AVERAGE_DISK_THROUGHPUT_TOTAL": "average_disk_throughput_total",
                        "-AVERAGE_DISK_THROUGHPUT_TOTAL": "-average_disk_throughput_total",
                        "AVERAGE_DISK_IOPS_READ": "average_disk_iops_read",
                        "-AVERAGE_DISK_IOPS_READ": "-average_disk_iops_read",
                        "AVERAGE_DISK_IOPS_WRITE": "average_disk_iops_write",
                        "-AVERAGE_DISK_IOPS_WRITE": "-average_disk_iops_write",
                        "AVERAGE_DISK_IOPS_TOTAL": "average_disk_iops_total",
                        "-AVERAGE_DISK_IOPS_TOTAL": "-average_disk_iops_total",
                        "AVERAGE_NFS_LATENCY_READ": "average_nfs_latency_read",
                        "-AVERAGE_NFS_LATENCY_READ": "-average_nfs_latency_read",
                        "AVERAGE_NFS_LATENCY_WRITE": "average_nfs_latency_write",
                        "-AVERAGE_NFS_LATENCY_WRITE": "-average_nfs_latency_write",
                        "AVERAGE_NFS_LATENCY_TOTAL": "average_nfs_latency_total",
                        "-AVERAGE_NFS_LATENCY_TOTAL": "-average_nfs_latency_total",
                        "AVERAGE_NFS_THROUGHPUT_READ": "average_nfs_throughput_read",
                        "-AVERAGE_NFS_THROUGHPUT_READ": "-average_nfs_throughput_read",
                        "AVERAGE_NFS_THROUGHPUT_WRITE": "average_nfs_throughput_write",
                        "-AVERAGE_NFS_THROUGHPUT_WRITE": "-average_nfs_throughput_write",
                        "AVERAGE_NFS_THROUGHPUT_TOTAL": "average_nfs_throughput_total",
                        "-AVERAGE_NFS_THROUGHPUT_TOTAL": "-average_nfs_throughput_total",
                        "AVERAGE_NFS_IOPS_READ": "average_nfs_iops_read",
                        "-AVERAGE_NFS_IOPS_READ": "-average_nfs_iops_read",
                        "AVERAGE_NFS_IOPS_WRITE": "average_nfs_iops_write",
                        "-AVERAGE_NFS_IOPS_WRITE": "-average_nfs_iops_write",
                        "AVERAGE_NFS_IOPS_TOTAL": "average_nfs_iops_total",
                        "-AVERAGE_NFS_IOPS_TOTAL": "-average_nfs_iops_total",
                        "AVERAGE_ISCSI_LATENCY_READ": "average_iscsi_latency_read",
                        "-AVERAGE_ISCSI_LATENCY_READ": "-average_iscsi_latency_read",
                        "AVERAGE_ISCSI_LATENCY_WRITE": "average_iscsi_latency_write",
                        "-AVERAGE_ISCSI_LATENCY_WRITE": "-average_iscsi_latency_write",
                        "AVERAGE_ISCSI_LATENCY_TOTAL": "average_iscsi_latency_total",
                        "-AVERAGE_ISCSI_LATENCY_TOTAL": "-average_iscsi_latency_total",
                        "AVERAGE_ISCSI_THROUGHPUT_READ": "average_iscsi_throughput_read",
                        "-AVERAGE_ISCSI_THROUGHPUT_READ": "-average_iscsi_throughput_read",
                        "AVERAGE_ISCSI_THROUGHPUT_WRITE": "average_iscsi_throughput_write",
                        "-AVERAGE_ISCSI_THROUGHPUT_WRITE": "-average_iscsi_throughput_write",
                        "AVERAGE_ISCSI_THROUGHPUT_TOTAL": "average_iscsi_throughput_total",
                        "-AVERAGE_ISCSI_THROUGHPUT_TOTAL": "-average_iscsi_throughput_total",
                        "AVERAGE_ISCSI_IOPS_READ": "average_iscsi_iops_read",
                        "-AVERAGE_ISCSI_IOPS_READ": "-average_iscsi_iops_read",
                        "AVERAGE_ISCSI_IOPS_WRITE": "average_iscsi_iops_write",
                        "-AVERAGE_ISCSI_IOPS_WRITE": "-average_iscsi_iops_write",
                        "AVERAGE_ISCSI_IOPS_TOTAL": "average_iscsi_iops_total",
                        "-AVERAGE_ISCSI_IOPS_TOTAL": "-average_iscsi_iops_total",
                        "AVERAGE_NETWORK_THROUGHPUT_TRANSMIT": "average_network_throughput_transmit",
                        "-AVERAGE_NETWORK_THROUGHPUT_TRANSMIT": "-average_network_throughput_transmit",
                        "AVERAGE_NETWORK_THROUGHPUT_RECEIVE": "average_network_throughput_receive",
                        "-AVERAGE_NETWORK_THROUGHPUT_RECEIVE": "-average_network_throughput_receive"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_engine_performance_analytics_report
        )

        def __get_masking_execution_metrics_report(
            self,
            **kwargs
        ):
            """Get the masking execution metrics report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_masking_execution_metrics_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MaskingExecutionMetricsReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_masking_execution_metrics_report = _Endpoint(
            settings={
                'response_type': (MaskingExecutionMetricsReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/masking-execution-metrics',
                'operation_id': 'get_masking_execution_metrics_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "MASKING_JOB_NAME": "masking_job_name",
                        "-MASKING_JOB_NAME": "-masking_job_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "RULESET_NAME": "ruleset_name",
                        "-RULESET_NAME": "-ruleset_name",
                        "ROWS_MASKED": "rows_masked",
                        "-ROWS_MASKED": "-rows_masked",
                        "ROWS_TOTAL": "rows_total",
                        "-ROWS_TOTAL": "-rows_total",
                        "BYTES_MASKED": "bytes_masked",
                        "-BYTES_MASKED": "-bytes_masked",
                        "BYTES_TOTAL": "bytes_total",
                        "-BYTES_TOTAL": "-bytes_total",
                        "DURATION": "duration",
                        "-DURATION": "-duration",
                        "TABLES_FILES_COUNT": "tables_files_count",
                        "-TABLES_FILES_COUNT": "-tables_files_count",
                        "MASKED_TABLES_FILES_COUNT": "masked_tables_files_count",
                        "-MASKED_TABLES_FILES_COUNT": "-masked_tables_files_count",
                        "COLUMNS_FIELDS_COUNT": "columns_fields_count",
                        "-COLUMNS_FIELDS_COUNT": "-columns_fields_count",
                        "MASKED_COLUMNS_FIELDS_COUNT": "masked_columns_fields_count",
                        "-MASKED_COLUMNS_FIELDS_COUNT": "-masked_columns_fields_count",
                        "MASKING_JOB_TYPE": "masking_job_type",
                        "-MASKING_JOB_TYPE": "-masking_job_type"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_masking_execution_metrics_report
        )

        def __get_product_info(
            self,
            **kwargs
        ):
            """Returns the DCT Product Information.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_product_info(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProductInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_product_info = _Endpoint(
            settings={
                'response_type': (ProductInfo,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/product_info',
                'operation_id': 'get_product_info',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_product_info
        )

        def __get_reporting_schedule_by_id(
            self,
            report_id,
            **kwargs
        ):
            """Returns a report schedule by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_reporting_schedule_by_id(report_id, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ReportingSchedule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.get_reporting_schedule_by_id = _Endpoint(
            settings={
                'response_type': (ReportingSchedule,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}',
                'operation_id': 'get_reporting_schedule_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                ],
                'required': [
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_reporting_schedule_by_id
        )

        def __get_reporting_schedule_tags(
            self,
            report_id,
            **kwargs
        ):
            """Get tags for a report schedule.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_reporting_schedule_tags(report_id, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.get_reporting_schedule_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}/tags',
                'operation_id': 'get_reporting_schedule_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                ],
                'required': [
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_reporting_schedule_tags
        )

        def __get_reporting_schedules(
            self,
            **kwargs
        ):
            """List all report schedules.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_reporting_schedules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListReportingScheduleResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_reporting_schedules = _Endpoint(
            settings={
                'response_type': (ListReportingScheduleResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule',
                'operation_id': 'get_reporting_schedules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "REPORT_ID": "report_id",
                        "-REPORT_ID": "-report_id",
                        "REPORT_TYPE": "report_type",
                        "-REPORT_TYPE": "-report_type",
                        "CRON_EXPRESSION": "cron_expression",
                        "-CRON_EXPRESSION": "-cron_expression",
                        "TIME_ZONE": "time_zone",
                        "-TIME_ZONE": "-time_zone",
                        "MESSAGE": "message",
                        "-MESSAGE": "-message",
                        "FILE_FORMAT": "file_format",
                        "-FILE_FORMAT": "-file_format",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "SORT_COLUMN": "sort_column",
                        "-SORT_COLUMN": "-sort_column"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_reporting_schedules
        )

        def __get_storage_capacity_data(
            self,
            **kwargs
        ):
            """Get engine storage capacity data.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_storage_capacity_data(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                engine_id (str): ID of a registered engine.. [optional]
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EngineStorageCapacityDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_storage_capacity_data = _Endpoint(
            settings={
                'response_type': (EngineStorageCapacityDataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/storage-capacity-data-report',
                'operation_id': 'get_storage_capacity_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'engine_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "CAPTURED_TIMESTAMP": "captured_timestamp",
                        "-CAPTURED_TIMESTAMP": "-captured_timestamp",
                        "DATASET_TYPE": "dataset_type",
                        "-DATASET_TYPE": "-dataset_type",
                        "DATASET_NAME": "dataset_name",
                        "-DATASET_NAME": "-dataset_name",
                        "IS_REPLICA": "is_replica",
                        "-IS_REPLICA": "-is_replica",
                        "TOTAL_SIZE": "total_size",
                        "-TOTAL_SIZE": "-total_size",
                        "BASE_SIZE": "base_size",
                        "-BASE_SIZE": "-base_size",
                        "SNAPSHOT_SIZE": "snapshot_size",
                        "-SNAPSHOT_SIZE": "-snapshot_size",
                        "LOGS_SIZE": "logs_size",
                        "-LOGS_SIZE": "-logs_size",
                        "UNVIRTUALIZED_SIZE": "unvirtualized_size",
                        "-UNVIRTUALIZED_SIZE": "-unvirtualized_size",
                        "CURRENT_TIMEFLOW_UNVIRTUALIZED_SIZE": "current_timeflow_unvirtualized_size",
                        "-CURRENT_TIMEFLOW_UNVIRTUALIZED_SIZE": "-current_timeflow_unvirtualized_size",
                        "TIMEFLOW_UNVIRTUALIZED_SIZE": "timeflow_unvirtualized_size",
                        "-TIMEFLOW_UNVIRTUALIZED_SIZE": "-timeflow_unvirtualized_size",
                        "DESCENDANT_SIZE": "descendant_size",
                        "-DESCENDANT_SIZE": "-descendant_size",
                        "POLICY_SIZE": "policy_size",
                        "-POLICY_SIZE": "-policy_size",
                        "MANUAL_SIZE": "manual_size",
                        "-MANUAL_SIZE": "-manual_size",
                        "UNOWNED_SNAPSHOT_SIZE": "unowned_snapshot_size",
                        "-UNOWNED_SNAPSHOT_SIZE": "-unowned_snapshot_size",
                        "INGESTED_SIZE": "ingested_size",
                        "-INGESTED_SIZE": "-ingested_size"
                    },
                },
                'openapi_types': {
                    'engine_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'engine_id': 'engine_id',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'engine_id': 'query',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_storage_capacity_data
        )

        def __get_vdb_inventory_report(
            self,
            **kwargs
        ):
            """Gets the inventory report for virtualization engine VDBs.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_inventory_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDBInventoryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_vdb_inventory_report = _Endpoint(
            settings={
                'response_type': (VDBInventoryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/vdb-inventory-report',
                'operation_id': 'get_vdb_inventory_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "TYPE": "type",
                        "-TYPE": "-type",
                        "VERSION": "version",
                        "-VERSION": "-version",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "PARENT_NAME": "parent_name",
                        "-PARENT_NAME": "-parent_name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "LAST_REFRESHED_DATE": "last_refreshed_date",
                        "-LAST_REFRESHED_DATE": "-last_refreshed_date",
                        "PARENT_TIMEFLOW_LOCATION": "parent_timeflow_location",
                        "-PARENT_TIMEFLOW_LOCATION": "-parent_timeflow_location",
                        "PARENT_TIMEFLOW_TIMESTAMP": "parent_timeflow_timestamp",
                        "-PARENT_TIMEFLOW_TIMESTAMP": "-parent_timeflow_timestamp",
                        "PARENT_TIMEFLOW_TIMEZONE": "parent_timeflow_timezone",
                        "-PARENT_TIMEFLOW_TIMEZONE": "-parent_timeflow_timezone",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_inventory_report
        )

        def __get_virtualization_storage_summary_report(
            self,
            **kwargs
        ):
            """Gets the storage summary report for virtualization engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_virtualization_storage_summary_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationStorageSummaryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_virtualization_storage_summary_report = _Endpoint(
            settings={
                'response_type': (VirtualizationStorageSummaryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/virtualization-storage-summary-report',
                'operation_id': 'get_virtualization_storage_summary_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "ENGINE_HOSTNAME": "engine_hostname",
                        "-ENGINE_HOSTNAME": "-engine_hostname",
                        "TOTAL_CAPACITY": "total_capacity",
                        "-TOTAL_CAPACITY": "-total_capacity",
                        "FREE_STORAGE": "free_storage",
                        "-FREE_STORAGE": "-free_storage",
                        "USED_STORAGE": "used_storage",
                        "-USED_STORAGE": "-used_storage",
                        "USED_PERCENTAGE": "used_percentage",
                        "-USED_PERCENTAGE": "-used_percentage",
                        "DSOURCE_COUNT": "dsource_count",
                        "-DSOURCE_COUNT": "-dsource_count",
                        "VDB_COUNT": "vdb_count",
                        "-VDB_COUNT": "-vdb_count",
                        "TOTAL_OBJECT_COUNT": "total_object_count",
                        "-TOTAL_OBJECT_COUNT": "-total_object_count",
                        "RESERVED_STORAGE": "reserved_storage",
                        "-RESERVED_STORAGE": "-reserved_storage",
                        "DSOURCE_USED_STORAGE": "dsource_used_storage",
                        "-DSOURCE_USED_STORAGE": "-dsource_used_storage",
                        "VDB_USED_STORAGE": "vdb_used_storage",
                        "-VDB_USED_STORAGE": "-vdb_used_storage"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_virtualization_storage_summary_report
        )

        def __search_data_risk_report(
            self,
            **kwargs
        ):
            """Search the masking data risk report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_data_risk_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchDataRiskReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_data_risk_report = _Endpoint(
            settings={
                'response_type': (SearchDataRiskReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/data-risk-report/search',
                'operation_id': 'search_data_risk_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "CONNECTOR_ID": "connector_id",
                        "-CONNECTOR_ID": "-connector_id",
                        "ENGINE_CONNECTOR_ID": "engine_connector_id",
                        "-ENGINE_CONNECTOR_ID": "-engine_connector_id",
                        "CONNECTOR_NAME": "connector_name",
                        "-CONNECTOR_NAME": "-connector_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "LAST_PROFILED_DATE": "last_profiled_date",
                        "-LAST_PROFILED_DATE": "-last_profiled_date",
                        "LAST_MASKED_DATE": "last_masked_date",
                        "-LAST_MASKED_DATE": "-last_masked_date",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "IS_PROFILED": "is_profiled",
                        "-IS_PROFILED": "-is_profiled",
                        "IS_SENSITIVE_DATA": "is_sensitive_data",
                        "-IS_SENSITIVE_DATA": "-is_sensitive_data",
                        "IS_MASKED": "is_masked",
                        "-IS_MASKED": "-is_masked",
                        "IS_AT_RISK": "is_at_risk",
                        "-IS_AT_RISK": "-is_at_risk",
                        "DATA_ELEMENTS_TOTAL": "data_elements_total",
                        "-DATA_ELEMENTS_TOTAL": "-data_elements_total",
                        "DATA_ELEMENTS_NOT_SENSITIVE": "data_elements_not_sensitive",
                        "-DATA_ELEMENTS_NOT_SENSITIVE": "-data_elements_not_sensitive",
                        "DATA_ELEMENTS_SENSITIVE_MASKED": "data_elements_sensitive_masked",
                        "-DATA_ELEMENTS_SENSITIVE_MASKED": "-data_elements_sensitive_masked",
                        "DATA_ELEMENTS_SENSITIVE_UNMASKED": "data_elements_sensitive_unmasked",
                        "-DATA_ELEMENTS_SENSITIVE_UNMASKED": "-data_elements_sensitive_unmasked",
                        "RECORDS_TOTAL": "records_total",
                        "-RECORDS_TOTAL": "-records_total",
                        "RECORDS_NOT_SENSITIVE": "records_not_sensitive",
                        "-RECORDS_NOT_SENSITIVE": "-records_not_sensitive",
                        "RECORDS_SENSITIVE_MASKED": "records_sensitive_masked",
                        "-RECORDS_SENSITIVE_MASKED": "-records_sensitive_masked",
                        "RECORDS_SENSITIVE_UNMASKED": "records_sensitive_unmasked",
                        "-RECORDS_SENSITIVE_UNMASKED": "-records_sensitive_unmasked"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_data_risk_report
        )

        def __search_dsource_consumption_report(
            self,
            **kwargs
        ):
            """Search the consumption report for virtualization engine DSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_dsource_consumption_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DSourceConsumptionReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_dsource_consumption_report = _Endpoint(
            settings={
                'response_type': (DSourceConsumptionReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/dsource-consumption-report/search',
                'operation_id': 'search_dsource_consumption_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "LAST_CONSUMPTION_DATE": "last_consumption_date",
                        "-LAST_CONSUMPTION_DATE": "-last_consumption_date",
                        "INGESTED_SIZE": "ingested_size",
                        "-INGESTED_SIZE": "-ingested_size"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_dsource_consumption_report
        )

        def __search_dsource_usage_report(
            self,
            **kwargs
        ):
            """Search the usage report for virtualization engine dSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_dsource_usage_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DSourceUsageReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_dsource_usage_report = _Endpoint(
            settings={
                'response_type': (DSourceUsageReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/dsource-usage-report/search',
                'operation_id': 'search_dsource_usage_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "UNVIRTUALIZED_SPACE": "unvirtualized_space",
                        "-UNVIRTUALIZED_SPACE": "-unvirtualized_space",
                        "ACTUAL_SPACE": "actual_space",
                        "-ACTUAL_SPACE": "-actual_space",
                        "DEPENDANT_VDBS": "dependant_vdbs",
                        "-DEPENDANT_VDBS": "-dependant_vdbs",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_dsource_usage_report
        )

        def __search_engine_global_object_state_report(
            self,
            **kwargs
        ):
            """Search the masking engine global object state report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_engine_global_object_state_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchEngineGlobalObjectStateReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_engine_global_object_state_report = _Endpoint(
            settings={
                'response_type': (SearchEngineGlobalObjectStateReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/engine-global-object-state-report/search',
                'operation_id': 'search_engine_global_object_state_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "JOBS_COUNT": "jobs_count",
                        "-JOBS_COUNT": "-jobs_count",
                        "CONNECTORS_COUNT": "connectors_count",
                        "-CONNECTORS_COUNT": "-connectors_count",
                        "RULESETS_COUNT": "rulesets_count",
                        "-RULESETS_COUNT": "-rulesets_count",
                        "GLOBAL_OBJECT_REVISION_HASH": "global_object_revision_hash",
                        "-GLOBAL_OBJECT_REVISION_HASH": "-global_object_revision_hash"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_engine_global_object_state_report
        )

        def __search_engine_performance_analytic_trends(
            self,
            **kwargs
        ):
            """Search the performance analytic trend data for engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_engine_performance_analytic_trends(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnginePerformanceAnalyticTrendResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_engine_performance_analytic_trends = _Endpoint(
            settings={
                'response_type': (EnginePerformanceAnalyticTrendResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/engine-performance-analytic-trends/search',
                'operation_id': 'search_engine_performance_analytic_trends',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "TREND_TYPE": "trend_type",
                        "-TREND_TYPE": "-trend_type",
                        "AGGREGATION_PERIOD": "aggregation_period",
                        "-AGGREGATION_PERIOD": "-aggregation_period"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_engine_performance_analytic_trends
        )

        def __search_engine_performance_analytics_report(
            self,
            **kwargs
        ):
            """Search the performance analytic report for engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_engine_performance_analytics_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnginePerformanceAnalyticReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_engine_performance_analytics_report = _Endpoint(
            settings={
                'response_type': (EnginePerformanceAnalyticReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/engine-performance-analytic-report/search',
                'operation_id': 'search_engine_performance_analytics_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "CPU_CORES_COUNT": "cpu_cores_count",
                        "-CPU_CORES_COUNT": "-cpu_cores_count",
                        "CPU_UTILIZATION": "cpu_utilization",
                        "-CPU_UTILIZATION": "-cpu_utilization",
                        "TOTAL_MEMORY": "total_memory",
                        "-TOTAL_MEMORY": "-total_memory",
                        "AVERAGE_DISK_LATENCY_READ": "average_disk_latency_read",
                        "-AVERAGE_DISK_LATENCY_READ": "-average_disk_latency_read",
                        "AVERAGE_DISK_LATENCY_WRITE": "average_disk_latency_write",
                        "-AVERAGE_DISK_LATENCY_WRITE": "-average_disk_latency_write",
                        "AVERAGE_DISK_LATENCY_TOTAL": "average_disk_latency_total",
                        "-AVERAGE_DISK_LATENCY_TOTAL": "-average_disk_latency_total",
                        "AVERAGE_DISK_THROUGHPUT_READ": "average_disk_throughput_read",
                        "-AVERAGE_DISK_THROUGHPUT_READ": "-average_disk_throughput_read",
                        "AVERAGE_DISK_THROUGHPUT_WRITE": "average_disk_throughput_write",
                        "-AVERAGE_DISK_THROUGHPUT_WRITE": "-average_disk_throughput_write",
                        "AVERAGE_DISK_THROUGHPUT_TOTAL": "average_disk_throughput_total",
                        "-AVERAGE_DISK_THROUGHPUT_TOTAL": "-average_disk_throughput_total",
                        "AVERAGE_DISK_IOPS_READ": "average_disk_iops_read",
                        "-AVERAGE_DISK_IOPS_READ": "-average_disk_iops_read",
                        "AVERAGE_DISK_IOPS_WRITE": "average_disk_iops_write",
                        "-AVERAGE_DISK_IOPS_WRITE": "-average_disk_iops_write",
                        "AVERAGE_DISK_IOPS_TOTAL": "average_disk_iops_total",
                        "-AVERAGE_DISK_IOPS_TOTAL": "-average_disk_iops_total",
                        "AVERAGE_NFS_LATENCY_READ": "average_nfs_latency_read",
                        "-AVERAGE_NFS_LATENCY_READ": "-average_nfs_latency_read",
                        "AVERAGE_NFS_LATENCY_WRITE": "average_nfs_latency_write",
                        "-AVERAGE_NFS_LATENCY_WRITE": "-average_nfs_latency_write",
                        "AVERAGE_NFS_LATENCY_TOTAL": "average_nfs_latency_total",
                        "-AVERAGE_NFS_LATENCY_TOTAL": "-average_nfs_latency_total",
                        "AVERAGE_NFS_THROUGHPUT_READ": "average_nfs_throughput_read",
                        "-AVERAGE_NFS_THROUGHPUT_READ": "-average_nfs_throughput_read",
                        "AVERAGE_NFS_THROUGHPUT_WRITE": "average_nfs_throughput_write",
                        "-AVERAGE_NFS_THROUGHPUT_WRITE": "-average_nfs_throughput_write",
                        "AVERAGE_NFS_THROUGHPUT_TOTAL": "average_nfs_throughput_total",
                        "-AVERAGE_NFS_THROUGHPUT_TOTAL": "-average_nfs_throughput_total",
                        "AVERAGE_NFS_IOPS_READ": "average_nfs_iops_read",
                        "-AVERAGE_NFS_IOPS_READ": "-average_nfs_iops_read",
                        "AVERAGE_NFS_IOPS_WRITE": "average_nfs_iops_write",
                        "-AVERAGE_NFS_IOPS_WRITE": "-average_nfs_iops_write",
                        "AVERAGE_NFS_IOPS_TOTAL": "average_nfs_iops_total",
                        "-AVERAGE_NFS_IOPS_TOTAL": "-average_nfs_iops_total",
                        "AVERAGE_ISCSI_LATENCY_READ": "average_iscsi_latency_read",
                        "-AVERAGE_ISCSI_LATENCY_READ": "-average_iscsi_latency_read",
                        "AVERAGE_ISCSI_LATENCY_WRITE": "average_iscsi_latency_write",
                        "-AVERAGE_ISCSI_LATENCY_WRITE": "-average_iscsi_latency_write",
                        "AVERAGE_ISCSI_LATENCY_TOTAL": "average_iscsi_latency_total",
                        "-AVERAGE_ISCSI_LATENCY_TOTAL": "-average_iscsi_latency_total",
                        "AVERAGE_ISCSI_THROUGHPUT_READ": "average_iscsi_throughput_read",
                        "-AVERAGE_ISCSI_THROUGHPUT_READ": "-average_iscsi_throughput_read",
                        "AVERAGE_ISCSI_THROUGHPUT_WRITE": "average_iscsi_throughput_write",
                        "-AVERAGE_ISCSI_THROUGHPUT_WRITE": "-average_iscsi_throughput_write",
                        "AVERAGE_ISCSI_THROUGHPUT_TOTAL": "average_iscsi_throughput_total",
                        "-AVERAGE_ISCSI_THROUGHPUT_TOTAL": "-average_iscsi_throughput_total",
                        "AVERAGE_ISCSI_IOPS_READ": "average_iscsi_iops_read",
                        "-AVERAGE_ISCSI_IOPS_READ": "-average_iscsi_iops_read",
                        "AVERAGE_ISCSI_IOPS_WRITE": "average_iscsi_iops_write",
                        "-AVERAGE_ISCSI_IOPS_WRITE": "-average_iscsi_iops_write",
                        "AVERAGE_ISCSI_IOPS_TOTAL": "average_iscsi_iops_total",
                        "-AVERAGE_ISCSI_IOPS_TOTAL": "-average_iscsi_iops_total",
                        "AVERAGE_NETWORK_THROUGHPUT_TRANSMIT": "average_network_throughput_transmit",
                        "-AVERAGE_NETWORK_THROUGHPUT_TRANSMIT": "-average_network_throughput_transmit",
                        "AVERAGE_NETWORK_THROUGHPUT_RECEIVE": "average_network_throughput_receive",
                        "-AVERAGE_NETWORK_THROUGHPUT_RECEIVE": "-average_network_throughput_receive"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_engine_performance_analytics_report
        )

        def __search_masking_execution_metrics_report(
            self,
            **kwargs
        ):
            """Search the Masking execution metrics report.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_masking_execution_metrics_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MaskingExecutionMetricsReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_masking_execution_metrics_report = _Endpoint(
            settings={
                'response_type': (MaskingExecutionMetricsReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/masking-execution-metrics/search',
                'operation_id': 'search_masking_execution_metrics_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "MASKING_JOB_NAME": "masking_job_name",
                        "-MASKING_JOB_NAME": "-masking_job_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "RULESET_NAME": "ruleset_name",
                        "-RULESET_NAME": "-ruleset_name",
                        "ROWS_MASKED": "rows_masked",
                        "-ROWS_MASKED": "-rows_masked",
                        "ROWS_TOTAL": "rows_total",
                        "-ROWS_TOTAL": "-rows_total",
                        "BYTES_MASKED": "bytes_masked",
                        "-BYTES_MASKED": "-bytes_masked",
                        "BYTES_TOTAL": "bytes_total",
                        "-BYTES_TOTAL": "-bytes_total",
                        "DURATION": "duration",
                        "-DURATION": "-duration",
                        "TABLES_FILES_COUNT": "tables_files_count",
                        "-TABLES_FILES_COUNT": "-tables_files_count",
                        "MASKED_TABLES_FILES_COUNT": "masked_tables_files_count",
                        "-MASKED_TABLES_FILES_COUNT": "-masked_tables_files_count",
                        "COLUMNS_FIELDS_COUNT": "columns_fields_count",
                        "-COLUMNS_FIELDS_COUNT": "-columns_fields_count",
                        "MASKED_COLUMNS_FIELDS_COUNT": "masked_columns_fields_count",
                        "-MASKED_COLUMNS_FIELDS_COUNT": "-masked_columns_fields_count",
                        "MASKING_JOB_TYPE": "masking_job_type",
                        "-MASKING_JOB_TYPE": "-masking_job_type"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_masking_execution_metrics_report
        )

        def __search_reporting_schedules(
            self,
            **kwargs
        ):
            """Search for report schedules.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_reporting_schedules(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchReportingScheduleResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_reporting_schedules = _Endpoint(
            settings={
                'response_type': (SearchReportingScheduleResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/search',
                'operation_id': 'search_reporting_schedules',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "REPORT_ID": "report_id",
                        "-REPORT_ID": "-report_id",
                        "REPORT_TYPE": "report_type",
                        "-REPORT_TYPE": "-report_type",
                        "CRON_EXPRESSION": "cron_expression",
                        "-CRON_EXPRESSION": "-cron_expression",
                        "TIME_ZONE": "time_zone",
                        "-TIME_ZONE": "-time_zone",
                        "MESSAGE": "message",
                        "-MESSAGE": "-message",
                        "FILE_FORMAT": "file_format",
                        "-FILE_FORMAT": "-file_format",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "SORT_COLUMN": "sort_column",
                        "-SORT_COLUMN": "-sort_column"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_reporting_schedules
        )

        def __search_storage_capacity_data(
            self,
            **kwargs
        ):
            """Search engine storage capacity data.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_storage_capacity_data(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                engine_id (str): ID of a registered engine.. [optional]
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EngineStorageCapacityDataResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_storage_capacity_data = _Endpoint(
            settings={
                'response_type': (EngineStorageCapacityDataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/storage-capacity-data-report/search',
                'operation_id': 'search_storage_capacity_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'engine_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "CAPTURED_TIMESTAMP": "captured_timestamp",
                        "-CAPTURED_TIMESTAMP": "-captured_timestamp",
                        "DATASET_TYPE": "dataset_type",
                        "-DATASET_TYPE": "-dataset_type",
                        "DATASET_NAME": "dataset_name",
                        "-DATASET_NAME": "-dataset_name",
                        "IS_REPLICA": "is_replica",
                        "-IS_REPLICA": "-is_replica",
                        "TOTAL_SIZE": "total_size",
                        "-TOTAL_SIZE": "-total_size",
                        "BASE_SIZE": "base_size",
                        "-BASE_SIZE": "-base_size",
                        "SNAPSHOT_SIZE": "snapshot_size",
                        "-SNAPSHOT_SIZE": "-snapshot_size",
                        "LOGS_SIZE": "logs_size",
                        "-LOGS_SIZE": "-logs_size",
                        "UNVIRTUALIZED_SIZE": "unvirtualized_size",
                        "-UNVIRTUALIZED_SIZE": "-unvirtualized_size",
                        "CURRENT_TIMEFLOW_UNVIRTUALIZED_SIZE": "current_timeflow_unvirtualized_size",
                        "-CURRENT_TIMEFLOW_UNVIRTUALIZED_SIZE": "-current_timeflow_unvirtualized_size",
                        "TIMEFLOW_UNVIRTUALIZED_SIZE": "timeflow_unvirtualized_size",
                        "-TIMEFLOW_UNVIRTUALIZED_SIZE": "-timeflow_unvirtualized_size",
                        "DESCENDANT_SIZE": "descendant_size",
                        "-DESCENDANT_SIZE": "-descendant_size",
                        "POLICY_SIZE": "policy_size",
                        "-POLICY_SIZE": "-policy_size",
                        "MANUAL_SIZE": "manual_size",
                        "-MANUAL_SIZE": "-manual_size",
                        "UNOWNED_SNAPSHOT_SIZE": "unowned_snapshot_size",
                        "-UNOWNED_SNAPSHOT_SIZE": "-unowned_snapshot_size",
                        "INGESTED_SIZE": "ingested_size",
                        "-INGESTED_SIZE": "-ingested_size"
                    },
                },
                'openapi_types': {
                    'engine_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'engine_id': 'engine_id',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'engine_id': 'query',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_storage_capacity_data
        )

        def __search_storage_savings_summary_report(
            self,
            **kwargs
        ):
            """Search the saving storage summary report for virtualization engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_storage_savings_summary_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StorageSavingsSummaryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_storage_savings_summary_report = _Endpoint(
            settings={
                'response_type': (StorageSavingsSummaryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/storage-savings-report/search',
                'operation_id': 'search_storage_savings_summary_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "DEPENDANT_VDBS": "dependant_vdbs",
                        "-DEPENDANT_VDBS": "-dependant_vdbs",
                        "UNVIRTUALIZED_SPACE": "unvirtualized_space",
                        "-UNVIRTUALIZED_SPACE": "-unvirtualized_space",
                        "CURRENT_TIMEFLOWS_UNVIRTUALIZED_SPACE": "current_timeflows_unvirtualized_space",
                        "-CURRENT_TIMEFLOWS_UNVIRTUALIZED_SPACE": "-current_timeflows_unvirtualized_space",
                        "VIRTUALIZED_SPACE": "virtualized_space",
                        "-VIRTUALIZED_SPACE": "-virtualized_space",
                        "NAME": "name",
                        "-NAME": "-name",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "DSOURCE_ID": "dsource_id",
                        "-DSOURCE_ID": "-dsource_id",
                        "ESTIMATED_SAVINGS": "estimated_savings",
                        "-ESTIMATED_SAVINGS": "-estimated_savings",
                        "ESTIMATED_SAVINGS_PERC": "estimated_savings_perc",
                        "-ESTIMATED_SAVINGS_PERC": "-estimated_savings_perc",
                        "ESTIMATED_CURRENT_TIMEFLOWS_SAVINGS": "estimated_current_timeflows_savings",
                        "-ESTIMATED_CURRENT_TIMEFLOWS_SAVINGS": "-estimated_current_timeflows_savings",
                        "ESTIMATED_CURRENT_TIMEFLOWS_SAVINGS_PERC": "estimated_current_timeflows_savings_perc",
                        "-ESTIMATED_CURRENT_TIMEFLOWS_SAVINGS_PERC": "-estimated_current_timeflows_savings_perc"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_storage_savings_summary_report
        )

        def __search_vdb_inventory_report(
            self,
            **kwargs
        ):
            """Search the inventory report for virtualization engine VDBs.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_vdb_inventory_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDBInventoryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_vdb_inventory_report = _Endpoint(
            settings={
                'response_type': (VDBInventoryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/vdb-inventory-report/search',
                'operation_id': 'search_vdb_inventory_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "NAME": "name",
                        "-NAME": "-name",
                        "TYPE": "type",
                        "-TYPE": "-type",
                        "VERSION": "version",
                        "-VERSION": "-version",
                        "PARENT_ID": "parent_id",
                        "-PARENT_ID": "-parent_id",
                        "PARENT_NAME": "parent_name",
                        "-PARENT_NAME": "-parent_name",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "LAST_REFRESHED_DATE": "last_refreshed_date",
                        "-LAST_REFRESHED_DATE": "-last_refreshed_date",
                        "PARENT_TIMEFLOW_LOCATION": "parent_timeflow_location",
                        "-PARENT_TIMEFLOW_LOCATION": "-parent_timeflow_location",
                        "PARENT_TIMEFLOW_TIMESTAMP": "parent_timeflow_timestamp",
                        "-PARENT_TIMEFLOW_TIMESTAMP": "-parent_timeflow_timestamp",
                        "PARENT_TIMEFLOW_TIMEZONE": "parent_timeflow_timezone",
                        "-PARENT_TIMEFLOW_TIMEZONE": "-parent_timeflow_timezone",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_vdb_inventory_report
        )

        def __search_virtualization_storage_summary_report(
            self,
            **kwargs
        ):
            """Search the storage summary report for virtualization engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_virtualization_storage_summary_report(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 10000.. [optional] if omitted the server will use the default value of 10000
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VirtualizationStorageSummaryReportResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_virtualization_storage_summary_report = _Endpoint(
            settings={
                'response_type': (VirtualizationStorageSummaryReportResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/virtualization-storage-summary-report/search',
                'operation_id': 'search_virtualization_storage_summary_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 10000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "ENGINE_HOSTNAME": "engine_hostname",
                        "-ENGINE_HOSTNAME": "-engine_hostname",
                        "TOTAL_CAPACITY": "total_capacity",
                        "-TOTAL_CAPACITY": "-total_capacity",
                        "FREE_STORAGE": "free_storage",
                        "-FREE_STORAGE": "-free_storage",
                        "USED_STORAGE": "used_storage",
                        "-USED_STORAGE": "-used_storage",
                        "USED_PERCENTAGE": "used_percentage",
                        "-USED_PERCENTAGE": "-used_percentage",
                        "DSOURCE_COUNT": "dsource_count",
                        "-DSOURCE_COUNT": "-dsource_count",
                        "VDB_COUNT": "vdb_count",
                        "-VDB_COUNT": "-vdb_count",
                        "TOTAL_OBJECT_COUNT": "total_object_count",
                        "-TOTAL_OBJECT_COUNT": "-total_object_count",
                        "RESERVED_STORAGE": "reserved_storage",
                        "-RESERVED_STORAGE": "-reserved_storage",
                        "DSOURCE_USED_STORAGE": "dsource_used_storage",
                        "-DSOURCE_USED_STORAGE": "-dsource_used_storage",
                        "VDB_USED_STORAGE": "vdb_used_storage",
                        "-VDB_USED_STORAGE": "-vdb_used_storage"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_virtualization_storage_summary_report
        )

        def __update_reporting_schedule(
            self,
            report_id,
            **kwargs
        ):
            """Update a reporting schedule by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_reporting_schedule(report_id, async_req=True)
            >>> result = thread.get()

            Args:
                report_id (int): The ID of the report schedule.

            Keyword Args:
                reporting_schedule (ReportingSchedule): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ReportingSchedule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['report_id'] = \
                report_id
            return self.call_with_http_info(**kwargs)

        self.update_reporting_schedule = _Endpoint(
            settings={
                'response_type': (ReportingSchedule,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/reporting/schedule/{reportId}',
                'operation_id': 'update_reporting_schedule',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'report_id',
                    'reporting_schedule',
                ],
                'required': [
                    'report_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'report_id':
                        (int,),
                    'reporting_schedule':
                        (ReportingSchedule,),
                },
                'attribute_map': {
                    'report_id': 'reportId',
                },
                'location_map': {
                    'report_id': 'path',
                    'reporting_schedule': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_reporting_schedule
        )
