"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.failover_namespace_parameters import FailoverNamespaceParameters
from delphix.api.gateway.model.list_namespaces_response import ListNamespacesResponse
from delphix.api.gateway.model.namespace import Namespace
from delphix.api.gateway.model.namespace_commit_failover_job_response import NamespaceCommitFailoverJobResponse
from delphix.api.gateway.model.namespace_delete_job_response import NamespaceDeleteJobResponse
from delphix.api.gateway.model.namespace_discard_job_response import NamespaceDiscardJobResponse
from delphix.api.gateway.model.namespace_failback_job_response import NamespaceFailbackJobResponse
from delphix.api.gateway.model.namespace_failover_job_response import NamespaceFailoverJobResponse
from delphix.api.gateway.model.namespace_update_job_response import NamespaceUpdateJobResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_namespaces_response import SearchNamespacesResponse
from delphix.api.gateway.model.update_namespace_parameters import UpdateNamespaceParameters


class NamespaceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __commit_failover_namespace(
            self,
            namespace_id,
            **kwargs
        ):
            """Commits the failover of a given namespace and discards the failback state.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.commit_failover_namespace(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceCommitFailoverJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.commit_failover_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceCommitFailoverJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}/commitFailover',
                'operation_id': 'commit_failover_namespace',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__commit_failover_namespace
        )

        def __delete_namespace(
            self,
            namespace_id,
            **kwargs
        ):
            """Delete a Namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_namespace(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceDeleteJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.delete_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceDeleteJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}',
                'operation_id': 'delete_namespace',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_namespace
        )

        def __discard_namespace(
            self,
            namespace_id,
            **kwargs
        ):
            """Discards any partial receive state for the given namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.discard_namespace(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceDiscardJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.discard_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceDiscardJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}/discard',
                'operation_id': 'discard_namespace',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__discard_namespace
        )

        def __failback_namespace(
            self,
            namespace_id,
            **kwargs
        ):
            """Initiates failback for the given namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.failback_namespace(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceFailbackJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.failback_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceFailbackJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}/failback',
                'operation_id': 'failback_namespace',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__failback_namespace
        )

        def __failover_namespace(
            self,
            namespace_id,
            **kwargs
        ):
            """Initiates failover for the given namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.failover_namespace(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                failover_namespace_parameters (FailoverNamespaceParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceFailoverJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.failover_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceFailoverJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}/failover',
                'operation_id': 'failover_namespace',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                    'failover_namespace_parameters',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                    'failover_namespace_parameters':
                        (FailoverNamespaceParameters,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                    'failover_namespace_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__failover_namespace
        )

        def __get_namespace_by_id(
            self,
            namespace_id,
            **kwargs
        ):
            """Get a namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_namespace_by_id(namespace_id, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Namespace
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            return self.call_with_http_info(**kwargs)

        self.get_namespace_by_id = _Endpoint(
            settings={
                'response_type': (Namespace,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}',
                'operation_id': 'get_namespace_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                ],
                'required': [
                    'namespace_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_namespace_by_id
        )

        def __list_namespaces(
            self,
            **kwargs
        ):
            """List all namespaces.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_namespaces(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListNamespacesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_namespaces = _Endpoint(
            settings={
                'response_type': (ListNamespacesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespaces',
                'operation_id': 'list_namespaces',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "TAG": "tag",
                        "-TAG": "-tag",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "SECURE_NAMESPACE": "secure_namespace",
                        "-SECURE_NAMESPACE": "-secure_namespace",
                        "FAILED_OVER": "failed_over",
                        "-FAILED_OVER": "-failed_over",
                        "LOCKED": "locked",
                        "-LOCKED": "-locked",
                        "FAILBACK_POSSIBLE": "failback_possible",
                        "-FAILBACK_POSSIBLE": "-failback_possible",
                        "FAILBACK_CAPABILITY": "failback_capability",
                        "-FAILBACK_CAPABILITY": "-failback_capability",
                        "FAILBACK_INCAPABILITY_REASON": "failback_incapability_reason",
                        "-FAILBACK_INCAPABILITY_REASON": "-failback_incapability_reason",
                        "REPLICATION_MODE": "replication_mode",
                        "-REPLICATION_MODE": "-replication_mode",
                        "LAST_EXECUTION_STATUS": "last_execution_status",
                        "-LAST_EXECUTION_STATUS": "-last_execution_status",
                        "LAST_EXECUTION_STATUS_TIMESTAMP": "last_execution_status_timestamp",
                        "-LAST_EXECUTION_STATUS_TIMESTAMP": "-last_execution_status_timestamp",
                        "SOURCE_ENGINE_ID": "source_engine_id",
                        "-SOURCE_ENGINE_ID": "-source_engine_id",
                        "SOURCE_ENGINE_NAME": "source_engine_name",
                        "-SOURCE_ENGINE_NAME": "-source_engine_name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_namespaces
        )

        def __search_namespaces(
            self,
            **kwargs
        ):
            """Search Namespaces.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_namespaces(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchNamespacesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_namespaces = _Endpoint(
            settings={
                'response_type': (SearchNamespacesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespaces/search',
                'operation_id': 'search_namespaces',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "TAG": "tag",
                        "-TAG": "-tag",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "SECURE_NAMESPACE": "secure_namespace",
                        "-SECURE_NAMESPACE": "-secure_namespace",
                        "FAILED_OVER": "failed_over",
                        "-FAILED_OVER": "-failed_over",
                        "LOCKED": "locked",
                        "-LOCKED": "-locked",
                        "FAILBACK_POSSIBLE": "failback_possible",
                        "-FAILBACK_POSSIBLE": "-failback_possible",
                        "FAILBACK_CAPABILITY": "failback_capability",
                        "-FAILBACK_CAPABILITY": "-failback_capability",
                        "FAILBACK_INCAPABILITY_REASON": "failback_incapability_reason",
                        "-FAILBACK_INCAPABILITY_REASON": "-failback_incapability_reason",
                        "REPLICATION_MODE": "replication_mode",
                        "-REPLICATION_MODE": "-replication_mode",
                        "LAST_EXECUTION_STATUS": "last_execution_status",
                        "-LAST_EXECUTION_STATUS": "-last_execution_status",
                        "LAST_EXECUTION_STATUS_TIMESTAMP": "last_execution_status_timestamp",
                        "-LAST_EXECUTION_STATUS_TIMESTAMP": "-last_execution_status_timestamp",
                        "SOURCE_ENGINE_ID": "source_engine_id",
                        "-SOURCE_ENGINE_ID": "-source_engine_id",
                        "SOURCE_ENGINE_NAME": "source_engine_name",
                        "-SOURCE_ENGINE_NAME": "-source_engine_name"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_namespaces
        )

        def __update_namespace(
            self,
            namespace_id,
            update_namespace_parameters,
            **kwargs
        ):
            """Update a Namespace.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_namespace(namespace_id, update_namespace_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                namespace_id (str): The ID of the namespace.
                update_namespace_parameters (UpdateNamespaceParameters):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NamespaceUpdateJobResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['namespace_id'] = \
                namespace_id
            kwargs['update_namespace_parameters'] = \
                update_namespace_parameters
            return self.call_with_http_info(**kwargs)

        self.update_namespace = _Endpoint(
            settings={
                'response_type': (NamespaceUpdateJobResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/namespace/{namespaceId}',
                'operation_id': 'update_namespace',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'namespace_id',
                    'update_namespace_parameters',
                ],
                'required': [
                    'namespace_id',
                    'update_namespace_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'namespace_id',
                ]
            },
            root_map={
                'validations': {
                    ('namespace_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'namespace_id':
                        (str,),
                    'update_namespace_parameters':
                        (UpdateNamespaceParameters,),
                },
                'attribute_map': {
                    'namespace_id': 'namespaceId',
                },
                'location_map': {
                    'namespace_id': 'path',
                    'update_namespace_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_namespace
        )
