"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.create_hyperscale_connector_response import CreateHyperscaleConnectorResponse
from delphix.api.gateway.model.create_hyperscale_mount_point_response import CreateHyperscaleMountPointResponse
from delphix.api.gateway.model.delete_hyperscale_connector_response import DeleteHyperscaleConnectorResponse
from delphix.api.gateway.model.delete_hyperscale_mount_point_response import DeleteHyperscaleMountPointResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.hyperscale_connector import HyperscaleConnector
from delphix.api.gateway.model.hyperscale_connector_create_parameters import HyperscaleConnectorCreateParameters
from delphix.api.gateway.model.hyperscale_connector_update_parameters import HyperscaleConnectorUpdateParameters
from delphix.api.gateway.model.hyperscale_dataset import HyperscaleDataset
from delphix.api.gateway.model.hyperscale_dataset_table_or_file import HyperscaleDatasetTableOrFile
from delphix.api.gateway.model.hyperscale_dataset_table_or_file_update_parameters import HyperscaleDatasetTableOrFileUpdateParameters
from delphix.api.gateway.model.hyperscale_dataset_update_parameters import HyperscaleDatasetUpdateParameters
from delphix.api.gateway.model.hyperscale_mount_point import HyperscaleMountPoint
from delphix.api.gateway.model.hyperscale_mount_point_update_parameters import HyperscaleMountPointUpdateParameters
from delphix.api.gateway.model.list_hyperscale_connectors_response import ListHyperscaleConnectorsResponse
from delphix.api.gateway.model.list_hyperscale_dataset_tables_or_files_response import ListHyperscaleDatasetTablesOrFilesResponse
from delphix.api.gateway.model.list_hyperscale_datasets_response import ListHyperscaleDatasetsResponse
from delphix.api.gateway.model.list_hyperscale_mount_points_response import ListHyperscaleMountPointsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_hyperscale_connectors_response import SearchHyperscaleConnectorsResponse
from delphix.api.gateway.model.search_hyperscale_dataset_tables_or_files_response import SearchHyperscaleDatasetTablesOrFilesResponse
from delphix.api.gateway.model.search_hyperscale_datasets_response import SearchHyperscaleDatasetsResponse
from delphix.api.gateway.model.search_hyperscale_mount_points_response import SearchHyperscaleMountPointsResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_hyperscale_connector_response import UpdateHyperscaleConnectorResponse
from delphix.api.gateway.model.update_hyperscale_dataset_response import UpdateHyperscaleDatasetResponse
from delphix.api.gateway.model.update_hyperscale_dataset_table_or_file_response import UpdateHyperscaleDatasetTableOrFileResponse
from delphix.api.gateway.model.update_hyperscale_mount_point_response import UpdateHyperscaleMountPointResponse


class HyperscaleObjectsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_hyperscale_connector(
            self,
            hyperscale_connector_create_parameters,
            **kwargs
        ):
            """Create a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperscale_connector(hyperscale_connector_create_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_create_parameters (HyperscaleConnectorCreateParameters):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateHyperscaleConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_create_parameters'] = \
                hyperscale_connector_create_parameters
            return self.call_with_http_info(**kwargs)

        self.create_hyperscale_connector = _Endpoint(
            settings={
                'response_type': (CreateHyperscaleConnectorResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors',
                'operation_id': 'create_hyperscale_connector',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_create_parameters',
                ],
                'required': [
                    'hyperscale_connector_create_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_create_parameters':
                        (HyperscaleConnectorCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'hyperscale_connector_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperscale_connector
        )

        def __create_hyperscale_connector_tags(
            self,
            hyperscale_connector_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperscale_connector_tags(hyperscale_connector_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.
                tags_request (TagsRequest): Tag information for a Hyperscale Connector.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_hyperscale_connector_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}/tags',
                'operation_id': 'create_hyperscale_connector_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                    'tags_request',
                ],
                'required': [
                    'hyperscale_connector_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperscale_connector_tags
        )

        def __create_hyperscale_dataset_tags(
            self,
            hyperscale_dataset_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a Hyperscale Dataset.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperscale_dataset_tags(hyperscale_dataset_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.
                tags_request (TagsRequest): Tag information for a Hyperscale Dataset.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_hyperscale_dataset_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tags',
                'operation_id': 'create_hyperscale_dataset_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'tags_request',
                ],
                'required': [
                    'hyperscale_dataset_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperscale_dataset_tags
        )

        def __create_hyperscale_mount_point(
            self,
            hyperscale_mount_point,
            **kwargs
        ):
            """Create a Hyperscale Mount Point  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperscale_mount_point(hyperscale_mount_point, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_mount_point (HyperscaleMountPoint): Request to create a Hyperscale Mount Point.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateHyperscaleMountPointResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_mount_point'] = \
                hyperscale_mount_point
            return self.call_with_http_info(**kwargs)

        self.create_hyperscale_mount_point = _Endpoint(
            settings={
                'response_type': (CreateHyperscaleMountPointResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points',
                'operation_id': 'create_hyperscale_mount_point',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_mount_point',
                ],
                'required': [
                    'hyperscale_mount_point',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_mount_point':
                        (HyperscaleMountPoint,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'hyperscale_mount_point': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperscale_mount_point
        )

        def __delete_hyperscale_connector(
            self,
            hyperscale_connector_id,
            **kwargs
        ):
            """Delete a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperscale_connector(hyperscale_connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteHyperscaleConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            return self.call_with_http_info(**kwargs)

        self.delete_hyperscale_connector = _Endpoint(
            settings={
                'response_type': (DeleteHyperscaleConnectorResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}',
                'operation_id': 'delete_hyperscale_connector',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                ],
                'required': [
                    'hyperscale_connector_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperscale_connector
        )

        def __delete_hyperscale_connector_tags(
            self,
            hyperscale_connector_id,
            **kwargs
        ):
            """Delete tags for a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperscale_connector_tags(hyperscale_connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            return self.call_with_http_info(**kwargs)

        self.delete_hyperscale_connector_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}/tags/delete',
                'operation_id': 'delete_hyperscale_connector_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                    'delete_tag',
                ],
                'required': [
                    'hyperscale_connector_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_hyperscale_connector_tags
        )

        def __delete_hyperscale_dataset_tags(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Delete tags for a Hyperscale Dataset.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperscale_dataset_tags(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.delete_hyperscale_dataset_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tags/delete',
                'operation_id': 'delete_hyperscale_dataset_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'delete_tag',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_hyperscale_dataset_tags
        )

        def __delete_hyperscale_mount_point(
            self,
            hyperscale_mount_point_id,
            **kwargs
        ):
            """Delete a Hyperscale Mount Point.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperscale_mount_point(hyperscale_mount_point_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_mount_point_id (str): The ID of the Hyperscale Mount Point.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteHyperscaleMountPointResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_mount_point_id'] = \
                hyperscale_mount_point_id
            return self.call_with_http_info(**kwargs)

        self.delete_hyperscale_mount_point = _Endpoint(
            settings={
                'response_type': (DeleteHyperscaleMountPointResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points/{hyperscaleMountPointId}',
                'operation_id': 'delete_hyperscale_mount_point',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_mount_point_id',
                ],
                'required': [
                    'hyperscale_mount_point_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_mount_point_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_mount_point_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_mount_point_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_mount_point_id': 'hyperscaleMountPointId',
                },
                'location_map': {
                    'hyperscale_mount_point_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperscale_mount_point
        )

        def __get_hyperscale_connector_by_id(
            self,
            hyperscale_connector_id,
            **kwargs
        ):
            """Get a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_connector_by_id(hyperscale_connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleConnector
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_connector_by_id = _Endpoint(
            settings={
                'response_type': (HyperscaleConnector,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}',
                'operation_id': 'get_hyperscale_connector_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                ],
                'required': [
                    'hyperscale_connector_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_connector_by_id
        )

        def __get_hyperscale_connector_tags(
            self,
            hyperscale_connector_id,
            **kwargs
        ):
            """Get tags for a Hyperscale Connector.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_connector_tags(hyperscale_connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_connector_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}/tags',
                'operation_id': 'get_hyperscale_connector_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                ],
                'required': [
                    'hyperscale_connector_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_connector_tags
        )

        def __get_hyperscale_connectors(
            self,
            **kwargs
        ):
            """Returns a list of Hyperscale Connectors.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_connectors(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListHyperscaleConnectorsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_connectors = _Endpoint(
            settings={
                'response_type': (ListHyperscaleConnectorsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors',
                'operation_id': 'get_hyperscale_connectors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "SOURCE_USERNAME": "source_username",
                        "-SOURCE_USERNAME": "-source_username",
                        "SOURCE_JDBC_URL": "source_jdbc_url",
                        "-SOURCE_JDBC_URL": "-source_jdbc_url",
                        "SOURCE_MONGO_URL": "source_mongo_url",
                        "-SOURCE_MONGO_URL": "-source_mongo_url",
                        "TARGET_USERNAME": "target_username",
                        "-TARGET_USERNAME": "-target_username",
                        "TARGET_JDBC_URL": "target_jdbc_url",
                        "-TARGET_JDBC_URL": "-target_jdbc_url",
                        "TARGET_MONGO_URL": "target_mongo_url",
                        "-TARGET_MONGO_URL": "-target_mongo_url"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_connectors
        )

        def __get_hyperscale_dataset_by_id(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Get a Hyperscale Dataset.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_dataset_by_id(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleDataset
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_dataset_by_id = _Endpoint(
            settings={
                'response_type': (HyperscaleDataset,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}',
                'operation_id': 'get_hyperscale_dataset_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_dataset_by_id
        )

        def __get_hyperscale_dataset_table_or_file_by_id(
            self,
            hyperscale_dataset_id,
            hyperscale_dataset_table_or_file_id,
            **kwargs
        ):
            """Get a Hyperscale Dataset table or file by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_dataset_table_or_file_by_id(hyperscale_dataset_id, hyperscale_dataset_table_or_file_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.
                hyperscale_dataset_table_or_file_id (str): The ID of the Hyperscale Dataset table or file.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleDatasetTableOrFile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            kwargs['hyperscale_dataset_table_or_file_id'] = \
                hyperscale_dataset_table_or_file_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_dataset_table_or_file_by_id = _Endpoint(
            settings={
                'response_type': (HyperscaleDatasetTableOrFile,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/{hyperscaleDatasetTableOrFileId}',
                'operation_id': 'get_hyperscale_dataset_table_or_file_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                ],
                'required': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                    ('hyperscale_dataset_table_or_file_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'hyperscale_dataset_table_or_file_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                    'hyperscale_dataset_table_or_file_id': 'hyperscaleDatasetTableOrFileId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'hyperscale_dataset_table_or_file_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_dataset_table_or_file_by_id
        )

        def __get_hyperscale_dataset_tables_or_files(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Get the tables or files of a hyperscale dataset  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_dataset_tables_or_files(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListHyperscaleDatasetTablesOrFilesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_dataset_tables_or_files = _Endpoint(
            settings={
                'response_type': (ListHyperscaleDatasetTablesOrFilesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files',
                'operation_id': 'get_hyperscale_dataset_tables_or_files',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'hyperscale_dataset_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "SCHEMA_NAME": "schema_name",
                        "-SCHEMA_NAME": "-schema_name",
                        "TABLE_NAME": "table_name",
                        "-TABLE_NAME": "-table_name",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "COLLECTION_NAME": "collection_name",
                        "-COLLECTION_NAME": "-collection_name",
                        "FILTER_KEY": "filter_key",
                        "-FILTER_KEY": "-filter_key",
                        "COLUMN_ARRAY_ROWS": "column_array_rows",
                        "-COLUMN_ARRAY_ROWS": "-column_array_rows",
                        "UNLOAD_SPLIT": "unload_split",
                        "-UNLOAD_SPLIT": "-unload_split",
                        "STREAM_SIZE": "stream_size",
                        "-STREAM_SIZE": "-stream_size"
                    },
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_dataset_tables_or_files
        )

        def __get_hyperscale_dataset_tags(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Get tags for a Hyperscale Dataset.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_dataset_tags(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_dataset_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tags',
                'operation_id': 'get_hyperscale_dataset_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_dataset_tags
        )

        def __get_hyperscale_datasets(
            self,
            **kwargs
        ):
            """Returns a list of Hyperscale Datasets.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_datasets(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListHyperscaleDatasetsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_datasets = _Endpoint(
            settings={
                'response_type': (ListHyperscaleDatasetsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets',
                'operation_id': 'get_hyperscale_datasets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "CONNECTOR_ID": "connector_id",
                        "-CONNECTOR_ID": "-connector_id",
                        "MOUNT_POINT_ID": "mount_point_id",
                        "-MOUNT_POINT_ID": "-mount_point_id"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_datasets
        )

        def __get_hyperscale_mount_point_by_id(
            self,
            hyperscale_mount_point_id,
            **kwargs
        ):
            """Get a Hyperscale Mount Points.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_mount_point_by_id(hyperscale_mount_point_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_mount_point_id (str): The ID of the Hyperscale Mount Point.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleMountPoint
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_mount_point_id'] = \
                hyperscale_mount_point_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_mount_point_by_id = _Endpoint(
            settings={
                'response_type': (HyperscaleMountPoint,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points/{hyperscaleMountPointId}',
                'operation_id': 'get_hyperscale_mount_point_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_mount_point_id',
                ],
                'required': [
                    'hyperscale_mount_point_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_mount_point_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_mount_point_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_mount_point_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_mount_point_id': 'hyperscaleMountPointId',
                },
                'location_map': {
                    'hyperscale_mount_point_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_mount_point_by_id
        )

        def __get_hyperscale_mount_points(
            self,
            **kwargs
        ):
            """Returns a list of Hyperscale Mount Points.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_mount_points(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListHyperscaleMountPointsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_mount_points = _Endpoint(
            settings={
                'response_type': (ListHyperscaleMountPointsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points',
                'operation_id': 'get_hyperscale_mount_points',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HOSTNAME": "hostname",
                        "-HOSTNAME": "-hostname",
                        "MOUNT_TYPE": "mount_type",
                        "-MOUNT_TYPE": "-mount_type",
                        "OPTIONS": "options",
                        "-OPTIONS": "-options",
                        "MOUNT_PATH": "mount_path",
                        "-MOUNT_PATH": "-mount_path",
                        "STAGING_STORAGE_TYPE": "staging_storage_type",
                        "-STAGING_STORAGE_TYPE": "-staging_storage_type",
                        "AUTH_MECHANISM": "auth_mechanism",
                        "-AUTH_MECHANISM": "-auth_mechanism",
                        "AWS_BUCKET_NAME": "aws_bucket_name",
                        "-AWS_BUCKET_NAME": "-aws_bucket_name",
                        "AWS_BUCKET_REGION": "aws_bucket_region",
                        "-AWS_BUCKET_REGION": "-aws_bucket_region",
                        "AWS_BUCKET_PREFIX": "aws_bucket_prefix",
                        "-AWS_BUCKET_PREFIX": "-aws_bucket_prefix",
                        "AWS_BUCKET_DELIMITER": "aws_bucket_delimiter",
                        "-AWS_BUCKET_DELIMITER": "-aws_bucket_delimiter",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_mount_points
        )

        def __search_hyperscale_connectors(
            self,
            **kwargs
        ):
            """Search for Hyperscale Connectors.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_hyperscale_connectors(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchHyperscaleConnectorsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_hyperscale_connectors = _Endpoint(
            settings={
                'response_type': (SearchHyperscaleConnectorsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/search',
                'operation_id': 'search_hyperscale_connectors',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "SOURCE_USERNAME": "source_username",
                        "-SOURCE_USERNAME": "-source_username",
                        "SOURCE_JDBC_URL": "source_jdbc_url",
                        "-SOURCE_JDBC_URL": "-source_jdbc_url",
                        "SOURCE_MONGO_URL": "source_mongo_url",
                        "-SOURCE_MONGO_URL": "-source_mongo_url",
                        "TARGET_USERNAME": "target_username",
                        "-TARGET_USERNAME": "-target_username",
                        "TARGET_JDBC_URL": "target_jdbc_url",
                        "-TARGET_JDBC_URL": "-target_jdbc_url",
                        "TARGET_MONGO_URL": "target_mongo_url",
                        "-TARGET_MONGO_URL": "-target_mongo_url"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_hyperscale_connectors
        )

        def __search_hyperscale_dataset_tables_or_files(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Search the tables or files of a hyperscale dataset  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_hyperscale_dataset_tables_or_files(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchHyperscaleDatasetTablesOrFilesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.search_hyperscale_dataset_tables_or_files = _Endpoint(
            settings={
                'response_type': (SearchHyperscaleDatasetTablesOrFilesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/search',
                'operation_id': 'search_hyperscale_dataset_tables_or_files',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'hyperscale_dataset_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "SCHEMA_NAME": "schema_name",
                        "-SCHEMA_NAME": "-schema_name",
                        "TABLE_NAME": "table_name",
                        "-TABLE_NAME": "-table_name",
                        "DATABASE_NAME": "database_name",
                        "-DATABASE_NAME": "-database_name",
                        "COLLECTION_NAME": "collection_name",
                        "-COLLECTION_NAME": "-collection_name",
                        "FILTER_KEY": "filter_key",
                        "-FILTER_KEY": "-filter_key",
                        "COLUMN_ARRAY_ROWS": "column_array_rows",
                        "-COLUMN_ARRAY_ROWS": "-column_array_rows",
                        "UNLOAD_SPLIT": "unload_split",
                        "-UNLOAD_SPLIT": "-unload_split",
                        "STREAM_SIZE": "stream_size",
                        "-STREAM_SIZE": "-stream_size"
                    },
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_hyperscale_dataset_tables_or_files
        )

        def __search_hyperscale_datasets(
            self,
            **kwargs
        ):
            """Search for Hyperscale Datasets.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_hyperscale_datasets(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchHyperscaleDatasetsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_hyperscale_datasets = _Endpoint(
            settings={
                'response_type': (SearchHyperscaleDatasetsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/search',
                'operation_id': 'search_hyperscale_datasets',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "CONNECTOR_ID": "connector_id",
                        "-CONNECTOR_ID": "-connector_id",
                        "MOUNT_POINT_ID": "mount_point_id",
                        "-MOUNT_POINT_ID": "-mount_point_id"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_hyperscale_datasets
        )

        def __search_hyperscale_mount_points(
            self,
            **kwargs
        ):
            """Search for Hyperscale Mount Points.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_hyperscale_mount_points(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchHyperscaleMountPointsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_hyperscale_mount_points = _Endpoint(
            settings={
                'response_type': (SearchHyperscaleMountPointsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points/search',
                'operation_id': 'search_hyperscale_mount_points',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HOSTNAME": "hostname",
                        "-HOSTNAME": "-hostname",
                        "MOUNT_TYPE": "mount_type",
                        "-MOUNT_TYPE": "-mount_type",
                        "OPTIONS": "options",
                        "-OPTIONS": "-options",
                        "MOUNT_PATH": "mount_path",
                        "-MOUNT_PATH": "-mount_path",
                        "STAGING_STORAGE_TYPE": "staging_storage_type",
                        "-STAGING_STORAGE_TYPE": "-staging_storage_type",
                        "AUTH_MECHANISM": "auth_mechanism",
                        "-AUTH_MECHANISM": "-auth_mechanism",
                        "AWS_BUCKET_NAME": "aws_bucket_name",
                        "-AWS_BUCKET_NAME": "-aws_bucket_name",
                        "AWS_BUCKET_REGION": "aws_bucket_region",
                        "-AWS_BUCKET_REGION": "-aws_bucket_region",
                        "AWS_BUCKET_PREFIX": "aws_bucket_prefix",
                        "-AWS_BUCKET_PREFIX": "-aws_bucket_prefix",
                        "AWS_BUCKET_DELIMITER": "aws_bucket_delimiter",
                        "-AWS_BUCKET_DELIMITER": "-aws_bucket_delimiter",
                        "HYPERSCALE_INSTANCE_ID": "hyperscale_instance_id",
                        "-HYPERSCALE_INSTANCE_ID": "-hyperscale_instance_id"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_hyperscale_mount_points
        )

        def __update_hyperscale_connector_by_id(
            self,
            hyperscale_connector_id,
            **kwargs
        ):
            """Update a Hyperscale Connector by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_hyperscale_connector_by_id(hyperscale_connector_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_connector_id (str): The ID of the Hyperscale Connector.

            Keyword Args:
                hyperscale_connector_update_parameters (HyperscaleConnectorUpdateParameters): The new data to update a Hyperscale Connector.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateHyperscaleConnectorResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_connector_id'] = \
                hyperscale_connector_id
            return self.call_with_http_info(**kwargs)

        self.update_hyperscale_connector_by_id = _Endpoint(
            settings={
                'response_type': (UpdateHyperscaleConnectorResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-connectors/{hyperscaleConnectorId}',
                'operation_id': 'update_hyperscale_connector_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_connector_id',
                    'hyperscale_connector_update_parameters',
                ],
                'required': [
                    'hyperscale_connector_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_connector_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_connector_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_connector_id':
                        (str,),
                    'hyperscale_connector_update_parameters':
                        (HyperscaleConnectorUpdateParameters,),
                },
                'attribute_map': {
                    'hyperscale_connector_id': 'hyperscaleConnectorId',
                },
                'location_map': {
                    'hyperscale_connector_id': 'path',
                    'hyperscale_connector_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_hyperscale_connector_by_id
        )

        def __update_hyperscale_dataset_by_id(
            self,
            hyperscale_dataset_id,
            **kwargs
        ):
            """Update a Hyperscale Dataset by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_hyperscale_dataset_by_id(hyperscale_dataset_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.

            Keyword Args:
                hyperscale_dataset_update_parameters (HyperscaleDatasetUpdateParameters): The new data to update a Hyperscale Dataset.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateHyperscaleDatasetResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            return self.call_with_http_info(**kwargs)

        self.update_hyperscale_dataset_by_id = _Endpoint(
            settings={
                'response_type': (UpdateHyperscaleDatasetResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}',
                'operation_id': 'update_hyperscale_dataset_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_update_parameters',
                ],
                'required': [
                    'hyperscale_dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'hyperscale_dataset_update_parameters':
                        (HyperscaleDatasetUpdateParameters,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'hyperscale_dataset_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_hyperscale_dataset_by_id
        )

        def __update_hyperscale_dataset_table_or_file_by_id(
            self,
            hyperscale_dataset_id,
            hyperscale_dataset_table_or_file_id,
            **kwargs
        ):
            """Update a Hyperscale Dataset table or file by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_hyperscale_dataset_table_or_file_by_id(hyperscale_dataset_id, hyperscale_dataset_table_or_file_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_dataset_id (str): The ID of the Hyperscale Dataset.
                hyperscale_dataset_table_or_file_id (str): The ID of the Hyperscale Dataset table or file.

            Keyword Args:
                hyperscale_dataset_table_or_file_update_parameters (HyperscaleDatasetTableOrFileUpdateParameters): The new data to update a Hyperscale Dataset table or file.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateHyperscaleDatasetTableOrFileResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_dataset_id'] = \
                hyperscale_dataset_id
            kwargs['hyperscale_dataset_table_or_file_id'] = \
                hyperscale_dataset_table_or_file_id
            return self.call_with_http_info(**kwargs)

        self.update_hyperscale_dataset_table_or_file_by_id = _Endpoint(
            settings={
                'response_type': (UpdateHyperscaleDatasetTableOrFileResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/{hyperscaleDatasetTableOrFileId}',
                'operation_id': 'update_hyperscale_dataset_table_or_file_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                    'hyperscale_dataset_table_or_file_update_parameters',
                ],
                'required': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_dataset_id',
                    'hyperscale_dataset_table_or_file_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_dataset_id',): {

                        'min_length': 1,
                    },
                    ('hyperscale_dataset_table_or_file_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_dataset_id':
                        (str,),
                    'hyperscale_dataset_table_or_file_id':
                        (str,),
                    'hyperscale_dataset_table_or_file_update_parameters':
                        (HyperscaleDatasetTableOrFileUpdateParameters,),
                },
                'attribute_map': {
                    'hyperscale_dataset_id': 'hyperscaleDatasetId',
                    'hyperscale_dataset_table_or_file_id': 'hyperscaleDatasetTableOrFileId',
                },
                'location_map': {
                    'hyperscale_dataset_id': 'path',
                    'hyperscale_dataset_table_or_file_id': 'path',
                    'hyperscale_dataset_table_or_file_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_hyperscale_dataset_table_or_file_by_id
        )

        def __update_hyperscale_mount_point_by_id(
            self,
            hyperscale_mount_point_id,
            **kwargs
        ):
            """Update a Hyperscale Mount Point by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_hyperscale_mount_point_by_id(hyperscale_mount_point_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_mount_point_id (str): The ID of the Hyperscale Mount Point.

            Keyword Args:
                hyperscale_mount_point_update_parameters (HyperscaleMountPointUpdateParameters): The new data to update a Hyperscale Mount Point.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateHyperscaleMountPointResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_mount_point_id'] = \
                hyperscale_mount_point_id
            return self.call_with_http_info(**kwargs)

        self.update_hyperscale_mount_point_by_id = _Endpoint(
            settings={
                'response_type': (UpdateHyperscaleMountPointResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-mount-points/{hyperscaleMountPointId}',
                'operation_id': 'update_hyperscale_mount_point_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_mount_point_id',
                    'hyperscale_mount_point_update_parameters',
                ],
                'required': [
                    'hyperscale_mount_point_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'hyperscale_mount_point_id',
                ]
            },
            root_map={
                'validations': {
                    ('hyperscale_mount_point_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_mount_point_id':
                        (str,),
                    'hyperscale_mount_point_update_parameters':
                        (HyperscaleMountPointUpdateParameters,),
                },
                'attribute_map': {
                    'hyperscale_mount_point_id': 'hyperscaleMountPointId',
                },
                'location_map': {
                    'hyperscale_mount_point_id': 'path',
                    'hyperscale_mount_point_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_hyperscale_mount_point_by_id
        )
