"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.add_engine_to_hyperscale_response import AddEngineToHyperscaleResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.engine_id_body import EngineIdBody
from delphix.api.gateway.model.hyperscale_instance import HyperscaleInstance
from delphix.api.gateway.model.hyperscale_instance_registration_parameter import HyperscaleInstanceRegistrationParameter
from delphix.api.gateway.model.hyperscale_instance_update_params import HyperscaleInstanceUpdateParams
from delphix.api.gateway.model.list_hyperscale_instances_response import ListHyperscaleInstancesResponse
from delphix.api.gateway.model.remove_engine_from_hyperscale_response import RemoveEngineFromHyperscaleResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_hyperscale_instances_response import SearchHyperscaleInstancesResponse
from delphix.api.gateway.model.sync_engines_hyperscale_parameters import SyncEnginesHyperscaleParameters
from delphix.api.gateway.model.sync_engines_hyperscale_response import SyncEnginesHyperscaleResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.unregister_hyperscale_instance_response import UnregisterHyperscaleInstanceResponse


class HyperscaleInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_engine_to_hyperscale_instance(
            self,
            hyperscale_instance_id,
            engine_id_body,
            **kwargs
        ):
            """Add an engine to a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_engine_to_hyperscale_instance(hyperscale_instance_id, engine_id_body, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.
                engine_id_body (EngineIdBody): Body containing the ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddEngineToHyperscaleResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            kwargs['engine_id_body'] = \
                engine_id_body
            return self.call_with_http_info(**kwargs)

        self.add_engine_to_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (AddEngineToHyperscaleResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/add-engine',
                'operation_id': 'add_engine_to_hyperscale_instance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'engine_id_body',
                ],
                'required': [
                    'hyperscale_instance_id',
                    'engine_id_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'engine_id_body':
                        (EngineIdBody,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'engine_id_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_engine_to_hyperscale_instance
        )

        def __create_hyperscale_instance_tags(
            self,
            hyperscale_instance_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperscale_instance_tags(hyperscale_instance_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.
                tags_request (TagsRequest): Tags information for Hyperscale Instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_hyperscale_instance_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/tags',
                'operation_id': 'create_hyperscale_instance_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'tags_request',
                ],
                'required': [
                    'hyperscale_instance_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperscale_instance_tags
        )

        def __delete_hyperscale_instance_tags(
            self,
            hyperscale_instance_id,
            **kwargs
        ):
            """Delete tags for a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperscale_instance_tags(hyperscale_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            return self.call_with_http_info(**kwargs)

        self.delete_hyperscale_instance_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/tags/delete',
                'operation_id': 'delete_hyperscale_instance_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'delete_tag',
                ],
                'required': [
                    'hyperscale_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_hyperscale_instance_tags
        )

        def __get_hyperscale_instance_by_id(
            self,
            hyperscale_instance_id,
            **kwargs
        ):
            """Returns a Hyperscale Instance by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_instance_by_id(hyperscale_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_instance_by_id = _Endpoint(
            settings={
                'response_type': (HyperscaleInstance,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}',
                'operation_id': 'get_hyperscale_instance_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                ],
                'required': [
                    'hyperscale_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_instance_by_id
        )

        def __get_hyperscale_instance_tags(
            self,
            hyperscale_instance_id,
            **kwargs
        ):
            """Get tags for a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_instance_tags(hyperscale_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_instance_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/tags',
                'operation_id': 'get_hyperscale_instance_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                ],
                'required': [
                    'hyperscale_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_instance_tags
        )

        def __get_hyperscale_instances(
            self,
            **kwargs
        ):
            """Returns a list of Hyperscale instances.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperscale_instances(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListHyperscaleInstancesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperscale_instances = _Endpoint(
            settings={
                'response_type': (ListHyperscaleInstancesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances',
                'operation_id': 'get_hyperscale_instances',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HOSTNAME": "hostname",
                        "-HOSTNAME": "-hostname",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "CONNECTION_STATUS": "connection_status",
                        "-CONNECTION_STATUS": "-connection_status",
                        "CONNECTION_STATUS_DETAILS": "connection_status_details",
                        "-CONNECTION_STATUS_DETAILS": "-connection_status_details"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperscale_instances
        )

        def __register_hyperscale_instance(
            self,
            hyperscale_instance_registration_parameter,
            **kwargs
        ):
            """Register a Hyperscale instance  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.register_hyperscale_instance(hyperscale_instance_registration_parameter, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_registration_parameter (HyperscaleInstanceRegistrationParameter): The parameters to register a Hyperscale instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_registration_parameter'] = \
                hyperscale_instance_registration_parameter
            return self.call_with_http_info(**kwargs)

        self.register_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (HyperscaleInstance,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances',
                'operation_id': 'register_hyperscale_instance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_registration_parameter',
                ],
                'required': [
                    'hyperscale_instance_registration_parameter',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_registration_parameter':
                        (HyperscaleInstanceRegistrationParameter,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'hyperscale_instance_registration_parameter': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__register_hyperscale_instance
        )

        def __remove_engine_from_hyperscale_instance(
            self,
            hyperscale_instance_id,
            engine_id_body,
            **kwargs
        ):
            """Remove an engine from a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.remove_engine_from_hyperscale_instance(hyperscale_instance_id, engine_id_body, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.
                engine_id_body (EngineIdBody): Body containing the ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RemoveEngineFromHyperscaleResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            kwargs['engine_id_body'] = \
                engine_id_body
            return self.call_with_http_info(**kwargs)

        self.remove_engine_from_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (RemoveEngineFromHyperscaleResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/remove-engine',
                'operation_id': 'remove_engine_from_hyperscale_instance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'engine_id_body',
                ],
                'required': [
                    'hyperscale_instance_id',
                    'engine_id_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'engine_id_body':
                        (EngineIdBody,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'engine_id_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__remove_engine_from_hyperscale_instance
        )

        def __search_hyperscale_instances(
            self,
            **kwargs
        ):
            """Search for Hyperscale instances.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_hyperscale_instances(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchHyperscaleInstancesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_hyperscale_instances = _Endpoint(
            settings={
                'response_type': (SearchHyperscaleInstancesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/search',
                'operation_id': 'search_hyperscale_instances',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "HOSTNAME": "hostname",
                        "-HOSTNAME": "-hostname",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "DATA_TYPE": "data_type",
                        "-DATA_TYPE": "-data_type",
                        "CONNECTION_STATUS": "connection_status",
                        "-CONNECTION_STATUS": "-connection_status",
                        "CONNECTION_STATUS_DETAILS": "connection_status_details",
                        "-CONNECTION_STATUS_DETAILS": "-connection_status_details"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_hyperscale_instances
        )

        def __sync_engines_hyperscale_instance(
            self,
            hyperscale_instance_id,
            **kwargs
        ):
            """Sync the global object from a source engine to engines on a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.sync_engines_hyperscale_instance(hyperscale_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.

            Keyword Args:
                sync_engines_hyperscale_parameters (SyncEnginesHyperscaleParameters): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SyncEnginesHyperscaleResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            return self.call_with_http_info(**kwargs)

        self.sync_engines_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (SyncEnginesHyperscaleResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}/sync-engines',
                'operation_id': 'sync_engines_hyperscale_instance',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'sync_engines_hyperscale_parameters',
                ],
                'required': [
                    'hyperscale_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'sync_engines_hyperscale_parameters':
                        (SyncEnginesHyperscaleParameters,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'sync_engines_hyperscale_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__sync_engines_hyperscale_instance
        )

        def __unregister_hyperscale_instance(
            self,
            hyperscale_instance_id,
            **kwargs
        ):
            """Unregister a Hyperscale Instance.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.unregister_hyperscale_instance(hyperscale_instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UnregisterHyperscaleInstanceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            return self.call_with_http_info(**kwargs)

        self.unregister_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (UnregisterHyperscaleInstanceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}',
                'operation_id': 'unregister_hyperscale_instance',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                ],
                'required': [
                    'hyperscale_instance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__unregister_hyperscale_instance
        )

        def __update_hyperscale_instance(
            self,
            hyperscale_instance_id,
            hyperscale_instance_update_params,
            **kwargs
        ):
            """Update an Hyperscale Instance  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_hyperscale_instance(hyperscale_instance_id, hyperscale_instance_update_params, async_req=True)
            >>> result = thread.get()

            Args:
                hyperscale_instance_id (str): The ID of hyperscale instance.
                hyperscale_instance_update_params (HyperscaleInstanceUpdateParams): Update parameters for a hyperscale instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperscaleInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperscale_instance_id'] = \
                hyperscale_instance_id
            kwargs['hyperscale_instance_update_params'] = \
                hyperscale_instance_update_params
            return self.call_with_http_info(**kwargs)

        self.update_hyperscale_instance = _Endpoint(
            settings={
                'response_type': (HyperscaleInstance,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/hyperscale-instances/{hyperscaleInstanceId}',
                'operation_id': 'update_hyperscale_instance',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperscale_instance_id',
                    'hyperscale_instance_update_params',
                ],
                'required': [
                    'hyperscale_instance_id',
                    'hyperscale_instance_update_params',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperscale_instance_id':
                        (str,),
                    'hyperscale_instance_update_params':
                        (HyperscaleInstanceUpdateParams,),
                },
                'attribute_map': {
                    'hyperscale_instance_id': 'hyperscaleInstanceId',
                },
                'location_map': {
                    'hyperscale_instance_id': 'path',
                    'hyperscale_instance_update_params': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_hyperscale_instance
        )
