"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.ased_source_link_source_parameters import ASEDSourceLinkSourceParameters
from delphix.api.gateway.model.app_data_d_source_link_source_parameters import AppDataDSourceLinkSourceParameters
from delphix.api.gateway.model.attach_d_source_response import AttachDSourceResponse
from delphix.api.gateway.model.attach_staging_push_d_source_response import AttachStagingPushDSourceResponse
from delphix.api.gateway.model.d_source import DSource
from delphix.api.gateway.model.d_source_snapshot_parameters import DSourceSnapshotParameters
from delphix.api.gateway.model.delete_d_source_request import DeleteDSourceRequest
from delphix.api.gateway.model.delete_d_source_response import DeleteDSourceResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.deletion_dependencies_response import DeletionDependenciesResponse
from delphix.api.gateway.model.detach_d_source_response import DetachDSourceResponse
from delphix.api.gateway.model.disable_dsource_parameters import DisableDsourceParameters
from delphix.api.gateway.model.disable_dsource_response import DisableDsourceResponse
from delphix.api.gateway.model.enable_dsource_parameters import EnableDsourceParameters
from delphix.api.gateway.model.enable_dsource_response import EnableDsourceResponse
from delphix.api.gateway.model.link_d_source_default_request import LinkDSourceDefaultRequest
from delphix.api.gateway.model.link_d_source_response import LinkDSourceResponse
from delphix.api.gateway.model.link_staging_push_d_source_default_request import LinkStagingPushDSourceDefaultRequest
from delphix.api.gateway.model.list_d_sources_response import ListDSourcesResponse
from delphix.api.gateway.model.list_snapshots_response import ListSnapshotsResponse
from delphix.api.gateway.model.mssqld_source_attach_source_parameters import MSSQLDSourceAttachSourceParameters
from delphix.api.gateway.model.mssqld_source_link_source_parameters import MSSQLDSourceLinkSourceParameters
from delphix.api.gateway.model.mssqld_source_staging_push_attach_source_parameters import MSSQLDSourceStagingPushAttachSourceParameters
from delphix.api.gateway.model.mssqld_source_staging_push_link_source_parameters import MSSQLDSourceStagingPushLinkSourceParameters
from delphix.api.gateway.model.oracle_attach_d_source_parameters import OracleAttachDSourceParameters
from delphix.api.gateway.model.oracle_d_source_link_source_parameters import OracleDSourceLinkSourceParameters
from delphix.api.gateway.model.oracle_link_staging_push_d_source_default_request import OracleLinkStagingPushDSourceDefaultRequest
from delphix.api.gateway.model.oracle_staging_push_d_source_link_source_parameters import OracleStagingPushDSourceLinkSourceParameters
from delphix.api.gateway.model.permission_enum import PermissionEnum
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_d_sources_response import SearchDSourcesResponse
from delphix.api.gateway.model.snapshot_d_source_response import SnapshotDSourceResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_app_data_d_source_parameters import UpdateAppDataDSourceParameters
from delphix.api.gateway.model.update_dsource_response import UpdateDsourceResponse
from delphix.api.gateway.model.update_mssql_dsource_parameters import UpdateMSSQLDsourceParameters
from delphix.api.gateway.model.update_oracle_dsource_parameters import UpdateOracleDsourceParameters
from delphix.api.gateway.model.upgrade_dsource_response import UpgradeDsourceResponse
from delphix.api.gateway.model.upgrade_oracle_database_parameters import UpgradeOracleDatabaseParameters


class DSourcesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __attach_mssql_database(
            self,
            dsource_id,
            **kwargs
        ):
            """Attaches a MSSql source to a previously detached dsource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.attach_mssql_database(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                mssqld_source_attach_source_parameters (MSSQLDSourceAttachSourceParameters): The parameters to attach a MSSql dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AttachDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.attach_mssql_database = _Endpoint(
            settings={
                'response_type': (AttachDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/{dsourceId}/attachSource',
                'operation_id': 'attach_mssql_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'mssqld_source_attach_source_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'mssqld_source_attach_source_parameters':
                        (MSSQLDSourceAttachSourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'mssqld_source_attach_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__attach_mssql_database
        )

        def __attach_mssql_staging_push_database(
            self,
            dsource_id,
            mssqld_source_staging_push_attach_source_parameters,
            **kwargs
        ):
            """Attaches a MSSql staging push database to a previously detached dsource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.attach_mssql_staging_push_database(dsource_id, mssqld_source_staging_push_attach_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.
                mssqld_source_staging_push_attach_source_parameters (MSSQLDSourceStagingPushAttachSourceParameters): The parameters to attach an MSSql dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AttachStagingPushDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            kwargs['mssqld_source_staging_push_attach_source_parameters'] = \
                mssqld_source_staging_push_attach_source_parameters
            return self.call_with_http_info(**kwargs)

        self.attach_mssql_staging_push_database = _Endpoint(
            settings={
                'response_type': (AttachStagingPushDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/staging-push/{dsourceId}/attachSource',
                'operation_id': 'attach_mssql_staging_push_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'mssqld_source_staging_push_attach_source_parameters',
                ],
                'required': [
                    'dsource_id',
                    'mssqld_source_staging_push_attach_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'mssqld_source_staging_push_attach_source_parameters':
                        (MSSQLDSourceStagingPushAttachSourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'mssqld_source_staging_push_attach_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__attach_mssql_staging_push_database
        )

        def __attach_oracle_dsource(
            self,
            dsource_id,
            oracle_attach_d_source_parameters,
            **kwargs
        ):
            """Attach an Oracle dSource to an Oracle database.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.attach_oracle_dsource(dsource_id, oracle_attach_d_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.
                oracle_attach_d_source_parameters (OracleAttachDSourceParameters): The parameters to attach an Oracle dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AttachDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            kwargs['oracle_attach_d_source_parameters'] = \
                oracle_attach_d_source_parameters
            return self.call_with_http_info(**kwargs)

        self.attach_oracle_dsource = _Endpoint(
            settings={
                'response_type': (AttachDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/{dsourceId}/attachSource',
                'operation_id': 'attach_oracle_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'oracle_attach_d_source_parameters',
                ],
                'required': [
                    'dsource_id',
                    'oracle_attach_d_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'oracle_attach_d_source_parameters':
                        (OracleAttachDSourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'oracle_attach_d_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__attach_oracle_dsource
        )

        def __create_tags_dsource(
            self,
            dsource_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_tags_dsource(dsource_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.
                tags_request (TagsRequest): Tags information for DSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_tags_dsource = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/tags',
                'operation_id': 'create_tags_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'tags_request',
                ],
                'required': [
                    'dsource_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_tags_dsource
        )

        def __delete_dsource(
            self,
            delete_d_source_request,
            **kwargs
        ):
            """Delete the specified dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_dsource(delete_d_source_request, async_req=True)
            >>> result = thread.get()

            Args:
                delete_d_source_request (DeleteDSourceRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['delete_d_source_request'] = \
                delete_d_source_request
            return self.call_with_http_info(**kwargs)

        self.delete_dsource = _Endpoint(
            settings={
                'response_type': (DeleteDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/delete',
                'operation_id': 'delete_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'delete_d_source_request',
                ],
                'required': [
                    'delete_d_source_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'delete_d_source_request':
                        (DeleteDSourceRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'delete_d_source_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_dsource
        )

        def __delete_tags_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Delete tags for a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_tags_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.delete_tags_dsource = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/tags/delete',
                'operation_id': 'delete_tags_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'delete_tag',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_tags_dsource
        )

        def __detach_mssql_database(
            self,
            dsource_id,
            **kwargs
        ):
            """Detaches a linked source from a MSSql database.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.detach_mssql_database(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DetachDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.detach_mssql_database = _Endpoint(
            settings={
                'response_type': (DetachDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/{dsourceId}/detachSource',
                'operation_id': 'detach_mssql_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__detach_mssql_database
        )

        def __detach_oracle_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Detaches an Oracle source from an Oracle database.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.detach_oracle_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DetachDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.detach_oracle_dsource = _Endpoint(
            settings={
                'response_type': (DetachDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/{dsourceId}/detachSource',
                'operation_id': 'detach_oracle_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__detach_oracle_dsource
        )

        def __disable_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Disable a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.disable_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                disable_dsource_parameters (DisableDsourceParameters): The parameters to disable a dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DisableDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.disable_dsource = _Endpoint(
            settings={
                'response_type': (DisableDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/disable',
                'operation_id': 'disable_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'disable_dsource_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'disable_dsource_parameters':
                        (DisableDsourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'disable_dsource_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__disable_dsource
        )

        def __enable_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Enable a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.enable_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                enable_dsource_parameters (EnableDsourceParameters): The parameters to enable a dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnableDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.enable_dsource = _Endpoint(
            settings={
                'response_type': (EnableDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/enable',
                'operation_id': 'enable_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'enable_dsource_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'enable_dsource_parameters':
                        (EnableDsourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'enable_dsource_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__enable_dsource
        )

        def __get_appdata_dsource_linking_defaults(
            self,
            link_d_source_default_request,
            **kwargs
        ):
            """Get defaults for an AppData dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_appdata_dsource_linking_defaults(link_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_d_source_default_request (LinkDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AppDataDSourceLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_d_source_default_request'] = \
                link_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_appdata_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (AppDataDSourceLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/appdata/defaults',
                'operation_id': 'get_appdata_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_d_source_default_request',
                ],
                'required': [
                    'link_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_d_source_default_request':
                        (LinkDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_appdata_dsource_linking_defaults
        )

        def __get_ase_dsource_linking_defaults(
            self,
            link_d_source_default_request,
            **kwargs
        ):
            """Get defaults for an ASE dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ase_dsource_linking_defaults(link_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_d_source_default_request (LinkDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ASEDSourceLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_d_source_default_request'] = \
                link_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_ase_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (ASEDSourceLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/ase/defaults',
                'operation_id': 'get_ase_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_d_source_default_request',
                ],
                'required': [
                    'link_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_d_source_default_request':
                        (LinkDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_ase_dsource_linking_defaults
        )

        def __get_dsource_by_id(
            self,
            dsource_id,
            **kwargs
        ):
            """Get a dSource by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsource_by_id(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DSource
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.get_dsource_by_id = _Endpoint(
            settings={
                'response_type': (DSource,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}',
                'operation_id': 'get_dsource_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsource_by_id
        )

        def __get_dsource_deletion_dependencies(
            self,
            dsource_id,
            **kwargs
        ):
            """Get deletion dependencies for a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsource_deletion_dependencies(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeletionDependenciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.get_dsource_deletion_dependencies = _Endpoint(
            settings={
                'response_type': (DeletionDependenciesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/deletion-dependencies',
                'operation_id': 'get_dsource_deletion_dependencies',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsource_deletion_dependencies
        )

        def __get_dsource_snapshots(
            self,
            dsource_id,
            **kwargs
        ):
            """List Snapshots for a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsource_snapshots(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSnapshotsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.get_dsource_snapshots = _Endpoint(
            settings={
                'response_type': (ListSnapshotsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/snapshots',
                'operation_id': 'get_dsource_snapshots',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'limit',
                    'cursor',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsource_snapshots
        )

        def __get_dsources(
            self,
            **kwargs
        ):
            """List all dSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_dsources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                permission (PermissionEnum): Restrict the objects, which are allowed.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListDSourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_dsources = _Endpoint(
            settings={
                'response_type': (ListDSourcesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources',
                'operation_id': 'get_dsources',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'permission',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "CONTENT_TYPE": "content_type",
                        "-CONTENT_TYPE": "-content_type",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "DATA_UUID": "data_uuid",
                        "-DATA_UUID": "-data_uuid",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size",
                        "PLUGIN_VERSION": "plugin_version",
                        "-PLUGIN_VERSION": "-plugin_version",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "SOURCE_ID": "source_id",
                        "-SOURCE_ID": "-source_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "PRIMARY_OBJECT_ID": "primary_object_id",
                        "-PRIMARY_OBJECT_ID": "-primary_object_id",
                        "PRIMARY_ENGINE_ID": "primary_engine_id",
                        "-PRIMARY_ENGINE_ID": "-primary_engine_id",
                        "PRIMARY_ENGINE_NAME": "primary_engine_name",
                        "-PRIMARY_ENGINE_NAME": "-primary_engine_name",
                        "SYNC_POLICY_ID": "sync_policy_id",
                        "-SYNC_POLICY_ID": "-sync_policy_id",
                        "RETENTION_POLICY_ID": "retention_policy_id",
                        "-RETENTION_POLICY_ID": "-retention_policy_id",
                        "REPLICA_RETENTION_POLICY_ID": "replica_retention_policy_id",
                        "-REPLICA_RETENTION_POLICY_ID": "-replica_retention_policy_id",
                        "QUOTA_POLICY_ID": "quota_policy_id",
                        "-QUOTA_POLICY_ID": "-quota_policy_id",
                        "LOGSYNC_ENABLED": "logsync_enabled",
                        "-LOGSYNC_ENABLED": "-logsync_enabled",
                        "LOGSYNC_MODE": "logsync_mode",
                        "-LOGSYNC_MODE": "-logsync_mode",
                        "LOGSYNC_INTERVAL": "logsync_interval",
                        "-LOGSYNC_INTERVAL": "-logsync_interval",
                        "EXPORTED_DATA_DIRECTORY": "exported_data_directory",
                        "-EXPORTED_DATA_DIRECTORY": "-exported_data_directory",
                        "TEMPLATE_ID": "template_id",
                        "-TEMPLATE_ID": "-template_id",
                        "ALLOW_AUTO_STAGING_RESTART_ON_HOST_REBOOT": "allow_auto_staging_restart_on_host_reboot",
                        "-ALLOW_AUTO_STAGING_RESTART_ON_HOST_REBOOT": "-allow_auto_staging_restart_on_host_reboot",
                        "PHYSICAL_STANDBY": "physical_standby",
                        "-PHYSICAL_STANDBY": "-physical_standby",
                        "VALIDATE_BY_OPENING_DB_IN_READ_ONLY_MODE": "validate_by_opening_db_in_read_only_mode",
                        "-VALIDATE_BY_OPENING_DB_IN_READ_ONLY_MODE": "-validate_by_opening_db_in_read_only_mode",
                        "MSSQL_SYNC_STRATEGY_MANAGED_TYPE": "mssql_sync_strategy_managed_type",
                        "-MSSQL_SYNC_STRATEGY_MANAGED_TYPE": "-mssql_sync_strategy_managed_type",
                        "VALIDATED_SYNC_MODE": "validated_sync_mode",
                        "-VALIDATED_SYNC_MODE": "-validated_sync_mode",
                        "BACKUP_POLICY": "backup_policy",
                        "-BACKUP_POLICY": "-backup_policy",
                        "COMPRESSION_ENABLED": "compression_enabled",
                        "-COMPRESSION_ENABLED": "-compression_enabled",
                        "STAGING_DATABASE_NAME": "staging_database_name",
                        "-STAGING_DATABASE_NAME": "-staging_database_name",
                        "DB_STATE": "db_state",
                        "-DB_STATE": "-db_state",
                        "EXTERNAL_NETBACKUP_CONFIG_MASTER_NAME": "external_netbackup_config_master_name",
                        "-EXTERNAL_NETBACKUP_CONFIG_MASTER_NAME": "-external_netbackup_config_master_name",
                        "EXTERNAL_NETBACKUP_CONFIG_SOURCE_CLIENT_NAME": "external_netbackup_config_source_client_name",
                        "-EXTERNAL_NETBACKUP_CONFIG_SOURCE_CLIENT_NAME": "-external_netbackup_config_source_client_name",
                        "EXTERNAL_NETBACKUP_CONFIG_TEMPLATES": "external_netbackup_config_templates",
                        "-EXTERNAL_NETBACKUP_CONFIG_TEMPLATES": "-external_netbackup_config_templates",
                        "EXTERNAL_COMMSERVE_HOST_NAME": "external_commserve_host_name",
                        "-EXTERNAL_COMMSERVE_HOST_NAME": "-external_commserve_host_name",
                        "EXTERNAL_COMMVAULT_CONFIG_SOURCE_CLIENT_NAME": "external_commvault_config_source_client_name",
                        "-EXTERNAL_COMMVAULT_CONFIG_SOURCE_CLIENT_NAME": "-external_commvault_config_source_client_name",
                        "EXTERNAL_COMMVAULT_CONFIG_STAGING_CLIENT_NAME": "external_commvault_config_staging_client_name",
                        "-EXTERNAL_COMMVAULT_CONFIG_STAGING_CLIENT_NAME": "-external_commvault_config_staging_client_name",
                        "EXTERNAL_COMMVAULT_CONFIG_TEMPLATES": "external_commvault_config_templates",
                        "-EXTERNAL_COMMVAULT_CONFIG_TEMPLATES": "-external_commvault_config_templates"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'permission':
                        (PermissionEnum,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                    'permission': 'permission',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'permission': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_dsources
        )

        def __get_mssql_dsource_linking_defaults(
            self,
            link_d_source_default_request,
            **kwargs
        ):
            """Get defaults for a MSSql dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_mssql_dsource_linking_defaults(link_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_d_source_default_request (LinkDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MSSQLDSourceLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_d_source_default_request'] = \
                link_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_mssql_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (MSSQLDSourceLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/defaults',
                'operation_id': 'get_mssql_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_d_source_default_request',
                ],
                'required': [
                    'link_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_d_source_default_request':
                        (LinkDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_mssql_dsource_linking_defaults
        )

        def __get_mssql_staging_push_dsource_linking_defaults(
            self,
            link_staging_push_d_source_default_request,
            **kwargs
        ):
            """Get defaults for a MSSql staging push dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_mssql_staging_push_dsource_linking_defaults(link_staging_push_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_staging_push_d_source_default_request (LinkStagingPushDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MSSQLDSourceStagingPushLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_staging_push_d_source_default_request'] = \
                link_staging_push_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_mssql_staging_push_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (MSSQLDSourceStagingPushLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/staging-push/defaults',
                'operation_id': 'get_mssql_staging_push_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_staging_push_d_source_default_request',
                ],
                'required': [
                    'link_staging_push_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_staging_push_d_source_default_request':
                        (LinkStagingPushDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_staging_push_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_mssql_staging_push_dsource_linking_defaults
        )

        def __get_oracle_dsource_linking_defaults(
            self,
            link_d_source_default_request,
            **kwargs
        ):
            """Get defaults for dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_oracle_dsource_linking_defaults(link_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                link_d_source_default_request (LinkDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OracleDSourceLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['link_d_source_default_request'] = \
                link_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_oracle_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (OracleDSourceLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/defaults',
                'operation_id': 'get_oracle_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'link_d_source_default_request',
                ],
                'required': [
                    'link_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'link_d_source_default_request':
                        (LinkDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'link_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_oracle_dsource_linking_defaults
        )

        def __get_oracle_staging_push_dsource_linking_defaults(
            self,
            oracle_link_staging_push_d_source_default_request,
            **kwargs
        ):
            """Get defaults for a Oracle staging push dSource linking.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_oracle_staging_push_dsource_linking_defaults(oracle_link_staging_push_d_source_default_request, async_req=True)
            >>> result = thread.get()

            Args:
                oracle_link_staging_push_d_source_default_request (OracleLinkStagingPushDSourceDefaultRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OracleStagingPushDSourceLinkSourceParameters
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['oracle_link_staging_push_d_source_default_request'] = \
                oracle_link_staging_push_d_source_default_request
            return self.call_with_http_info(**kwargs)

        self.get_oracle_staging_push_dsource_linking_defaults = _Endpoint(
            settings={
                'response_type': (OracleStagingPushDSourceLinkSourceParameters,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/staging-push/defaults',
                'operation_id': 'get_oracle_staging_push_dsource_linking_defaults',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'oracle_link_staging_push_d_source_default_request',
                ],
                'required': [
                    'oracle_link_staging_push_d_source_default_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'oracle_link_staging_push_d_source_default_request':
                        (OracleLinkStagingPushDSourceDefaultRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'oracle_link_staging_push_d_source_default_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_oracle_staging_push_dsource_linking_defaults
        )

        def __get_tags_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Get tags for a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tags_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.get_tags_dsource = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/tags',
                'operation_id': 'get_tags_dsource',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tags_dsource
        )

        def __link_appdata_database(
            self,
            app_data_d_source_link_source_parameters,
            **kwargs
        ):
            """Link an AppData database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_appdata_database(app_data_d_source_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                app_data_d_source_link_source_parameters (AppDataDSourceLinkSourceParameters): The parameters to link an AppData dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['app_data_d_source_link_source_parameters'] = \
                app_data_d_source_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_appdata_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/appdata',
                'operation_id': 'link_appdata_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'app_data_d_source_link_source_parameters',
                ],
                'required': [
                    'app_data_d_source_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'app_data_d_source_link_source_parameters':
                        (AppDataDSourceLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'app_data_d_source_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_appdata_database
        )

        def __link_ase_database(
            self,
            ased_source_link_source_parameters,
            **kwargs
        ):
            """Link an ASE database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_ase_database(ased_source_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                ased_source_link_source_parameters (ASEDSourceLinkSourceParameters): The parameters to link an ASE dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['ased_source_link_source_parameters'] = \
                ased_source_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_ase_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/ase',
                'operation_id': 'link_ase_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ased_source_link_source_parameters',
                ],
                'required': [
                    'ased_source_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ased_source_link_source_parameters':
                        (ASEDSourceLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'ased_source_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_ase_database
        )

        def __link_mssql_database(
            self,
            mssqld_source_link_source_parameters,
            **kwargs
        ):
            """Link a MSSql database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_mssql_database(mssqld_source_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                mssqld_source_link_source_parameters (MSSQLDSourceLinkSourceParameters): The parameters to link an MSSql dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['mssqld_source_link_source_parameters'] = \
                mssqld_source_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_mssql_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql',
                'operation_id': 'link_mssql_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'mssqld_source_link_source_parameters',
                ],
                'required': [
                    'mssqld_source_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'mssqld_source_link_source_parameters':
                        (MSSQLDSourceLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'mssqld_source_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_mssql_database
        )

        def __link_mssql_staging_push_database(
            self,
            mssqld_source_staging_push_link_source_parameters,
            **kwargs
        ):
            """Link a MSSql staging push database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_mssql_staging_push_database(mssqld_source_staging_push_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                mssqld_source_staging_push_link_source_parameters (MSSQLDSourceStagingPushLinkSourceParameters): The parameters to link an MSSql dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['mssqld_source_staging_push_link_source_parameters'] = \
                mssqld_source_staging_push_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_mssql_staging_push_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/staging-push',
                'operation_id': 'link_mssql_staging_push_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'mssqld_source_staging_push_link_source_parameters',
                ],
                'required': [
                    'mssqld_source_staging_push_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'mssqld_source_staging_push_link_source_parameters':
                        (MSSQLDSourceStagingPushLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'mssqld_source_staging_push_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_mssql_staging_push_database
        )

        def __link_oracle_database(
            self,
            oracle_d_source_link_source_parameters,
            **kwargs
        ):
            """Link Oracle database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_oracle_database(oracle_d_source_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                oracle_d_source_link_source_parameters (OracleDSourceLinkSourceParameters): The parameters to link an Oracle dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['oracle_d_source_link_source_parameters'] = \
                oracle_d_source_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_oracle_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle',
                'operation_id': 'link_oracle_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'oracle_d_source_link_source_parameters',
                ],
                'required': [
                    'oracle_d_source_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'oracle_d_source_link_source_parameters':
                        (OracleDSourceLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'oracle_d_source_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_oracle_database
        )

        def __link_oracle_staging_push_database(
            self,
            oracle_staging_push_d_source_link_source_parameters,
            **kwargs
        ):
            """Link an Oracle staging push database as dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.link_oracle_staging_push_database(oracle_staging_push_d_source_link_source_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                oracle_staging_push_d_source_link_source_parameters (OracleStagingPushDSourceLinkSourceParameters): The parameters to link an Oracle dSource.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                LinkDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['oracle_staging_push_d_source_link_source_parameters'] = \
                oracle_staging_push_d_source_link_source_parameters
            return self.call_with_http_info(**kwargs)

        self.link_oracle_staging_push_database = _Endpoint(
            settings={
                'response_type': (LinkDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/staging-push',
                'operation_id': 'link_oracle_staging_push_database',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'oracle_staging_push_d_source_link_source_parameters',
                ],
                'required': [
                    'oracle_staging_push_d_source_link_source_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'oracle_staging_push_d_source_link_source_parameters':
                        (OracleStagingPushDSourceLinkSourceParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'oracle_staging_push_d_source_link_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__link_oracle_staging_push_database
        )

        def __search_dsources(
            self,
            **kwargs
        ):
            """Search for dSources.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_dsources(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies descending order.. [optional]
                permission (PermissionEnum): Restrict the objects, which are allowed.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchDSourcesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_dsources = _Endpoint(
            settings={
                'response_type': (SearchDSourcesResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/search',
                'operation_id': 'search_dsources',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'permission',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "CONTENT_TYPE": "content_type",
                        "-CONTENT_TYPE": "-content_type",
                        "DATABASE_TYPE": "database_type",
                        "-DATABASE_TYPE": "-database_type",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DATABASE_VERSION": "database_version",
                        "-DATABASE_VERSION": "-database_version",
                        "DATA_UUID": "data_uuid",
                        "-DATA_UUID": "-data_uuid",
                        "STORAGE_SIZE": "storage_size",
                        "-STORAGE_SIZE": "-storage_size",
                        "PLUGIN_VERSION": "plugin_version",
                        "-PLUGIN_VERSION": "-plugin_version",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "GROUP_NAME": "group_name",
                        "-GROUP_NAME": "-group_name",
                        "ENABLED": "enabled",
                        "-ENABLED": "-enabled",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "SOURCE_ID": "source_id",
                        "-SOURCE_ID": "-source_id",
                        "STATUS": "status",
                        "-STATUS": "-status",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "PRIMARY_OBJECT_ID": "primary_object_id",
                        "-PRIMARY_OBJECT_ID": "-primary_object_id",
                        "PRIMARY_ENGINE_ID": "primary_engine_id",
                        "-PRIMARY_ENGINE_ID": "-primary_engine_id",
                        "PRIMARY_ENGINE_NAME": "primary_engine_name",
                        "-PRIMARY_ENGINE_NAME": "-primary_engine_name",
                        "SYNC_POLICY_ID": "sync_policy_id",
                        "-SYNC_POLICY_ID": "-sync_policy_id",
                        "RETENTION_POLICY_ID": "retention_policy_id",
                        "-RETENTION_POLICY_ID": "-retention_policy_id",
                        "REPLICA_RETENTION_POLICY_ID": "replica_retention_policy_id",
                        "-REPLICA_RETENTION_POLICY_ID": "-replica_retention_policy_id",
                        "QUOTA_POLICY_ID": "quota_policy_id",
                        "-QUOTA_POLICY_ID": "-quota_policy_id",
                        "LOGSYNC_ENABLED": "logsync_enabled",
                        "-LOGSYNC_ENABLED": "-logsync_enabled",
                        "LOGSYNC_MODE": "logsync_mode",
                        "-LOGSYNC_MODE": "-logsync_mode",
                        "LOGSYNC_INTERVAL": "logsync_interval",
                        "-LOGSYNC_INTERVAL": "-logsync_interval",
                        "EXPORTED_DATA_DIRECTORY": "exported_data_directory",
                        "-EXPORTED_DATA_DIRECTORY": "-exported_data_directory",
                        "TEMPLATE_ID": "template_id",
                        "-TEMPLATE_ID": "-template_id",
                        "ALLOW_AUTO_STAGING_RESTART_ON_HOST_REBOOT": "allow_auto_staging_restart_on_host_reboot",
                        "-ALLOW_AUTO_STAGING_RESTART_ON_HOST_REBOOT": "-allow_auto_staging_restart_on_host_reboot",
                        "PHYSICAL_STANDBY": "physical_standby",
                        "-PHYSICAL_STANDBY": "-physical_standby",
                        "VALIDATE_BY_OPENING_DB_IN_READ_ONLY_MODE": "validate_by_opening_db_in_read_only_mode",
                        "-VALIDATE_BY_OPENING_DB_IN_READ_ONLY_MODE": "-validate_by_opening_db_in_read_only_mode",
                        "MSSQL_SYNC_STRATEGY_MANAGED_TYPE": "mssql_sync_strategy_managed_type",
                        "-MSSQL_SYNC_STRATEGY_MANAGED_TYPE": "-mssql_sync_strategy_managed_type",
                        "VALIDATED_SYNC_MODE": "validated_sync_mode",
                        "-VALIDATED_SYNC_MODE": "-validated_sync_mode",
                        "BACKUP_POLICY": "backup_policy",
                        "-BACKUP_POLICY": "-backup_policy",
                        "COMPRESSION_ENABLED": "compression_enabled",
                        "-COMPRESSION_ENABLED": "-compression_enabled",
                        "STAGING_DATABASE_NAME": "staging_database_name",
                        "-STAGING_DATABASE_NAME": "-staging_database_name",
                        "DB_STATE": "db_state",
                        "-DB_STATE": "-db_state",
                        "EXTERNAL_NETBACKUP_CONFIG_MASTER_NAME": "external_netbackup_config_master_name",
                        "-EXTERNAL_NETBACKUP_CONFIG_MASTER_NAME": "-external_netbackup_config_master_name",
                        "EXTERNAL_NETBACKUP_CONFIG_SOURCE_CLIENT_NAME": "external_netbackup_config_source_client_name",
                        "-EXTERNAL_NETBACKUP_CONFIG_SOURCE_CLIENT_NAME": "-external_netbackup_config_source_client_name",
                        "EXTERNAL_NETBACKUP_CONFIG_TEMPLATES": "external_netbackup_config_templates",
                        "-EXTERNAL_NETBACKUP_CONFIG_TEMPLATES": "-external_netbackup_config_templates",
                        "EXTERNAL_COMMSERVE_HOST_NAME": "external_commserve_host_name",
                        "-EXTERNAL_COMMSERVE_HOST_NAME": "-external_commserve_host_name",
                        "EXTERNAL_COMMVAULT_CONFIG_SOURCE_CLIENT_NAME": "external_commvault_config_source_client_name",
                        "-EXTERNAL_COMMVAULT_CONFIG_SOURCE_CLIENT_NAME": "-external_commvault_config_source_client_name",
                        "EXTERNAL_COMMVAULT_CONFIG_STAGING_CLIENT_NAME": "external_commvault_config_staging_client_name",
                        "-EXTERNAL_COMMVAULT_CONFIG_STAGING_CLIENT_NAME": "-external_commvault_config_staging_client_name",
                        "EXTERNAL_COMMVAULT_CONFIG_TEMPLATES": "external_commvault_config_templates",
                        "-EXTERNAL_COMMVAULT_CONFIG_TEMPLATES": "-external_commvault_config_templates"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'permission':
                        (PermissionEnum,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                    'permission': 'permission',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'permission': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_dsources
        )

        def __snapshot_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Snapshot a dSource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.snapshot_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                d_source_snapshot_parameters (DSourceSnapshotParameters): Optional parameters to snapshot a DSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SnapshotDSourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.snapshot_dsource = _Endpoint(
            settings={
                'response_type': (SnapshotDSourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/{dsourceId}/snapshots',
                'operation_id': 'snapshot_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'd_source_snapshot_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'd_source_snapshot_parameters':
                        (DSourceSnapshotParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'd_source_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__snapshot_dsource
        )

        def __update_appdata_dsource_by_id(
            self,
            dsource_id,
            **kwargs
        ):
            """Update values of an AppData dSource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_appdata_dsource_by_id(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                update_app_data_d_source_parameters (UpdateAppDataDSourceParameters): The new data to update an AppData dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.update_appdata_dsource_by_id = _Endpoint(
            settings={
                'response_type': (UpdateDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/appdata/{dsourceId}',
                'operation_id': 'update_appdata_dsource_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'update_app_data_d_source_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'update_app_data_d_source_parameters':
                        (UpdateAppDataDSourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'update_app_data_d_source_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_appdata_dsource_by_id
        )

        def __update_mssql_dsource_by_id(
            self,
            dsource_id,
            **kwargs
        ):
            """Update values of an MSSql dSource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_mssql_dsource_by_id(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                update_mssql_dsource_parameters (UpdateMSSQLDsourceParameters): The new data to update an MSSql dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.update_mssql_dsource_by_id = _Endpoint(
            settings={
                'response_type': (UpdateDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/mssql/{dsourceId}',
                'operation_id': 'update_mssql_dsource_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'update_mssql_dsource_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'update_mssql_dsource_parameters':
                        (UpdateMSSQLDsourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'update_mssql_dsource_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_mssql_dsource_by_id
        )

        def __update_oracle_dsource_by_id(
            self,
            dsource_id,
            **kwargs
        ):
            """Update values of an Oracle dSource  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_oracle_dsource_by_id(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                update_oracle_dsource_parameters (UpdateOracleDsourceParameters): The new data to update an Oracle dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.update_oracle_dsource_by_id = _Endpoint(
            settings={
                'response_type': (UpdateDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/{dsourceId}',
                'operation_id': 'update_oracle_dsource_by_id',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'update_oracle_dsource_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'update_oracle_dsource_parameters':
                        (UpdateOracleDsourceParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'update_oracle_dsource_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_oracle_dsource_by_id
        )

        def __upgrade_oracle_dsource(
            self,
            dsource_id,
            **kwargs
        ):
            """Upgrade the requested Oracle dSource installation and user.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.upgrade_oracle_dsource(dsource_id, async_req=True)
            >>> result = thread.get()

            Args:
                dsource_id (str): The ID of the dSource.

            Keyword Args:
                upgrade_oracle_database_parameters (UpgradeOracleDatabaseParameters): The new data to upgrade an Oracle dSource.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpgradeDsourceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['dsource_id'] = \
                dsource_id
            return self.call_with_http_info(**kwargs)

        self.upgrade_oracle_dsource = _Endpoint(
            settings={
                'response_type': (UpgradeDsourceResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/dsources/oracle/{dsourceId}/upgrade',
                'operation_id': 'upgrade_oracle_dsource',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'dsource_id',
                    'upgrade_oracle_database_parameters',
                ],
                'required': [
                    'dsource_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'dsource_id',
                ]
            },
            root_map={
                'validations': {
                    ('dsource_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'dsource_id':
                        (str,),
                    'upgrade_oracle_database_parameters':
                        (UpgradeOracleDatabaseParameters,),
                },
                'attribute_map': {
                    'dsource_id': 'dsourceId',
                },
                'location_map': {
                    'dsource_id': 'path',
                    'upgrade_oracle_database_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__upgrade_oracle_dsource
        )
