"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.commvault_connectivity_check_parameters import CommvaultConnectivityCheckParameters
from delphix.api.gateway.model.connectivity_check_parameters import ConnectivityCheckParameters
from delphix.api.gateway.model.connectivity_check_response import ConnectivityCheckResponse
from delphix.api.gateway.model.database_connectivity_check_parameters import DatabaseConnectivityCheckParameters
from delphix.api.gateway.model.netbackup_connectivity_check_parameters import NetbackupConnectivityCheckParameters


class ConnectivityApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __commvault_connectivity_check(
            self,
            commvault_connectivity_check_parameters,
            **kwargs
        ):
            """Tests whether the CommServe host is accessible from the given environment and Commvault agent.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.commvault_connectivity_check(commvault_connectivity_check_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                commvault_connectivity_check_parameters (CommvaultConnectivityCheckParameters): The api to check connectivity to the CommServe host and staging client from an environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['commvault_connectivity_check_parameters'] = \
                commvault_connectivity_check_parameters
            return self.call_with_http_info(**kwargs)

        self.commvault_connectivity_check = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/commvault/connectivity/check',
                'operation_id': 'commvault_connectivity_check',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'commvault_connectivity_check_parameters',
                ],
                'required': [
                    'commvault_connectivity_check_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'commvault_connectivity_check_parameters':
                        (CommvaultConnectivityCheckParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'commvault_connectivity_check_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__commvault_connectivity_check
        )

        def __connectivity_check(
            self,
            connectivity_check_parameters,
            **kwargs
        ):
            """Checks connectivity between an engine and a remote host machine on a given port.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.connectivity_check(connectivity_check_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                connectivity_check_parameters (ConnectivityCheckParameters): The api to check connectivity of engine and a remote host on given port.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectivityCheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['connectivity_check_parameters'] = \
                connectivity_check_parameters
            return self.call_with_http_info(**kwargs)

        self.connectivity_check = _Endpoint(
            settings={
                'response_type': (ConnectivityCheckResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/connectivity/check',
                'operation_id': 'connectivity_check',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'connectivity_check_parameters',
                ],
                'required': [
                    'connectivity_check_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'connectivity_check_parameters':
                        (ConnectivityCheckParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'connectivity_check_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__connectivity_check
        )

        def __database_connectivity_check(
            self,
            database_connectivity_check_parameters,
            **kwargs
        ):
            """Tests the validity of the supplied database credentials, returning an error if unable to connect to the database.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.database_connectivity_check(database_connectivity_check_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                database_connectivity_check_parameters (DatabaseConnectivityCheckParameters):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ConnectivityCheckResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['database_connectivity_check_parameters'] = \
                database_connectivity_check_parameters
            return self.call_with_http_info(**kwargs)

        self.database_connectivity_check = _Endpoint(
            settings={
                'response_type': (ConnectivityCheckResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/database/connectivity/check',
                'operation_id': 'database_connectivity_check',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'database_connectivity_check_parameters',
                ],
                'required': [
                    'database_connectivity_check_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'database_connectivity_check_parameters':
                        (DatabaseConnectivityCheckParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'database_connectivity_check_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__database_connectivity_check
        )

        def __netbackup_connectivity_check(
            self,
            netbackup_connectivity_check_parameters,
            **kwargs
        ):
            """Checks whether the specified NetBackup master server and client are able to communicate on the given environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.netbackup_connectivity_check(netbackup_connectivity_check_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                netbackup_connectivity_check_parameters (NetbackupConnectivityCheckParameters): The api to check connectivity of NetBackup master server and client on an environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['netbackup_connectivity_check_parameters'] = \
                netbackup_connectivity_check_parameters
            return self.call_with_http_info(**kwargs)

        self.netbackup_connectivity_check = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/netbackup/connectivity/check',
                'operation_id': 'netbackup_connectivity_check',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'netbackup_connectivity_check_parameters',
                ],
                'required': [
                    'netbackup_connectivity_check_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'netbackup_connectivity_check_parameters':
                        (NetbackupConnectivityCheckParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'netbackup_connectivity_check_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__netbackup_connectivity_check
        )
