"""
    Delphix DCT API

    Delphix DCT API  # noqa: E501

    The version of the OpenAPI document: 3.20.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.compliance_job_collection import ComplianceJobCollection
from delphix.api.gateway.model.create_compliance_job_collection_request import CreateComplianceJobCollectionRequest
from delphix.api.gateway.model.create_compliance_job_collection_response import CreateComplianceJobCollectionResponse
from delphix.api.gateway.model.delete_compliance_job_collection_response import DeleteComplianceJobCollectionResponse
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.execute_compliance_job_collection_response import ExecuteComplianceJobCollectionResponse
from delphix.api.gateway.model.list_compliance_job_collections_response import ListComplianceJobCollectionsResponse
from delphix.api.gateway.model.list_compliance_jobs_response import ListComplianceJobsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.search_compliance_job_collections_response import SearchComplianceJobCollectionsResponse
from delphix.api.gateway.model.search_compliance_jobs_response import SearchComplianceJobsResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_compliance_job_collection_request import UpdateComplianceJobCollectionRequest
from delphix.api.gateway.model.update_compliance_job_collection_response import UpdateComplianceJobCollectionResponse


class ComplianceJobCollectionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_compliance_job_collection(
            self,
            create_compliance_job_collection_request,
            **kwargs
        ):
            """Create a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_compliance_job_collection(create_compliance_job_collection_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_compliance_job_collection_request (CreateComplianceJobCollectionRequest): The parameters to create a compliance job collection

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateComplianceJobCollectionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_compliance_job_collection_request'] = \
                create_compliance_job_collection_request
            return self.call_with_http_info(**kwargs)

        self.create_compliance_job_collection = _Endpoint(
            settings={
                'response_type': (CreateComplianceJobCollectionResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections',
                'operation_id': 'create_compliance_job_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_compliance_job_collection_request',
                ],
                'required': [
                    'create_compliance_job_collection_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_compliance_job_collection_request':
                        (CreateComplianceJobCollectionRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_compliance_job_collection_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_compliance_job_collection
        )

        def __create_compliance_job_collection_tags(
            self,
            compliance_job_collection_id,
            tags_request,
            **kwargs
        ):
            """Create tags for a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_compliance_job_collection_tags(compliance_job_collection_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.
                tags_request (TagsRequest): Tags information for a compliance job collection.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_compliance_job_collection_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/tags',
                'operation_id': 'create_compliance_job_collection_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'tags_request',
                ],
                'required': [
                    'compliance_job_collection_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_compliance_job_collection_tags
        )

        def __delete_compliance_job_collection(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Delete a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_compliance_job_collection(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteComplianceJobCollectionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.delete_compliance_job_collection = _Endpoint(
            settings={
                'response_type': (DeleteComplianceJobCollectionResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}',
                'operation_id': 'delete_compliance_job_collection',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_compliance_job_collection
        )

        def __delete_compliance_job_collection_tags(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Delete tags for a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_compliance_job_collection_tags(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                delete_tag (DeleteTag): The parameters to delete tags. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.delete_compliance_job_collection_tags = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/tags/delete',
                'operation_id': 'delete_compliance_job_collection_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'delete_tag',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'delete_tag':
                        (DeleteTag,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'delete_tag': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_compliance_job_collection_tags
        )

        def __execute_compliance_job_collection(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Execute a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.execute_compliance_job_collection(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExecuteComplianceJobCollectionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.execute_compliance_job_collection = _Endpoint(
            settings={
                'response_type': (ExecuteComplianceJobCollectionResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/execute',
                'operation_id': 'execute_compliance_job_collection',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'body',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__execute_compliance_job_collection
        )

        def __get_compliance_job_collection_by_id(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Retrieve a compliance job collection by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_compliance_job_collection_by_id(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ComplianceJobCollection
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.get_compliance_job_collection_by_id = _Endpoint(
            settings={
                'response_type': (ComplianceJobCollection,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}',
                'operation_id': 'get_compliance_job_collection_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_compliance_job_collection_by_id
        )

        def __get_compliance_job_collection_jobs(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Get compliance jobs for a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_compliance_job_collection_jobs(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListComplianceJobsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.get_compliance_job_collection_jobs = _Endpoint(
            settings={
                'response_type': (ListComplianceJobsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/jobs',
                'operation_id': 'get_compliance_job_collection_jobs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'compliance_job_collection_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "IS_ON_THE_FLY_MASKING": "is_on_the_fly_masking",
                        "-IS_ON_THE_FLY_MASKING": "-is_on_the_fly_masking",
                        "TYPE": "type",
                        "-TYPE": "-type",
                        "EXECUTION_TYPE": "execution_type",
                        "-EXECUTION_TYPE": "-execution_type",
                        "ENGINE_JOB_ID": "engine_job_id",
                        "-ENGINE_JOB_ID": "-engine_job_id",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "LAST_COMPLETED_EXECUTION_DATE": "last_completed_execution_date",
                        "-LAST_COMPLETED_EXECUTION_DATE": "-last_completed_execution_date",
                        "LAST_EXECUTION_STATUS": "last_execution_status",
                        "-LAST_EXECUTION_STATUS": "-last_execution_status",
                        "LAST_EXECUTION_ID": "last_execution_id",
                        "-LAST_EXECUTION_ID": "-last_execution_id",
                        "LAST_EXECUTION_START_TIME": "last_execution_start_time",
                        "-LAST_EXECUTION_START_TIME": "-last_execution_start_time",
                        "LAST_EXECUTION_RUN_TIME": "last_execution_run_time",
                        "-LAST_EXECUTION_RUN_TIME": "-last_execution_run_time",
                        "RULE_SET_ID": "rule_set_id",
                        "-RULE_SET_ID": "-rule_set_id",
                        "RULE_SET_NAME": "rule_set_name",
                        "-RULE_SET_NAME": "-rule_set_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "RETAIN_EXECUTION_DATA": "retain_execution_data",
                        "-RETAIN_EXECUTION_DATA": "-retain_execution_data",
                        "PARALLELISM_DEGREE": "parallelism_degree",
                        "-PARALLELISM_DEGREE": "-parallelism_degree",
                        "MAX_CONCURRENT_TARGET_CONNECTIONS": "max_concurrent_target_connections",
                        "-MAX_CONCURRENT_TARGET_CONNECTIONS": "-max_concurrent_target_connections",
                        "MAX_CONCURRENT_SOURCE_CONNECTIONS": "max_concurrent_source_connections",
                        "-MAX_CONCURRENT_SOURCE_CONNECTIONS": "-max_concurrent_source_connections",
                        "NUM_INPUT_STREAMS": "num_input_streams",
                        "-NUM_INPUT_STREAMS": "-num_input_streams",
                        "STREAM_ROW_LIMIT": "stream_row_limit",
                        "-STREAM_ROW_LIMIT": "-stream_row_limit",
                        "FEEDBACK_SIZE": "feedback_size",
                        "-FEEDBACK_SIZE": "-feedback_size",
                        "MIN_MEMORY": "min_memory",
                        "-MIN_MEMORY": "-min_memory",
                        "MAX_MEMORY": "max_memory",
                        "-MAX_MEMORY": "-max_memory",
                        "DISCOVERY_POLICY_ID": "discovery_policy_id",
                        "-DISCOVERY_POLICY_ID": "-discovery_policy_id",
                        "DISCOVERY_POLICY_NAME": "discovery_policy_name",
                        "-DISCOVERY_POLICY_NAME": "-discovery_policy_name"
                    },
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_compliance_job_collection_jobs
        )

        def __get_compliance_job_collection_tags(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Get tags for a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_compliance_job_collection_tags(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.get_compliance_job_collection_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/tags',
                'operation_id': 'get_compliance_job_collection_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_compliance_job_collection_tags
        )

        def __get_compliance_job_collections(
            self,
            **kwargs
        ):
            """Retrieve the list of compliance job collections.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_compliance_job_collections(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListComplianceJobCollectionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_compliance_job_collections = _Endpoint(
            settings={
                'response_type': (ListComplianceJobCollectionsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections',
                'operation_id': 'get_compliance_job_collections',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "JOB_COUNT": "job_count",
                        "-JOB_COUNT": "-job_count",
                        "LAST_EXECUTION_ID": "last_execution_id",
                        "-LAST_EXECUTION_ID": "-last_execution_id",
                        "FAILURE_HANDLING": "failure_handling",
                        "-FAILURE_HANDLING": "-failure_handling"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_compliance_job_collections
        )

        def __search_compliance_job_collection_jobs(
            self,
            compliance_job_collection_id,
            **kwargs
        ):
            """Search compliance jobs for a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_compliance_job_collection_jobs(compliance_job_collection_id, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.

            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchComplianceJobsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            return self.call_with_http_info(**kwargs)

        self.search_compliance_job_collection_jobs = _Endpoint(
            settings={
                'response_type': (SearchComplianceJobsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}/jobs/search',
                'operation_id': 'search_compliance_job_collection_jobs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [
                    'compliance_job_collection_id',
                ],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'compliance_job_collection_id',
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "IS_ON_THE_FLY_MASKING": "is_on_the_fly_masking",
                        "-IS_ON_THE_FLY_MASKING": "-is_on_the_fly_masking",
                        "TYPE": "type",
                        "-TYPE": "-type",
                        "EXECUTION_TYPE": "execution_type",
                        "-EXECUTION_TYPE": "-execution_type",
                        "ENGINE_JOB_ID": "engine_job_id",
                        "-ENGINE_JOB_ID": "-engine_job_id",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "ENGINE_ID": "engine_id",
                        "-ENGINE_ID": "-engine_id",
                        "ENGINE_NAME": "engine_name",
                        "-ENGINE_NAME": "-engine_name",
                        "LAST_COMPLETED_EXECUTION_DATE": "last_completed_execution_date",
                        "-LAST_COMPLETED_EXECUTION_DATE": "-last_completed_execution_date",
                        "LAST_EXECUTION_STATUS": "last_execution_status",
                        "-LAST_EXECUTION_STATUS": "-last_execution_status",
                        "LAST_EXECUTION_ID": "last_execution_id",
                        "-LAST_EXECUTION_ID": "-last_execution_id",
                        "LAST_EXECUTION_START_TIME": "last_execution_start_time",
                        "-LAST_EXECUTION_START_TIME": "-last_execution_start_time",
                        "LAST_EXECUTION_RUN_TIME": "last_execution_run_time",
                        "-LAST_EXECUTION_RUN_TIME": "-last_execution_run_time",
                        "RULE_SET_ID": "rule_set_id",
                        "-RULE_SET_ID": "-rule_set_id",
                        "RULE_SET_NAME": "rule_set_name",
                        "-RULE_SET_NAME": "-rule_set_name",
                        "CONNECTOR_TYPE": "connector_type",
                        "-CONNECTOR_TYPE": "-connector_type",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "DATASET_ID": "dataset_id",
                        "-DATASET_ID": "-dataset_id",
                        "RETAIN_EXECUTION_DATA": "retain_execution_data",
                        "-RETAIN_EXECUTION_DATA": "-retain_execution_data",
                        "PARALLELISM_DEGREE": "parallelism_degree",
                        "-PARALLELISM_DEGREE": "-parallelism_degree",
                        "MAX_CONCURRENT_TARGET_CONNECTIONS": "max_concurrent_target_connections",
                        "-MAX_CONCURRENT_TARGET_CONNECTIONS": "-max_concurrent_target_connections",
                        "MAX_CONCURRENT_SOURCE_CONNECTIONS": "max_concurrent_source_connections",
                        "-MAX_CONCURRENT_SOURCE_CONNECTIONS": "-max_concurrent_source_connections",
                        "NUM_INPUT_STREAMS": "num_input_streams",
                        "-NUM_INPUT_STREAMS": "-num_input_streams",
                        "STREAM_ROW_LIMIT": "stream_row_limit",
                        "-STREAM_ROW_LIMIT": "-stream_row_limit",
                        "FEEDBACK_SIZE": "feedback_size",
                        "-FEEDBACK_SIZE": "-feedback_size",
                        "MIN_MEMORY": "min_memory",
                        "-MIN_MEMORY": "-min_memory",
                        "MAX_MEMORY": "max_memory",
                        "-MAX_MEMORY": "-max_memory",
                        "DISCOVERY_POLICY_ID": "discovery_policy_id",
                        "-DISCOVERY_POLICY_ID": "-discovery_policy_id",
                        "DISCOVERY_POLICY_NAME": "discovery_policy_name",
                        "-DISCOVERY_POLICY_NAME": "-discovery_policy_name"
                    },
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_compliance_job_collection_jobs
        )

        def __search_compliance_job_collections(
            self,
            **kwargs
        ):
            """Search compliance job collections.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_compliance_job_collections(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results. The value of this property must be extracted from the 'prev_cursor' or 'next_cursor' property of a PaginatedResponseMetadata which is contained in the response of list and search API endpoints.. [optional]
                sort (str, none_type): The field to sort results by. A property name with a prepended '-' signifies a descending order.. [optional]
                search_body (SearchBody): A request body containing a filter expression. This enables searching for items matching arbitrarily complex conditions. The list of attributes which can be used in filter expressions is available in the x-filterable vendor extension.  # Filter Expression Overview **Note: All keywords are case-insensitive**  ## Comparison Operators | Operator | Description | Example | | --- | --- | --- | | CONTAINS | Substring or membership testing for string and list attributes respectively. | field3 CONTAINS 'foobar', field4 CONTAINS TRUE  | | IN | Tests if field is a member of a list literal. List can contain a maximum of 100 values | field2 IN ['Goku', 'Vegeta'] | | GE | Tests if a field is greater than or equal to a literal value | field1 GE 1.2e-2 | | GT | Tests if a field is greater than a literal value | field1 GT 1.2e-2 | | LE | Tests if a field is less than or equal to a literal value | field1 LE 9000 | | LT | Tests if a field is less than a literal value | field1 LT 9.02 | | NE | Tests if a field is not equal to a literal value | field1 NE 42 | | EQ | Tests if a field is equal to a literal value | field1 EQ 42 |  ## Search Operator The SEARCH operator filters for items which have any filterable attribute that contains the input string as a substring, comparison is done case-insensitively. This is not restricted to attributes with string values. Specifically `SEARCH '12'` would match an item with an attribute with an integer value of `123`.  ## Logical Operators Ordered by precedence. | Operator | Description | Example | | --- | --- | --- | | NOT | Logical NOT (Right associative) | NOT field1 LE 9000 | | AND | Logical AND (Left Associative) | field1 GT 9000 AND field2 EQ 'Goku' | | OR | Logical OR (Left Associative) | field1 GT 9000 OR field2 EQ 'Goku' |  ## Grouping Parenthesis `()` can be used to override operator precedence.  For example: NOT (field1 LT 1234 AND field2 CONTAINS 'foo')  ## Literal Values | Literal      | Description | Examples | | --- | --- | --- | | Nil | Represents the absence of a value | nil, Nil, nIl, NIL | | Boolean | true/false boolean | true, false, True, False, TRUE, FALSE | | Number | Signed integer and floating point numbers. Also supports scientific notation. | 0, 1, -1, 1.2, 0.35, 1.2e-2, -1.2e+2 | | String | Single or double quoted | \"foo\", \"bar\", \"foo bar\", 'foo', 'bar', 'foo bar' | | Datetime | Formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) | 2018-04-27T18:39:26.397237+00:00 | | List | Comma-separated literals wrapped in square brackets | [0], [0, 1], ['foo', \"bar\"] |  ## Limitations - A maximum of 8 unique identifiers may be used inside a filter expression. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SearchComplianceJobCollectionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.search_compliance_job_collections = _Endpoint(
            settings={
                'response_type': (SearchComplianceJobCollectionsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/search',
                'operation_id': 'search_compliance_job_collections',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                    'sort',
                    'search_body',
                ],
                'required': [],
                'nullable': [
                    'sort',
                ],
                'enum': [
                    'sort',
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                    ('sort',): {
                        'None': None,
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "DESCRIPTION": "description",
                        "-DESCRIPTION": "-description",
                        "CREATION_DATE": "creation_date",
                        "-CREATION_DATE": "-creation_date",
                        "JOB_COUNT": "job_count",
                        "-JOB_COUNT": "-job_count",
                        "LAST_EXECUTION_ID": "last_execution_id",
                        "-LAST_EXECUTION_ID": "-last_execution_id",
                        "FAILURE_HANDLING": "failure_handling",
                        "-FAILURE_HANDLING": "-failure_handling"
                    },
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                    'sort':
                        (str, none_type,),
                    'search_body':
                        (SearchBody,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                    'sort': 'sort',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                    'sort': 'query',
                    'search_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__search_compliance_job_collections
        )

        def __update_compliance_job_collection(
            self,
            compliance_job_collection_id,
            update_compliance_job_collection_request,
            **kwargs
        ):
            """Update a compliance job collection.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_compliance_job_collection(compliance_job_collection_id, update_compliance_job_collection_request, async_req=True)
            >>> result = thread.get()

            Args:
                compliance_job_collection_id (str): The ID of the compliance job collection.
                update_compliance_job_collection_request (UpdateComplianceJobCollectionRequest): The parameters to update a compliance job collection

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateComplianceJobCollectionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['compliance_job_collection_id'] = \
                compliance_job_collection_id
            kwargs['update_compliance_job_collection_request'] = \
                update_compliance_job_collection_request
            return self.call_with_http_info(**kwargs)

        self.update_compliance_job_collection = _Endpoint(
            settings={
                'response_type': (UpdateComplianceJobCollectionResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/compliance-job-collections/{complianceJobCollectionId}',
                'operation_id': 'update_compliance_job_collection',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'compliance_job_collection_id',
                    'update_compliance_job_collection_request',
                ],
                'required': [
                    'compliance_job_collection_id',
                    'update_compliance_job_collection_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'compliance_job_collection_id',
                ]
            },
            root_map={
                'validations': {
                    ('compliance_job_collection_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'compliance_job_collection_id':
                        (str,),
                    'update_compliance_job_collection_request':
                        (UpdateComplianceJobCollectionRequest,),
                },
                'attribute_map': {
                    'compliance_job_collection_id': 'complianceJobCollectionId',
                },
                'location_map': {
                    'compliance_job_collection_id': 'path',
                    'update_compliance_job_collection_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_compliance_job_collection
        )
