# delphix-dct-api
Delphix DCT API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.20.0
- Package version: 2025.1.0-rc3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import accounts_api
from delphix.api.gateway.model.account import Account
from delphix.api.gateway.model.account_create_parameter import AccountCreateParameter
from delphix.api.gateway.model.account_create_response import AccountCreateResponse
from delphix.api.gateway.model.account_ui_profiles_response import AccountUiProfilesResponse
from delphix.api.gateway.model.account_update_parameter import AccountUpdateParameter
from delphix.api.gateway.model.apikey_regenerate_parameter import ApikeyRegenerateParameter
from delphix.api.gateway.model.change_password_parameter import ChangePasswordParameter
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_accounts_response import ListAccountsResponse
from delphix.api.gateway.model.password_policies_params import PasswordPoliciesParams
from delphix.api.gateway.model.reset_password_parameter import ResetPasswordParameter
from delphix.api.gateway.model.search_accounts_response import SearchAccountsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
# Defining the host is optional and defaults to http://localhost/dct/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/dct/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = accounts_api.AccountsApi(api_client)
    id = 1 # int | Numeric ID of the Account.

    try:
        # Delete an API Key for an account
        api_instance.api_key_delete(id)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling AccountsApi->api_key_delete: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/dct/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**api_key_delete**](docs/AccountsApi.md#api_key_delete) | **DELETE** /management/accounts/{id}/api-key-delete | Delete an API Key for an account
*AccountsApi* | [**api_key_regenerate**](docs/AccountsApi.md#api_key_regenerate) | **POST** /management/accounts/api-key-regenerate | Regenerate api key for the self.
*AccountsApi* | [**api_key_reset**](docs/AccountsApi.md#api_key_reset) | **POST** /management/accounts/{id}/api-key-reset | Reset account API key.
*AccountsApi* | [**change_account_password**](docs/AccountsApi.md#change_account_password) | **POST** /management/accounts/{id}/change_password | Change Account Password. 
*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /management/accounts | Create a new Account 
*AccountsApi* | [**create_account_tags**](docs/AccountsApi.md#create_account_tags) | **POST** /management/accounts/{id}/tags | Create tags for an Account.
*AccountsApi* | [**delete_account**](docs/AccountsApi.md#delete_account) | **DELETE** /management/accounts/{id} | Delete an Account
*AccountsApi* | [**delete_account_tags**](docs/AccountsApi.md#delete_account_tags) | **POST** /management/accounts/{id}/tags/delete | Delete tags for an Account.
*AccountsApi* | [**disable**](docs/AccountsApi.md#disable) | **POST** /management/accounts/{id}/disable | Disable an Account.
*AccountsApi* | [**enable_account**](docs/AccountsApi.md#enable_account) | **POST** /management/accounts/{id}/enable | Enable an Account.
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /management/accounts/{id} | Get an Account by id
*AccountsApi* | [**get_account_tags**](docs/AccountsApi.md#get_account_tags) | **GET** /management/accounts/{id}/tags | Get tags for an Account.
*AccountsApi* | [**get_account_ui_profiles**](docs/AccountsApi.md#get_account_ui_profiles) | **GET** /management/accounts/{id}/ui-profiles | Returns the list of effective UI profiles for an account. This can only be called for one&#39;s own account.
*AccountsApi* | [**get_accounts**](docs/AccountsApi.md#get_accounts) | **GET** /management/accounts | Returns a list of Accounts
*AccountsApi* | [**get_password_policies**](docs/AccountsApi.md#get_password_policies) | **GET** /management/accounts/password-policies | Returns the password policies
*AccountsApi* | [**reset_account_password**](docs/AccountsApi.md#reset_account_password) | **POST** /management/accounts/{id}/reset_password | Reset Account Password. 
*AccountsApi* | [**search_accounts**](docs/AccountsApi.md#search_accounts) | **POST** /management/accounts/search | Search for Accounts.
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /management/accounts/{id} | Update an Account 
*AccountsApi* | [**update_password_policies**](docs/AccountsApi.md#update_password_policies) | **PATCH** /management/accounts/password-policies | Update password policies.
*AlgorithmsApi* | [**create_algorithm_tags**](docs/AlgorithmsApi.md#create_algorithm_tags) | **POST** /algorithms/{algorithmId}/tags | Create tags for an Algorithm.
*AlgorithmsApi* | [**delete_algorithm_tags**](docs/AlgorithmsApi.md#delete_algorithm_tags) | **POST** /algorithms/{algorithmId}/tags/delete | Delete tags for an Algorithm.
*AlgorithmsApi* | [**get_algorithm_by_id**](docs/AlgorithmsApi.md#get_algorithm_by_id) | **GET** /algorithms/{algorithmId} | Get an algorithm by ID.
*AlgorithmsApi* | [**get_algorithm_dependencies_by_id**](docs/AlgorithmsApi.md#get_algorithm_dependencies_by_id) | **GET** /algorithms/{algorithmId}/dependencies | Get dependencies of an algorithm by ID.
*AlgorithmsApi* | [**get_algorithm_tags**](docs/AlgorithmsApi.md#get_algorithm_tags) | **GET** /algorithms/{algorithmId}/tags | Get tags for an Algorithm.
*AlgorithmsApi* | [**get_algorithms**](docs/AlgorithmsApi.md#get_algorithms) | **GET** /algorithms | Retrieve the list of algorithms.
*AlgorithmsApi* | [**search_algorithm_dependencies**](docs/AlgorithmsApi.md#search_algorithm_dependencies) | **POST** /algorithms/{algorithmId}/dependencies/search | Search for algorithm dependencies.
*AlgorithmsApi* | [**search_algorithms**](docs/AlgorithmsApi.md#search_algorithms) | **POST** /algorithms/search | Search for algorithms.
*AuthorizationApi* | [**add_access_group_account_ids**](docs/AuthorizationApi.md#add_access_group_account_ids) | **POST** /access-groups/{accessGroupId}/account-ids | Add account ids to an Access group
*AuthorizationApi* | [**add_access_group_account_tags**](docs/AuthorizationApi.md#add_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags | Add account tags to an Access group
*AuthorizationApi* | [**add_access_group_scopes**](docs/AuthorizationApi.md#add_access_group_scopes) | **POST** /access-groups/{accessGroupId}/scopes | Add scopes to an Access group
*AuthorizationApi* | [**add_always_allowed_permissions**](docs/AuthorizationApi.md#add_always_allowed_permissions) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions | Add always allowed permissions for given object type.
*AuthorizationApi* | [**add_objects_to_access_group_scope**](docs/AuthorizationApi.md#add_objects_to_access_group_scope) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/objects | Add objects to the access group scope.
*AuthorizationApi* | [**add_role_permissions**](docs/AuthorizationApi.md#add_role_permissions) | **POST** /roles/{roleId}/permissions | Add permissions to a role.
*AuthorizationApi* | [**add_role_ui_profiles**](docs/AuthorizationApi.md#add_role_ui_profiles) | **POST** /roles/{roleId}/ui-profiles | Add UI profiles to a role.
*AuthorizationApi* | [**add_tags_to_scope**](docs/AuthorizationApi.md#add_tags_to_scope) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/object-tags | Add object tags to the access group scope.
*AuthorizationApi* | [**create_access_group**](docs/AuthorizationApi.md#create_access_group) | **POST** /access-groups | Create a new access group.
*AuthorizationApi* | [**create_role**](docs/AuthorizationApi.md#create_role) | **POST** /roles | Create custom role
*AuthorizationApi* | [**create_role_tags**](docs/AuthorizationApi.md#create_role_tags) | **POST** /roles/{roleId}/tags | Create tags for a role.
*AuthorizationApi* | [**delete_access_group**](docs/AuthorizationApi.md#delete_access_group) | **DELETE** /access-groups/{accessGroupId} | Delete an Access group.
*AuthorizationApi* | [**delete_access_group_scope_object_tags**](docs/AuthorizationApi.md#delete_access_group_scope_object_tags) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/object-tags/delete | Remove tags from the access group scope.
*AuthorizationApi* | [**delete_access_group_scope_objects**](docs/AuthorizationApi.md#delete_access_group_scope_objects) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/objects/delete | Remove objects from the access group scope.
*AuthorizationApi* | [**delete_role**](docs/AuthorizationApi.md#delete_role) | **DELETE** /roles/{roleId} | Delete role by ID.
*AuthorizationApi* | [**delete_role_tag**](docs/AuthorizationApi.md#delete_role_tag) | **POST** /roles/{roleId}/tags/delete | Delete tags for a Role.
*AuthorizationApi* | [**delete_role_ui_profiles**](docs/AuthorizationApi.md#delete_role_ui_profiles) | **POST** /roles/{roleId}/ui-profiles/delete | Delete UI profiles from a Role.
*AuthorizationApi* | [**get_access_group_by_id**](docs/AuthorizationApi.md#get_access_group_by_id) | **GET** /access-groups/{accessGroupId} | Returns an Access group by ID.
*AuthorizationApi* | [**get_access_group_scope**](docs/AuthorizationApi.md#get_access_group_scope) | **GET** /access-groups/{accessGroupId}/scopes/{scopeId} | Get access group scope.
*AuthorizationApi* | [**get_access_groups**](docs/AuthorizationApi.md#get_access_groups) | **GET** /access-groups | List all access groups.
*AuthorizationApi* | [**get_all_object_permissions**](docs/AuthorizationApi.md#get_all_object_permissions) | **GET** /auth/object-permissions | Returns all of the possible permissions for all of the objects.
*AuthorizationApi* | [**get_object_permissions**](docs/AuthorizationApi.md#get_object_permissions) | **GET** /auth/permissions/objects/{objectType}/{objectId} | Returns permissions for given object.
*AuthorizationApi* | [**get_role_by_id**](docs/AuthorizationApi.md#get_role_by_id) | **GET** /roles/{roleId} | Returns role by ID.
*AuthorizationApi* | [**get_role_tags**](docs/AuthorizationApi.md#get_role_tags) | **GET** /roles/{roleId}/tags | Get tags for a Role.
*AuthorizationApi* | [**get_roles**](docs/AuthorizationApi.md#get_roles) | **GET** /roles | List all roles
*AuthorizationApi* | [**remove_access_group_account_id**](docs/AuthorizationApi.md#remove_access_group_account_id) | **DELETE** /access-groups/{accessGroupId}/account-ids/{accountId} | Remove the account from the access group.
*AuthorizationApi* | [**remove_access_group_account_tags**](docs/AuthorizationApi.md#remove_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags/delete | Remove account tags from an access group.
*AuthorizationApi* | [**remove_access_group_scope**](docs/AuthorizationApi.md#remove_access_group_scope) | **DELETE** /access-groups/{accessGroupId}/scopes/{scopeId} | Remove the scope from the Access group.
*AuthorizationApi* | [**remove_always_allowed_permissions**](docs/AuthorizationApi.md#remove_always_allowed_permissions) | **POST** /access-groups/{accessGroupId}/scopes/{scopeId}/always_allowed_permissions/delete | Remove always allowed permissions for given object type.
*AuthorizationApi* | [**remove_role_permissions**](docs/AuthorizationApi.md#remove_role_permissions) | **POST** /roles/{roleId}/permissions/delete | Remove permissions from a role.
*AuthorizationApi* | [**search_access_groups**](docs/AuthorizationApi.md#search_access_groups) | **POST** /access-groups/search | Search for access groups.
*AuthorizationApi* | [**search_roles**](docs/AuthorizationApi.md#search_roles) | **POST** /roles/search | Search for roles.
*AuthorizationApi* | [**update_access_group**](docs/AuthorizationApi.md#update_access_group) | **PATCH** /access-groups/{accessGroupId} | Update an Access group.
*AuthorizationApi* | [**update_access_group_scope**](docs/AuthorizationApi.md#update_access_group_scope) | **PATCH** /access-groups/{accessGroupId}/scopes/{scopeId} | Update access group scope.
*AuthorizationApi* | [**update_role**](docs/AuthorizationApi.md#update_role) | **PATCH** /roles/{roleId} | Update a Role.
*BookmarksApi* | [**create_bookmark**](docs/BookmarksApi.md#create_bookmark) | **POST** /bookmarks | Create a bookmark at the current time.
*BookmarksApi* | [**create_bookmark_tags**](docs/BookmarksApi.md#create_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags | Create tags for a Bookmark.
*BookmarksApi* | [**delete_bookmark**](docs/BookmarksApi.md#delete_bookmark) | **DELETE** /bookmarks/{bookmarkId} | Delete a bookmark.
*BookmarksApi* | [**delete_bookmark_tags**](docs/BookmarksApi.md#delete_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags/delete | Delete tags for a Bookmark.
*BookmarksApi* | [**get_bookmark_by_id**](docs/BookmarksApi.md#get_bookmark_by_id) | **GET** /bookmarks/{bookmarkId} | Get a bookmark by ID.
*BookmarksApi* | [**get_bookmark_tags**](docs/BookmarksApi.md#get_bookmark_tags) | **GET** /bookmarks/{bookmarkId}/tags | Get tags for a Bookmark.
*BookmarksApi* | [**get_bookmarks**](docs/BookmarksApi.md#get_bookmarks) | **GET** /bookmarks | List all bookmarks.
*BookmarksApi* | [**get_vdb_groups_by_bookmark**](docs/BookmarksApi.md#get_vdb_groups_by_bookmark) | **GET** /bookmarks/{bookmarkId}/vdb-groups | List VDB Groups compatible with this bookmark.
*BookmarksApi* | [**import_engine_bookmarks**](docs/BookmarksApi.md#import_engine_bookmarks) | **POST** /bookmarks/import-engine-bookmarks/{engineId} | Import engine bookmarks to DCT.
*BookmarksApi* | [**search_bookmarks**](docs/BookmarksApi.md#search_bookmarks) | **POST** /bookmarks/search | Search for bookmarks.
*BookmarksApi* | [**search_vdb_groups_by_bookmark**](docs/BookmarksApi.md#search_vdb_groups_by_bookmark) | **POST** /bookmarks/{bookmarkId}/vdb-groups/search | Search for VDB Groups compatible with this bookmark.
*BookmarksApi* | [**update_bookmark**](docs/BookmarksApi.md#update_bookmark) | **PATCH** /bookmarks/{bookmarkId} | Update a bookmark
*CDBsApi* | [**attach_cdb**](docs/CDBsApi.md#attach_cdb) | **POST** /cdbs/{cdbId}/attachSource | Attach an Oracle CDB to an Oracle database.
*CDBsApi* | [**create_cdb_tags**](docs/CDBsApi.md#create_cdb_tags) | **POST** /cdbs/{cdbId}/tags | Create tags for a CDB.
*CDBsApi* | [**delete_cdb**](docs/CDBsApi.md#delete_cdb) | **POST** /cdbs/{cdbId}/delete | Delete a CDB.
*CDBsApi* | [**delete_cdb_tags**](docs/CDBsApi.md#delete_cdb_tags) | **POST** /cdbs/{cdbId}/tags/delete | Delete tags for a CDB.
*CDBsApi* | [**detach_cdb**](docs/CDBsApi.md#detach_cdb) | **POST** /cdbs/{cdbId}/detachSource | Detaches an Oracle CDB from an Oracle database.
*CDBsApi* | [**disable_cdb**](docs/CDBsApi.md#disable_cdb) | **POST** /cdbs/{cdbId}/disable | Disable a CDB.
*CDBsApi* | [**enable_cdb**](docs/CDBsApi.md#enable_cdb) | **POST** /cdbs/{cdbId}/enable | Enable a CDB.
*CDBsApi* | [**get_cdb_by_id**](docs/CDBsApi.md#get_cdb_by_id) | **GET** /cdbs/{cdbId} | Get a CDB by ID (Oracle only).
*CDBsApi* | [**get_cdb_deletion_dependencies**](docs/CDBsApi.md#get_cdb_deletion_dependencies) | **GET** /cdbs/{cdbId}/deletion-dependencies | Get deletion dependencies of a CDB.
*CDBsApi* | [**get_cdbs**](docs/CDBsApi.md#get_cdbs) | **GET** /cdbs | List all CDBs (Oracle only).
*CDBsApi* | [**get_tags_cdb**](docs/CDBsApi.md#get_tags_cdb) | **GET** /cdbs/{cdbId}/tags | Get tags for a CDB.
*CDBsApi* | [**search_cdbs**](docs/CDBsApi.md#search_cdbs) | **POST** /cdbs/search | Search for CDBs (Oracle only).
*CDBsApi* | [**update_cdb**](docs/CDBsApi.md#update_cdb) | **PATCH** /cdbs/{cdbId} | Update a CDB.
*CDBsApi* | [**update_cdb_by_id**](docs/CDBsApi.md#update_cdb_by_id) | **PATCH** /cdbs/{cdbId}/update | Update a CDB.
*CDBsApi* | [**upgrade_cdb**](docs/CDBsApi.md#upgrade_cdb) | **POST** /cdbs/{cdbId}/upgrade | Upgrade Oracle CDB
*CDBsApi* | [**verify_cdb_jdbc_connection_string**](docs/CDBsApi.md#verify_cdb_jdbc_connection_string) | **POST** /cdbs/{cdbId}/jdbc-check | Verify JDBC connection string for a CDB.
*ClassifiersApi* | [**create_classifier_tags**](docs/ClassifiersApi.md#create_classifier_tags) | **POST** /classifiers/{classifierId}/tags | Create tags for a classifier.
*ClassifiersApi* | [**delete_classifier_tags**](docs/ClassifiersApi.md#delete_classifier_tags) | **POST** /classifiers/{classifierId}/tags/delete | Delete tags for a classifier.
*ClassifiersApi* | [**get_classifier_by_id**](docs/ClassifiersApi.md#get_classifier_by_id) | **GET** /classifiers/{classifierId} | Get a classifier by ID.
*ClassifiersApi* | [**get_classifier_discovery_policies**](docs/ClassifiersApi.md#get_classifier_discovery_policies) | **GET** /classifiers/{classifierId}/discovery-policies | Get discovery policies for a classifier.
*ClassifiersApi* | [**get_classifier_tags**](docs/ClassifiersApi.md#get_classifier_tags) | **GET** /classifiers/{classifierId}/tags | Get tags for a classifier.
*ClassifiersApi* | [**get_classifiers**](docs/ClassifiersApi.md#get_classifiers) | **GET** /classifiers | Retrieve classifiers.
*ClassifiersApi* | [**search_classifier_discovery_policies**](docs/ClassifiersApi.md#search_classifier_discovery_policies) | **POST** /classifiers/{classifierId}/discovery-policies/search | Search discovery policies for a classifier.
*ClassifiersApi* | [**search_classifiers**](docs/ClassifiersApi.md#search_classifiers) | **POST** /classifiers/search | Search for classifiers.
*ComplianceJobCollectionsApi* | [**create_compliance_job_collection**](docs/ComplianceJobCollectionsApi.md#create_compliance_job_collection) | **POST** /compliance-job-collections | Create a compliance job collection.
*ComplianceJobCollectionsApi* | [**create_compliance_job_collection_tags**](docs/ComplianceJobCollectionsApi.md#create_compliance_job_collection_tags) | **POST** /compliance-job-collections/{complianceJobCollectionId}/tags | Create tags for a compliance job collection.
*ComplianceJobCollectionsApi* | [**delete_compliance_job_collection**](docs/ComplianceJobCollectionsApi.md#delete_compliance_job_collection) | **DELETE** /compliance-job-collections/{complianceJobCollectionId} | Delete a compliance job collection.
*ComplianceJobCollectionsApi* | [**delete_compliance_job_collection_tags**](docs/ComplianceJobCollectionsApi.md#delete_compliance_job_collection_tags) | **POST** /compliance-job-collections/{complianceJobCollectionId}/tags/delete | Delete tags for a compliance job collection.
*ComplianceJobCollectionsApi* | [**execute_compliance_job_collection**](docs/ComplianceJobCollectionsApi.md#execute_compliance_job_collection) | **POST** /compliance-job-collections/{complianceJobCollectionId}/execute | Execute a compliance job collection.
*ComplianceJobCollectionsApi* | [**get_compliance_job_collection_by_id**](docs/ComplianceJobCollectionsApi.md#get_compliance_job_collection_by_id) | **GET** /compliance-job-collections/{complianceJobCollectionId} | Retrieve a compliance job collection by ID.
*ComplianceJobCollectionsApi* | [**get_compliance_job_collection_jobs**](docs/ComplianceJobCollectionsApi.md#get_compliance_job_collection_jobs) | **GET** /compliance-job-collections/{complianceJobCollectionId}/jobs | Get compliance jobs for a compliance job collection.
*ComplianceJobCollectionsApi* | [**get_compliance_job_collection_tags**](docs/ComplianceJobCollectionsApi.md#get_compliance_job_collection_tags) | **GET** /compliance-job-collections/{complianceJobCollectionId}/tags | Get tags for a compliance job collection.
*ComplianceJobCollectionsApi* | [**get_compliance_job_collections**](docs/ComplianceJobCollectionsApi.md#get_compliance_job_collections) | **GET** /compliance-job-collections | Retrieve the list of compliance job collections.
*ComplianceJobCollectionsApi* | [**search_compliance_job_collection_jobs**](docs/ComplianceJobCollectionsApi.md#search_compliance_job_collection_jobs) | **POST** /compliance-job-collections/{complianceJobCollectionId}/jobs/search | Search compliance jobs for a compliance job collection.
*ComplianceJobCollectionsApi* | [**search_compliance_job_collections**](docs/ComplianceJobCollectionsApi.md#search_compliance_job_collections) | **POST** /compliance-job-collections/search | Search compliance job collections.
*ComplianceJobCollectionsApi* | [**update_compliance_job_collection**](docs/ComplianceJobCollectionsApi.md#update_compliance_job_collection) | **PATCH** /compliance-job-collections/{complianceJobCollectionId} | Update a compliance job collection.
*ComplianceJobsApi* | [**create_compliance_job_tag**](docs/ComplianceJobsApi.md#create_compliance_job_tag) | **POST** /compliance-jobs/{complianceJobId}/tags | Create tags for a compliance job.
*ComplianceJobsApi* | [**delete_compliance_job_tag**](docs/ComplianceJobsApi.md#delete_compliance_job_tag) | **POST** /compliance-jobs/{complianceJobId}/tags/delete | Delete tags for a compliance job.
*ComplianceJobsApi* | [**execute_compliance_job**](docs/ComplianceJobsApi.md#execute_compliance_job) | **POST** /compliance-jobs/{complianceJobId}/execute | Execute a compliance job.
*ComplianceJobsApi* | [**get_compliance_job_by_id**](docs/ComplianceJobsApi.md#get_compliance_job_by_id) | **GET** /compliance-jobs/{complianceJobId} | Retrieve a compliance job by ID.
*ComplianceJobsApi* | [**get_compliance_job_connectors**](docs/ComplianceJobsApi.md#get_compliance_job_connectors) | **GET** /compliance-jobs/{complianceJobId}/connectors | Get connectors for a Masking Job by ID.
*ComplianceJobsApi* | [**get_compliance_job_tag**](docs/ComplianceJobsApi.md#get_compliance_job_tag) | **GET** /compliance-jobs/{complianceJobId}/tags | Get tags for a compliance job.
*ComplianceJobsApi* | [**get_compliance_jobs**](docs/ComplianceJobsApi.md#get_compliance_jobs) | **GET** /compliance-jobs | Retrieve the list of compliance jobs.
*ComplianceJobsApi* | [**search_compliance_jobs**](docs/ComplianceJobsApi.md#search_compliance_jobs) | **POST** /compliance-jobs/search | Search compliance jobs.
*ConnectivityApi* | [**commvault_connectivity_check**](docs/ConnectivityApi.md#commvault_connectivity_check) | **POST** /commvault/connectivity/check | Tests whether the CommServe host is accessible from the given environment and Commvault agent.
*ConnectivityApi* | [**connectivity_check**](docs/ConnectivityApi.md#connectivity_check) | **POST** /connectivity/check | Checks connectivity between an engine and a remote host machine on a given port.
*ConnectivityApi* | [**database_connectivity_check**](docs/ConnectivityApi.md#database_connectivity_check) | **POST** /database/connectivity/check | Tests the validity of the supplied database credentials, returning an error if unable to connect to the database.
*ConnectivityApi* | [**netbackup_connectivity_check**](docs/ConnectivityApi.md#netbackup_connectivity_check) | **POST** /netbackup/connectivity/check | Checks whether the specified NetBackup master server and client are able to communicate on the given environment.
*ConnectorsApi* | [**connectors_test**](docs/ConnectorsApi.md#connectors_test) | **POST** /connectors/{connectorId}/test | Checks connectivity between a masking engine and a remote data source.
*ConnectorsApi* | [**create_connector_tags**](docs/ConnectorsApi.md#create_connector_tags) | **POST** /connectors/{connectorId}/tags | Create tags for a Connector.
*ConnectorsApi* | [**delete_connector_tag**](docs/ConnectorsApi.md#delete_connector_tag) | **POST** /connectors/{connectorId}/tags/delete | Delete tags for a Connector.
*ConnectorsApi* | [**get_connector_by_id**](docs/ConnectorsApi.md#get_connector_by_id) | **GET** /connectors/{connectorId} | Retrieve a masking Connector by ID.
*ConnectorsApi* | [**get_connector_tags**](docs/ConnectorsApi.md#get_connector_tags) | **GET** /connectors/{connectorId}/tags | Get tags for a Connector.
*ConnectorsApi* | [**get_connectors**](docs/ConnectorsApi.md#get_connectors) | **GET** /connectors | Retrieve the list of masking connectors.
*ConnectorsApi* | [**search_connector_jobs**](docs/ConnectorsApi.md#search_connector_jobs) | **POST** /connectors/{connectorId}/masking-jobs/search | Search jobs that use this connector
*ConnectorsApi* | [**search_connectors**](docs/ConnectorsApi.md#search_connectors) | **POST** /connectors/search | Search for masking Connectors.
*ConnectorsApi* | [**update_connector_by_id**](docs/ConnectorsApi.md#update_connector_by_id) | **PATCH** /connectors/{connectorId} | Update a masking Connector by ID.
*DSourcesApi* | [**attach_mssql_database**](docs/DSourcesApi.md#attach_mssql_database) | **POST** /dsources/mssql/{dsourceId}/attachSource | Attaches a MSSql source to a previously detached dsource.
*DSourcesApi* | [**attach_mssql_staging_push_database**](docs/DSourcesApi.md#attach_mssql_staging_push_database) | **POST** /dsources/mssql/staging-push/{dsourceId}/attachSource | Attaches a MSSql staging push database to a previously detached dsource.
*DSourcesApi* | [**attach_oracle_dsource**](docs/DSourcesApi.md#attach_oracle_dsource) | **POST** /dsources/oracle/{dsourceId}/attachSource | Attach an Oracle dSource to an Oracle database.
*DSourcesApi* | [**create_tags_dsource**](docs/DSourcesApi.md#create_tags_dsource) | **POST** /dsources/{dsourceId}/tags | Create tags for a dSource.
*DSourcesApi* | [**delete_dsource**](docs/DSourcesApi.md#delete_dsource) | **POST** /dsources/delete | Delete the specified dSource.
*DSourcesApi* | [**delete_tags_dsource**](docs/DSourcesApi.md#delete_tags_dsource) | **POST** /dsources/{dsourceId}/tags/delete | Delete tags for a dSource.
*DSourcesApi* | [**detach_mssql_database**](docs/DSourcesApi.md#detach_mssql_database) | **POST** /dsources/mssql/{dsourceId}/detachSource | Detaches a linked source from a MSSql database.
*DSourcesApi* | [**detach_oracle_dsource**](docs/DSourcesApi.md#detach_oracle_dsource) | **POST** /dsources/oracle/{dsourceId}/detachSource | Detaches an Oracle source from an Oracle database.
*DSourcesApi* | [**disable_dsource**](docs/DSourcesApi.md#disable_dsource) | **POST** /dsources/{dsourceId}/disable | Disable a dSource.
*DSourcesApi* | [**enable_dsource**](docs/DSourcesApi.md#enable_dsource) | **POST** /dsources/{dsourceId}/enable | Enable a dSource.
*DSourcesApi* | [**get_appdata_dsource_linking_defaults**](docs/DSourcesApi.md#get_appdata_dsource_linking_defaults) | **POST** /dsources/appdata/defaults | Get defaults for an AppData dSource linking.
*DSourcesApi* | [**get_ase_dsource_linking_defaults**](docs/DSourcesApi.md#get_ase_dsource_linking_defaults) | **POST** /dsources/ase/defaults | Get defaults for an ASE dSource linking.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsource_deletion_dependencies**](docs/DSourcesApi.md#get_dsource_deletion_dependencies) | **GET** /dsources/{dsourceId}/deletion-dependencies | Get deletion dependencies for a dSource.
*DSourcesApi* | [**get_dsource_snapshots**](docs/DSourcesApi.md#get_dsource_snapshots) | **GET** /dsources/{dsourceId}/snapshots | List Snapshots for a dSource.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*DSourcesApi* | [**get_mssql_dsource_linking_defaults**](docs/DSourcesApi.md#get_mssql_dsource_linking_defaults) | **POST** /dsources/mssql/defaults | Get defaults for a MSSql dSource linking.
*DSourcesApi* | [**get_mssql_staging_push_dsource_linking_defaults**](docs/DSourcesApi.md#get_mssql_staging_push_dsource_linking_defaults) | **POST** /dsources/mssql/staging-push/defaults | Get defaults for a MSSql staging push dSource linking.
*DSourcesApi* | [**get_oracle_dsource_linking_defaults**](docs/DSourcesApi.md#get_oracle_dsource_linking_defaults) | **POST** /dsources/oracle/defaults | Get defaults for dSource linking.
*DSourcesApi* | [**get_oracle_staging_push_dsource_linking_defaults**](docs/DSourcesApi.md#get_oracle_staging_push_dsource_linking_defaults) | **POST** /dsources/oracle/staging-push/defaults | Get defaults for a Oracle staging push dSource linking.
*DSourcesApi* | [**get_tags_dsource**](docs/DSourcesApi.md#get_tags_dsource) | **GET** /dsources/{dsourceId}/tags | Get tags for a dSource.
*DSourcesApi* | [**link_appdata_database**](docs/DSourcesApi.md#link_appdata_database) | **POST** /dsources/appdata | Link an AppData database as dSource.
*DSourcesApi* | [**link_ase_database**](docs/DSourcesApi.md#link_ase_database) | **POST** /dsources/ase | Link an ASE database as dSource.
*DSourcesApi* | [**link_mssql_database**](docs/DSourcesApi.md#link_mssql_database) | **POST** /dsources/mssql | Link a MSSql database as dSource.
*DSourcesApi* | [**link_mssql_staging_push_database**](docs/DSourcesApi.md#link_mssql_staging_push_database) | **POST** /dsources/mssql/staging-push | Link a MSSql staging push database as dSource.
*DSourcesApi* | [**link_oracle_database**](docs/DSourcesApi.md#link_oracle_database) | **POST** /dsources/oracle | Link Oracle database as dSource.
*DSourcesApi* | [**link_oracle_staging_push_database**](docs/DSourcesApi.md#link_oracle_staging_push_database) | **POST** /dsources/oracle/staging-push | Link an Oracle staging push database as dSource.
*DSourcesApi* | [**search_dsources**](docs/DSourcesApi.md#search_dsources) | **POST** /dsources/search | Search for dSources.
*DSourcesApi* | [**snapshot_dsource**](docs/DSourcesApi.md#snapshot_dsource) | **POST** /dsources/{dsourceId}/snapshots | Snapshot a dSource.
*DSourcesApi* | [**update_appdata_dsource_by_id**](docs/DSourcesApi.md#update_appdata_dsource_by_id) | **PATCH** /dsources/appdata/{dsourceId} | Update values of an AppData dSource
*DSourcesApi* | [**update_mssql_dsource_by_id**](docs/DSourcesApi.md#update_mssql_dsource_by_id) | **PATCH** /dsources/mssql/{dsourceId} | Update values of an MSSql dSource
*DSourcesApi* | [**update_oracle_dsource_by_id**](docs/DSourcesApi.md#update_oracle_dsource_by_id) | **PATCH** /dsources/oracle/{dsourceId} | Update values of an Oracle dSource
*DSourcesApi* | [**upgrade_oracle_dsource**](docs/DSourcesApi.md#upgrade_oracle_dsource) | **POST** /dsources/oracle/{dsourceId}/upgrade | Upgrade the requested Oracle dSource installation and user.
*DataLayoutsApi* | [**convert_and_drop_bookmarks**](docs/DataLayoutsApi.md#convert_and_drop_bookmarks) | **POST** /data-layouts/{dataLayoutId}/convert-and-drop | Convert and drop engine bookmarks and vdb groups for the data-layout.
*DataLayoutsApi* | [**create_data_layout_tags**](docs/DataLayoutsApi.md#create_data_layout_tags) | **POST** /data-layouts/{dataLayoutId}/tags | Create tags for a data-layout.
*DataLayoutsApi* | [**delete_data_layout_tags**](docs/DataLayoutsApi.md#delete_data_layout_tags) | **POST** /data-layouts/{dataLayoutId}/tags/delete | Delete tags for a data-layout.
*DataLayoutsApi* | [**get_data_layout_by_id**](docs/DataLayoutsApi.md#get_data_layout_by_id) | **GET** /data-layouts/{dataLayoutId} | Get a data-layout by ID.
*DataLayoutsApi* | [**get_data_layout_tags**](docs/DataLayoutsApi.md#get_data_layout_tags) | **GET** /data-layouts/{dataLayoutId}/tags | Get tags for a data-layout.
*DataLayoutsApi* | [**get_data_layouts**](docs/DataLayoutsApi.md#get_data_layouts) | **GET** /data-layouts | List all data-layout (Self-Service Container/Template).
*DataLayoutsApi* | [**import_engine_accounts**](docs/DataLayoutsApi.md#import_engine_accounts) | **POST** /data-layouts/import-engine-accounts | Import engine (self-service) accounts.
*DataLayoutsApi* | [**search_data_layouts**](docs/DataLayoutsApi.md#search_data_layouts) | **POST** /data-layouts/search | Search for data-layouts.
*DataClassesApi* | [**create_data_class_tags**](docs/DataClassesApi.md#create_data_class_tags) | **POST** /data-classes/{dataClassId}/tags | Create tags for a Data Class.
*DataClassesApi* | [**delete_data_class_tags**](docs/DataClassesApi.md#delete_data_class_tags) | **POST** /data-classes/{dataClassId}/tags/delete | Delete tags for a Data Class.
*DataClassesApi* | [**get_data_class_algorithms**](docs/DataClassesApi.md#get_data_class_algorithms) | **GET** /data-classes/{dataClassId}/algorithms | Retrieve the list of algorithms for a Data Class.
*DataClassesApi* | [**get_data_class_by_id**](docs/DataClassesApi.md#get_data_class_by_id) | **GET** /data-classes/{dataClassId} | Get a Data Class by ID.
*DataClassesApi* | [**get_data_class_tags**](docs/DataClassesApi.md#get_data_class_tags) | **GET** /data-classes/{dataClassId}/tags | Get tags for a Data Class.
*DataClassesApi* | [**get_data_classes**](docs/DataClassesApi.md#get_data_classes) | **GET** /data-classes | Retrieve the list of Data Classes.
*DataClassesApi* | [**search_data_class_algorithms**](docs/DataClassesApi.md#search_data_class_algorithms) | **POST** /data-classes/{dataClassId}/algorithms/search | Search for algorithms of a Data Class.
*DataClassesApi* | [**search_data_classes**](docs/DataClassesApi.md#search_data_classes) | **POST** /data-classes/search | Search for Data Classes.
*DataClassesApi* | [**update_data_class**](docs/DataClassesApi.md#update_data_class) | **PATCH** /data-classes/{dataClassId} | Update a Data Class.
*DatabaseTemplatesApi* | [**create_database_template**](docs/DatabaseTemplatesApi.md#create_database_template) | **POST** /database-templates | Create a database template.
*DatabaseTemplatesApi* | [**create_database_template_tags**](docs/DatabaseTemplatesApi.md#create_database_template_tags) | **POST** /database-templates/{databaseTemplateId}/tags | Create tags for a DatabaseTemplate.
*DatabaseTemplatesApi* | [**delete_database_template**](docs/DatabaseTemplatesApi.md#delete_database_template) | **DELETE** /database-templates/{databaseTemplateId} | Delete a DatabaseTemplate by ID.
*DatabaseTemplatesApi* | [**delete_database_template_tag**](docs/DatabaseTemplatesApi.md#delete_database_template_tag) | **POST** /database-templates/{databaseTemplateId}/tags/delete | Delete tags for a DatabaseTemplate.
*DatabaseTemplatesApi* | [**get_database_template_by_id**](docs/DatabaseTemplatesApi.md#get_database_template_by_id) | **GET** /database-templates/{databaseTemplateId} | Retrieve a DatabaseTemplate by ID.
*DatabaseTemplatesApi* | [**get_database_template_tags**](docs/DatabaseTemplatesApi.md#get_database_template_tags) | **GET** /database-templates/{databaseTemplateId}/tags | Get tags for a DatabaseTemplate.
*DatabaseTemplatesApi* | [**get_database_templates**](docs/DatabaseTemplatesApi.md#get_database_templates) | **GET** /database-templates | Retrieve the list of database templates.
*DatabaseTemplatesApi* | [**import_database_templates**](docs/DatabaseTemplatesApi.md#import_database_templates) | **POST** /database-templates/import | Imports the database templates from an engine.
*DatabaseTemplatesApi* | [**search_database_templates**](docs/DatabaseTemplatesApi.md#search_database_templates) | **POST** /database-templates/search | Search DatabaseTemplates.
*DatabaseTemplatesApi* | [**undo_import_database_templates**](docs/DatabaseTemplatesApi.md#undo_import_database_templates) | **POST** /database-templates/undo-import | Undo an import of DatabaseTemplates on an Engine.
*DatabaseTemplatesApi* | [**update_database_template**](docs/DatabaseTemplatesApi.md#update_database_template) | **PATCH** /database-templates/{databaseTemplateId} | Updates a DatabaseTemplate by ID
*DiscoveryExpressionsApi* | [**create_discovery_expression_tags**](docs/DiscoveryExpressionsApi.md#create_discovery_expression_tags) | **POST** /discovery-expressions/{expressionId}/tags | Create tags for a discovery expression.
*DiscoveryExpressionsApi* | [**delete_discovery_expression_tags**](docs/DiscoveryExpressionsApi.md#delete_discovery_expression_tags) | **POST** /discovery-expressions/{expressionId}/tags/delete | Delete tags for a discovery expression.
*DiscoveryExpressionsApi* | [**get_discovery_expression_by_id**](docs/DiscoveryExpressionsApi.md#get_discovery_expression_by_id) | **GET** /discovery-expressions/{expressionId} | Get a discovery expression by ID.
*DiscoveryExpressionsApi* | [**get_discovery_expression_tags**](docs/DiscoveryExpressionsApi.md#get_discovery_expression_tags) | **GET** /discovery-expressions/{expressionId}/tags | Get tags for a discovery expression.
*DiscoveryExpressionsApi* | [**get_discovery_expressions**](docs/DiscoveryExpressionsApi.md#get_discovery_expressions) | **GET** /discovery-expressions | Retrieve discovery expressions.
*DiscoveryExpressionsApi* | [**search_discovery_expressions**](docs/DiscoveryExpressionsApi.md#search_discovery_expressions) | **POST** /discovery-expressions/search | Search discovery expressions.
*DiscoveryPoliciesApi* | [**create_discovery_policy_tags**](docs/DiscoveryPoliciesApi.md#create_discovery_policy_tags) | **POST** /discovery-policies/{discoveryPolicyId}/tags | Create tags for a discovery policy.
*DiscoveryPoliciesApi* | [**delete_discovery_policy_tags**](docs/DiscoveryPoliciesApi.md#delete_discovery_policy_tags) | **POST** /discovery-policies/{discoveryPolicyId}/tags/delete | Delete tags for a discovery policy.
*DiscoveryPoliciesApi* | [**get_discovery_policies**](docs/DiscoveryPoliciesApi.md#get_discovery_policies) | **GET** /discovery-policies | Retrieve discovery policies.
*DiscoveryPoliciesApi* | [**get_discovery_policy_by_id**](docs/DiscoveryPoliciesApi.md#get_discovery_policy_by_id) | **GET** /discovery-policies/{discoveryPolicyId} | Get a discovery policy by ID.
*DiscoveryPoliciesApi* | [**get_discovery_policy_classifiers**](docs/DiscoveryPoliciesApi.md#get_discovery_policy_classifiers) | **GET** /discovery-policies/{discoveryPolicyId}/classifiers | Get classifiers for a discovery policy.
*DiscoveryPoliciesApi* | [**get_discovery_policy_expressions**](docs/DiscoveryPoliciesApi.md#get_discovery_policy_expressions) | **GET** /discovery-policies/{discoveryPolicyId}/expressions | Get discovery expressions for a discovery policy.
*DiscoveryPoliciesApi* | [**get_discovery_policy_tags**](docs/DiscoveryPoliciesApi.md#get_discovery_policy_tags) | **GET** /discovery-policies/{discoveryPolicyId}/tags | Get tags for a discovery policy.
*DiscoveryPoliciesApi* | [**search_discovery_policies**](docs/DiscoveryPoliciesApi.md#search_discovery_policies) | **POST** /discovery-policies/search | Search for discovery policies.
*DiscoveryPoliciesApi* | [**search_discovery_policy_classifiers**](docs/DiscoveryPoliciesApi.md#search_discovery_policy_classifiers) | **POST** /discovery-policies/{discoveryPolicyId}/classifiers/search | Search for classifiers of a discovery policy.
*DiscoveryPoliciesApi* | [**search_discovery_policy_expressions**](docs/DiscoveryPoliciesApi.md#search_discovery_policy_expressions) | **POST** /discovery-policies/{discoveryPolicyId}/expressions/search | Search for discovery expressions of a discovery policy.
*EnvironmentsApi* | [**compatible_repositories_by_location**](docs/EnvironmentsApi.md#compatible_repositories_by_location) | **POST** /environments/compatible_repositories_by_location | Get compatible repositories corresponding to the location.
*EnvironmentsApi* | [**compatible_repositories_by_snapshot**](docs/EnvironmentsApi.md#compatible_repositories_by_snapshot) | **POST** /environments/compatible_repositories_by_snapshot | Get compatible repositories corresponding to the snapshot.
*EnvironmentsApi* | [**compatible_repositories_by_timestamp**](docs/EnvironmentsApi.md#compatible_repositories_by_timestamp) | **POST** /environments/compatible_repositories_by_timestamp | Get compatible repositories corresponding to the timestamp.
*EnvironmentsApi* | [**compatible_repositories_from_bookmark**](docs/EnvironmentsApi.md#compatible_repositories_from_bookmark) | **POST** /environments/compatible_repositories_from_bookmark | Get compatible repositories corresponding to the bookmark.
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /environments | Create an environment.
*EnvironmentsApi* | [**create_environment_tags**](docs/EnvironmentsApi.md#create_environment_tags) | **POST** /environments/{environmentId}/tags | Create tags for an Environment.
*EnvironmentsApi* | [**create_environment_user**](docs/EnvironmentsApi.md#create_environment_user) | **POST** /environments/{environmentId}/users | Create environment user.
*EnvironmentsApi* | [**create_host**](docs/EnvironmentsApi.md#create_host) | **POST** /environments/{environmentId}/hosts | Create a new Host.
*EnvironmentsApi* | [**create_oracle_listener**](docs/EnvironmentsApi.md#create_oracle_listener) | **POST** /environments/{environmentId}/listeners | Create Oracle listener.
*EnvironmentsApi* | [**create_repository**](docs/EnvironmentsApi.md#create_repository) | **POST** /environments/{environmentId}/repository | Create a repository.
*EnvironmentsApi* | [**delete_environment**](docs/EnvironmentsApi.md#delete_environment) | **DELETE** /environments/{environmentId} | Delete an environment by ID.
*EnvironmentsApi* | [**delete_environment_tags**](docs/EnvironmentsApi.md#delete_environment_tags) | **POST** /environments/{environmentId}/tags/delete | Delete tags for an Environment.
*EnvironmentsApi* | [**delete_environment_user**](docs/EnvironmentsApi.md#delete_environment_user) | **DELETE** /environments/{environmentId}/users/{userRef} | Delete environment user.
*EnvironmentsApi* | [**delete_host**](docs/EnvironmentsApi.md#delete_host) | **DELETE** /environments/{environmentId}/hosts/{hostId} | Delete a Host.
*EnvironmentsApi* | [**delete_oracle_listener**](docs/EnvironmentsApi.md#delete_oracle_listener) | **DELETE** /environments/{environmentId}/listeners/{listenerId} | Delete an Oracle listener.
*EnvironmentsApi* | [**delete_repository**](docs/EnvironmentsApi.md#delete_repository) | **DELETE** /environments/{environmentId}/repository/{repositoryId} | Delete a repository.
*EnvironmentsApi* | [**disable_environment**](docs/EnvironmentsApi.md#disable_environment) | **POST** /environments/{environmentId}/disable | Disable environment.
*EnvironmentsApi* | [**enable_environment**](docs/EnvironmentsApi.md#enable_environment) | **POST** /environments/{environmentId}/enable | Enable a disabled environment.
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /environments/{environmentId} | Returns an environment by ID.
*EnvironmentsApi* | [**get_environments**](docs/EnvironmentsApi.md#get_environments) | **GET** /environments | List all environments.
*EnvironmentsApi* | [**get_tags_environment**](docs/EnvironmentsApi.md#get_tags_environment) | **GET** /environments/{environmentId}/tags | Get tags for an Environment.
*EnvironmentsApi* | [**list_environment_users**](docs/EnvironmentsApi.md#list_environment_users) | **GET** /environments/{environmentId}/users | List environment users.
*EnvironmentsApi* | [**primary_environment_user**](docs/EnvironmentsApi.md#primary_environment_user) | **POST** /environments/{environmentId}/users/{userRef}/primary | Set primary environment user.
*EnvironmentsApi* | [**refresh_environment**](docs/EnvironmentsApi.md#refresh_environment) | **POST** /environments/{environmentId}/refresh | Refresh environment.
*EnvironmentsApi* | [**search_environments**](docs/EnvironmentsApi.md#search_environments) | **POST** /environments/search | Search for environments.
*EnvironmentsApi* | [**update_environment**](docs/EnvironmentsApi.md#update_environment) | **PATCH** /environments/{environmentId} | Update an environment by ID.
*EnvironmentsApi* | [**update_environment_user**](docs/EnvironmentsApi.md#update_environment_user) | **PUT** /environments/{environmentId}/users/{userRef} | Update environment user.
*EnvironmentsApi* | [**update_host**](docs/EnvironmentsApi.md#update_host) | **PATCH** /environments/{environmentId}/hosts/{hostId} | Update a Host.
*EnvironmentsApi* | [**update_oracle_listener**](docs/EnvironmentsApi.md#update_oracle_listener) | **PATCH** /environments/{environmentId}/listeners/{listenerId} | Update an Oracle listener.
*EnvironmentsApi* | [**update_repository**](docs/EnvironmentsApi.md#update_repository) | **PATCH** /environments/{environmentId}/repository/{repositoryId} | Update a Repository.
*ExecutionsApi* | [**cancel_execution**](docs/ExecutionsApi.md#cancel_execution) | **POST** /executions/{executionId}/cancel | Cancel an Execution.
*ExecutionsApi* | [**cleanup_execution**](docs/ExecutionsApi.md#cleanup_execution) | **POST** /executions/{executionId}/cleanup | Cleanup an Execution (Hyperscale only).
*ExecutionsApi* | [**get_discovery_results**](docs/ExecutionsApi.md#get_discovery_results) | **GET** /executions/{executionId}/discovery-results | Retrieve the list of discovery results for a masking execution.
*ExecutionsApi* | [**get_execution_by_id**](docs/ExecutionsApi.md#get_execution_by_id) | **GET** /executions/{executionId} | Retrieve an Execution by ID.
*ExecutionsApi* | [**get_execution_component_by_id**](docs/ExecutionsApi.md#get_execution_component_by_id) | **GET** /executions/{executionId}/execution-components/{executionComponentId} | Get an execution component by ID.
*ExecutionsApi* | [**get_execution_component_log**](docs/ExecutionsApi.md#get_execution_component_log) | **GET** /executions/{executionId}/execution-components/{executionComponentId}/log | Get an execution component log.
*ExecutionsApi* | [**get_execution_components**](docs/ExecutionsApi.md#get_execution_components) | **GET** /executions/{executionId}/execution-components | Get execution components for an execution.
*ExecutionsApi* | [**get_execution_events**](docs/ExecutionsApi.md#get_execution_events) | **GET** /executions/{executionId}/events | Retrieve the list of events for a masking execution.
*ExecutionsApi* | [**get_execution_log**](docs/ExecutionsApi.md#get_execution_log) | **GET** /executions/{executionId}/log | Retrieve the masking execution log.
*ExecutionsApi* | [**get_executions**](docs/ExecutionsApi.md#get_executions) | **GET** /executions | Retrieve the list of masking executions.
*ExecutionsApi* | [**restart_execution**](docs/ExecutionsApi.md#restart_execution) | **POST** /executions/{executionId}/restart | Restart an Execution (Hyperscale only).
*ExecutionsApi* | [**search_discovery_results**](docs/ExecutionsApi.md#search_discovery_results) | **POST** /executions/{executionId}/discovery-results/search | Search discovery results associated with execution of a discovery job
*ExecutionsApi* | [**search_execution_components**](docs/ExecutionsApi.md#search_execution_components) | **POST** /executions/{executionId}/execution-components/search | Search execution components for an execution.
*ExecutionsApi* | [**search_execution_events**](docs/ExecutionsApi.md#search_execution_events) | **POST** /executions/{executionId}/events/search | Search masking executions events.
*ExecutionsApi* | [**search_executions**](docs/ExecutionsApi.md#search_executions) | **POST** /executions/search | Search masking executions.
*GroupsApi* | [**get_dataset_group_by_id**](docs/GroupsApi.md#get_dataset_group_by_id) | **GET** /groups/{groupId} | Get a dataset group by ID or Name.
*GroupsApi* | [**get_dataset_groups**](docs/GroupsApi.md#get_dataset_groups) | **GET** /groups | List all dataset groups.
*GroupsApi* | [**search_dataset_groups**](docs/GroupsApi.md#search_dataset_groups) | **POST** /groups/search | Search for dataset groups.
*HyperscaleInstanceApi* | [**add_engine_to_hyperscale_instance**](docs/HyperscaleInstanceApi.md#add_engine_to_hyperscale_instance) | **POST** /hyperscale-instances/{hyperscaleInstanceId}/add-engine | Add an engine to a Hyperscale Instance.
*HyperscaleInstanceApi* | [**create_hyperscale_instance_tags**](docs/HyperscaleInstanceApi.md#create_hyperscale_instance_tags) | **POST** /hyperscale-instances/{hyperscaleInstanceId}/tags | Create tags for a Hyperscale Instance.
*HyperscaleInstanceApi* | [**delete_hyperscale_instance_tags**](docs/HyperscaleInstanceApi.md#delete_hyperscale_instance_tags) | **POST** /hyperscale-instances/{hyperscaleInstanceId}/tags/delete | Delete tags for a Hyperscale Instance.
*HyperscaleInstanceApi* | [**get_hyperscale_instance_by_id**](docs/HyperscaleInstanceApi.md#get_hyperscale_instance_by_id) | **GET** /hyperscale-instances/{hyperscaleInstanceId} | Returns a Hyperscale Instance by ID.
*HyperscaleInstanceApi* | [**get_hyperscale_instance_tags**](docs/HyperscaleInstanceApi.md#get_hyperscale_instance_tags) | **GET** /hyperscale-instances/{hyperscaleInstanceId}/tags | Get tags for a Hyperscale Instance.
*HyperscaleInstanceApi* | [**get_hyperscale_instances**](docs/HyperscaleInstanceApi.md#get_hyperscale_instances) | **GET** /hyperscale-instances | Returns a list of Hyperscale instances.
*HyperscaleInstanceApi* | [**register_hyperscale_instance**](docs/HyperscaleInstanceApi.md#register_hyperscale_instance) | **POST** /hyperscale-instances | Register a Hyperscale instance
*HyperscaleInstanceApi* | [**remove_engine_from_hyperscale_instance**](docs/HyperscaleInstanceApi.md#remove_engine_from_hyperscale_instance) | **POST** /hyperscale-instances/{hyperscaleInstanceId}/remove-engine | Remove an engine from a Hyperscale Instance.
*HyperscaleInstanceApi* | [**search_hyperscale_instances**](docs/HyperscaleInstanceApi.md#search_hyperscale_instances) | **POST** /hyperscale-instances/search | Search for Hyperscale instances.
*HyperscaleInstanceApi* | [**sync_engines_hyperscale_instance**](docs/HyperscaleInstanceApi.md#sync_engines_hyperscale_instance) | **POST** /hyperscale-instances/{hyperscaleInstanceId}/sync-engines | Sync the global object from a source engine to engines on a Hyperscale Instance.
*HyperscaleInstanceApi* | [**unregister_hyperscale_instance**](docs/HyperscaleInstanceApi.md#unregister_hyperscale_instance) | **DELETE** /hyperscale-instances/{hyperscaleInstanceId} | Unregister a Hyperscale Instance.
*HyperscaleInstanceApi* | [**update_hyperscale_instance**](docs/HyperscaleInstanceApi.md#update_hyperscale_instance) | **PATCH** /hyperscale-instances/{hyperscaleInstanceId} | Update an Hyperscale Instance
*HyperscaleObjectsApi* | [**create_hyperscale_connector**](docs/HyperscaleObjectsApi.md#create_hyperscale_connector) | **POST** /hyperscale-connectors | Create a Hyperscale Connector.
*HyperscaleObjectsApi* | [**create_hyperscale_connector_tags**](docs/HyperscaleObjectsApi.md#create_hyperscale_connector_tags) | **POST** /hyperscale-connectors/{hyperscaleConnectorId}/tags | Create tags for a Hyperscale Connector.
*HyperscaleObjectsApi* | [**create_hyperscale_dataset_tags**](docs/HyperscaleObjectsApi.md#create_hyperscale_dataset_tags) | **POST** /hyperscale-datasets/{hyperscaleDatasetId}/tags | Create tags for a Hyperscale Dataset.
*HyperscaleObjectsApi* | [**create_hyperscale_mount_point**](docs/HyperscaleObjectsApi.md#create_hyperscale_mount_point) | **POST** /hyperscale-mount-points | Create a Hyperscale Mount Point
*HyperscaleObjectsApi* | [**delete_hyperscale_connector**](docs/HyperscaleObjectsApi.md#delete_hyperscale_connector) | **DELETE** /hyperscale-connectors/{hyperscaleConnectorId} | Delete a Hyperscale Connector.
*HyperscaleObjectsApi* | [**delete_hyperscale_connector_tags**](docs/HyperscaleObjectsApi.md#delete_hyperscale_connector_tags) | **POST** /hyperscale-connectors/{hyperscaleConnectorId}/tags/delete | Delete tags for a Hyperscale Connector.
*HyperscaleObjectsApi* | [**delete_hyperscale_dataset_tags**](docs/HyperscaleObjectsApi.md#delete_hyperscale_dataset_tags) | **POST** /hyperscale-datasets/{hyperscaleDatasetId}/tags/delete | Delete tags for a Hyperscale Dataset.
*HyperscaleObjectsApi* | [**delete_hyperscale_mount_point**](docs/HyperscaleObjectsApi.md#delete_hyperscale_mount_point) | **DELETE** /hyperscale-mount-points/{hyperscaleMountPointId} | Delete a Hyperscale Mount Point.
*HyperscaleObjectsApi* | [**get_hyperscale_connector_by_id**](docs/HyperscaleObjectsApi.md#get_hyperscale_connector_by_id) | **GET** /hyperscale-connectors/{hyperscaleConnectorId} | Get a Hyperscale Connector.
*HyperscaleObjectsApi* | [**get_hyperscale_connector_tags**](docs/HyperscaleObjectsApi.md#get_hyperscale_connector_tags) | **GET** /hyperscale-connectors/{hyperscaleConnectorId}/tags | Get tags for a Hyperscale Connector.
*HyperscaleObjectsApi* | [**get_hyperscale_connectors**](docs/HyperscaleObjectsApi.md#get_hyperscale_connectors) | **GET** /hyperscale-connectors | Returns a list of Hyperscale Connectors.
*HyperscaleObjectsApi* | [**get_hyperscale_dataset_by_id**](docs/HyperscaleObjectsApi.md#get_hyperscale_dataset_by_id) | **GET** /hyperscale-datasets/{hyperscaleDatasetId} | Get a Hyperscale Dataset.
*HyperscaleObjectsApi* | [**get_hyperscale_dataset_table_or_file_by_id**](docs/HyperscaleObjectsApi.md#get_hyperscale_dataset_table_or_file_by_id) | **GET** /hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/{hyperscaleDatasetTableOrFileId} | Get a Hyperscale Dataset table or file by ID.
*HyperscaleObjectsApi* | [**get_hyperscale_dataset_tables_or_files**](docs/HyperscaleObjectsApi.md#get_hyperscale_dataset_tables_or_files) | **GET** /hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files | Get the tables or files of a hyperscale dataset
*HyperscaleObjectsApi* | [**get_hyperscale_dataset_tags**](docs/HyperscaleObjectsApi.md#get_hyperscale_dataset_tags) | **GET** /hyperscale-datasets/{hyperscaleDatasetId}/tags | Get tags for a Hyperscale Dataset.
*HyperscaleObjectsApi* | [**get_hyperscale_datasets**](docs/HyperscaleObjectsApi.md#get_hyperscale_datasets) | **GET** /hyperscale-datasets | Returns a list of Hyperscale Datasets.
*HyperscaleObjectsApi* | [**get_hyperscale_mount_point_by_id**](docs/HyperscaleObjectsApi.md#get_hyperscale_mount_point_by_id) | **GET** /hyperscale-mount-points/{hyperscaleMountPointId} | Get a Hyperscale Mount Points.
*HyperscaleObjectsApi* | [**get_hyperscale_mount_points**](docs/HyperscaleObjectsApi.md#get_hyperscale_mount_points) | **GET** /hyperscale-mount-points | Returns a list of Hyperscale Mount Points.
*HyperscaleObjectsApi* | [**search_hyperscale_connectors**](docs/HyperscaleObjectsApi.md#search_hyperscale_connectors) | **POST** /hyperscale-connectors/search | Search for Hyperscale Connectors.
*HyperscaleObjectsApi* | [**search_hyperscale_dataset_tables_or_files**](docs/HyperscaleObjectsApi.md#search_hyperscale_dataset_tables_or_files) | **POST** /hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/search | Search the tables or files of a hyperscale dataset
*HyperscaleObjectsApi* | [**search_hyperscale_datasets**](docs/HyperscaleObjectsApi.md#search_hyperscale_datasets) | **POST** /hyperscale-datasets/search | Search for Hyperscale Datasets.
*HyperscaleObjectsApi* | [**search_hyperscale_mount_points**](docs/HyperscaleObjectsApi.md#search_hyperscale_mount_points) | **POST** /hyperscale-mount-points/search | Search for Hyperscale Mount Points.
*HyperscaleObjectsApi* | [**update_hyperscale_connector_by_id**](docs/HyperscaleObjectsApi.md#update_hyperscale_connector_by_id) | **PATCH** /hyperscale-connectors/{hyperscaleConnectorId} | Update a Hyperscale Connector by ID.
*HyperscaleObjectsApi* | [**update_hyperscale_dataset_by_id**](docs/HyperscaleObjectsApi.md#update_hyperscale_dataset_by_id) | **PATCH** /hyperscale-datasets/{hyperscaleDatasetId} | Update a Hyperscale Dataset by ID.
*HyperscaleObjectsApi* | [**update_hyperscale_dataset_table_or_file_by_id**](docs/HyperscaleObjectsApi.md#update_hyperscale_dataset_table_or_file_by_id) | **PATCH** /hyperscale-datasets/{hyperscaleDatasetId}/tables-or-files/{hyperscaleDatasetTableOrFileId} | Update a Hyperscale Dataset table or file by ID.
*HyperscaleObjectsApi* | [**update_hyperscale_mount_point_by_id**](docs/HyperscaleObjectsApi.md#update_hyperscale_mount_point_by_id) | **PATCH** /hyperscale-mount-points/{hyperscaleMountPointId} | Update a Hyperscale Mount Point by ID.
*JobCollectionExecutionsApi* | [**cancel_job_collection_execution**](docs/JobCollectionExecutionsApi.md#cancel_job_collection_execution) | **POST** /job-collection-executions/{jobCollectionExecutionId}/cancel | Cancel a compliance job collection execution. This operation is asynchronous is not complete until the collection execution is marked cancelled.
*JobCollectionExecutionsApi* | [**get_job_collection_execution_by_id**](docs/JobCollectionExecutionsApi.md#get_job_collection_execution_by_id) | **GET** /job-collection-executions/{jobCollectionExecutionId} | Retrieve a compliance job collection execution by ID.
*JobCollectionExecutionsApi* | [**get_job_collection_executions**](docs/JobCollectionExecutionsApi.md#get_job_collection_executions) | **GET** /job-collection-executions | Retrieve the list of compliance job collection executions.
*JobCollectionExecutionsApi* | [**search_job_collection_executions**](docs/JobCollectionExecutionsApi.md#search_job_collection_executions) | **POST** /job-collection-executions/search | Search compliance job collection executions.
*JobsApi* | [**abandon_job**](docs/JobsApi.md#abandon_job) | **POST** /jobs/{jobId}/abandon | Abandons a job.
*JobsApi* | [**create_job_tags**](docs/JobsApi.md#create_job_tags) | **POST** /jobs/{jobId}/tags | Create tags for a Job.
*JobsApi* | [**delete_job_tag**](docs/JobsApi.md#delete_job_tag) | **POST** /jobs/{jobId}/tags/delete | Delete tags for a Job.
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /jobs/{jobId} | Returns a job by ID.
*JobsApi* | [**get_job_result**](docs/JobsApi.md#get_job_result) | **GET** /jobs/{jobId}/result | Get job result.
*JobsApi* | [**get_job_tags**](docs/JobsApi.md#get_job_tags) | **GET** /jobs/{jobId}/tags | Get tags for a Job.
*JobsApi* | [**get_jobs**](docs/JobsApi.md#get_jobs) | **GET** /jobs | List all jobs.
*JobsApi* | [**search_jobs**](docs/JobsApi.md#search_jobs) | **POST** /jobs/search | Search for jobs.
*KerberosConfigApi* | [**get_kerberos_config_by_id**](docs/KerberosConfigApi.md#get_kerberos_config_by_id) | **GET** /kerberos-configs/{kerberosConfigId} | Get a kerberos config by ID or Name.
*KerberosConfigApi* | [**list_kerberos_configs**](docs/KerberosConfigApi.md#list_kerberos_configs) | **GET** /kerberos-configs | List all kerberos configs.
*KerberosConfigApi* | [**search_kerberos_configs**](docs/KerberosConfigApi.md#search_kerberos_configs) | **POST** /kerberos-configs/search | Search for Kerberos Configs.
*LicenseApi* | [**change_license**](docs/LicenseApi.md#change_license) | **POST** /management/license/change-license | Change the current DCT license.
*LicenseApi* | [**get_license**](docs/LicenseApi.md#get_license) | **GET** /management/license | Returns the DCT license information.
*LoginApi* | [**account_login**](docs/LoginApi.md#account_login) | **POST** /login | Login to Account with Username and Password 
*LoginApi* | [**account_logout**](docs/LoginApi.md#account_logout) | **POST** /logout | Invalidates username/password and SSO login session.
*LoginApi* | [**token_info**](docs/LoginApi.md#token_info) | **POST** /token-info | Get Token Information 
*ManagementApi* | [**create_engine_tags**](docs/ManagementApi.md#create_engine_tags) | **POST** /management/engines/{engineId}/tags | Create tags for an Engine.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**create_hashicorp_vault_tags**](docs/ManagementApi.md#create_hashicorp_vault_tags) | **POST** /management/vaults/hashicorp/{vaultId}/tags | Create tags for a Hashicorp vault.
*ManagementApi* | [**delete_engine_tags**](docs/ManagementApi.md#delete_engine_tags) | **POST** /management/engines/{engineId}/tags/delete | Delete tags for an Engine.
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**delete_hashicorp_vault_tag**](docs/ManagementApi.md#delete_hashicorp_vault_tag) | **POST** /management/vaults/hashicorp/{vaultId}/tags/delete | Delete tags for a Hashicorp vault.
*ManagementApi* | [**get_api_classification**](docs/ManagementApi.md#get_api_classification) | **GET** /management/api-classification | Get api classification.
*ManagementApi* | [**get_compliance_application_settings**](docs/ManagementApi.md#get_compliance_application_settings) | **GET** /management/engines/{engineId}/compliance-application-settings | Returns a compliance engine&#39;s application settings.
*ManagementApi* | [**get_engine_auto_tagging_config**](docs/ManagementApi.md#get_engine_auto_tagging_config) | **GET** /management/engines/{engineId}/auto-tagging | Returns the engine&#39;s auto tagging configuration.
*ManagementApi* | [**get_engine_tags**](docs/ManagementApi.md#get_engine_tags) | **GET** /management/engines/{engineId}/tags | Get tags for a Engine.
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vault_tags**](docs/ManagementApi.md#get_hashicorp_vault_tags) | **GET** /management/vaults/hashicorp/{vaultId}/tags | Get tags for a Hashicorp vault.
*ManagementApi* | [**get_hashicorp_vaults**](docs/ManagementApi.md#get_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**get_ldap_config**](docs/ManagementApi.md#get_ldap_config) | **GET** /management/ldap-config | Returns the LDAP configuration
*ManagementApi* | [**get_metadata_database**](docs/ManagementApi.md#get_metadata_database) | **GET** /management/metadata-database | Returns configuration information about the metadata database which stores the product data.
*ManagementApi* | [**get_phonehome_events**](docs/ManagementApi.md#get_phonehome_events) | **GET** /management/phonehome/events | Returns previous bundle upload events
*ManagementApi* | [**get_product_registration_delphix_connectivity_check**](docs/ManagementApi.md#get_product_registration_delphix_connectivity_check) | **GET** /management/product-registration-delphix-connectivity-check | Returns True if Delphix services are reachable for product registration.
*ManagementApi* | [**get_product_registration_key**](docs/ManagementApi.md#get_product_registration_key) | **GET** /management/product-registration-offline | Generates and returns a public key that can be used to register the product.
*ManagementApi* | [**get_product_registration_status**](docs/ManagementApi.md#get_product_registration_status) | **GET** /management/product-registration-status | Returns the product registration status.
*ManagementApi* | [**get_proxy_configuration**](docs/ManagementApi.md#get_proxy_configuration) | **GET** /management/proxy | Returns the current web proxy configuration to use to connect to Delphix services.
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**get_registered_engines**](docs/ManagementApi.md#get_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**get_saml_config**](docs/ManagementApi.md#get_saml_config) | **GET** /management/saml-config | Returns the SAML configuration
*ManagementApi* | [**get_smtp_config**](docs/ManagementApi.md#get_smtp_config) | **GET** /management/smtp | Returns the SMTP configuration
*ManagementApi* | [**list_properties**](docs/ManagementApi.md#list_properties) | **GET** /management/properties | Get global properties.
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**register_product_offline**](docs/ManagementApi.md#register_product_offline) | **POST** /management/product-registration-offline | Registers the product using a manually generated payload.
*ManagementApi* | [**register_product_online**](docs/ManagementApi.md#register_product_online) | **POST** /management/product-registration-online | Registers the product using the provided credentials.
*ManagementApi* | [**search_compliance_application_settings**](docs/ManagementApi.md#search_compliance_application_settings) | **POST** /management/engines/{engineId}/compliance-application-settings/search | Search a compliance engine&#39;s application settings.
*ManagementApi* | [**search_engines**](docs/ManagementApi.md#search_engines) | **POST** /management/engines/search | Search for engines.
*ManagementApi* | [**search_hashicorp_vaults**](docs/ManagementApi.md#search_hashicorp_vaults) | **POST** /management/vaults/hashicorp/search | Search for configured Hashicorp vaults.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_api_classification**](docs/ManagementApi.md#update_api_classification) | **PUT** /management/api-classification | Update the api classification to new version.
*ManagementApi* | [**update_engine_auto_tagging_config**](docs/ManagementApi.md#update_engine_auto_tagging_config) | **PATCH** /management/engines/{engineId}/auto-tagging | Update the engine&#39;s auto tagging configuration.
*ManagementApi* | [**update_ldap_config**](docs/ManagementApi.md#update_ldap_config) | **PUT** /management/ldap-config | Update LDAP Config.
*ManagementApi* | [**update_properties**](docs/ManagementApi.md#update_properties) | **PATCH** /management/properties | Update value of predefined properties.
*ManagementApi* | [**update_proxy_configuration**](docs/ManagementApi.md#update_proxy_configuration) | **PUT** /management/proxy | Update the web proxy configuration to use to connect to Delphix services.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*ManagementApi* | [**update_registered_engine_partial**](docs/ManagementApi.md#update_registered_engine_partial) | **PATCH** /management/engines/{engineId} | Update a registered engine.
*ManagementApi* | [**update_saml_config**](docs/ManagementApi.md#update_saml_config) | **PUT** /management/saml-config | Update SAML Config.
*ManagementApi* | [**update_smtp_config**](docs/ManagementApi.md#update_smtp_config) | **PUT** /management/smtp | Update SMTP Config.
*ManagementApi* | [**validate_java_path**](docs/ManagementApi.md#validate_java_path) | **POST** /management/engines/{engineId}/validate/java-path | Validate java path for the remote host machine.
*ManagementApi* | [**validate_ldap_config**](docs/ManagementApi.md#validate_ldap_config) | **POST** /management/ldap-config/validate | Validate LDAP Config. Without username/password, DCT performs an anonymous bind against the LDAP server. If credentials are provided DCT validates that authentication and mapping of optional properties are actually working with provided credentials. LDAP search is only validated if search attributes are set.
*ManagementApi* | [**validate_smtp_config**](docs/ManagementApi.md#validate_smtp_config) | **POST** /management/smtp/validate | Validate SMTP Config.
*MaskingEnvironmentsApi* | [**get_masking_environment_by_id**](docs/MaskingEnvironmentsApi.md#get_masking_environment_by_id) | **GET** /masking-environments/{maskingEnvironmentId} | Retrieve a MaskingEnvironment by ID.
*MaskingEnvironmentsApi* | [**get_masking_environments**](docs/MaskingEnvironmentsApi.md#get_masking_environments) | **GET** /masking-environments | Retrieve the list of masking environments.
*MaskingEnvironmentsApi* | [**search_masking_environments**](docs/MaskingEnvironmentsApi.md#search_masking_environments) | **POST** /masking-environments/search | Search masking environments.
*MaskingFilesApi* | [**create_masking_file_tags**](docs/MaskingFilesApi.md#create_masking_file_tags) | **POST** /masking-file-uploads/{maskingFileId}/tags | Create tags for a masking file.
*MaskingFilesApi* | [**delete_masking_file_tags**](docs/MaskingFilesApi.md#delete_masking_file_tags) | **POST** /masking-file-uploads/{maskingFileId}/tags/delete | Delete tags for a masking file
*MaskingFilesApi* | [**get_masking_file_by_id**](docs/MaskingFilesApi.md#get_masking_file_by_id) | **GET** /masking-file-uploads/{maskingFileId} | Get a masking file by ID or name.
*MaskingFilesApi* | [**get_masking_file_consumers**](docs/MaskingFilesApi.md#get_masking_file_consumers) | **GET** /masking-file-uploads/{maskingFileId}/consumers | Get all consumers associated with this masking file
*MaskingFilesApi* | [**get_masking_file_tags**](docs/MaskingFilesApi.md#get_masking_file_tags) | **GET** /masking-file-uploads/{maskingFileId}/tags | Get tags for a masking file.
*MaskingFilesApi* | [**get_masking_files**](docs/MaskingFilesApi.md#get_masking_files) | **GET** /masking-file-uploads | Retrieve the list of masking file uploads.
*MaskingFilesApi* | [**search_masking_file_consumers**](docs/MaskingFilesApi.md#search_masking_file_consumers) | **POST** /masking-file-uploads/{maskingFileId}/consumers/search | Search consumers of a masking file.
*MaskingFilesApi* | [**search_masking_files**](docs/MaskingFilesApi.md#search_masking_files) | **POST** /masking-file-uploads/search | Search for masking files.
*MaskingFilesApi* | [**update_masking_file_upload_by_id**](docs/MaskingFilesApi.md#update_masking_file_upload_by_id) | **PATCH** /masking-file-uploads/{maskingFileId} | Update a masking file upload by id.
*MaskingJobsApi* | [**add_engine_to_masking_job**](docs/MaskingJobsApi.md#add_engine_to_masking_job) | **POST** /masking-jobs/{maskingJobId}/add-engine | Add an engine to a Masking Job (Hyperscale Job only).
*MaskingJobsApi* | [**copy_masking_job**](docs/MaskingJobsApi.md#copy_masking_job) | **POST** /masking-jobs/{maskingJobId}/copy | Copies the masking job to another engine.
*MaskingJobsApi* | [**create_masking_job**](docs/MaskingJobsApi.md#create_masking_job) | **POST** /masking-jobs | Create a Masking Job.
*MaskingJobsApi* | [**create_masking_job_tag**](docs/MaskingJobsApi.md#create_masking_job_tag) | **POST** /masking-jobs/{maskingJobId}/tags | Create tags for a Masking Job.
*MaskingJobsApi* | [**delete_masking_job**](docs/MaskingJobsApi.md#delete_masking_job) | **DELETE** /masking-jobs/{maskingJobId} | Delete a masking job.
*MaskingJobsApi* | [**delete_masking_job_tag**](docs/MaskingJobsApi.md#delete_masking_job_tag) | **POST** /masking-jobs/{maskingJobId}/tags/delete | Delete tags for a Masking Job.
*MaskingJobsApi* | [**execute_masking_job**](docs/MaskingJobsApi.md#execute_masking_job) | **POST** /masking-jobs/{maskingJobId}/execute | Execute a MaskingJob.
*MaskingJobsApi* | [**get_masking_job_by_id**](docs/MaskingJobsApi.md#get_masking_job_by_id) | **GET** /masking-jobs/{maskingJobId} | Retrieve a MaskingJob by ID.
*MaskingJobsApi* | [**get_masking_job_connectors**](docs/MaskingJobsApi.md#get_masking_job_connectors) | **GET** /masking-jobs/{maskingJobId}/connectors | Get connectors for a Masking Job by ID.
*MaskingJobsApi* | [**get_masking_job_source_engines**](docs/MaskingJobsApi.md#get_masking_job_source_engines) | **GET** /masking-jobs/source-engines | Retrieve the list of masking jobs along with their source engine.
*MaskingJobsApi* | [**get_masking_job_tag**](docs/MaskingJobsApi.md#get_masking_job_tag) | **GET** /masking-jobs/{maskingJobId}/tags | Get tags for a Masking Job.
*MaskingJobsApi* | [**get_masking_jobs**](docs/MaskingJobsApi.md#get_masking_jobs) | **GET** /masking-jobs | Retrieve the list of masking jobs.
*MaskingJobsApi* | [**migrate_masking_job**](docs/MaskingJobsApi.md#migrate_masking_job) | **POST** /masking-jobs/{maskingJobId}/migrate | Migrates the masking job from its current source engine to another engine.
*MaskingJobsApi* | [**re_import_masking_job**](docs/MaskingJobsApi.md#re_import_masking_job) | **POST** /masking-jobs/{maskingJobId}/re-import | Re-import the dataset from the source MaskingJob (Hyperscale Job only).
*MaskingJobsApi* | [**remove_engine_from_masking_job**](docs/MaskingJobsApi.md#remove_engine_from_masking_job) | **POST** /masking-jobs/{maskingJobId}/remove-engine | Remove an engine from a Masking Job (Hyperscale Job only).
*MaskingJobsApi* | [**search_masking_job_source_engines**](docs/MaskingJobsApi.md#search_masking_job_source_engines) | **POST** /masking-jobs/source-engines/search | Search the list of masking jobs along with their source engine.
*MaskingJobsApi* | [**search_masking_jobs**](docs/MaskingJobsApi.md#search_masking_jobs) | **POST** /masking-jobs/search | Search masking jobs.
*MaskingJobsApi* | [**update_masking_job_by_id**](docs/MaskingJobsApi.md#update_masking_job_by_id) | **PATCH** /masking-jobs/{maskingJobId} | Update values of a MaskingJob.
*NamespaceApi* | [**commit_failover_namespace**](docs/NamespaceApi.md#commit_failover_namespace) | **POST** /namespace/{namespaceId}/commitFailover | Commits the failover of a given namespace and discards the failback state.
*NamespaceApi* | [**delete_namespace**](docs/NamespaceApi.md#delete_namespace) | **DELETE** /namespace/{namespaceId} | Delete a Namespace.
*NamespaceApi* | [**discard_namespace**](docs/NamespaceApi.md#discard_namespace) | **POST** /namespace/{namespaceId}/discard | Discards any partial receive state for the given namespace.
*NamespaceApi* | [**failback_namespace**](docs/NamespaceApi.md#failback_namespace) | **POST** /namespace/{namespaceId}/failback | Initiates failback for the given namespace.
*NamespaceApi* | [**failover_namespace**](docs/NamespaceApi.md#failover_namespace) | **POST** /namespace/{namespaceId}/failover | Initiates failover for the given namespace.
*NamespaceApi* | [**get_namespace_by_id**](docs/NamespaceApi.md#get_namespace_by_id) | **GET** /namespace/{namespaceId} | Get a namespace.
*NamespaceApi* | [**list_namespaces**](docs/NamespaceApi.md#list_namespaces) | **GET** /namespaces | List all namespaces.
*NamespaceApi* | [**search_namespaces**](docs/NamespaceApi.md#search_namespaces) | **POST** /namespaces/search | Search Namespaces.
*NamespaceApi* | [**update_namespace**](docs/NamespaceApi.md#update_namespace) | **PATCH** /namespace/{namespaceId} | Update a Namespace.
*PasswordVaultsApi* | [**get_password_vault_by_id**](docs/PasswordVaultsApi.md#get_password_vault_by_id) | **GET** /password_vaults/{passwordVaultId} | Get a password vault by ID or Name.
*PasswordVaultsApi* | [**get_password_vaults**](docs/PasswordVaultsApi.md#get_password_vaults) | **GET** /password_vaults | List all password vaults.
*PasswordVaultsApi* | [**search_password_vaults**](docs/PasswordVaultsApi.md#search_password_vaults) | **POST** /password_vaults/search | Search for Password Vaults.
*ReplicationApi* | [**create_replication_profile**](docs/ReplicationApi.md#create_replication_profile) | **POST** /replication-profiles | Create a ReplicationProfile.
*ReplicationApi* | [**create_replication_profile_tags**](docs/ReplicationApi.md#create_replication_profile_tags) | **POST** /replication-profiles/{replicationProfileId}/tags | Create tags for a ReplicationProfile.
*ReplicationApi* | [**delete_replication_profile**](docs/ReplicationApi.md#delete_replication_profile) | **DELETE** /replication-profiles/{replicationProfileId} | Delete a ReplicationProfile.
*ReplicationApi* | [**delete_replication_profile_tags**](docs/ReplicationApi.md#delete_replication_profile_tags) | **POST** /replication-profiles/{replicationProfileId}/tags/delete | Delete tags for a ReplicationProfile.
*ReplicationApi* | [**disable_tag_replication**](docs/ReplicationApi.md#disable_tag_replication) | **POST** /replication-profiles/{replicationProfileId}/disable-tag-replication | Disable tag replication for given ReplicationProfile.
*ReplicationApi* | [**enable_tag_replication**](docs/ReplicationApi.md#enable_tag_replication) | **POST** /replication-profiles/{replicationProfileId}/enable-tag-replication | Enable tag replication for given ReplicationProfile.
*ReplicationApi* | [**execute_replication_profile**](docs/ReplicationApi.md#execute_replication_profile) | **POST** /replication-profiles/{replicationProfileId}/execute | Execute a ReplicationProfile.
*ReplicationApi* | [**get_replication_profile_by_id**](docs/ReplicationApi.md#get_replication_profile_by_id) | **GET** /replication-profiles/{replicationProfileId} | Get a ReplicationProfile by ID.
*ReplicationApi* | [**get_replication_profile_tags**](docs/ReplicationApi.md#get_replication_profile_tags) | **GET** /replication-profiles/{replicationProfileId}/tags | Get tags for a ReplicationProfile.
*ReplicationApi* | [**get_replication_profiles**](docs/ReplicationApi.md#get_replication_profiles) | **GET** /replication-profiles | List all ReplicationProfiles.
*ReplicationApi* | [**search_replication_profiles**](docs/ReplicationApi.md#search_replication_profiles) | **POST** /replication-profiles/search | Search for ReplicationProfiles.
*ReplicationApi* | [**update_replication_profile**](docs/ReplicationApi.md#update_replication_profile) | **PATCH** /replication-profiles/{replicationProfileId} | Update a ReplicationProfile.
*ReportingApi* | [**create_reporting_schedule**](docs/ReportingApi.md#create_reporting_schedule) | **POST** /reporting/schedule | Create a new report schedule.
*ReportingApi* | [**create_reporting_schedule_tags**](docs/ReportingApi.md#create_reporting_schedule_tags) | **POST** /reporting/schedule/{reportId}/tags | Create tags for a report schedule.
*ReportingApi* | [**delete_reporting_schedule**](docs/ReportingApi.md#delete_reporting_schedule) | **DELETE** /reporting/schedule/{reportId} | Delete report schedule by ID.
*ReportingApi* | [**delete_reporting_schedule_tag**](docs/ReportingApi.md#delete_reporting_schedule_tag) | **POST** /reporting/schedule/{reportId}/tags/delete | Delete tags for a report schedule.
*ReportingApi* | [**get_api_usage_report**](docs/ReportingApi.md#get_api_usage_report) | **GET** /reporting/api-usage-report | Gets the report of API usage metrics over a given time period. This API returns at the most 10000 results in the response to protect against the server running out of memory. Users might not hit this limit with the default report without any &#39;apiUsageReportGroupByParam&#39; param but can hit this limit if the groupBy is by too granular like by &#39;client_name&#39; or &#39;user_agent&#39; only. Hence it is advisable to use startDate and endDate to &#39;limit&#39; the scope of the report.
*ReportingApi* | [**get_audit_logs_summary_report**](docs/ReportingApi.md#get_audit_logs_summary_report) | **GET** /reporting/audit-logs-summary-report | Gets the audit log summary report.
*ReportingApi* | [**get_data_risk_report**](docs/ReportingApi.md#get_data_risk_report) | **GET** /reporting/data-risk-report | Get the masking data risk report.
*ReportingApi* | [**get_dsource_consumption_report**](docs/ReportingApi.md#get_dsource_consumption_report) | **GET** /reporting/dsource-consumption-report | Gets the consumption report for virtualization engine dSources.
*ReportingApi* | [**get_dsource_usage_report**](docs/ReportingApi.md#get_dsource_usage_report) | **GET** /reporting/dsource-usage-report | Gets the usage report for virtualization engine dSources.
*ReportingApi* | [**get_engine_global_object_state_report**](docs/ReportingApi.md#get_engine_global_object_state_report) | **GET** /reporting/engine-global-object-state-report | Get the masking engine global object state report.
*ReportingApi* | [**get_engine_performance_analytics_report**](docs/ReportingApi.md#get_engine_performance_analytics_report) | **GET** /reporting/engine-performance-analytic-report | Gets the performance analytics report for engines.
*ReportingApi* | [**get_masking_execution_metrics_report**](docs/ReportingApi.md#get_masking_execution_metrics_report) | **GET** /reporting/masking-execution-metrics | Get the masking execution metrics report.
*ReportingApi* | [**get_product_info**](docs/ReportingApi.md#get_product_info) | **GET** /reporting/product_info | Returns the DCT Product Information.
*ReportingApi* | [**get_reporting_schedule_by_id**](docs/ReportingApi.md#get_reporting_schedule_by_id) | **GET** /reporting/schedule/{reportId} | Returns a report schedule by ID.
*ReportingApi* | [**get_reporting_schedule_tags**](docs/ReportingApi.md#get_reporting_schedule_tags) | **GET** /reporting/schedule/{reportId}/tags | Get tags for a report schedule.
*ReportingApi* | [**get_reporting_schedules**](docs/ReportingApi.md#get_reporting_schedules) | **GET** /reporting/schedule | List all report schedules.
*ReportingApi* | [**get_storage_capacity_data**](docs/ReportingApi.md#get_storage_capacity_data) | **GET** /reporting/storage-capacity-data-report | Get engine storage capacity data.
*ReportingApi* | [**get_vdb_inventory_report**](docs/ReportingApi.md#get_vdb_inventory_report) | **GET** /reporting/vdb-inventory-report | Gets the inventory report for virtualization engine VDBs.
*ReportingApi* | [**get_virtualization_storage_summary_report**](docs/ReportingApi.md#get_virtualization_storage_summary_report) | **GET** /reporting/virtualization-storage-summary-report | Gets the storage summary report for virtualization engines.
*ReportingApi* | [**search_data_risk_report**](docs/ReportingApi.md#search_data_risk_report) | **POST** /reporting/data-risk-report/search | Search the masking data risk report.
*ReportingApi* | [**search_dsource_consumption_report**](docs/ReportingApi.md#search_dsource_consumption_report) | **POST** /reporting/dsource-consumption-report/search | Search the consumption report for virtualization engine DSources.
*ReportingApi* | [**search_dsource_usage_report**](docs/ReportingApi.md#search_dsource_usage_report) | **POST** /reporting/dsource-usage-report/search | Search the usage report for virtualization engine dSources.
*ReportingApi* | [**search_engine_global_object_state_report**](docs/ReportingApi.md#search_engine_global_object_state_report) | **POST** /reporting/engine-global-object-state-report/search | Search the masking engine global object state report.
*ReportingApi* | [**search_engine_performance_analytic_trends**](docs/ReportingApi.md#search_engine_performance_analytic_trends) | **POST** /reporting/engine-performance-analytic-trends/search | Search the performance analytic trend data for engines.
*ReportingApi* | [**search_engine_performance_analytics_report**](docs/ReportingApi.md#search_engine_performance_analytics_report) | **POST** /reporting/engine-performance-analytic-report/search | Search the performance analytic report for engines.
*ReportingApi* | [**search_masking_execution_metrics_report**](docs/ReportingApi.md#search_masking_execution_metrics_report) | **POST** /reporting/masking-execution-metrics/search | Search the Masking execution metrics report.
*ReportingApi* | [**search_reporting_schedules**](docs/ReportingApi.md#search_reporting_schedules) | **POST** /reporting/schedule/search | Search for report schedules.
*ReportingApi* | [**search_storage_capacity_data**](docs/ReportingApi.md#search_storage_capacity_data) | **POST** /reporting/storage-capacity-data-report/search | Search engine storage capacity data.
*ReportingApi* | [**search_storage_savings_summary_report**](docs/ReportingApi.md#search_storage_savings_summary_report) | **POST** /reporting/storage-savings-report/search | Search the saving storage summary report for virtualization engines.
*ReportingApi* | [**search_vdb_inventory_report**](docs/ReportingApi.md#search_vdb_inventory_report) | **POST** /reporting/vdb-inventory-report/search | Search the inventory report for virtualization engine VDBs.
*ReportingApi* | [**search_virtualization_storage_summary_report**](docs/ReportingApi.md#search_virtualization_storage_summary_report) | **POST** /reporting/virtualization-storage-summary-report/search | Search the storage summary report for virtualization engines.
*ReportingApi* | [**update_reporting_schedule**](docs/ReportingApi.md#update_reporting_schedule) | **PUT** /reporting/schedule/{reportId} | Update a reporting schedule by ID.
*RuleSetsApi* | [**create_rule_set_tags**](docs/RuleSetsApi.md#create_rule_set_tags) | **POST** /rule-sets/{ruleSetId}/tags | Create tags for a Rule Set.
*RuleSetsApi* | [**delete_rule_set_tags**](docs/RuleSetsApi.md#delete_rule_set_tags) | **POST** /rule-sets/{ruleSetId}/tags/delete | Delete tags for a Rule Set.
*RuleSetsApi* | [**get_database_column_metadata**](docs/RuleSetsApi.md#get_database_column_metadata) | **GET** /database-column-metadata | Retrieve column metadata.
*RuleSetsApi* | [**get_database_table_metadata**](docs/RuleSetsApi.md#get_database_table_metadata) | **GET** /database-table-metadata | Retrieve table metadata.
*RuleSetsApi* | [**get_rule_set_by_id**](docs/RuleSetsApi.md#get_rule_set_by_id) | **GET** /rule-sets/{ruleSetId} | Get a Rule Set by ID.
*RuleSetsApi* | [**get_rule_set_tags**](docs/RuleSetsApi.md#get_rule_set_tags) | **GET** /rule-sets/{ruleSetId}/tags | Get tags for a Rule Set.
*RuleSetsApi* | [**get_rule_sets**](docs/RuleSetsApi.md#get_rule_sets) | **GET** /rule-sets | Retrieve the list of Rule Sets.
*RuleSetsApi* | [**search_database_column_metadata**](docs/RuleSetsApi.md#search_database_column_metadata) | **POST** /database-column-metadata/search | Search column metadata.
*RuleSetsApi* | [**search_database_table_metadata**](docs/RuleSetsApi.md#search_database_table_metadata) | **POST** /database-table-metadata/search | Search table metadata.
*RuleSetsApi* | [**search_rule_sets**](docs/RuleSetsApi.md#search_rule_sets) | **POST** /rule-sets/search | Search for Rule Sets.
*SamlLoginApi* | [**check_saml**](docs/SamlLoginApi.md#check_saml) | **GET** /is-saml-enabled | Check if SAML is enabled 
*SnapshotsApi* | [**create_snapshot_tags**](docs/SnapshotsApi.md#create_snapshot_tags) | **POST** /snapshots/{snapshotId}/tags | Create tags for a Snapshot.
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /snapshots/{snapshotId} | Delete a Snapshot.
*SnapshotsApi* | [**delete_snapshot_tags**](docs/SnapshotsApi.md#delete_snapshot_tags) | **POST** /snapshots/{snapshotId}/tags/delete | Delete tags for a Snapshot.
*SnapshotsApi* | [**find_by_location**](docs/SnapshotsApi.md#find_by_location) | **GET** /snapshots/find_by_location | Get the snapshots at this location for a dataset.
*SnapshotsApi* | [**find_by_timestamp**](docs/SnapshotsApi.md#find_by_timestamp) | **GET** /snapshots/find_by_timestamp | Get the snapshots at this timestamp for a dataset.
*SnapshotsApi* | [**get_snapshot_by_id**](docs/SnapshotsApi.md#get_snapshot_by_id) | **GET** /snapshots/{snapshotId} | Get a Snapshot by ID.
*SnapshotsApi* | [**get_snapshot_runtime_by_id**](docs/SnapshotsApi.md#get_snapshot_runtime_by_id) | **GET** /snapshots/{snapshotId}/runtime | Get a runtime object of a snapshot by id
*SnapshotsApi* | [**get_snapshot_tags**](docs/SnapshotsApi.md#get_snapshot_tags) | **GET** /snapshots/{snapshotId}/tags | Get tags for a Snapshot.
*SnapshotsApi* | [**get_snapshot_timeflow_range**](docs/SnapshotsApi.md#get_snapshot_timeflow_range) | **GET** /snapshots/{snapshotId}/timeflow_range | Return the provisionable timeflow range based on a specific snapshot.
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /snapshots | Retrieve the list of snapshots.
*SnapshotsApi* | [**get_snapshots_capacity_data**](docs/SnapshotsApi.md#get_snapshots_capacity_data) | **GET** /snapshots/capacity | Lists capacity metrics for all snapshots of dataset or the engine.
*SnapshotsApi* | [**search_snapshots**](docs/SnapshotsApi.md#search_snapshots) | **POST** /snapshots/search | Search snapshots.
*SnapshotsApi* | [**unset_snapshot_retention**](docs/SnapshotsApi.md#unset_snapshot_retention) | **POST** /snapshots/{snapshotId}/unset_expiration | Unset a Snapshot&#39;s expiration, removing expiration and retain_forever values for the snapshot.
*SnapshotsApi* | [**update_snapshot**](docs/SnapshotsApi.md#update_snapshot) | **PATCH** /snapshots/{snapshotId} | Update values of a Snapshot.
*SourcesApi* | [**create_app_data_source**](docs/SourcesApi.md#create_app_data_source) | **POST** /sources/appdata | Create an AppData source.
*SourcesApi* | [**create_oracle_source**](docs/SourcesApi.md#create_oracle_source) | **POST** /sources/oracle | Create an Oracle Source.
*SourcesApi* | [**create_postgres_source**](docs/SourcesApi.md#create_postgres_source) | **POST** /sources/postgres | Create a PostgreSQL source.
*SourcesApi* | [**create_source_tags**](docs/SourcesApi.md#create_source_tags) | **POST** /sources/{sourceId}/tags | Create tags for a Source.
*SourcesApi* | [**delete_source**](docs/SourcesApi.md#delete_source) | **DELETE** /sources/{sourceId} | Delete a source by ID.
*SourcesApi* | [**delete_source_tags**](docs/SourcesApi.md#delete_source_tags) | **POST** /sources/{sourceId}/tags/delete | Delete tags for a Source.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_source_compatible_repo**](docs/SourcesApi.md#get_source_compatible_repo) | **GET** /sources/{sourceId}/staging_compatible_repositories | Returns a list of repositories that match the specified source.
*SourcesApi* | [**get_source_tags**](docs/SourcesApi.md#get_source_tags) | **GET** /sources/{sourceId}/tags | Get tags for a Source.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*SourcesApi* | [**search_sources**](docs/SourcesApi.md#search_sources) | **POST** /sources/search | Search for Sources.
*SourcesApi* | [**update_oracle_source_by_id**](docs/SourcesApi.md#update_oracle_source_by_id) | **PATCH** /sources/oracle/{sourceId} | Update an Oracle source by ID.
*SourcesApi* | [**update_postgres_source_by_id**](docs/SourcesApi.md#update_postgres_source_by_id) | **PATCH** /sources/postgres/{sourceId} | Update a PostgreSQL source by ID.
*SourcesApi* | [**update_source_by_id**](docs/SourcesApi.md#update_source_by_id) | **PATCH** /sources/{sourceId}/update | Update a Source.
*SourcesApi* | [**verify_source_jdbc_connection_string**](docs/SourcesApi.md#verify_source_jdbc_connection_string) | **POST** /sources/{sourceId}/jdbc-check | Verify JDBC connection string for a source.
*StagingSourcesApi* | [**create_staging_source_tags**](docs/StagingSourcesApi.md#create_staging_source_tags) | **POST** /staging-sources/{stagingSourceId}/tags | Create tags for a Staging Source.
*StagingSourcesApi* | [**delete_staging_source_tags**](docs/StagingSourcesApi.md#delete_staging_source_tags) | **POST** /staging-sources/{stagingSourceId}/tags/delete | Delete tags for a Staging Source.
*StagingSourcesApi* | [**get_staging_source_by_id**](docs/StagingSourcesApi.md#get_staging_source_by_id) | **GET** /staging-sources/{stagingSourceId} | Get a staging source by ID.
*StagingSourcesApi* | [**get_staging_source_tags**](docs/StagingSourcesApi.md#get_staging_source_tags) | **GET** /staging-sources/{stagingSourceId}/tags | Get tags for a Staging Source.
*StagingSourcesApi* | [**get_staging_sources**](docs/StagingSourcesApi.md#get_staging_sources) | **GET** /staging-sources | List all staging sources.
*StagingSourcesApi* | [**search_staging_sources**](docs/StagingSourcesApi.md#search_staging_sources) | **POST** /staging-sources/search | Search for Staging Sources.
*StagingSourcesApi* | [**update_staging_source_by_id**](docs/StagingSourcesApi.md#update_staging_source_by_id) | **PATCH** /staging-sources/{stagingSourceId}/update | Update a Staging Source.
*StorageUsageApi* | [**get_historical_storage_summary_aggregate**](docs/StorageUsageApi.md#get_historical_storage_summary_aggregate) | **GET** /historical-storage-summary-aggregate | Returns the aggregated historical storage usage of all registered engines over time, optionally with a projection of future storage usage.
*StorageUsageApi* | [**get_historical_storage_summary_by_engine**](docs/StorageUsageApi.md#get_historical_storage_summary_by_engine) | **GET** /historical-storage-summary-by-engine | Returns the historical storage usage by engine over time, optionally with a projection of future storage usage.
*TagsApi* | [**get_tag**](docs/TagsApi.md#get_tag) | **GET** /management/tags/{tagId} | Get a global tag by id
*TagsApi* | [**get_tag_permissions**](docs/TagsApi.md#get_tag_permissions) | **GET** /management/tags/{tagId}/permissions | List instances of this global tag being used to scope an access group.
*TagsApi* | [**get_tag_usages**](docs/TagsApi.md#get_tag_usages) | **GET** /management/tags/{tagId}/usages | List specific usages of this global tag.
*TagsApi* | [**get_tags**](docs/TagsApi.md#get_tags) | **GET** /management/tags | Returns a list of global tags
*TagsApi* | [**search_tag_permissions**](docs/TagsApi.md#search_tag_permissions) | **POST** /management/tags/{tagId}/permissions/search | Search instances of this global tag being used to scope an access group
*TagsApi* | [**search_tag_usages**](docs/TagsApi.md#search_tag_usages) | **POST** /management/tags/{tagId}/usages/search | Search specific usages of this global tag.
*TagsApi* | [**search_tags**](docs/TagsApi.md#search_tags) | **POST** /management/tags/search | Search for global tags.
*TimeflowsApi* | [**create_timeflow_tags**](docs/TimeflowsApi.md#create_timeflow_tags) | **POST** /timeflows/{timeflowId}/tags | Create tags for a Timeflow.
*TimeflowsApi* | [**delete_timeflow**](docs/TimeflowsApi.md#delete_timeflow) | **DELETE** /timeflows/{timeflowId} | Delete a timeflow.
*TimeflowsApi* | [**delete_timeflow_tags**](docs/TimeflowsApi.md#delete_timeflow_tags) | **POST** /timeflows/{timeflowId}/tags/delete | Delete tags for a Timeflow.
*TimeflowsApi* | [**get_timeflow_by_id**](docs/TimeflowsApi.md#get_timeflow_by_id) | **GET** /timeflows/{timeflowId} | Get a Timeflow by ID.
*TimeflowsApi* | [**get_timeflow_snapshot_day_range**](docs/TimeflowsApi.md#get_timeflow_snapshot_day_range) | **GET** /timeflows/{timeflowId}/timeflowSnapshotDayRange | Returns the count of TimeFlow snapshots of the Timeflow aggregated by day.
*TimeflowsApi* | [**get_timeflow_tags**](docs/TimeflowsApi.md#get_timeflow_tags) | **GET** /timeflows/{timeflowId}/tags | Get tags for a Timeflow.
*TimeflowsApi* | [**get_timeflows**](docs/TimeflowsApi.md#get_timeflows) | **GET** /timeflows | Retrieve the list of timeflows.
*TimeflowsApi* | [**search_timeflows**](docs/TimeflowsApi.md#search_timeflows) | **POST** /timeflows/search | Search timeflows.
*TimeflowsApi* | [**timeflow_repair**](docs/TimeflowsApi.md#timeflow_repair) | **POST** /timeflows/{timeflowId}/repair | Repair a Timeflow.
*TimeflowsApi* | [**update_timeflow**](docs/TimeflowsApi.md#update_timeflow) | **PATCH** /timeflows/{timeflowId} | Update values of a timeflow.
*ToolkitsApi* | [**create_toolkit_tags**](docs/ToolkitsApi.md#create_toolkit_tags) | **POST** /toolkits/{toolkitId}/tags | Create tags for a toolkit.
*ToolkitsApi* | [**delete_toolkit_tags**](docs/ToolkitsApi.md#delete_toolkit_tags) | **POST** /toolkits/{toolkitId}/tags/delete | Delete tags for a Toolkit.
*ToolkitsApi* | [**get_toolkit_by_id**](docs/ToolkitsApi.md#get_toolkit_by_id) | **GET** /toolkits/{toolkitId} | Get Toolkit by ID.
*ToolkitsApi* | [**get_toolkit_tags**](docs/ToolkitsApi.md#get_toolkit_tags) | **GET** /toolkits/{toolkitId}/tags | Get tags for a Toolkit.
*ToolkitsApi* | [**get_toolkits**](docs/ToolkitsApi.md#get_toolkits) | **GET** /toolkits | List all toolkits.
*ToolkitsApi* | [**search_toolkits**](docs/ToolkitsApi.md#search_toolkits) | **POST** /toolkits/search | Search for toolkits.
*VCDBsApi* | [**create_vcdb_tags**](docs/VCDBsApi.md#create_vcdb_tags) | **POST** /vcdbs/{vcdbId}/tags | Create tags for a vCDB.
*VCDBsApi* | [**delete_vcdb**](docs/VCDBsApi.md#delete_vcdb) | **POST** /vcdbs/{vcdbId}/delete | Delete a vCDB.
*VCDBsApi* | [**delete_vcdb_tags**](docs/VCDBsApi.md#delete_vcdb_tags) | **POST** /vcdbs/{vcdbId}/tags/delete | Delete tags for a vCDB.
*VCDBsApi* | [**disable_vcdb**](docs/VCDBsApi.md#disable_vcdb) | **POST** /vcdbs/{vcdbId}/disable | Disable a vCDB.
*VCDBsApi* | [**enable_vcdb**](docs/VCDBsApi.md#enable_vcdb) | **POST** /vcdbs/{vcdbId}/enable | Enable a vCDB.
*VCDBsApi* | [**get_tags_vcdb**](docs/VCDBsApi.md#get_tags_vcdb) | **GET** /vcdbs/{vcdbId}/tags | Get tags for a vCDB.
*VCDBsApi* | [**get_vcdb_by_id**](docs/VCDBsApi.md#get_vcdb_by_id) | **GET** /vcdbs/{vcdbId} | Get a CDB by ID (Oracle only).
*VCDBsApi* | [**get_vcdb_deletion_dependencies**](docs/VCDBsApi.md#get_vcdb_deletion_dependencies) | **GET** /vcdbs/{vcdbId}/deletion-dependencies | Get deletion dependencies of a vCDB.
*VCDBsApi* | [**get_vcdbs**](docs/VCDBsApi.md#get_vcdbs) | **GET** /vcdbs | List all vCDBs (Oracle only).
*VCDBsApi* | [**search_vcdbs**](docs/VCDBsApi.md#search_vcdbs) | **POST** /vcdbs/search | Search for vCDBs (Oracle only).
*VCDBsApi* | [**start_vcdb**](docs/VCDBsApi.md#start_vcdb) | **POST** /vcdbs/{vcdbId}/start | Start a vCDB.
*VCDBsApi* | [**stop_vcdb**](docs/VCDBsApi.md#stop_vcdb) | **POST** /vcdbs/{vcdbId}/stop | Stop a vCDB.
*VCDBsApi* | [**update_vcdb**](docs/VCDBsApi.md#update_vcdb) | **PATCH** /vcdbs/{vcdbId} | Update values of a VCDB
*VCDBsApi* | [**update_vcdb_by_id**](docs/VCDBsApi.md#update_vcdb_by_id) | **PATCH** /vcdbs/{vcdbId}/update | Update a VCDB.
*VCDBsApi* | [**upgrade_vcdb**](docs/VCDBsApi.md#upgrade_vcdb) | **POST** /vcdbs/{vcdbId}/upgrade | Upgrade Oracle vCDB
*VCDBsApi* | [**verify_vcdb_jdbc_connection_string**](docs/VCDBsApi.md#verify_vcdb_jdbc_connection_string) | **POST** /vcdbs/{vcdbId}/jdbc-check | Verify JDBC connection string for a vCDB.
*VDBGroupsApi* | [**create_vdb_group**](docs/VDBGroupsApi.md#create_vdb_group) | **POST** /vdb-groups | Create a new VDB Group.
*VDBGroupsApi* | [**create_vdb_groups_tags**](docs/VDBGroupsApi.md#create_vdb_groups_tags) | **POST** /vdb-groups/{vdbGroupId}/tags | Create tags for a VDB Group.
*VDBGroupsApi* | [**delete_vdb_group**](docs/VDBGroupsApi.md#delete_vdb_group) | **DELETE** /vdb-groups/{vdbGroupId} | Delete a VDBGoup.
*VDBGroupsApi* | [**delete_vdb_group_tags**](docs/VDBGroupsApi.md#delete_vdb_group_tags) | **POST** /vdb-groups/{vdbGroupId}/tags/delete | Delete tags for a VDB Group.
*VDBGroupsApi* | [**disable_vdb_group**](docs/VDBGroupsApi.md#disable_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/disable | Disable a VDB Group.
*VDBGroupsApi* | [**enable_vdb_group**](docs/VDBGroupsApi.md#enable_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/enable | Enable a VDB Group.
*VDBGroupsApi* | [**get_bookmarks_by_vdb_group**](docs/VDBGroupsApi.md#get_bookmarks_by_vdb_group) | **GET** /vdb-groups/{vdbGroupId}/bookmarks | List bookmarks compatible with this VDB Group.
*VDBGroupsApi* | [**get_vdb_group**](docs/VDBGroupsApi.md#get_vdb_group) | **GET** /vdb-groups/{vdbGroupId} | Get a VDB Group by name.
*VDBGroupsApi* | [**get_vdb_group_tags**](docs/VDBGroupsApi.md#get_vdb_group_tags) | **GET** /vdb-groups/{vdbGroupId}/tags | Get tags for a VDB Group.
*VDBGroupsApi* | [**get_vdb_group_timestamp_summary**](docs/VDBGroupsApi.md#get_vdb_group_timestamp_summary) | **POST** /vdb-groups/{vdbGroupId}/timestamp-summary | Get timestamp summary of all the vdbs in VDB Group.
*VDBGroupsApi* | [**get_vdb_group_vdbs_latest_snapshots**](docs/VDBGroupsApi.md#get_vdb_group_vdbs_latest_snapshots) | **GET** /vdb-groups/{vdbGroupId}/latest-snapshots | Get latest snapshot of all the vdbs in VDB Group.
*VDBGroupsApi* | [**get_vdb_groups**](docs/VDBGroupsApi.md#get_vdb_groups) | **GET** /vdb-groups | List all VDBGroups.
*VDBGroupsApi* | [**lock_vdb_group**](docs/VDBGroupsApi.md#lock_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/lock | Lock a VDB Group.
*VDBGroupsApi* | [**provision_vdb_group_from_bookmark**](docs/VDBGroupsApi.md#provision_vdb_group_from_bookmark) | **POST** /vdb-groups/provision_from_bookmark | Provision a new VDB Group from a Bookmark.
*VDBGroupsApi* | [**refresh_vdb_group**](docs/VDBGroupsApi.md#refresh_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/refresh | Refresh a VDB Group from bookmark.
*VDBGroupsApi* | [**refresh_vdb_group_by_snapshot**](docs/VDBGroupsApi.md#refresh_vdb_group_by_snapshot) | **POST** /vdb-groups/{vdbGroupId}/refresh_by_snapshot | Refresh a VDB Group by snapshot.
*VDBGroupsApi* | [**refresh_vdb_group_by_timestamp**](docs/VDBGroupsApi.md#refresh_vdb_group_by_timestamp) | **POST** /vdb-groups/{vdbGroupId}/refresh_by_timestamp | Refresh a VDB Group by timestamp.
*VDBGroupsApi* | [**refresh_vdb_group_from_bookmark**](docs/VDBGroupsApi.md#refresh_vdb_group_from_bookmark) | **POST** /vdb-groups/{vdbGroupId}/refresh_from_bookmark | Refresh a VDB Group from bookmark.
*VDBGroupsApi* | [**rollback_vdb_group**](docs/VDBGroupsApi.md#rollback_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/rollback | Rollback a VDB Group from a bookmark.
*VDBGroupsApi* | [**search_bookmarks_by_vdb_group**](docs/VDBGroupsApi.md#search_bookmarks_by_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/bookmarks/search | Search for bookmarks compatible with this VDB Group.
*VDBGroupsApi* | [**search_vdb_groups**](docs/VDBGroupsApi.md#search_vdb_groups) | **POST** /vdb-groups/search | Search for VDB Groups.
*VDBGroupsApi* | [**start_vdb_group**](docs/VDBGroupsApi.md#start_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/start | Start a VDB Group.
*VDBGroupsApi* | [**stop_vdb_group**](docs/VDBGroupsApi.md#stop_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/stop | Stop a VDB Group.
*VDBGroupsApi* | [**unlock_vdb_group**](docs/VDBGroupsApi.md#unlock_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/unlock | Unlock a VDB Group.
*VDBGroupsApi* | [**update_vdb_group_by_id**](docs/VDBGroupsApi.md#update_vdb_group_by_id) | **PATCH** /vdb-groups/{vdbGroupId} | Update values of a VDB group.
*VDBsApi* | [**create_vdb_tags**](docs/VDBsApi.md#create_vdb_tags) | **POST** /vdbs/{vdbId}/tags | Create tags for a VDB.
*VDBsApi* | [**delete_vdb**](docs/VDBsApi.md#delete_vdb) | **POST** /vdbs/{vdbId}/delete | Delete a VDB.
*VDBsApi* | [**delete_vdb_tags**](docs/VDBsApi.md#delete_vdb_tags) | **POST** /vdbs/{vdbId}/tags/delete | Delete tags for a VDB.
*VDBsApi* | [**disable_vdb**](docs/VDBsApi.md#disable_vdb) | **POST** /vdbs/{vdbId}/disable | Disable a VDB.
*VDBsApi* | [**enable_vdb**](docs/VDBsApi.md#enable_vdb) | **POST** /vdbs/{vdbId}/enable | Enable a VDB.
*VDBsApi* | [**get_bookmarks_by_vdb**](docs/VDBsApi.md#get_bookmarks_by_vdb) | **GET** /vdbs/{vdbId}/bookmarks | List Bookmarks compatible with this VDB.
*VDBsApi* | [**get_tags_vdb**](docs/VDBsApi.md#get_tags_vdb) | **GET** /vdbs/{vdbId}/tags | Get tags for a VDB.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdb_deletion_dependencies**](docs/VDBsApi.md#get_vdb_deletion_dependencies) | **GET** /vdbs/{vdbId}/deletion-dependencies | Get deletion dependencies of a VDB.
*VDBsApi* | [**get_vdb_snapshots**](docs/VDBsApi.md#get_vdb_snapshots) | **GET** /vdbs/{vdbId}/snapshots | List Snapshots for a VDB.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.
*VDBsApi* | [**lock_vdb**](docs/VDBsApi.md#lock_vdb) | **POST** /vdbs/{vdbId}/lock | Lock a VDB.
*VDBsApi* | [**migrate_vdb**](docs/VDBsApi.md#migrate_vdb) | **POST** /vdbs/{vdbId}/migrate | Migrate a VDB.
*VDBsApi* | [**oracle_asm_in_place_vdb_export**](docs/VDBsApi.md#oracle_asm_in_place_vdb_export) | **POST** /vdbs/{vdbId}/asm-in-place-export | Convert a VDB/vPDB to a physical DB/PDB on Oracle ASM file system.
*VDBsApi* | [**provision_vdb_by_location**](docs/VDBsApi.md#provision_vdb_by_location) | **POST** /vdbs/provision_by_location | Provision a new VDB by location.
*VDBsApi* | [**provision_vdb_by_location_defaults**](docs/VDBsApi.md#provision_vdb_by_location_defaults) | **POST** /vdbs/provision_by_location/defaults | Get default provision parameters for provisioning a new VDB by location.
*VDBsApi* | [**provision_vdb_by_snapshot**](docs/VDBsApi.md#provision_vdb_by_snapshot) | **POST** /vdbs/provision_by_snapshot | Provision a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_snapshot_defaults**](docs/VDBsApi.md#provision_vdb_by_snapshot_defaults) | **POST** /vdbs/provision_by_snapshot/defaults | Get default provision parameters for provisioning a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_timestamp**](docs/VDBsApi.md#provision_vdb_by_timestamp) | **POST** /vdbs/provision_by_timestamp | Provision a new VDB by timestamp.
*VDBsApi* | [**provision_vdb_by_timestamp_defaults**](docs/VDBsApi.md#provision_vdb_by_timestamp_defaults) | **POST** /vdbs/provision_by_timestamp/defaults | Get default provision parameters for provisioning a new VDB by timestamp.
*VDBsApi* | [**provision_vdb_from_bookmark**](docs/VDBsApi.md#provision_vdb_from_bookmark) | **POST** /vdbs/provision_from_bookmark | Provision a new VDB from a bookmark with a single VDB.
*VDBsApi* | [**provision_vdb_from_bookmark_defaults**](docs/VDBsApi.md#provision_vdb_from_bookmark_defaults) | **POST** /vdbs/provision_from_bookmark/defaults | Get default provision parameters for provisioning a new VDB from a bookmark.
*VDBsApi* | [**refresh_vdb_by_location**](docs/VDBsApi.md#refresh_vdb_by_location) | **POST** /vdbs/{vdbId}/refresh_by_location | Refresh a VDB by location.
*VDBsApi* | [**refresh_vdb_by_snapshot**](docs/VDBsApi.md#refresh_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/refresh_by_snapshot | Refresh a VDB by snapshot.
*VDBsApi* | [**refresh_vdb_by_timestamp**](docs/VDBsApi.md#refresh_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/refresh_by_timestamp | Refresh a VDB by timestamp.
*VDBsApi* | [**refresh_vdb_from_bookmark**](docs/VDBsApi.md#refresh_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/refresh_from_bookmark | Refresh a VDB from bookmark with a single VDB.
*VDBsApi* | [**rollback_vdb_by_snapshot**](docs/VDBsApi.md#rollback_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/rollback_by_snapshot | Rollback a VDB by snapshot.
*VDBsApi* | [**rollback_vdb_by_timestamp**](docs/VDBsApi.md#rollback_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/rollback_by_timestamp | Rollback a VDB by timestamp.
*VDBsApi* | [**rollback_vdb_from_bookmark**](docs/VDBsApi.md#rollback_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/rollback_from_bookmark | Rollback a VDB from a bookmark with only the same VDB.
*VDBsApi* | [**search_bookmarks_by_vdb**](docs/VDBsApi.md#search_bookmarks_by_vdb) | **POST** /vdbs/{vdbId}/bookmarks/search | Search Bookmarks compatible with this VDB.
*VDBsApi* | [**search_vdbs**](docs/VDBsApi.md#search_vdbs) | **POST** /vdbs/search | Search for VDBs.
*VDBsApi* | [**snapshot_vdb**](docs/VDBsApi.md#snapshot_vdb) | **POST** /vdbs/{vdbId}/snapshots | Snapshot a VDB.
*VDBsApi* | [**start_vdb**](docs/VDBsApi.md#start_vdb) | **POST** /vdbs/{vdbId}/start | Start a VDB.
*VDBsApi* | [**stop_vdb**](docs/VDBsApi.md#stop_vdb) | **POST** /vdbs/{vdbId}/stop | Stop a VDB.
*VDBsApi* | [**switch_timeflow**](docs/VDBsApi.md#switch_timeflow) | **POST** /vdbs/{vdbId}/switch_timeflow | Switches the current timeflow of a VDB.
*VDBsApi* | [**undo_refresh**](docs/VDBsApi.md#undo_refresh) | **POST** /vdbs/{vdbId}/undo_refresh | Undo the last refresh operation.
*VDBsApi* | [**unlock_vdb**](docs/VDBsApi.md#unlock_vdb) | **POST** /vdbs/{vdbId}/unlock | Unlock a VDB.
*VDBsApi* | [**update_vdb_by_id**](docs/VDBsApi.md#update_vdb_by_id) | **PATCH** /vdbs/{vdbId} | Update values of a VDB
*VDBsApi* | [**upgrade_oracle_vdb**](docs/VDBsApi.md#upgrade_oracle_vdb) | **POST** /vdbs/oracle/{vdbId}/upgrade | Upgrade Oracle VDB
*VDBsApi* | [**upgrade_vdb**](docs/VDBsApi.md#upgrade_vdb) | **POST** /vdbs/{vdbId}/upgrade | Upgrade VDB
*VDBsApi* | [**verify_vdb_jdbc_connection_string**](docs/VDBsApi.md#verify_vdb_jdbc_connection_string) | **POST** /vdbs/{vdbId}/jdbc-check | Verify JDBC connection string for VDB.
*VirtualizationActionsApi* | [**get_virtualization_action_history**](docs/VirtualizationActionsApi.md#get_virtualization_action_history) | **GET** /virtualization-actions/history | Fetch a list of all virtualization actions
*VirtualizationActionsApi* | [**search_virtualization_action_history**](docs/VirtualizationActionsApi.md#search_virtualization_action_history) | **POST** /virtualization-actions/history/search | Search virtualization actions
*VirtualizationAlertsApi* | [**get_virtualization_alerts_history**](docs/VirtualizationAlertsApi.md#get_virtualization_alerts_history) | **GET** /virtualization-alerts/history | Fetch a list of all virtualization alerts
*VirtualizationAlertsApi* | [**search_virtualization_alerts_history**](docs/VirtualizationAlertsApi.md#search_virtualization_alerts_history) | **POST** /virtualization-alerts/history/search | Search virtualization alerts
*VirtualizationFaultsApi* | [**get_virtualization_faults_history**](docs/VirtualizationFaultsApi.md#get_virtualization_faults_history) | **GET** /virtualization-faults/history | Fetch a list of all virtualization faults
*VirtualizationFaultsApi* | [**resolve_all_virtualization_faults**](docs/VirtualizationFaultsApi.md#resolve_all_virtualization_faults) | **POST** /virtualization-faults/{engineId}/resolveAll | Marks all active faults of an engine that the user has permissions over as resolved.
*VirtualizationFaultsApi* | [**resolve_or_ignore_virtualization_faults**](docs/VirtualizationFaultsApi.md#resolve_or_ignore_virtualization_faults) | **POST** /virtualization-faults/resolveOrIgnore | Marks selected faults as resolved or ignored.
*VirtualizationFaultsApi* | [**resolve_virtualization_fault**](docs/VirtualizationFaultsApi.md#resolve_virtualization_fault) | **POST** /virtualization-fault/{faultId}/resolve | Marks the fault as resolved. The Delphix engine will attempt to automatically detect cases where the fault has been resolved; but this is not always possible and may only occur on periodic intervals. In these cases, the user can proactively mark the fault resolved. This does not change the underlying disposition of the fault - if the problem is still present the system may immediately diagnose the same problem again. This should only be used to notify the system of resolution after the underlying problem has been resolved.
*VirtualizationFaultsApi* | [**search_virtualization_faults_history**](docs/VirtualizationFaultsApi.md#search_virtualization_faults_history) | **POST** /virtualization-faults/history/search | Search virtualization faults
*VirtualizationJobsApi* | [**get_virtualization_job_history**](docs/VirtualizationJobsApi.md#get_virtualization_job_history) | **GET** /virtualization-jobs/history | Fetch a list of all virtualization jobs
*VirtualizationJobsApi* | [**search_virtualization_job_history**](docs/VirtualizationJobsApi.md#search_virtualization_job_history) | **POST** /virtualization-jobs/history/search | Search virtualization jobs
*VirtualizationPoliciesApi* | [**apply_virtualization_policy_by_id_or_name**](docs/VirtualizationPoliciesApi.md#apply_virtualization_policy_by_id_or_name) | **POST** /virtualization-policies/{policyId}/apply | Apply a virtualization policy to the given list of objects.
*VirtualizationPoliciesApi* | [**convert_virtualization_policy**](docs/VirtualizationPoliciesApi.md#convert_virtualization_policy) | **POST** /virtualization-policies/{policyId}/convert | Convert a virtualization policy to a DCT-managed policy.
*VirtualizationPoliciesApi* | [**create_virtualization_policy**](docs/VirtualizationPoliciesApi.md#create_virtualization_policy) | **POST** /virtualization-policies | Create a VirtualizationPolicy.
*VirtualizationPoliciesApi* | [**create_virtualization_policy_tags**](docs/VirtualizationPoliciesApi.md#create_virtualization_policy_tags) | **POST** /virtualization-policies/{policyId}/tags | Create tags for a VirtualizationPolicy.
*VirtualizationPoliciesApi* | [**delete_virtualization_policy**](docs/VirtualizationPoliciesApi.md#delete_virtualization_policy) | **DELETE** /virtualization-policies/{policyId} | Delete a VirtualizationPolicy.
*VirtualizationPoliciesApi* | [**delete_virtualization_policy_tags**](docs/VirtualizationPoliciesApi.md#delete_virtualization_policy_tags) | **POST** /virtualization-policies/{policyId}/tags/delete | Delete tags for a VirtualizationPolicy.
*VirtualizationPoliciesApi* | [**get_virtualization_policy_by_id**](docs/VirtualizationPoliciesApi.md#get_virtualization_policy_by_id) | **GET** /virtualization-policies/{policyId} | Fetch a virtualization policy by Id.
*VirtualizationPoliciesApi* | [**get_virtualization_policy_tags**](docs/VirtualizationPoliciesApi.md#get_virtualization_policy_tags) | **GET** /virtualization-policies/{policyId}/tags | Get tags for a VirtualizationPolicy.
*VirtualizationPoliciesApi* | [**list_virtualization_policies**](docs/VirtualizationPoliciesApi.md#list_virtualization_policies) | **GET** /virtualization-policies | Fetch a list of all virtualization policies
*VirtualizationPoliciesApi* | [**search_virtualization_policies**](docs/VirtualizationPoliciesApi.md#search_virtualization_policies) | **POST** /virtualization-policies/search | Search Virtualization Policies.
*VirtualizationPoliciesApi* | [**search_virtualization_policy_targets**](docs/VirtualizationPoliciesApi.md#search_virtualization_policy_targets) | **POST** /virtualization-policies/targets/search | Search Virtualization Policy Target Objects.
*VirtualizationPoliciesApi* | [**unapply_virtualization_policy_by_id_or_name**](docs/VirtualizationPoliciesApi.md#unapply_virtualization_policy_by_id_or_name) | **POST** /virtualization-policies/{policyId}/unapply | Unapply a virtualization policy to the given list of objects.
*VirtualizationPoliciesApi* | [**update_virtualization_policy**](docs/VirtualizationPoliciesApi.md#update_virtualization_policy) | **PATCH** /virtualization-policies/{policyId} | Update a VirtualizationPolicy.


## Documentation For Models

 - [APIClassificationConfig](docs/APIClassificationConfig.md)
 - [ASEDSourceLinkSourceParameters](docs/ASEDSourceLinkSourceParameters.md)
 - [ASEDSourceLinkSourceParametersAllOf](docs/ASEDSourceLinkSourceParametersAllOf.md)
 - [AccessGroup](docs/AccessGroup.md)
 - [AccessGroupAccountIdsRequest](docs/AccessGroupAccountIdsRequest.md)
 - [AccessGroupScope](docs/AccessGroupScope.md)
 - [AccessGroupScopesRequest](docs/AccessGroupScopesRequest.md)
 - [AccessGroupUpdateParameters](docs/AccessGroupUpdateParameters.md)
 - [Account](docs/Account.md)
 - [AccountCreateParameter](docs/AccountCreateParameter.md)
 - [AccountCreateResponse](docs/AccountCreateResponse.md)
 - [AccountLoginParameter](docs/AccountLoginParameter.md)
 - [AccountUiProfilesResponse](docs/AccountUiProfilesResponse.md)
 - [AccountUpdateParameter](docs/AccountUpdateParameter.md)
 - [AddEngineToHyperscaleResponse](docs/AddEngineToHyperscaleResponse.md)
 - [AddEngineToJobResponse](docs/AddEngineToJobResponse.md)
 - [AddUiProfilesResponse](docs/AddUiProfilesResponse.md)
 - [AdditionalMountPoint](docs/AdditionalMountPoint.md)
 - [Algorithm](docs/Algorithm.md)
 - [AllObjectPermissionsResponse](docs/AllObjectPermissionsResponse.md)
 - [AlwaysAllowedPermission](docs/AlwaysAllowedPermission.md)
 - [AlwaysAllowedPermissionRequest](docs/AlwaysAllowedPermissionRequest.md)
 - [ApiClassificationObject](docs/ApiClassificationObject.md)
 - [ApiUsageData](docs/ApiUsageData.md)
 - [ApiUsageReportResponse](docs/ApiUsageReportResponse.md)
 - [ApikeyRegenerateParameter](docs/ApikeyRegenerateParameter.md)
 - [AppDataDSourceLinkSourceParameters](docs/AppDataDSourceLinkSourceParameters.md)
 - [AppDataDSourceLinkSourceParametersAllOf](docs/AppDataDSourceLinkSourceParametersAllOf.md)
 - [AppDataSourceCreateParameters](docs/AppDataSourceCreateParameters.md)
 - [AttachCDBResponse](docs/AttachCDBResponse.md)
 - [AttachDSourceResponse](docs/AttachDSourceResponse.md)
 - [AttachStagingPushDSourceResponse](docs/AttachStagingPushDSourceResponse.md)
 - [AuditLogsSummary](docs/AuditLogsSummary.md)
 - [AuditLogsSummaryReportResponse](docs/AuditLogsSummaryReportResponse.md)
 - [AuditLogsSummaryTotals](docs/AuditLogsSummaryTotals.md)
 - [AutoTaggingConfig](docs/AutoTaggingConfig.md)
 - [BaseDSourceLinkSourceParameters](docs/BaseDSourceLinkSourceParameters.md)
 - [BaseProvisionVDBParameters](docs/BaseProvisionVDBParameters.md)
 - [BaseProvisionVDBParametersAllOf](docs/BaseProvisionVDBParametersAllOf.md)
 - [Bookmark](docs/Bookmark.md)
 - [BookmarkCompatibleEnvironmentsResponse](docs/BookmarkCompatibleEnvironmentsResponse.md)
 - [BookmarkCompatibleRepositoryRequest](docs/BookmarkCompatibleRepositoryRequest.md)
 - [BookmarkCreateParameters](docs/BookmarkCreateParameters.md)
 - [BookmarkDSources](docs/BookmarkDSources.md)
 - [BookmarkVDBs](docs/BookmarkVDBs.md)
 - [BundleUploadEvent](docs/BundleUploadEvent.md)
 - [CDB](docs/CDB.md)
 - [CancelJobCollectionExecutionResponse](docs/CancelJobCollectionExecutionResponse.md)
 - [ChangeLicenseParameters](docs/ChangeLicenseParameters.md)
 - [ChangePasswordParameter](docs/ChangePasswordParameter.md)
 - [Classifier](docs/Classifier.md)
 - [ClassifiersListResponse](docs/ClassifiersListResponse.md)
 - [ClassifiersSearchResponse](docs/ClassifiersSearchResponse.md)
 - [CleanupExecutionResponse](docs/CleanupExecutionResponse.md)
 - [ClusterNodeInstance](docs/ClusterNodeInstance.md)
 - [CommvaultConnectivityCheckParameters](docs/CommvaultConnectivityCheckParameters.md)
 - [ComplianceApplicationSetting](docs/ComplianceApplicationSetting.md)
 - [ComplianceApplicationSettingsListResponse](docs/ComplianceApplicationSettingsListResponse.md)
 - [ComplianceApplicationSettingsSearchResponse](docs/ComplianceApplicationSettingsSearchResponse.md)
 - [ComplianceJob](docs/ComplianceJob.md)
 - [ComplianceJobCollection](docs/ComplianceJobCollection.md)
 - [ComplianceJobCollectionMembers](docs/ComplianceJobCollectionMembers.md)
 - [ComplianceJobConnectorsResponse](docs/ComplianceJobConnectorsResponse.md)
 - [ConfigSettingsStg](docs/ConfigSettingsStg.md)
 - [ConnectivityCheckParameters](docs/ConnectivityCheckParameters.md)
 - [ConnectivityCheckResponse](docs/ConnectivityCheckResponse.md)
 - [Connector](docs/Connector.md)
 - [ConnectorTestResponse](docs/ConnectorTestResponse.md)
 - [ConnectorTypeEnum](docs/ConnectorTypeEnum.md)
 - [ConnectorUpdateParameters](docs/ConnectorUpdateParameters.md)
 - [Consumer](docs/Consumer.md)
 - [ContainerizationStateEnum](docs/ContainerizationStateEnum.md)
 - [ConvertDataLayoutRequest](docs/ConvertDataLayoutRequest.md)
 - [ConvertDataLayoutResponse](docs/ConvertDataLayoutResponse.md)
 - [CopyMaskingJobParameters](docs/CopyMaskingJobParameters.md)
 - [CopyMaskingJobResponse](docs/CopyMaskingJobResponse.md)
 - [CreateAppDataSourceResponse](docs/CreateAppDataSourceResponse.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [CreateComplianceJobCollectionRequest](docs/CreateComplianceJobCollectionRequest.md)
 - [CreateComplianceJobCollectionResponse](docs/CreateComplianceJobCollectionResponse.md)
 - [CreateDatabaseTemplateResponse](docs/CreateDatabaseTemplateResponse.md)
 - [CreateEnvironmentResponse](docs/CreateEnvironmentResponse.md)
 - [CreateEnvironmentUserResponse](docs/CreateEnvironmentUserResponse.md)
 - [CreateHostResponse](docs/CreateHostResponse.md)
 - [CreateHyperscaleConnectorResponse](docs/CreateHyperscaleConnectorResponse.md)
 - [CreateHyperscaleMountPointResponse](docs/CreateHyperscaleMountPointResponse.md)
 - [CreateMaskingJobRequest](docs/CreateMaskingJobRequest.md)
 - [CreateMaskingJobResponse](docs/CreateMaskingJobResponse.md)
 - [CreateOracleListenerParams](docs/CreateOracleListenerParams.md)
 - [CreateOracleListenerResponse](docs/CreateOracleListenerResponse.md)
 - [CreateOracleSourceResponse](docs/CreateOracleSourceResponse.md)
 - [CreatePostgresSourceResponse](docs/CreatePostgresSourceResponse.md)
 - [CreateReplicationProfileParameters](docs/CreateReplicationProfileParameters.md)
 - [CreateReplicationProfileResponse](docs/CreateReplicationProfileResponse.md)
 - [CreateRepositoryParams](docs/CreateRepositoryParams.md)
 - [CreateRepositoryResponse](docs/CreateRepositoryResponse.md)
 - [CreateRole](docs/CreateRole.md)
 - [CreateVDBGroupOrder](docs/CreateVDBGroupOrder.md)
 - [CreateVDBGroupRequest](docs/CreateVDBGroupRequest.md)
 - [CreateVDBGroupResponse](docs/CreateVDBGroupResponse.md)
 - [CreateVirtualizationPolicyParameters](docs/CreateVirtualizationPolicyParameters.md)
 - [CreateVirtualizationPolicyResponse](docs/CreateVirtualizationPolicyResponse.md)
 - [CredentialsEnvVariable](docs/CredentialsEnvVariable.md)
 - [DSource](docs/DSource.md)
 - [DSourceConsumptionData](docs/DSourceConsumptionData.md)
 - [DSourceConsumptionReportResponse](docs/DSourceConsumptionReportResponse.md)
 - [DSourceHooks](docs/DSourceHooks.md)
 - [DSourceSnapshotParameters](docs/DSourceSnapshotParameters.md)
 - [DSourceUsageData](docs/DSourceUsageData.md)
 - [DSourceUsageReportResponse](docs/DSourceUsageReportResponse.md)
 - [DataClass](docs/DataClass.md)
 - [DataClassUpdateParams](docs/DataClassUpdateParams.md)
 - [DataClassUpdateResponse](docs/DataClassUpdateResponse.md)
 - [DataClassesListResponse](docs/DataClassesListResponse.md)
 - [DataClassesSearchResponse](docs/DataClassesSearchResponse.md)
 - [DataLayout](docs/DataLayout.md)
 - [DataPointByLocationParameters](docs/DataPointByLocationParameters.md)
 - [DataPointBySnapshotParameters](docs/DataPointBySnapshotParameters.md)
 - [DataPointByTimestampParameters](docs/DataPointByTimestampParameters.md)
 - [DataPointFromBookmarkParameters](docs/DataPointFromBookmarkParameters.md)
 - [DataRiskData](docs/DataRiskData.md)
 - [DataRiskReportTotals](docs/DataRiskReportTotals.md)
 - [DatabaseColumnMetadata](docs/DatabaseColumnMetadata.md)
 - [DatabaseColumnMetadataListResponse](docs/DatabaseColumnMetadataListResponse.md)
 - [DatabaseColumnMetadataSearchResponse](docs/DatabaseColumnMetadataSearchResponse.md)
 - [DatabaseConnectivityCheckParameters](docs/DatabaseConnectivityCheckParameters.md)
 - [DatabaseTableMetadata](docs/DatabaseTableMetadata.md)
 - [DatabaseTableMetadataListResponse](docs/DatabaseTableMetadataListResponse.md)
 - [DatabaseTableMetadataSearchResponse](docs/DatabaseTableMetadataSearchResponse.md)
 - [DatabaseTemplate](docs/DatabaseTemplate.md)
 - [DatabaseTemplateCreateParameters](docs/DatabaseTemplateCreateParameters.md)
 - [DatasetGroup](docs/DatasetGroup.md)
 - [DeleteCDBParameters](docs/DeleteCDBParameters.md)
 - [DeleteCDBResponse](docs/DeleteCDBResponse.md)
 - [DeleteComplianceJobCollectionResponse](docs/DeleteComplianceJobCollectionResponse.md)
 - [DeleteDSourceRequest](docs/DeleteDSourceRequest.md)
 - [DeleteDSourceResponse](docs/DeleteDSourceResponse.md)
 - [DeleteDSourceResponseAllOf](docs/DeleteDSourceResponseAllOf.md)
 - [DeleteDatabaseTemplateResponse](docs/DeleteDatabaseTemplateResponse.md)
 - [DeleteEngineResponse](docs/DeleteEngineResponse.md)
 - [DeleteEnvironmentResponse](docs/DeleteEnvironmentResponse.md)
 - [DeleteEnvironmentUserResponse](docs/DeleteEnvironmentUserResponse.md)
 - [DeleteHostResponse](docs/DeleteHostResponse.md)
 - [DeleteHyperscaleConnectorResponse](docs/DeleteHyperscaleConnectorResponse.md)
 - [DeleteHyperscaleMountPointResponse](docs/DeleteHyperscaleMountPointResponse.md)
 - [DeleteMaskingJobResponse](docs/DeleteMaskingJobResponse.md)
 - [DeleteOracleListenerResponse](docs/DeleteOracleListenerResponse.md)
 - [DeleteScopeObjectTags](docs/DeleteScopeObjectTags.md)
 - [DeleteScopedObjectItem](docs/DeleteScopedObjectItem.md)
 - [DeleteSnapshotResponse](docs/DeleteSnapshotResponse.md)
 - [DeleteSourceResponse](docs/DeleteSourceResponse.md)
 - [DeleteTag](docs/DeleteTag.md)
 - [DeleteTimeflowResponse](docs/DeleteTimeflowResponse.md)
 - [DeleteVCDBParameters](docs/DeleteVCDBParameters.md)
 - [DeleteVCDBResponse](docs/DeleteVCDBResponse.md)
 - [DeleteVDBParameters](docs/DeleteVDBParameters.md)
 - [DeleteVDBResponse](docs/DeleteVDBResponse.md)
 - [DeletionDependenciesResponse](docs/DeletionDependenciesResponse.md)
 - [Dependency](docs/Dependency.md)
 - [DetachCDBResponse](docs/DetachCDBResponse.md)
 - [DetachDSourceResponse](docs/DetachDSourceResponse.md)
 - [DisableCDBParameters](docs/DisableCDBParameters.md)
 - [DisableCDBResponse](docs/DisableCDBResponse.md)
 - [DisableDsourceParameters](docs/DisableDsourceParameters.md)
 - [DisableDsourceResponse](docs/DisableDsourceResponse.md)
 - [DisableEnvironmentResponse](docs/DisableEnvironmentResponse.md)
 - [DisableVCDBParameters](docs/DisableVCDBParameters.md)
 - [DisableVCDBResponse](docs/DisableVCDBResponse.md)
 - [DisableVDBGroupParameters](docs/DisableVDBGroupParameters.md)
 - [DisableVDBGroupResponse](docs/DisableVDBGroupResponse.md)
 - [DisableVDBParameters](docs/DisableVDBParameters.md)
 - [DisableVDBResponse](docs/DisableVDBResponse.md)
 - [DiscoveryExpression](docs/DiscoveryExpression.md)
 - [DiscoveryExpressionsListResponse](docs/DiscoveryExpressionsListResponse.md)
 - [DiscoveryExpressionsSearchResponse](docs/DiscoveryExpressionsSearchResponse.md)
 - [DiscoveryPoliciesListResponse](docs/DiscoveryPoliciesListResponse.md)
 - [DiscoveryPoliciesSearchResponse](docs/DiscoveryPoliciesSearchResponse.md)
 - [DiscoveryPolicy](docs/DiscoveryPolicy.md)
 - [DiscoveryResult](docs/DiscoveryResult.md)
 - [Domain](docs/Domain.md)
 - [EffectiveScope](docs/EffectiveScope.md)
 - [EnableCDBParameters](docs/EnableCDBParameters.md)
 - [EnableCDBResponse](docs/EnableCDBResponse.md)
 - [EnableDsourceParameters](docs/EnableDsourceParameters.md)
 - [EnableDsourceResponse](docs/EnableDsourceResponse.md)
 - [EnableEnvironmentResponse](docs/EnableEnvironmentResponse.md)
 - [EnableVCDBParameters](docs/EnableVCDBParameters.md)
 - [EnableVCDBResponse](docs/EnableVCDBResponse.md)
 - [EnableVDBGroupParameters](docs/EnableVDBGroupParameters.md)
 - [EnableVDBGroupResponse](docs/EnableVDBGroupResponse.md)
 - [EnableVDBParameters](docs/EnableVDBParameters.md)
 - [EnableVDBResponse](docs/EnableVDBResponse.md)
 - [Engine](docs/Engine.md)
 - [EngineAutoTaggingConfigUpdateParameters](docs/EngineAutoTaggingConfigUpdateParameters.md)
 - [EngineGlobalObjectStateData](docs/EngineGlobalObjectStateData.md)
 - [EngineHistoricalStorageSummary](docs/EngineHistoricalStorageSummary.md)
 - [EngineIdBody](docs/EngineIdBody.md)
 - [EnginePerformanceAnalytic](docs/EnginePerformanceAnalytic.md)
 - [EnginePerformanceAnalyticReportResponse](docs/EnginePerformanceAnalyticReportResponse.md)
 - [EnginePerformanceAnalyticTrend](docs/EnginePerformanceAnalyticTrend.md)
 - [EnginePerformanceAnalyticTrendDatapoint](docs/EnginePerformanceAnalyticTrendDatapoint.md)
 - [EnginePerformanceAnalyticTrendResponse](docs/EnginePerformanceAnalyticTrendResponse.md)
 - [EngineRegistrationParameter](docs/EngineRegistrationParameter.md)
 - [EngineStorageCapacityData](docs/EngineStorageCapacityData.md)
 - [EngineStorageCapacityDataResponse](docs/EngineStorageCapacityDataResponse.md)
 - [EngineStorageCapacityDependencyData](docs/EngineStorageCapacityDependencyData.md)
 - [EngineStorageCapacityDependencyDataAllOf](docs/EngineStorageCapacityDependencyDataAllOf.md)
 - [EngineStorageDatasetType](docs/EngineStorageDatasetType.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentCreateParameters](docs/EnvironmentCreateParameters.md)
 - [EnvironmentRepository](docs/EnvironmentRepository.md)
 - [EnvironmentRepositoryAllOf](docs/EnvironmentRepositoryAllOf.md)
 - [EnvironmentUpdateParameters](docs/EnvironmentUpdateParameters.md)
 - [EnvironmentUser](docs/EnvironmentUser.md)
 - [EnvironmentUserParams](docs/EnvironmentUserParams.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [ExecuteComplianceJobCollectionResponse](docs/ExecuteComplianceJobCollectionResponse.md)
 - [ExecuteComplianceJobResponse](docs/ExecuteComplianceJobResponse.md)
 - [ExecuteMaskingJobParameters](docs/ExecuteMaskingJobParameters.md)
 - [ExecuteMaskingJobResponse](docs/ExecuteMaskingJobResponse.md)
 - [ExecuteReplicationProfileResponse](docs/ExecuteReplicationProfileResponse.md)
 - [Execution](docs/Execution.md)
 - [ExecutionCancelParameters](docs/ExecutionCancelParameters.md)
 - [ExecutionComponent](docs/ExecutionComponent.md)
 - [ExecutionComponentLog](docs/ExecutionComponentLog.md)
 - [ExecutionComponentsListResponse](docs/ExecutionComponentsListResponse.md)
 - [ExecutionComponentsSearchResponse](docs/ExecutionComponentsSearchResponse.md)
 - [ExecutionEvent](docs/ExecutionEvent.md)
 - [ExecutionLog](docs/ExecutionLog.md)
 - [ExecutionStatus](docs/ExecutionStatus.md)
 - [ExecutionStatusReason](docs/ExecutionStatusReason.md)
 - [FailoverNamespaceParameters](docs/FailoverNamespaceParameters.md)
 - [FindByLocationResponse](docs/FindByLocationResponse.md)
 - [FindByTimestampResponse](docs/FindByTimestampResponse.md)
 - [GetDataRiskReportResponse](docs/GetDataRiskReportResponse.md)
 - [GetEngineGlobalObjectStateReportResponse](docs/GetEngineGlobalObjectStateReportResponse.md)
 - [GlobalProperties](docs/GlobalProperties.md)
 - [GlobalTag](docs/GlobalTag.md)
 - [GlobalTagPermissions](docs/GlobalTagPermissions.md)
 - [GlobalTagUsage](docs/GlobalTagUsage.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [HistoricalStorageSummary](docs/HistoricalStorageSummary.md)
 - [HistoricalStorageSummaryAggregate](docs/HistoricalStorageSummaryAggregate.md)
 - [Hook](docs/Hook.md)
 - [Host](docs/Host.md)
 - [HostCreateParameters](docs/HostCreateParameters.md)
 - [HostUpdateParameters](docs/HostUpdateParameters.md)
 - [HyperscaleColumnOrField](docs/HyperscaleColumnOrField.md)
 - [HyperscaleConnector](docs/HyperscaleConnector.md)
 - [HyperscaleConnectorCreateParameters](docs/HyperscaleConnectorCreateParameters.md)
 - [HyperscaleConnectorUpdateParameters](docs/HyperscaleConnectorUpdateParameters.md)
 - [HyperscaleDataTypeEnum](docs/HyperscaleDataTypeEnum.md)
 - [HyperscaleDataset](docs/HyperscaleDataset.md)
 - [HyperscaleDatasetTableOrFile](docs/HyperscaleDatasetTableOrFile.md)
 - [HyperscaleDatasetTableOrFileUpdateParameters](docs/HyperscaleDatasetTableOrFileUpdateParameters.md)
 - [HyperscaleDatasetUpdateParameters](docs/HyperscaleDatasetUpdateParameters.md)
 - [HyperscaleInstance](docs/HyperscaleInstance.md)
 - [HyperscaleInstanceRegistrationParameter](docs/HyperscaleInstanceRegistrationParameter.md)
 - [HyperscaleInstanceUpdateParams](docs/HyperscaleInstanceUpdateParams.md)
 - [HyperscaleMountPoint](docs/HyperscaleMountPoint.md)
 - [HyperscaleMountPointUpdateParameters](docs/HyperscaleMountPointUpdateParameters.md)
 - [HyperscaleTaskError](docs/HyperscaleTaskError.md)
 - [HyperscaleTaskEvent](docs/HyperscaleTaskEvent.md)
 - [ImportEngineAccountRequest](docs/ImportEngineAccountRequest.md)
 - [ImportEngineAccountsResponse](docs/ImportEngineAccountsResponse.md)
 - [ImportEngineBookmarkResponse](docs/ImportEngineBookmarkResponse.md)
 - [Job](docs/Job.md)
 - [JobCollectionExecution](docs/JobCollectionExecution.md)
 - [JobCollectionFailureHandlingEnum](docs/JobCollectionFailureHandlingEnum.md)
 - [JobResultResponse](docs/JobResultResponse.md)
 - [JobTask](docs/JobTask.md)
 - [JobTaskEvent](docs/JobTaskEvent.md)
 - [KDCServers](docs/KDCServers.md)
 - [KerberosConfig](docs/KerberosConfig.md)
 - [LDAPConfigParams](docs/LDAPConfigParams.md)
 - [LatestSnapshotsResponse](docs/LatestSnapshotsResponse.md)
 - [LdapConfigValidateParameter](docs/LdapConfigValidateParameter.md)
 - [LdapValidateResponse](docs/LdapValidateResponse.md)
 - [LicenseInfo](docs/LicenseInfo.md)
 - [LicenseTier](docs/LicenseTier.md)
 - [LinkDSourceDefaultRequest](docs/LinkDSourceDefaultRequest.md)
 - [LinkDSourceResponse](docs/LinkDSourceResponse.md)
 - [LinkStagingPushDSourceDefaultRequest](docs/LinkStagingPushDSourceDefaultRequest.md)
 - [ListAccessGroupsResponse](docs/ListAccessGroupsResponse.md)
 - [ListAccountsResponse](docs/ListAccountsResponse.md)
 - [ListAlgorithmDependenciesResponse](docs/ListAlgorithmDependenciesResponse.md)
 - [ListAlgorithmsResponse](docs/ListAlgorithmsResponse.md)
 - [ListBookmarksByVDBGroupsResponse](docs/ListBookmarksByVDBGroupsResponse.md)
 - [ListBookmarksByVDBResponse](docs/ListBookmarksByVDBResponse.md)
 - [ListBookmarksResponse](docs/ListBookmarksResponse.md)
 - [ListCDBsResponse](docs/ListCDBsResponse.md)
 - [ListComplianceJobCollectionsResponse](docs/ListComplianceJobCollectionsResponse.md)
 - [ListComplianceJobsResponse](docs/ListComplianceJobsResponse.md)
 - [ListConnectorsMaskingJobsResponse](docs/ListConnectorsMaskingJobsResponse.md)
 - [ListConnectorsResponse](docs/ListConnectorsResponse.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListDataLayoutResponse](docs/ListDataLayoutResponse.md)
 - [ListDatabaseTemplatesResponse](docs/ListDatabaseTemplatesResponse.md)
 - [ListDiscoveryResultsResponse](docs/ListDiscoveryResultsResponse.md)
 - [ListEnvironmentUsers](docs/ListEnvironmentUsers.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListExecutionEventsResponse](docs/ListExecutionEventsResponse.md)
 - [ListExecutionsResponse](docs/ListExecutionsResponse.md)
 - [ListGroupsResponse](docs/ListGroupsResponse.md)
 - [ListHashicorpVaultsResponse](docs/ListHashicorpVaultsResponse.md)
 - [ListHyperscaleConnectorsResponse](docs/ListHyperscaleConnectorsResponse.md)
 - [ListHyperscaleDatasetTablesOrFilesResponse](docs/ListHyperscaleDatasetTablesOrFilesResponse.md)
 - [ListHyperscaleDatasetsResponse](docs/ListHyperscaleDatasetsResponse.md)
 - [ListHyperscaleInstancesResponse](docs/ListHyperscaleInstancesResponse.md)
 - [ListHyperscaleMountPointsResponse](docs/ListHyperscaleMountPointsResponse.md)
 - [ListJobCollectionExecutionsResponse](docs/ListJobCollectionExecutionsResponse.md)
 - [ListJobsResponse](docs/ListJobsResponse.md)
 - [ListKerberosConfigsResponse](docs/ListKerberosConfigsResponse.md)
 - [ListMaskingEnvironmentsResponse](docs/ListMaskingEnvironmentsResponse.md)
 - [ListMaskingFileConsumersResponse](docs/ListMaskingFileConsumersResponse.md)
 - [ListMaskingFilesResponse](docs/ListMaskingFilesResponse.md)
 - [ListMaskingJobSourceEnginesResponse](docs/ListMaskingJobSourceEnginesResponse.md)
 - [ListMaskingJobsResponse](docs/ListMaskingJobsResponse.md)
 - [ListNamespacesResponse](docs/ListNamespacesResponse.md)
 - [ListPasswordVaultsResponse](docs/ListPasswordVaultsResponse.md)
 - [ListRegisteredEnginesResponse](docs/ListRegisteredEnginesResponse.md)
 - [ListReplicationProfilesResponse](docs/ListReplicationProfilesResponse.md)
 - [ListReportingScheduleResponse](docs/ListReportingScheduleResponse.md)
 - [ListRolesResponse](docs/ListRolesResponse.md)
 - [ListSnapshotsResponse](docs/ListSnapshotsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListStagingSourcesResponse](docs/ListStagingSourcesResponse.md)
 - [ListTagPermissionsResponse](docs/ListTagPermissionsResponse.md)
 - [ListTagUsagesResponse](docs/ListTagUsagesResponse.md)
 - [ListTagsResponse](docs/ListTagsResponse.md)
 - [ListTimeflowsResponse](docs/ListTimeflowsResponse.md)
 - [ListToolkitResponse](docs/ListToolkitResponse.md)
 - [ListVCDBsResponse](docs/ListVCDBsResponse.md)
 - [ListVDBGroupsByBookmarkResponse](docs/ListVDBGroupsByBookmarkResponse.md)
 - [ListVDBGroupsResponse](docs/ListVDBGroupsResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [ListVirtualizationActionsResponse](docs/ListVirtualizationActionsResponse.md)
 - [ListVirtualizationAlertsResponse](docs/ListVirtualizationAlertsResponse.md)
 - [ListVirtualizationFaultsResponse](docs/ListVirtualizationFaultsResponse.md)
 - [ListVirtualizationJobsResponse](docs/ListVirtualizationJobsResponse.md)
 - [ListVirtualizationPoliciesResponse](docs/ListVirtualizationPoliciesResponse.md)
 - [LocationCompatibleEnvironmentsResponse](docs/LocationCompatibleEnvironmentsResponse.md)
 - [LocationCompatibleRepositoryRequest](docs/LocationCompatibleRepositoryRequest.md)
 - [LockVDBGroupParameters](docs/LockVDBGroupParameters.md)
 - [LockVDBParameters](docs/LockVDBParameters.md)
 - [LoginToken](docs/LoginToken.md)
 - [MSSQLClusterListener](docs/MSSQLClusterListener.md)
 - [MSSQLDSourceAttachSourceParameters](docs/MSSQLDSourceAttachSourceParameters.md)
 - [MSSQLDSourceLinkSourceParameters](docs/MSSQLDSourceLinkSourceParameters.md)
 - [MSSQLDSourceLinkSourceParametersAllOf](docs/MSSQLDSourceLinkSourceParametersAllOf.md)
 - [MSSQLDSourceStagingPushAttachSourceParameters](docs/MSSQLDSourceStagingPushAttachSourceParameters.md)
 - [MSSQLDSourceStagingPushLinkSourceParameters](docs/MSSQLDSourceStagingPushLinkSourceParameters.md)
 - [MSSQLDSourceStagingPushLinkSourceParametersAllOf](docs/MSSQLDSourceStagingPushLinkSourceParametersAllOf.md)
 - [MSSQLListenerTypeEnum](docs/MSSQLListenerTypeEnum.md)
 - [MaskingEnvironment](docs/MaskingEnvironment.md)
 - [MaskingExecutionMetrics](docs/MaskingExecutionMetrics.md)
 - [MaskingExecutionMetricsReportResponse](docs/MaskingExecutionMetricsReportResponse.md)
 - [MaskingFileUpload](docs/MaskingFileUpload.md)
 - [MaskingFileUploadUpdateParameters](docs/MaskingFileUploadUpdateParameters.md)
 - [MaskingJob](docs/MaskingJob.md)
 - [MaskingJobConnectorsResponse](docs/MaskingJobConnectorsResponse.md)
 - [MaskingJobSourceEngine](docs/MaskingJobSourceEngine.md)
 - [MaskingJobWithConnectorRole](docs/MaskingJobWithConnectorRole.md)
 - [MaskingRuleset](docs/MaskingRuleset.md)
 - [MetadataDbInfo](docs/MetadataDbInfo.md)
 - [MigrateMaskingJobParameters](docs/MigrateMaskingJobParameters.md)
 - [MigrateMaskingJobResponse](docs/MigrateMaskingJobResponse.md)
 - [MigrateVDBParameters](docs/MigrateVDBParameters.md)
 - [MigrateVDBResponse](docs/MigrateVDBResponse.md)
 - [NameValuePair](docs/NameValuePair.md)
 - [Namespace](docs/Namespace.md)
 - [NamespaceCommitFailoverJobResponse](docs/NamespaceCommitFailoverJobResponse.md)
 - [NamespaceDeleteJobResponse](docs/NamespaceDeleteJobResponse.md)
 - [NamespaceDiscardJobResponse](docs/NamespaceDiscardJobResponse.md)
 - [NamespaceFailbackJobResponse](docs/NamespaceFailbackJobResponse.md)
 - [NamespaceFailoverJobResponse](docs/NamespaceFailoverJobResponse.md)
 - [NamespaceUpdateJobResponse](docs/NamespaceUpdateJobResponse.md)
 - [NetbackupConnectivityCheckParameters](docs/NetbackupConnectivityCheckParameters.md)
 - [ObjectPermissionAccessGroups](docs/ObjectPermissionAccessGroups.md)
 - [ObjectPermissionAccount](docs/ObjectPermissionAccount.md)
 - [ObjectPermissionsResponse](docs/ObjectPermissionsResponse.md)
 - [ObjectTypeEnum](docs/ObjectTypeEnum.md)
 - [ObjectTypeProperty](docs/ObjectTypeProperty.md)
 - [OracleAsmInPlaceExportParameters](docs/OracleAsmInPlaceExportParameters.md)
 - [OracleAsmInPlaceExportParametersAllOf](docs/OracleAsmInPlaceExportParametersAllOf.md)
 - [OracleAsmInPlaceVDBExportResponse](docs/OracleAsmInPlaceVDBExportResponse.md)
 - [OracleAsmLayoutParameters](docs/OracleAsmLayoutParameters.md)
 - [OracleAttachCdbParameters](docs/OracleAttachCdbParameters.md)
 - [OracleAttachDSourceParameters](docs/OracleAttachDSourceParameters.md)
 - [OracleAttachParameters](docs/OracleAttachParameters.md)
 - [OracleBaseExportTransferStrategyParameters](docs/OracleBaseExportTransferStrategyParameters.md)
 - [OracleClusterNodeInstance](docs/OracleClusterNodeInstance.md)
 - [OracleConfigTypeEnum](docs/OracleConfigTypeEnum.md)
 - [OracleDSourceLinkSourceParameters](docs/OracleDSourceLinkSourceParameters.md)
 - [OracleDSourceLinkSourceParametersAllOf](docs/OracleDSourceLinkSourceParametersAllOf.md)
 - [OracleLinkStagingPushDSourceDefaultRequest](docs/OracleLinkStagingPushDSourceDefaultRequest.md)
 - [OracleListener](docs/OracleListener.md)
 - [OracleListenerTypeEnum](docs/OracleListenerTypeEnum.md)
 - [OracleLogsyncModeTypeEnum](docs/OracleLogsyncModeTypeEnum.md)
 - [OracleRACDatabaseInstance](docs/OracleRACDatabaseInstance.md)
 - [OracleRacCustomEnvFile](docs/OracleRacCustomEnvFile.md)
 - [OracleRacCustomEnvVar](docs/OracleRacCustomEnvVar.md)
 - [OracleService](docs/OracleService.md)
 - [OracleSourceCreateParameters](docs/OracleSourceCreateParameters.md)
 - [OracleSourceUpdateParameters](docs/OracleSourceUpdateParameters.md)
 - [OracleStagingPushDSourceLinkSourceParameters](docs/OracleStagingPushDSourceLinkSourceParameters.md)
 - [OracleStagingPushDSourceLinkSourceParametersAllOf](docs/OracleStagingPushDSourceLinkSourceParametersAllOf.md)
 - [OracleTdeKeystoreConfigTypeEnum](docs/OracleTdeKeystoreConfigTypeEnum.md)
 - [OracleVerifyJdbcConnectionStringParams](docs/OracleVerifyJdbcConnectionStringParams.md)
 - [OracleVirtualIP](docs/OracleVirtualIP.md)
 - [PaginatedResponseMetadata](docs/PaginatedResponseMetadata.md)
 - [PasswordPoliciesParams](docs/PasswordPoliciesParams.md)
 - [PasswordVault](docs/PasswordVault.md)
 - [PermissionEnum](docs/PermissionEnum.md)
 - [PermissionObject](docs/PermissionObject.md)
 - [PermissionProperty](docs/PermissionProperty.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PhoneHomeBundle](docs/PhoneHomeBundle.md)
 - [PhoneHomeBundleApiTelemetry](docs/PhoneHomeBundleApiTelemetry.md)
 - [PhoneHomeBundleProductHistory](docs/PhoneHomeBundleProductHistory.md)
 - [PhoneHomeBundleProductInfo](docs/PhoneHomeBundleProductInfo.md)
 - [PhoneHomeBundleRegisteredEngine](docs/PhoneHomeBundleRegisteredEngine.md)
 - [PolicyTargetObject](docs/PolicyTargetObject.md)
 - [PolicyType](docs/PolicyType.md)
 - [PostgresSourceCreateParameters](docs/PostgresSourceCreateParameters.md)
 - [PostgresSourceUpdateParameters](docs/PostgresSourceUpdateParameters.md)
 - [PrimaryEnvironmentUserResponse](docs/PrimaryEnvironmentUserResponse.md)
 - [ProductHistory](docs/ProductHistory.md)
 - [ProductInfo](docs/ProductInfo.md)
 - [ProductRegistrationOfflinePayload](docs/ProductRegistrationOfflinePayload.md)
 - [ProductRegistrationOnlinePayload](docs/ProductRegistrationOnlinePayload.md)
 - [ProvisionSource](docs/ProvisionSource.md)
 - [ProvisionVDBByLocationDefaultsRequest](docs/ProvisionVDBByLocationDefaultsRequest.md)
 - [ProvisionVDBByLocationParameters](docs/ProvisionVDBByLocationParameters.md)
 - [ProvisionVDBByLocationParametersAllOf](docs/ProvisionVDBByLocationParametersAllOf.md)
 - [ProvisionVDBBySnapshotDefaultsRequest](docs/ProvisionVDBBySnapshotDefaultsRequest.md)
 - [ProvisionVDBBySnapshotParameters](docs/ProvisionVDBBySnapshotParameters.md)
 - [ProvisionVDBBySnapshotParametersAllOf](docs/ProvisionVDBBySnapshotParametersAllOf.md)
 - [ProvisionVDBByTimestampDefaultsRequest](docs/ProvisionVDBByTimestampDefaultsRequest.md)
 - [ProvisionVDBByTimestampParameters](docs/ProvisionVDBByTimestampParameters.md)
 - [ProvisionVDBByTimestampParametersAllOf](docs/ProvisionVDBByTimestampParametersAllOf.md)
 - [ProvisionVDBFromBookmarkDefaultsRequest](docs/ProvisionVDBFromBookmarkDefaultsRequest.md)
 - [ProvisionVDBFromBookmarkParameters](docs/ProvisionVDBFromBookmarkParameters.md)
 - [ProvisionVDBFromBookmarkParametersAllOf](docs/ProvisionVDBFromBookmarkParametersAllOf.md)
 - [ProvisionVDBGroupFromBookmarkParameters](docs/ProvisionVDBGroupFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkResponse](docs/ProvisionVDBGroupFromBookmarkResponse.md)
 - [ProvisionVDBResponse](docs/ProvisionVDBResponse.md)
 - [ProxyConfiguration](docs/ProxyConfiguration.md)
 - [ReImportMaskingJobResponse](docs/ReImportMaskingJobResponse.md)
 - [RefreshEnvironmentResponse](docs/RefreshEnvironmentResponse.md)
 - [RefreshModeEnum](docs/RefreshModeEnum.md)
 - [RefreshVDBByLocationParameters](docs/RefreshVDBByLocationParameters.md)
 - [RefreshVDBByLocationResponse](docs/RefreshVDBByLocationResponse.md)
 - [RefreshVDBBySnapshotParameters](docs/RefreshVDBBySnapshotParameters.md)
 - [RefreshVDBBySnapshotResponse](docs/RefreshVDBBySnapshotResponse.md)
 - [RefreshVDBByTimestampParameters](docs/RefreshVDBByTimestampParameters.md)
 - [RefreshVDBByTimestampParametersAllOf](docs/RefreshVDBByTimestampParametersAllOf.md)
 - [RefreshVDBByTimestampResponse](docs/RefreshVDBByTimestampResponse.md)
 - [RefreshVDBFromBookmarkParameters](docs/RefreshVDBFromBookmarkParameters.md)
 - [RefreshVDBFromBookmarkResponse](docs/RefreshVDBFromBookmarkResponse.md)
 - [RefreshVDBGroupBySnapshotParameters](docs/RefreshVDBGroupBySnapshotParameters.md)
 - [RefreshVDBGroupByTimestampParameters](docs/RefreshVDBGroupByTimestampParameters.md)
 - [RefreshVDBGroupParameters](docs/RefreshVDBGroupParameters.md)
 - [RefreshVDBGroupResponse](docs/RefreshVDBGroupResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [RemoveEngineFromHyperscaleResponse](docs/RemoveEngineFromHyperscaleResponse.md)
 - [RemoveEngineFromJobResponse](docs/RemoveEngineFromJobResponse.md)
 - [RemoveMaskingJobParameters](docs/RemoveMaskingJobParameters.md)
 - [Replica](docs/Replica.md)
 - [ReplicationProfile](docs/ReplicationProfile.md)
 - [ReplicationProfileDeleteJobResponse](docs/ReplicationProfileDeleteJobResponse.md)
 - [ReplicationProfileUpdateJobResponse](docs/ReplicationProfileUpdateJobResponse.md)
 - [ReportingSchedule](docs/ReportingSchedule.md)
 - [ReportingScheduleCreateParameters](docs/ReportingScheduleCreateParameters.md)
 - [Repository](docs/Repository.md)
 - [RepositoryDeleteJobResponse](docs/RepositoryDeleteJobResponse.md)
 - [ResetPasswordParameter](docs/ResetPasswordParameter.md)
 - [RestartExecutionResponse](docs/RestartExecutionResponse.md)
 - [Role](docs/Role.md)
 - [RoleAllOf](docs/RoleAllOf.md)
 - [RoleUpdateParameters](docs/RoleUpdateParameters.md)
 - [RollbackVDBBySnapshotParameters](docs/RollbackVDBBySnapshotParameters.md)
 - [RollbackVDBBySnapshotResponse](docs/RollbackVDBBySnapshotResponse.md)
 - [RollbackVDBByTimestampParameters](docs/RollbackVDBByTimestampParameters.md)
 - [RollbackVDBByTimestampResponse](docs/RollbackVDBByTimestampResponse.md)
 - [RollbackVDBFromBookmarkParameters](docs/RollbackVDBFromBookmarkParameters.md)
 - [RollbackVDBFromBookmarkResponse](docs/RollbackVDBFromBookmarkResponse.md)
 - [RollbackVDBGroupParameters](docs/RollbackVDBGroupParameters.md)
 - [RollbackVDBGroupResponse](docs/RollbackVDBGroupResponse.md)
 - [RuleSet](docs/RuleSet.md)
 - [RuleSetsListResponse](docs/RuleSetsListResponse.md)
 - [RuleSetsSearchResponse](docs/RuleSetsSearchResponse.md)
 - [SAMLConfigParams](docs/SAMLConfigParams.md)
 - [SAMLValidationResponse](docs/SAMLValidationResponse.md)
 - [SMTPConfigParams](docs/SMTPConfigParams.md)
 - [SMTPConfigValidate](docs/SMTPConfigValidate.md)
 - [SSHVerificationStrategy](docs/SSHVerificationStrategy.md)
 - [ScopeTag](docs/ScopeTag.md)
 - [ScopeTagsRequest](docs/ScopeTagsRequest.md)
 - [ScopeTagsResponse](docs/ScopeTagsResponse.md)
 - [ScopedObjectItem](docs/ScopedObjectItem.md)
 - [ScopedObjectItemsResponse](docs/ScopedObjectItemsResponse.md)
 - [ScopedObjectsRequest](docs/ScopedObjectsRequest.md)
 - [SearchAccessGroupsResponse](docs/SearchAccessGroupsResponse.md)
 - [SearchAccountsResponse](docs/SearchAccountsResponse.md)
 - [SearchAlgorithmDependenciesResponse](docs/SearchAlgorithmDependenciesResponse.md)
 - [SearchAlgorithmsResponse](docs/SearchAlgorithmsResponse.md)
 - [SearchBody](docs/SearchBody.md)
 - [SearchBookmarksByVDBGroupsResponse](docs/SearchBookmarksByVDBGroupsResponse.md)
 - [SearchBookmarksByVDBResponse](docs/SearchBookmarksByVDBResponse.md)
 - [SearchBookmarksResponse](docs/SearchBookmarksResponse.md)
 - [SearchCDBsResponse](docs/SearchCDBsResponse.md)
 - [SearchComplianceJobCollectionsResponse](docs/SearchComplianceJobCollectionsResponse.md)
 - [SearchComplianceJobsResponse](docs/SearchComplianceJobsResponse.md)
 - [SearchConnectorsResponse](docs/SearchConnectorsResponse.md)
 - [SearchDSourcesResponse](docs/SearchDSourcesResponse.md)
 - [SearchDataLayoutResponse](docs/SearchDataLayoutResponse.md)
 - [SearchDataRiskReportResponse](docs/SearchDataRiskReportResponse.md)
 - [SearchDatabaseTemplatesResponse](docs/SearchDatabaseTemplatesResponse.md)
 - [SearchDatasetGroupResponse](docs/SearchDatasetGroupResponse.md)
 - [SearchDiscoveryResultsResponse](docs/SearchDiscoveryResultsResponse.md)
 - [SearchEngineGlobalObjectStateReportResponse](docs/SearchEngineGlobalObjectStateReportResponse.md)
 - [SearchEnginesResponse](docs/SearchEnginesResponse.md)
 - [SearchEnvironmentsResponse](docs/SearchEnvironmentsResponse.md)
 - [SearchExecutionEventsResponse](docs/SearchExecutionEventsResponse.md)
 - [SearchExecutionsResponse](docs/SearchExecutionsResponse.md)
 - [SearchHashicorpVaultsResponse](docs/SearchHashicorpVaultsResponse.md)
 - [SearchHyperscaleConnectorsResponse](docs/SearchHyperscaleConnectorsResponse.md)
 - [SearchHyperscaleDatasetTablesOrFilesResponse](docs/SearchHyperscaleDatasetTablesOrFilesResponse.md)
 - [SearchHyperscaleDatasetsResponse](docs/SearchHyperscaleDatasetsResponse.md)
 - [SearchHyperscaleInstancesResponse](docs/SearchHyperscaleInstancesResponse.md)
 - [SearchHyperscaleMountPointsResponse](docs/SearchHyperscaleMountPointsResponse.md)
 - [SearchJobCollectionExecutionsResponse](docs/SearchJobCollectionExecutionsResponse.md)
 - [SearchJobsResponse](docs/SearchJobsResponse.md)
 - [SearchKerberosConfigsResponse](docs/SearchKerberosConfigsResponse.md)
 - [SearchMaskingEnvironmentsResponse](docs/SearchMaskingEnvironmentsResponse.md)
 - [SearchMaskingFileConsumersResponse](docs/SearchMaskingFileConsumersResponse.md)
 - [SearchMaskingFilesResponse](docs/SearchMaskingFilesResponse.md)
 - [SearchMaskingJobSourceEnginesResponse](docs/SearchMaskingJobSourceEnginesResponse.md)
 - [SearchMaskingJobsResponse](docs/SearchMaskingJobsResponse.md)
 - [SearchNamespacesResponse](docs/SearchNamespacesResponse.md)
 - [SearchPasswordVaultResponse](docs/SearchPasswordVaultResponse.md)
 - [SearchReplicationProfilesResponse](docs/SearchReplicationProfilesResponse.md)
 - [SearchReportingScheduleResponse](docs/SearchReportingScheduleResponse.md)
 - [SearchRolesResponse](docs/SearchRolesResponse.md)
 - [SearchSnapshotsResponse](docs/SearchSnapshotsResponse.md)
 - [SearchSourcesResponse](docs/SearchSourcesResponse.md)
 - [SearchStagingSourcesResponse](docs/SearchStagingSourcesResponse.md)
 - [SearchTagPermissionsResponse](docs/SearchTagPermissionsResponse.md)
 - [SearchTagUsagesResponse](docs/SearchTagUsagesResponse.md)
 - [SearchTagsResponse](docs/SearchTagsResponse.md)
 - [SearchTimeflowsResponse](docs/SearchTimeflowsResponse.md)
 - [SearchToolkitResponse](docs/SearchToolkitResponse.md)
 - [SearchVCDBsResponse](docs/SearchVCDBsResponse.md)
 - [SearchVDBGroupResponse](docs/SearchVDBGroupResponse.md)
 - [SearchVDBGroupsByBookmarkResponse](docs/SearchVDBGroupsByBookmarkResponse.md)
 - [SearchVDBsResponse](docs/SearchVDBsResponse.md)
 - [SearchVirtualizationActionsResponse](docs/SearchVirtualizationActionsResponse.md)
 - [SearchVirtualizationAlertsResponse](docs/SearchVirtualizationAlertsResponse.md)
 - [SearchVirtualizationFaultsResponse](docs/SearchVirtualizationFaultsResponse.md)
 - [SearchVirtualizationJobsResponse](docs/SearchVirtualizationJobsResponse.md)
 - [SearchVirtualizationPoliciesResponse](docs/SearchVirtualizationPoliciesResponse.md)
 - [SearchVirtualizationPolicyTargetsResponse](docs/SearchVirtualizationPolicyTargetsResponse.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotCapacity](docs/SnapshotCapacity.md)
 - [SnapshotCapacityResponse](docs/SnapshotCapacityResponse.md)
 - [SnapshotCompatibleEnvironmentsResponse](docs/SnapshotCompatibleEnvironmentsResponse.md)
 - [SnapshotCompatibleRepositoryRequest](docs/SnapshotCompatibleRepositoryRequest.md)
 - [SnapshotDSourceResponse](docs/SnapshotDSourceResponse.md)
 - [SnapshotDayRange](docs/SnapshotDayRange.md)
 - [SnapshotMissingLog](docs/SnapshotMissingLog.md)
 - [SnapshotRuntime](docs/SnapshotRuntime.md)
 - [SnapshotVDBResponse](docs/SnapshotVDBResponse.md)
 - [SnapshotsDayRangesResponse](docs/SnapshotsDayRangesResponse.md)
 - [Source](docs/Source.md)
 - [SourceOperation](docs/SourceOperation.md)
 - [StagingCompatibleEnvironmentsResponse](docs/StagingCompatibleEnvironmentsResponse.md)
 - [StagingSource](docs/StagingSource.md)
 - [StartVCDBParameters](docs/StartVCDBParameters.md)
 - [StartVCDBResponse](docs/StartVCDBResponse.md)
 - [StartVDBGroupParameters](docs/StartVDBGroupParameters.md)
 - [StartVDBGroupResponse](docs/StartVDBGroupResponse.md)
 - [StartVDBParameters](docs/StartVDBParameters.md)
 - [StartVDBResponse](docs/StartVDBResponse.md)
 - [StopVCDBParameters](docs/StopVCDBParameters.md)
 - [StopVCDBResponse](docs/StopVCDBResponse.md)
 - [StopVDBGroupParameters](docs/StopVDBGroupParameters.md)
 - [StopVDBGroupResponse](docs/StopVDBGroupResponse.md)
 - [StopVDBParameters](docs/StopVDBParameters.md)
 - [StopVDBResponse](docs/StopVDBResponse.md)
 - [StorageSavingsReportSummarizedData](docs/StorageSavingsReportSummarizedData.md)
 - [StorageSavingsSummaryData](docs/StorageSavingsSummaryData.md)
 - [StorageSavingsSummaryReportResponse](docs/StorageSavingsSummaryReportResponse.md)
 - [StorageSummaryHistoricalDataPoint](docs/StorageSummaryHistoricalDataPoint.md)
 - [StorageSummaryProjectedDataPoint](docs/StorageSummaryProjectedDataPoint.md)
 - [SwitchTimeflowParameters](docs/SwitchTimeflowParameters.md)
 - [SwitchTimeflowResponse](docs/SwitchTimeflowResponse.md)
 - [SyncEnginesHyperscaleParameters](docs/SyncEnginesHyperscaleParameters.md)
 - [SyncEnginesHyperscaleResponse](docs/SyncEnginesHyperscaleResponse.md)
 - [Tag](docs/Tag.md)
 - [TagsRequest](docs/TagsRequest.md)
 - [TagsResponse](docs/TagsResponse.md)
 - [TargetJobType](docs/TargetJobType.md)
 - [TargetObjectType](docs/TargetObjectType.md)
 - [TargetPolicyObjectType](docs/TargetPolicyObjectType.md)
 - [TaskEvent](docs/TaskEvent.md)
 - [Timeflow](docs/Timeflow.md)
 - [TimeflowRange](docs/TimeflowRange.md)
 - [TimeflowRepairRequest](docs/TimeflowRepairRequest.md)
 - [TimeflowRepairResponse](docs/TimeflowRepairResponse.md)
 - [TimestampCompatibleEnvironmentsResponse](docs/TimestampCompatibleEnvironmentsResponse.md)
 - [TimestampCompatibleRepositoryRequest](docs/TimestampCompatibleRepositoryRequest.md)
 - [TokenInfoRequest](docs/TokenInfoRequest.md)
 - [TokenInfoResponse](docs/TokenInfoResponse.md)
 - [Toolkit](docs/Toolkit.md)
 - [UiProfilesRequest](docs/UiProfilesRequest.md)
 - [UndoRefreshVDBResponse](docs/UndoRefreshVDBResponse.md)
 - [UnregisterHyperscaleInstanceResponse](docs/UnregisterHyperscaleInstanceResponse.md)
 - [UnsetSnapshotRetentionResponse](docs/UnsetSnapshotRetentionResponse.md)
 - [UpdateAccessGroupScope](docs/UpdateAccessGroupScope.md)
 - [UpdateAppDataDSourceParameters](docs/UpdateAppDataDSourceParameters.md)
 - [UpdateBookmarkParameters](docs/UpdateBookmarkParameters.md)
 - [UpdateBookmarkResponse](docs/UpdateBookmarkResponse.md)
 - [UpdateCDBParameters](docs/UpdateCDBParameters.md)
 - [UpdateCDBResponse](docs/UpdateCDBResponse.md)
 - [UpdateComplianceJobCollectionRequest](docs/UpdateComplianceJobCollectionRequest.md)
 - [UpdateComplianceJobCollectionResponse](docs/UpdateComplianceJobCollectionResponse.md)
 - [UpdateConnectorResponse](docs/UpdateConnectorResponse.md)
 - [UpdateDatabaseTemplateParameters](docs/UpdateDatabaseTemplateParameters.md)
 - [UpdateDatabaseTemplateResponse](docs/UpdateDatabaseTemplateResponse.md)
 - [UpdateDsourceResponse](docs/UpdateDsourceResponse.md)
 - [UpdateEngineAutoTaggingConfigResponse](docs/UpdateEngineAutoTaggingConfigResponse.md)
 - [UpdateEnvironmentResponse](docs/UpdateEnvironmentResponse.md)
 - [UpdateEnvironmentUserResponse](docs/UpdateEnvironmentUserResponse.md)
 - [UpdateHostResponse](docs/UpdateHostResponse.md)
 - [UpdateHyperscaleConnectorResponse](docs/UpdateHyperscaleConnectorResponse.md)
 - [UpdateHyperscaleDatasetResponse](docs/UpdateHyperscaleDatasetResponse.md)
 - [UpdateHyperscaleDatasetTableOrFileResponse](docs/UpdateHyperscaleDatasetTableOrFileResponse.md)
 - [UpdateHyperscaleMountPointResponse](docs/UpdateHyperscaleMountPointResponse.md)
 - [UpdateMSSQLDsourceParameters](docs/UpdateMSSQLDsourceParameters.md)
 - [UpdateMaskingJobParameters](docs/UpdateMaskingJobParameters.md)
 - [UpdateNamespaceParameters](docs/UpdateNamespaceParameters.md)
 - [UpdateOracleDsourceParameters](docs/UpdateOracleDsourceParameters.md)
 - [UpdateOracleListenerParams](docs/UpdateOracleListenerParams.md)
 - [UpdateOracleListenerResponse](docs/UpdateOracleListenerResponse.md)
 - [UpdateOracleSourceResponse](docs/UpdateOracleSourceResponse.md)
 - [UpdatePostgresSourceResponse](docs/UpdatePostgresSourceResponse.md)
 - [UpdateReplicationProfileParameters](docs/UpdateReplicationProfileParameters.md)
 - [UpdateRepositoryParameters](docs/UpdateRepositoryParameters.md)
 - [UpdateRepositoryResponse](docs/UpdateRepositoryResponse.md)
 - [UpdateSnapshotParameters](docs/UpdateSnapshotParameters.md)
 - [UpdateSnapshotResponse](docs/UpdateSnapshotResponse.md)
 - [UpdateSourceParameters](docs/UpdateSourceParameters.md)
 - [UpdateSourceResponse](docs/UpdateSourceResponse.md)
 - [UpdateStagingSourceParameters](docs/UpdateStagingSourceParameters.md)
 - [UpdateStagingSourceResponse](docs/UpdateStagingSourceResponse.md)
 - [UpdateTimeflowParameters](docs/UpdateTimeflowParameters.md)
 - [UpdateTimeflowResponse](docs/UpdateTimeflowResponse.md)
 - [UpdateVCDBParameters](docs/UpdateVCDBParameters.md)
 - [UpdateVCDBResponse](docs/UpdateVCDBResponse.md)
 - [UpdateVDBGroupParameters](docs/UpdateVDBGroupParameters.md)
 - [UpdateVDBParameters](docs/UpdateVDBParameters.md)
 - [UpdateVDBResponse](docs/UpdateVDBResponse.md)
 - [UpdateVirtualizationPolicyParameters](docs/UpdateVirtualizationPolicyParameters.md)
 - [UpgradeCDBResponse](docs/UpgradeCDBResponse.md)
 - [UpgradeDatabaseParameters](docs/UpgradeDatabaseParameters.md)
 - [UpgradeDsourceResponse](docs/UpgradeDsourceResponse.md)
 - [UpgradeOracleContainerDatabaseParameters](docs/UpgradeOracleContainerDatabaseParameters.md)
 - [UpgradeOracleDatabaseParameters](docs/UpgradeOracleDatabaseParameters.md)
 - [UpgradeVCDBResponse](docs/UpgradeVCDBResponse.md)
 - [UpgradeVDBResponse](docs/UpgradeVDBResponse.md)
 - [VCDB](docs/VCDB.md)
 - [VDB](docs/VDB.md)
 - [VDBDisableParametersMapping](docs/VDBDisableParametersMapping.md)
 - [VDBDisableParametersMappingAllOf](docs/VDBDisableParametersMappingAllOf.md)
 - [VDBEnableParametersMapping](docs/VDBEnableParametersMapping.md)
 - [VDBEnableParametersMappingAllOf](docs/VDBEnableParametersMappingAllOf.md)
 - [VDBGroup](docs/VDBGroup.md)
 - [VDBGroupRefreshBySnapshot](docs/VDBGroupRefreshBySnapshot.md)
 - [VDBGroupRefreshByTimestamp](docs/VDBGroupRefreshByTimestamp.md)
 - [VDBGroupTimestampSummaryRequest](docs/VDBGroupTimestampSummaryRequest.md)
 - [VDBInventoryData](docs/VDBInventoryData.md)
 - [VDBInventoryReportResponse](docs/VDBInventoryReportResponse.md)
 - [VDBOrder](docs/VDBOrder.md)
 - [VDBOrderAllOf](docs/VDBOrderAllOf.md)
 - [VDBStartParametersMapping](docs/VDBStartParametersMapping.md)
 - [VDBStartParametersMappingAllOf](docs/VDBStartParametersMappingAllOf.md)
 - [VDBStopParametersMapping](docs/VDBStopParametersMapping.md)
 - [VDBStopParametersMappingAllOf](docs/VDBStopParametersMappingAllOf.md)
 - [ValidateJavaParameters](docs/ValidateJavaParameters.md)
 - [ValidateJavaResponse](docs/ValidateJavaResponse.md)
 - [VdbGroupTimestampSummary](docs/VdbGroupTimestampSummary.md)
 - [VdbGroupTimestampSummaryItem](docs/VdbGroupTimestampSummaryItem.md)
 - [VdbGroupTimestampSummaryResponse](docs/VdbGroupTimestampSummaryResponse.md)
 - [VirtualDatasetHooks](docs/VirtualDatasetHooks.md)
 - [VirtualizationAction](docs/VirtualizationAction.md)
 - [VirtualizationAlert](docs/VirtualizationAlert.md)
 - [VirtualizationFault](docs/VirtualizationFault.md)
 - [VirtualizationFaultResolveAllJobResponse](docs/VirtualizationFaultResolveAllJobResponse.md)
 - [VirtualizationFaultResolveJobResponse](docs/VirtualizationFaultResolveJobResponse.md)
 - [VirtualizationFaultResolveOrIgnoreJobResponse](docs/VirtualizationFaultResolveOrIgnoreJobResponse.md)
 - [VirtualizationFaultResolveOrIgnoreParameters](docs/VirtualizationFaultResolveOrIgnoreParameters.md)
 - [VirtualizationFaultResolveParameters](docs/VirtualizationFaultResolveParameters.md)
 - [VirtualizationJob](docs/VirtualizationJob.md)
 - [VirtualizationJobEvent](docs/VirtualizationJobEvent.md)
 - [VirtualizationPolicy](docs/VirtualizationPolicy.md)
 - [VirtualizationPolicyApplyParams](docs/VirtualizationPolicyApplyParams.md)
 - [VirtualizationPolicyApplyResponse](docs/VirtualizationPolicyApplyResponse.md)
 - [VirtualizationPolicyConvertJobResponse](docs/VirtualizationPolicyConvertJobResponse.md)
 - [VirtualizationPolicyDeleteJobResponse](docs/VirtualizationPolicyDeleteJobResponse.md)
 - [VirtualizationPolicyTarget](docs/VirtualizationPolicyTarget.md)
 - [VirtualizationPolicyUnapplyResponse](docs/VirtualizationPolicyUnapplyResponse.md)
 - [VirtualizationPolicyUpdateJobResponse](docs/VirtualizationPolicyUpdateJobResponse.md)
 - [VirtualizationSchedule](docs/VirtualizationSchedule.md)
 - [VirtualizationStorageSummaryData](docs/VirtualizationStorageSummaryData.md)
 - [VirtualizationStorageSummaryReportResponse](docs/VirtualizationStorageSummaryReportResponse.md)
 - [VirtualizationTask](docs/VirtualizationTask.md)
 - [VirtualizationTaskEvent](docs/VirtualizationTaskEvent.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

