"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAppMonitor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-08-17T16:40:13.321Z","fingerprint":"MjIZ7nZiZ+2g8r9JcFWGL2W0bAjsX/XFAHpUicoI0fo="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAppMonitorProps`
 *
 * @param properties - the TypeScript properties of a `CfnAppMonitorProps`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitorPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('appMonitorConfiguration', CfnAppMonitor_AppMonitorConfigurationPropertyValidator)(properties.appMonitorConfiguration));
    errors.collect(cdk.propertyValidator('cwLogEnabled', cdk.validateBoolean)(properties.cwLogEnabled));
    errors.collect(cdk.propertyValidator('domain', cdk.requiredValidator)(properties.domain));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAppMonitorProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor` resource
 *
 * @param properties - the TypeScript properties of a `CfnAppMonitorProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitorPropsValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        Name: cdk.stringToCloudFormation(properties.name),
        AppMonitorConfiguration: cfnAppMonitorAppMonitorConfigurationPropertyToCloudFormation(properties.appMonitorConfiguration),
        CwLogEnabled: cdk.booleanToCloudFormation(properties.cwLogEnabled),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domain', 'Domain', cfn_parse.FromCloudFormation.getString(properties.Domain));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('appMonitorConfiguration', 'AppMonitorConfiguration', properties.AppMonitorConfiguration != null ? CfnAppMonitorAppMonitorConfigurationPropertyFromCloudFormation(properties.AppMonitorConfiguration) : undefined);
    ret.addPropertyResult('cwLogEnabled', 'CwLogEnabled', properties.CwLogEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CwLogEnabled) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RUM::AppMonitor`
 *
 * Creates a CloudWatch RUM app monitor, which you can use to collect telemetry data from your application and send it to CloudWatch RUM. The data includes performance and reliability information such as page load time, client-side errors, and user behavior.
 *
 * After you create an app monitor, sign in to the CloudWatch RUM console to get the JavaScript code snippet to add to your web application. For more information, see [How do I find a code snippet that I've already generated?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-RUM-find-code-snippet.html)
 *
 * @cloudformationResource AWS::RUM::AppMonitor
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html
 */
class CfnAppMonitor extends cdk.CfnResource {
    /**
     * Create a new `AWS::RUM::AppMonitor`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAppMonitor.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rum_CfnAppMonitorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAppMonitor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'domain', this);
        cdk.requireProperty(props, 'name', this);
        this.domain = props.domain;
        this.name = props.name;
        this.appMonitorConfiguration = props.appMonitorConfiguration;
        this.cwLogEnabled = props.cwLogEnabled;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RUM::AppMonitor", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAppMonitorPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAppMonitor(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAppMonitor.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domain: this.domain,
            name: this.name,
            appMonitorConfiguration: this.appMonitorConfiguration,
            cwLogEnabled: this.cwLogEnabled,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAppMonitorPropsToCloudFormation(props);
    }
}
exports.CfnAppMonitor = CfnAppMonitor;
_a = JSII_RTTI_SYMBOL_1;
CfnAppMonitor[_a] = { fqn: "@aws-cdk/aws-rum.CfnAppMonitor", version: "1.169.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAppMonitor.CFN_RESOURCE_TYPE_NAME = "AWS::RUM::AppMonitor";
/**
 * Determine whether the given properties match those of a `AppMonitorConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AppMonitorConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnAppMonitor_AppMonitorConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowCookies', cdk.validateBoolean)(properties.allowCookies));
    errors.collect(cdk.propertyValidator('enableXRay', cdk.validateBoolean)(properties.enableXRay));
    errors.collect(cdk.propertyValidator('excludedPages', cdk.listValidator(cdk.validateString))(properties.excludedPages));
    errors.collect(cdk.propertyValidator('favoritePages', cdk.listValidator(cdk.validateString))(properties.favoritePages));
    errors.collect(cdk.propertyValidator('guestRoleArn', cdk.validateString)(properties.guestRoleArn));
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.validateString)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('includedPages', cdk.listValidator(cdk.validateString))(properties.includedPages));
    errors.collect(cdk.propertyValidator('sessionSampleRate', cdk.validateNumber)(properties.sessionSampleRate));
    errors.collect(cdk.propertyValidator('telemetries', cdk.listValidator(cdk.validateString))(properties.telemetries));
    return errors.wrap('supplied properties not correct for "AppMonitorConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.AppMonitorConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AppMonitorConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RUM::AppMonitor.AppMonitorConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnAppMonitorAppMonitorConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAppMonitor_AppMonitorConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AllowCookies: cdk.booleanToCloudFormation(properties.allowCookies),
        EnableXRay: cdk.booleanToCloudFormation(properties.enableXRay),
        ExcludedPages: cdk.listMapper(cdk.stringToCloudFormation)(properties.excludedPages),
        FavoritePages: cdk.listMapper(cdk.stringToCloudFormation)(properties.favoritePages),
        GuestRoleArn: cdk.stringToCloudFormation(properties.guestRoleArn),
        IdentityPoolId: cdk.stringToCloudFormation(properties.identityPoolId),
        IncludedPages: cdk.listMapper(cdk.stringToCloudFormation)(properties.includedPages),
        SessionSampleRate: cdk.numberToCloudFormation(properties.sessionSampleRate),
        Telemetries: cdk.listMapper(cdk.stringToCloudFormation)(properties.telemetries),
    };
}
// @ts-ignore TS6133
function CfnAppMonitorAppMonitorConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowCookies', 'AllowCookies', properties.AllowCookies != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowCookies) : undefined);
    ret.addPropertyResult('enableXRay', 'EnableXRay', properties.EnableXRay != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableXRay) : undefined);
    ret.addPropertyResult('excludedPages', 'ExcludedPages', properties.ExcludedPages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExcludedPages) : undefined);
    ret.addPropertyResult('favoritePages', 'FavoritePages', properties.FavoritePages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.FavoritePages) : undefined);
    ret.addPropertyResult('guestRoleArn', 'GuestRoleArn', properties.GuestRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.GuestRoleArn) : undefined);
    ret.addPropertyResult('identityPoolId', 'IdentityPoolId', properties.IdentityPoolId != null ? cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId) : undefined);
    ret.addPropertyResult('includedPages', 'IncludedPages', properties.IncludedPages != null ? cfn_parse.FromCloudFormation.getStringArray(properties.IncludedPages) : undefined);
    ret.addPropertyResult('sessionSampleRate', 'SessionSampleRate', properties.SessionSampleRate != null ? cfn_parse.FromCloudFormation.getNumber(properties.SessionSampleRate) : undefined);
    ret.addPropertyResult('telemetries', 'Telemetries', properties.Telemetries != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Telemetries) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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