import numpy as np
import os
import sys

sys.path.insert(0, os.path.dirname(os.path.abspath(__file__)))
from csaf_f16.models.helpers.f16plant_helper import fix, sign
from numba import jit  # type: ignore


@jit(nopython=True)
def cx(alpha, el):
    """cx definition"""

    a = np.array([[-.099, -.081, -.081, -.063, -.025, .044, .097, .113, .145, .167, .174, .166], \
                  [-.048, -.038, -.040, -.021, .016, .083, .127, .137, .162, .177, .179, .167], \
                  [-.022, -.020, -.021, -.004, .032, .094, .128, .130, .154, .161, .155, .138], \
                  [-.040, -.038, -.039, -.025, .006, .062, .087, .085, .100, .110, .104, .091], \
                  [-.083, -.073, -.076, -.072, -.046, .012, .024, .025, .043, .053, .047, .040]]).T

    s = .2 * alpha
    k = fix(s)
    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = el / 12
    m = fix(s)
    if m <= -2:
        m = -1

    if m >= 2:
        m = 1

    de = s - m
    n = m + fix(1.1 * sign(de))
    k = k + 3
    l = l + 3
    m = m + 3
    n = n + 3
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)
    cxx = v + (w - v) * abs(de)

    return cxx


@jit(nopython=True)
def cy(beta, ail, rdr):
    """cy function"""

    return -.02 * beta + .021 * (ail / 20) + .086 * (rdr / 30)


@jit(nopython=True)
def cz(alpha, beta, el):
    """cz function"""

    a = np.array([.770, .241, -.100, -.415, -.731, -1.053, -1.355, -1.646, -1.917, -2.120, -2.248, -2.229]).T

    s = .2 * alpha
    k = fix(s)

    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    l = l + 3
    k = k + 3
    s = a[k - 1] + abs(da) * (a[l - 1] - a[k - 1])

    return s * (1 - (beta / 57.3) ** 2) - .19 * (el / 25)


@jit(nopython=True)
def cl(alpha, beta):
    """For calculating rolling moment coefficient"""

    a = np.array([[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], \
                  [-.001, -.004, -.008, -.012, -.016, -.022, -.022, -.021, -.015, -.008, -.013, -.015], \
                  [-.003, -.009, -.017, -.024, -.030, -.041, -.045, -.040, -.016, -.002, -.010, -.019], \
                  [-.001, -.010, -.020, -.030, -.039, -.054, -.057, -.054, -.023, -.006, -.014, -.027], \
                  [.000, -.010, -.022, -.034, -.047, -.060, -.069, -.067, -.033, -.036, -.035, -.035], \
                  [.007, -.010, -.023, -.034, -.049, -.063, -.081, -.079, -.060, -.058, -.062, -.059], \
                  [.009, -.011, -.023, -.037, -.050, -.068, -.089, -.088, -.091, -.076, -.077, -.076]]).T

    s = .2 * alpha
    k = fix(s)

    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .2 * abs(beta)
    m = fix(s)
    if m == 0:
        m = 1

    if m >= 6:
        m = 5

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 1
    n = n + 1
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)
    dum = v + (w - v) * abs(db)

    return dum * sign(beta)


@jit(nopython=True)
def cm(alpha, el):
    """cm function"""

    a = np.array([[.205, .168, .186, .196, .213, .251, .245, .238, .252, .231, .198, .192], \
                  [.081, .077, .107, .110, .110, .141, .127, .119, .133, .108, .081, .093], \
                  [-.046, -.020, -.009, -.005, -.006, .010, .006, -.001, .014, .000, -.013, .032], \
                  [-.174, -.145, -.121, -.127, -.129, -.102, -.097, -.113, -.087, -.084, -.069, -.006], \
                  [-.259, -.202, -.184, -.193, -.199, -.150, -.160, -.167, -.104, -.076, -.041, -.005]]).T

    s = .2 * alpha
    k = fix(s)

    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = el / 12
    m = fix(s)

    if m <= -2:
        m = -1

    if m >= 2:
        m = 1

    de = s - m
    n = m + fix(1.1 * sign(de))
    k = k + 3
    l = l + 3
    m = m + 3
    n = n + 3
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)

    return v + (w - v) * abs(de)


@jit(nopython=True)
def cn(alpha, beta):
    """cn function"""

    a = np.array([[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], \
                  [.018, .019, .018, .019, .019, .018, .013, .007, .004, -.014, -.017, -.033], \
                  [.038, .042, .042, .042, .043, .039, .030, .017, .004, -.035, -.047, -.057], \
                  [.056, .057, .059, .058, .058, .053, .032, .012, .002, -.046, -.071, -.073], \
                  [.064, .077, .076, .074, .073, .057, .029, .007, .012, -.034, -.065, -.041], \
                  [.074, .086, .093, .089, .080, .062, .049, .022, .028, -.012, -.002, -.013], \
                  [.079, .090, .106, .106, .096, .080, .068, .030, .064, .015, .011, -.001]]).T

    s = .2 * alpha
    k = fix(s)

    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .2 * abs(beta)
    m = fix(s)

    if m == 0:
        m = 1

    if m >= 6:
        m = 5

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 1
    n = n + 1
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]

    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)
    dum = v + (w - v) * abs(db)

    return dum * sign(beta)


@jit(nopython=True)
def dlda(alpha, beta):
    """dlda function"""

    a = np.array([[-.041, -.052, -.053, -.056, -.050, -.056, -.082, -.059, -.042, -.038, -.027, -.017], \
                  [-.041, -.053, -.053, -.053, -.050, -.051, -.066, -.043, -.038, -.027, -.023, -.016], \
                  [-.042, -.053, -.052, -.051, -.049, -.049, -.043, -.035, -.026, -.016, -.018, -.014], \
                  [-.040, -.052, -.051, -.052, -.048, -.048, -.042, -.037, -.031, -.026, -.017, -.012], \
                  [-.043, -.049, -.048, -.049, -.043, -.042, -.042, -.036, -.025, -.021, -.016, -.011], \
                  [-.044, -.048, -.048, -.047, -.042, -.041, -.020, -.028, -.013, -.014, -.011, -.010], \
                  [-.043, -.049, -.047, -.045, -.042, -.037, -.003, -.013, -.010, -.003, -.007, -.008]]).T

    s = .2 * alpha
    k = fix(s)
    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .1 * beta
    m = fix(s)
    if m <= -3:
        m = -2

    if m >= 3:
        m = 2

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 4
    n = n + 4
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)

    return v + (w - v) * abs(db)


@jit(nopython=True)
def dldr(alpha, beta):
    """dldr function"""

    a = np.array([[.005, .017, .014, .010, -.005, .009, .019, .005, -.000, -.005, -.011, .008], \
                  [.007, .016, .014, .014, .013, .009, .012, .005, .000, .004, .009, .007], \
                  [.013, .013, .011, .012, .011, .009, .008, .005, -.002, .005, .003, .005], \
                  [.018, .015, .015, .014, .014, .014, .014, .015, .013, .011, .006, .001], \
                  [.015, .014, .013, .013, .012, .011, .011, .010, .008, .008, .007, .003], \
                  [.021, .011, .010, .011, .010, .009, .008, .010, .006, .005, .000, .001], \
                  [.023, .010, .011, .011, .011, .010, .008, .010, .006, .014, .020, .000]]).T

    s = .2 * alpha
    k = fix(s)
    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .1 * beta
    m = fix(s)

    if m <= -3:
        m = -2

    if m >= 3:
        m = 2

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 4
    n = n + 4
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]

    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)

    return v + (w - v) * abs(db)


@jit(nopython=True)
def dnda(alpha, beta):
    """dnda function"""

    a = np.array([[.001, -.027, -.017, -.013, -.012, -.016, .001, .017, .011, .017, .008, .016], \
                  [.002, -.014, -.016, -.016, -.014, -.019, -.021, .002, .012, .016, .015, .011], \
                  [-.006, -.008, -.006, -.006, -.005, -.008, -.005, .007, .004, .007, .006, .006], \
                  [-.011, -.011, -.010, -.009, -.008, -.006, .000, .004, .007, .010, .004, .010], \
                  [-.015, -.015, -.014, -.012, -.011, -.008, -.002, .002, .006, .012, .011, .011], \
                  [-.024, -.010, -.004, -.002, -.001, .003, .014, .006, -.001, .004, .004, .006], \
                  [-.022, .002, -.003, -.005, -.003, -.001, -.009, -.009, -.001, .003, -.002, .001]]).T

    s = .2 * alpha
    k = fix(s)

    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .1 * beta
    m = fix(s)
    if m <= -3:
        m = -2

    if m >= 3:
        m = 2

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 4
    n = n + 4
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)

    return v + (w - v) * abs(db)


@jit(nopython=True)
def dndr(alpha, beta):
    """dndr function"""

    a = np.array([[-.018, -.052, -.052, -.052, -.054, -.049, -.059, -.051, -.030, -.037, -.026, -.013], \
                  [-.028, -.051, -.043, -.046, -.045, -.049, -.057, -.052, -.030, -.033, -.030, -.008], \
                  [-.037, -.041, -.038, -.040, -.040, -.038, -.037, -.030, -.027, -.024, -.019, -.013], \
                  [-.048, -.045, -.045, -.045, -.044, -.045, -.047, -.048, -.049, -.045, -.033, -.016], \
                  [-.043, -.044, -.041, -.041, -.040, -.038, -.034, -.035, -.035, -.029, -.022, -.009], \
                  [-.052, -.034, -.036, -.036, -.035, -.028, -.024, -.023, -.020, -.016, -.010, -.014], \
                  [-.062, -.034, -.027, -.028, -.027, -.027, -.023, -.023, -.019, -.009, -.025, -.010]]).T

    s = .2 * alpha
    k = fix(s)
    if k <= -2:
        k = -1

    if k >= 9:
        k = 8

    da = s - k
    l = k + fix(1.1 * sign(da))
    s = .1 * beta
    m = fix(s)
    if m <= -3:
        m = -2

    if m >= 3:
        m = 2

    db = s - m
    n = m + fix(1.1 * sign(db))
    l = l + 3
    k = k + 3
    m = m + 4
    n = n + 4
    t = a[k - 1, m - 1]
    u = a[k - 1, n - 1]
    v = t + abs(da) * (a[l - 1, m - 1] - t)
    w = u + abs(da) * (a[l - 1, n - 1] - u)
    return v + (w - v) * abs(db)


@jit(nopython=True)
def stevens_f16(*, alpha, beta, el, ail, rdr, dail, drdr):
    '''
    Computes the f16 dynamics using Stevens Lookup table model
    All angles are in degrees
    '''
    cxt = cx(alpha, el)
    cyt = cy(beta, ail, rdr)
    czt = cz(alpha, beta, el)

    clt = cl(alpha, beta) + dlda(alpha, beta) * dail + dldr(alpha, beta) * drdr
    cmt = cm(alpha, el)
    cnt = cn(alpha, beta) + dnda(alpha, beta) * dail + dndr(alpha, beta) * drdr
    return cxt, cyt, czt, clt, cmt, cnt
