# Contributing to CSAF

While this repository is hosted by Galois, we rely on code contributions from our collaborators. To facilitate concurrent work on new features, bug fixes, and improvements across organization boundaries, we have chosen to adopt a few specific version control practices, documented here.

When contributing to this repository, please first discuss the change you wish to make via an issue, email, or any other method with the owners of this repository before making a change.

## Branch management

We use a version of the [git flow](https://nvie.com/posts/a-successful-git-branching-model/)
branching management discipline popularized by GitHub and adopted by many open source projects.
It is intended to support these properties of the repo:

- The `master` branch only contains tagged release versions
- The `develop` branch is always a stable snapshot of current work, where all tests pass
- Changes are implemented on branches which originate from and target the develop branch
- Merge requests are used to review and order branch merges back into develop

When contributing code to the CSAF, please use the following process:

- When implementing new features or fixes, branch from current `develop`
- When finished with a working branch:
    - rebase onto `develop`, or merge `develop` into the work branch
    - run all tests, either in CI or locally 
    - when tests pass, open a merge request targeting `develop`
    - include other contributors in code review as appropriate
    - if the branch addresses issues in the issue tracker, link to them
- Merge your own branch when it's approved by a Maintainer
  and you believe it has been adequately reviewed

We use GitLab's permissions model to help enforce this workflow.
Both `master` and `develop` branches require Maintainer-level permissions to push or merge.
Galois engineers have Maintainer permissions;
other contributors have Developer permissions.

## Version control of *.ipynb files

We use jupyer notebooks extensively, and in order to avoid some [common problems with the version control of *.ipynb files](https://nextjournal.com/schmudde/how-to-version-control-jupyter) we ask the developers to:

* **Clean the notebook before committing:** The simplest solution is to always clear the output before committing. **Cell → All Output → Clear → Save.** This removes any binary blobs that have been generated by the notebook. 
* Where appropriate, convert the notebook to HTML and/or Python with:
  * HTML:
    ```
    jupyter nbconvert /jupyter-git/simple-nb.ipynb --output-dir="/results" --output="simple-nb.html"
    cat /results/simple-nb.html
    ```
  * Python:
    ```
    jupyter nbconvert /jupyter-git/simple-nb.ipynb --to="python" --output-dir="/results" --output="simple-nb-nbconvert"
    cat /results/simple-nb-nbconvert.py
    ```

## Releases

To prepare a new CSAF version for release:

1. Sanity-check:
   * are all feature or bugfix branches merged?
   * has documentation (`README.md`, `CHANGELOG.md` etc.) been updated?
1. Pull `master` and `develop` branches
1. Make sure all tests pass on `develop`
1. `git checkout master`
1. `git merge develop`
1. `git tag` to list all current tags
1. `git tag release-X.Y` with appropriate new version number
1. `git push`
1. `git push --tags`

With the new version tagged on `master` - congratulations on a new CSAF version!

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/