"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupSettings = exports.GroupSettingsTimeoutsOutputReference = exports.groupSettingsTimeoutsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function groupSettingsTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.groupSettingsTimeoutsToTerraform = groupSettingsTimeoutsToTerraform;
class GroupSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GroupSettingsTimeoutsOutputReference = GroupSettingsTimeoutsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GroupSettingsTimeoutsOutputReference[_a] = { fqn: "@cdktf/provider-googleworkspace.groupSettings.GroupSettingsTimeoutsOutputReference", version: "1.0.2" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_settings googleworkspace_group_settings}
*/
class GroupSettings extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/group_settings googleworkspace_group_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupSettingsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'googleworkspace_group_settings',
            terraformGeneratorMetadata: {
                providerName: 'googleworkspace',
                providerVersion: '0.7.0',
                providerVersionConstraint: '~> 0.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GroupSettingsTimeoutsOutputReference(this, "timeouts");
        this._allowExternalMembers = config.allowExternalMembers;
        this._allowWebPosting = config.allowWebPosting;
        this._archiveOnly = config.archiveOnly;
        this._customFooterText = config.customFooterText;
        this._customReplyTo = config.customReplyTo;
        this._defaultMessageDenyNotificationText = config.defaultMessageDenyNotificationText;
        this._email = config.email;
        this._enableCollaborativeInbox = config.enableCollaborativeInbox;
        this._includeCustomFooter = config.includeCustomFooter;
        this._includeInGlobalAddressList = config.includeInGlobalAddressList;
        this._isArchived = config.isArchived;
        this._membersCanPostAsTheGroup = config.membersCanPostAsTheGroup;
        this._messageModerationLevel = config.messageModerationLevel;
        this._primaryLanguage = config.primaryLanguage;
        this._replyTo = config.replyTo;
        this._sendMessageDenyNotification = config.sendMessageDenyNotification;
        this._spamModerationLevel = config.spamModerationLevel;
        this._whoCanAssistContent = config.whoCanAssistContent;
        this._whoCanContactOwner = config.whoCanContactOwner;
        this._whoCanDiscoverGroup = config.whoCanDiscoverGroup;
        this._whoCanJoin = config.whoCanJoin;
        this._whoCanLeaveGroup = config.whoCanLeaveGroup;
        this._whoCanModerateContent = config.whoCanModerateContent;
        this._whoCanModerateMembers = config.whoCanModerateMembers;
        this._whoCanPostMessage = config.whoCanPostMessage;
        this._whoCanViewGroup = config.whoCanViewGroup;
        this._whoCanViewMembership = config.whoCanViewMembership;
        this._timeouts.internalValue = config.timeouts;
    }
    get allowExternalMembers() {
        return this.getBooleanAttribute('allow_external_members');
    }
    set allowExternalMembers(value) {
        this._allowExternalMembers = value;
    }
    resetAllowExternalMembers() {
        this._allowExternalMembers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowExternalMembersInput() {
        return this._allowExternalMembers;
    }
    get allowWebPosting() {
        return this.getBooleanAttribute('allow_web_posting');
    }
    set allowWebPosting(value) {
        this._allowWebPosting = value;
    }
    resetAllowWebPosting() {
        this._allowWebPosting = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowWebPostingInput() {
        return this._allowWebPosting;
    }
    get archiveOnly() {
        return this.getBooleanAttribute('archive_only');
    }
    set archiveOnly(value) {
        this._archiveOnly = value;
    }
    resetArchiveOnly() {
        this._archiveOnly = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get archiveOnlyInput() {
        return this._archiveOnly;
    }
    get customFooterText() {
        return this.getStringAttribute('custom_footer_text');
    }
    set customFooterText(value) {
        this._customFooterText = value;
    }
    resetCustomFooterText() {
        this._customFooterText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customFooterTextInput() {
        return this._customFooterText;
    }
    get customReplyTo() {
        return this.getStringAttribute('custom_reply_to');
    }
    set customReplyTo(value) {
        this._customReplyTo = value;
    }
    resetCustomReplyTo() {
        this._customReplyTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customReplyToInput() {
        return this._customReplyTo;
    }
    // custom_roles_enabled_for_settings_to_be_merged - computed: true, optional: false, required: false
    get customRolesEnabledForSettingsToBeMerged() {
        return this.getBooleanAttribute('custom_roles_enabled_for_settings_to_be_merged');
    }
    get defaultMessageDenyNotificationText() {
        return this.getStringAttribute('default_message_deny_notification_text');
    }
    set defaultMessageDenyNotificationText(value) {
        this._defaultMessageDenyNotificationText = value;
    }
    resetDefaultMessageDenyNotificationText() {
        this._defaultMessageDenyNotificationText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultMessageDenyNotificationTextInput() {
        return this._defaultMessageDenyNotificationText;
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    get email() {
        return this.getStringAttribute('email');
    }
    set email(value) {
        this._email = value;
    }
    // Temporarily expose input value. Use with caution.
    get emailInput() {
        return this._email;
    }
    get enableCollaborativeInbox() {
        return this.getBooleanAttribute('enable_collaborative_inbox');
    }
    set enableCollaborativeInbox(value) {
        this._enableCollaborativeInbox = value;
    }
    resetEnableCollaborativeInbox() {
        this._enableCollaborativeInbox = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableCollaborativeInboxInput() {
        return this._enableCollaborativeInbox;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get includeCustomFooter() {
        return this.getBooleanAttribute('include_custom_footer');
    }
    set includeCustomFooter(value) {
        this._includeCustomFooter = value;
    }
    resetIncludeCustomFooter() {
        this._includeCustomFooter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeCustomFooterInput() {
        return this._includeCustomFooter;
    }
    get includeInGlobalAddressList() {
        return this.getBooleanAttribute('include_in_global_address_list');
    }
    set includeInGlobalAddressList(value) {
        this._includeInGlobalAddressList = value;
    }
    resetIncludeInGlobalAddressList() {
        this._includeInGlobalAddressList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeInGlobalAddressListInput() {
        return this._includeInGlobalAddressList;
    }
    get isArchived() {
        return this.getBooleanAttribute('is_archived');
    }
    set isArchived(value) {
        this._isArchived = value;
    }
    resetIsArchived() {
        this._isArchived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isArchivedInput() {
        return this._isArchived;
    }
    get membersCanPostAsTheGroup() {
        return this.getBooleanAttribute('members_can_post_as_the_group');
    }
    set membersCanPostAsTheGroup(value) {
        this._membersCanPostAsTheGroup = value;
    }
    resetMembersCanPostAsTheGroup() {
        this._membersCanPostAsTheGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membersCanPostAsTheGroupInput() {
        return this._membersCanPostAsTheGroup;
    }
    get messageModerationLevel() {
        return this.getStringAttribute('message_moderation_level');
    }
    set messageModerationLevel(value) {
        this._messageModerationLevel = value;
    }
    resetMessageModerationLevel() {
        this._messageModerationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageModerationLevelInput() {
        return this._messageModerationLevel;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get primaryLanguage() {
        return this.getStringAttribute('primary_language');
    }
    set primaryLanguage(value) {
        this._primaryLanguage = value;
    }
    resetPrimaryLanguage() {
        this._primaryLanguage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryLanguageInput() {
        return this._primaryLanguage;
    }
    get replyTo() {
        return this.getStringAttribute('reply_to');
    }
    set replyTo(value) {
        this._replyTo = value;
    }
    resetReplyTo() {
        this._replyTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replyToInput() {
        return this._replyTo;
    }
    get sendMessageDenyNotification() {
        return this.getBooleanAttribute('send_message_deny_notification');
    }
    set sendMessageDenyNotification(value) {
        this._sendMessageDenyNotification = value;
    }
    resetSendMessageDenyNotification() {
        this._sendMessageDenyNotification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sendMessageDenyNotificationInput() {
        return this._sendMessageDenyNotification;
    }
    get spamModerationLevel() {
        return this.getStringAttribute('spam_moderation_level');
    }
    set spamModerationLevel(value) {
        this._spamModerationLevel = value;
    }
    resetSpamModerationLevel() {
        this._spamModerationLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spamModerationLevelInput() {
        return this._spamModerationLevel;
    }
    get whoCanAssistContent() {
        return this.getStringAttribute('who_can_assist_content');
    }
    set whoCanAssistContent(value) {
        this._whoCanAssistContent = value;
    }
    resetWhoCanAssistContent() {
        this._whoCanAssistContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanAssistContentInput() {
        return this._whoCanAssistContent;
    }
    get whoCanContactOwner() {
        return this.getStringAttribute('who_can_contact_owner');
    }
    set whoCanContactOwner(value) {
        this._whoCanContactOwner = value;
    }
    resetWhoCanContactOwner() {
        this._whoCanContactOwner = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanContactOwnerInput() {
        return this._whoCanContactOwner;
    }
    get whoCanDiscoverGroup() {
        return this.getStringAttribute('who_can_discover_group');
    }
    set whoCanDiscoverGroup(value) {
        this._whoCanDiscoverGroup = value;
    }
    resetWhoCanDiscoverGroup() {
        this._whoCanDiscoverGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanDiscoverGroupInput() {
        return this._whoCanDiscoverGroup;
    }
    get whoCanJoin() {
        return this.getStringAttribute('who_can_join');
    }
    set whoCanJoin(value) {
        this._whoCanJoin = value;
    }
    resetWhoCanJoin() {
        this._whoCanJoin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanJoinInput() {
        return this._whoCanJoin;
    }
    get whoCanLeaveGroup() {
        return this.getStringAttribute('who_can_leave_group');
    }
    set whoCanLeaveGroup(value) {
        this._whoCanLeaveGroup = value;
    }
    resetWhoCanLeaveGroup() {
        this._whoCanLeaveGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanLeaveGroupInput() {
        return this._whoCanLeaveGroup;
    }
    get whoCanModerateContent() {
        return this.getStringAttribute('who_can_moderate_content');
    }
    set whoCanModerateContent(value) {
        this._whoCanModerateContent = value;
    }
    resetWhoCanModerateContent() {
        this._whoCanModerateContent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanModerateContentInput() {
        return this._whoCanModerateContent;
    }
    get whoCanModerateMembers() {
        return this.getStringAttribute('who_can_moderate_members');
    }
    set whoCanModerateMembers(value) {
        this._whoCanModerateMembers = value;
    }
    resetWhoCanModerateMembers() {
        this._whoCanModerateMembers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanModerateMembersInput() {
        return this._whoCanModerateMembers;
    }
    get whoCanPostMessage() {
        return this.getStringAttribute('who_can_post_message');
    }
    set whoCanPostMessage(value) {
        this._whoCanPostMessage = value;
    }
    resetWhoCanPostMessage() {
        this._whoCanPostMessage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanPostMessageInput() {
        return this._whoCanPostMessage;
    }
    get whoCanViewGroup() {
        return this.getStringAttribute('who_can_view_group');
    }
    set whoCanViewGroup(value) {
        this._whoCanViewGroup = value;
    }
    resetWhoCanViewGroup() {
        this._whoCanViewGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanViewGroupInput() {
        return this._whoCanViewGroup;
    }
    get whoCanViewMembership() {
        return this.getStringAttribute('who_can_view_membership');
    }
    set whoCanViewMembership(value) {
        this._whoCanViewMembership = value;
    }
    resetWhoCanViewMembership() {
        this._whoCanViewMembership = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get whoCanViewMembershipInput() {
        return this._whoCanViewMembership;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_external_members: cdktf.booleanToTerraform(this._allowExternalMembers),
            allow_web_posting: cdktf.booleanToTerraform(this._allowWebPosting),
            archive_only: cdktf.booleanToTerraform(this._archiveOnly),
            custom_footer_text: cdktf.stringToTerraform(this._customFooterText),
            custom_reply_to: cdktf.stringToTerraform(this._customReplyTo),
            default_message_deny_notification_text: cdktf.stringToTerraform(this._defaultMessageDenyNotificationText),
            email: cdktf.stringToTerraform(this._email),
            enable_collaborative_inbox: cdktf.booleanToTerraform(this._enableCollaborativeInbox),
            include_custom_footer: cdktf.booleanToTerraform(this._includeCustomFooter),
            include_in_global_address_list: cdktf.booleanToTerraform(this._includeInGlobalAddressList),
            is_archived: cdktf.booleanToTerraform(this._isArchived),
            members_can_post_as_the_group: cdktf.booleanToTerraform(this._membersCanPostAsTheGroup),
            message_moderation_level: cdktf.stringToTerraform(this._messageModerationLevel),
            primary_language: cdktf.stringToTerraform(this._primaryLanguage),
            reply_to: cdktf.stringToTerraform(this._replyTo),
            send_message_deny_notification: cdktf.booleanToTerraform(this._sendMessageDenyNotification),
            spam_moderation_level: cdktf.stringToTerraform(this._spamModerationLevel),
            who_can_assist_content: cdktf.stringToTerraform(this._whoCanAssistContent),
            who_can_contact_owner: cdktf.stringToTerraform(this._whoCanContactOwner),
            who_can_discover_group: cdktf.stringToTerraform(this._whoCanDiscoverGroup),
            who_can_join: cdktf.stringToTerraform(this._whoCanJoin),
            who_can_leave_group: cdktf.stringToTerraform(this._whoCanLeaveGroup),
            who_can_moderate_content: cdktf.stringToTerraform(this._whoCanModerateContent),
            who_can_moderate_members: cdktf.stringToTerraform(this._whoCanModerateMembers),
            who_can_post_message: cdktf.stringToTerraform(this._whoCanPostMessage),
            who_can_view_group: cdktf.stringToTerraform(this._whoCanViewGroup),
            who_can_view_membership: cdktf.stringToTerraform(this._whoCanViewMembership),
            timeouts: groupSettingsTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GroupSettings = GroupSettings;
_b = JSII_RTTI_SYMBOL_1;
GroupSettings[_b] = { fqn: "@cdktf/provider-googleworkspace.groupSettings.GroupSettings", version: "1.0.2" };
// =================
// STATIC PROPERTIES
// =================
GroupSettings.tfResourceType = "googleworkspace_group_settings";
//# sourceMappingURL=data:application/json;base64,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