# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from .bank_account_request import BankAccountRequest
from .card_request import CardRequest
from .check_request import CheckRequest
from .custom_payment_method_request import CustomPaymentMethodRequest
from .payment_method_type import PaymentMethodType


class PaymentMethodRequest(pydantic.BaseModel):
    type: PaymentMethodType
    bank_account: typing.Optional[BankAccountRequest] = pydantic.Field(alias="bankAccount")
    check: typing.Optional[CheckRequest]
    card: typing.Optional[CardRequest]
    custom: typing.Optional[CustomPaymentMethodRequest]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
