# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...entity.types.entity_id import EntityId
from ...entity.types.entity_response import EntityResponse
from ...payment_method.types.payment_method_id import PaymentMethodId
from ...payment_method.types.payment_method_response import PaymentMethodResponse
from .invoice_id import InvoiceId
from .invoice_status import InvoiceStatus
from .transaction_response import TransactionResponse


class InvoiceResponse(pydantic.BaseModel):
    id: InvoiceId
    status: InvoiceStatus
    amount: typing.Optional[float]
    currency: typing.Optional[str]
    deduction_date: typing.Optional[dt.datetime] = pydantic.Field(alias="deductionDate")
    funded_date: typing.Optional[dt.datetime] = pydantic.Field(alias="fundedDate")
    due_date: typing.Optional[dt.datetime] = pydantic.Field(alias="dueDate")
    invoice_number: typing.Optional[str] = pydantic.Field(alias="invoiceNumber")
    note_to_self: typing.Optional[str] = pydantic.Field(alias="noteToSelf")
    payer_id: typing.Optional[EntityId] = pydantic.Field(alias="payerId")
    payer: typing.Optional[EntityResponse]
    payment_source: typing.Optional[PaymentMethodResponse] = pydantic.Field(alias="paymentSource")
    payment_source_id: typing.Optional[PaymentMethodId] = pydantic.Field(alias="paymentSourceId")
    vendor_id: typing.Optional[EntityId] = pydantic.Field(alias="vendorId")
    vendor: typing.Optional[EntityResponse]
    payment_destination: typing.Optional[PaymentMethodResponse] = pydantic.Field(alias="paymentDestination")
    payment_destination_id: typing.Optional[PaymentMethodId] = pydantic.Field(alias="paymentDestinationId")
    payment_destination_confirmed: bool = pydantic.Field(alias="paymentDestinationConfirmed")
    transactions: typing.Optional[typing.List[TransactionResponse]]
    processed_at: typing.Optional[dt.datetime] = pydantic.Field(alias="processedAt")
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
