# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ....core.datetime_utils import serialize_datetime
from ...entity.types.entity_id import EntityId
from ...payment_method.types.payment_method_id import PaymentMethodId
from .create_vendor_request import CreateVendorRequest
from .invoice_status import InvoiceStatus


class InvoiceRequest(pydantic.BaseModel):
    status: typing.Optional[InvoiceStatus]
    amount: typing.Optional[float]
    currency: typing.Optional[str]
    deduction_date: typing.Optional[dt.datetime] = pydantic.Field(alias="deductionDate")
    funded_date: typing.Optional[dt.datetime] = pydantic.Field(alias="fundedDate")
    due_date: typing.Optional[dt.datetime] = pydantic.Field(alias="dueDate")
    invoice_number: typing.Optional[str] = pydantic.Field(alias="invoiceNumber")
    note_to_self: typing.Optional[str] = pydantic.Field(alias="noteToSelf")
    payer_id: typing.Optional[EntityId] = pydantic.Field(alias="payerId")
    payment_source_id: typing.Optional[PaymentMethodId] = pydantic.Field(alias="paymentSourceId")
    vendor_id: typing.Optional[EntityId] = pydantic.Field(alias="vendorId")
    payment_destination_id: typing.Optional[PaymentMethodId] = pydantic.Field(alias="paymentDestinationId")
    create_vendor: typing.Optional[CreateVendorRequest] = pydantic.Field(
        alias="createVendor",
        description=(
            "When paying to a new vendor, use the createVendor object. Mercoa will create the vendor entity and tie it to this invoice. This object is ignored when updating an invoice.\n"
        ),
    )
    update_vendor: typing.Optional[CreateVendorRequest] = pydantic.Field(
        alias="updateVendor",
        description=(
            "When paying to an existing vendor with an incomplete profile, use the updateVendor object. Mercoa will update the vendor entity tied to this invoice. This object is ignored if the vendor already has already been created with complete information and when creating a new invoice.\n"
        ),
    )
    uploaded_image: typing.Optional[str] = pydantic.Field(alias="uploadedImage")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
