# Python 2ip Module

**2ip** allows you to make requests to the 2ip.me API to retrieve provider/geographic information for IP addresses. Requests are (optionally, on by default) cached to prevent unnecessary API lookups when possible.

## Examples

Retrieve provider information for the IP address `192.0.2.0`:

```python
>>> from twoip import TwoIP
>>> twoip = TwoIP(key = None)
>>> twoip.provider(ip = '192.0.2.0')
{'ip': '192.0.2.0',
 'ip_range_end': '3221226239',
 'ip_range_start': '3221225984',
 'mask': '24',
 'name_ripe': 'Reserved AS',
 'name_rus': '',
 'route': '192.0.2.0'}
```

Retrieve geographic information for the IP address `8.8.8.8`:

```python
>>> from twoip import TwoIP
>>> twoip = TwoIP(key = None)
>>> twoip.geo(ip = '8.8.8.8')
{'city': 'Mountain view',
 'country': 'United states of america',
 'country_code': 'US',
 'country_rus': 'США',
 'country_ua': 'США',
 'ip': '8.8.8.8',
 'latitude': '37.405992',
 'longitude': '-122.078515',
 'region': 'California',
 'region_rus': 'Калифорния',
 'region_ua': 'Каліфорнія',
 'time_zone': '-08:00',
 'zip_code': '94043'}
```

## Roadmap/Todo

- [ ] Support for email API
- [ ] Support for MAC address API
- [ ] Support for hosting API
- [ ] Option to retrieve data as XML
- [ ] Unit tests
