"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
});
test('Modify an InstanceFleet with static ClusterId, InstanceFleetName, and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrModifyInstanceFleetByName({
            clusterId: 'ClusterId',
            instanceFleetName: 'InstanceFleetName',
            targetOnDemandCapacity: 2,
            targetSpotCapacity: 0
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0
            }
        },
    });
});
test('Modify an InstanceFleet with ClusterId from payload and static InstanceFleetName and InstanceFleetConfiguration', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrModifyInstanceFleetByName({
            clusterId: sfn.Data.stringAt('$.ClusterId'),
            instanceFleetName: 'InstanceFleetName',
            targetOnDemandCapacity: 2,
            targetSpotCapacity: 0
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId.$': '$.ClusterId',
            'InstanceFleetName': 'InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0
            }
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetConfigurateion and InstanceFleetName from payload', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrModifyInstanceFleetByName({
            clusterId: 'ClusterId',
            instanceFleetName: sfn.Data.stringAt('$.InstanceFleetName'),
            targetOnDemandCapacity: 2,
            targetSpotCapacity: 0
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            'ClusterId': 'ClusterId',
            'InstanceFleetName.$': '$.InstanceFleetName',
            'InstanceFleet': {
                TargetOnDemandCapacity: 2,
                TargetSpotCapacity: 0
            }
        },
    });
});
test('Modify an InstanceFleet with static ClusterId and InstanceFleetName and Target Capacities from payload', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EmrModifyInstanceFleetByName({
            clusterId: 'ClusterId',
            instanceFleetName: 'InstanceFleetName',
            targetOnDemandCapacity: sfn.Data.numberAt('$.TargetOnDemandCapacity'),
            targetSpotCapacity: sfn.Data.numberAt('$.TargetSpotCapacity')
        })
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::elasticmapreduce:modifyInstanceFleetByName',
                ],
            ],
        },
        End: true,
        Parameters: {
            ClusterId: 'ClusterId',
            InstanceFleetName: 'InstanceFleetName',
            InstanceFleet: {
                'TargetOnDemandCapacity.$': '$.TargetOnDemandCapacity',
                'TargetSpotCapacity.$': '$.TargetSpotCapacity'
            }
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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