import * as sfn from '@aws-cdk/aws-stepfunctions';
/**
 * Properties for EmrTerminateCluster
 *
 * @experimental
 */
export interface EmrTerminateClusterProps {
    /**
     * The ClusterId to terminate.
     */
    readonly clusterId: string;
    /**
     * The service integration pattern indicates different ways to call TerminateCluster.
     *
     * The valid value is either FIRE_AND_FORGET or SYNC.
     *
     * @default SYNC
     */
    readonly integrationPattern?: sfn.ServiceIntegrationPattern;
}
/**
 * A Step Functions Task to terminate an EMR Cluster.
 *
 * @experimental
 */
export declare class EmrTerminateCluster implements sfn.IStepFunctionsTask {
    private readonly props;
    private readonly integrationPattern;
    constructor(props: EmrTerminateClusterProps);
    bind(_task: sfn.Task): sfn.StepFunctionsTaskConfig;
    /**
     * This generates the PolicyStatements required by the Task to call TerminateCluster.
     */
    private createPolicyStatements;
}
