from tqix import *
from tqix.qtool import dotx
import numpy as np

__all__ = ['_mub_']
#use for inner povm.py

def _mub_(d):
    if d == 2:
       return _mub_2()
    elif d == 3:
       return _mub_3()
    elif d == 4:
       return _mub_4()
    elif d == 5:
       return _mub_5()
    elif d == 7:
       return _mub_7()
    else:
       return ('not construct yet')

def _mub_2():
    u = obasis(2,0)
    d = obasis(2,1)
    h = dotx(u,daggx(u))
    v = dotx(d,daggx(d))
    p = dotx(normx(u+d),daggx(normx(u+d)))
    m = dotx(normx(u-d),daggx(normx(u-d)))
    l = dotx(normx(u+1j*d),daggx(normx(u+1j*d)))
    r = dotx(normx(u-1j*d),daggx(normx(u-1j*d)))
    m = [h,v,p,m,l,r]
    return m

def _mub_3():
    d = 3
    w = np.exp(2*np.pi*1j/3.)
    s = 1/np.sqrt(3.0)
    v1 = obasis(d,0)
    v2 = obasis(d,1)
    v3 = obasis(d,2)
    v4 = s*(v1+v2+v3)
    v5 = s*(v1+w*v2+w**2*v3)
    v6 = s*(v1+w**2*v2+w*v3)
    v7 = s*(v1+w*v2+w*v3)
    v8 = s*(v1+w**2*v2+v3)
    v9 = s*(v1+v2+w**2*v3)
    v10 = s*(v1+w**2*v2+w**2*v3)
    v11 = s*(v1+w*v2+v3)
    v12 = s*(v1+v2+w*v3)
    v = [v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12]
    vv = []
    for i in v:
        vv.append(dotx(i,daggx(i)))
    return vv

def _mub_4():
   d = 4
   v1 = obasis(d,0)
   v2 = obasis(d,1)
   v3 = obasis(d,2)
   v4 = obasis(d,3)
   v5 = 0.5*(v1+v2+v3+v4)
   v6 = 0.5*(v1+v2-v3-v4)
   v7 = 0.5*(v1-v2-v3+v4)
   v8 = 0.5*(v1-v2+v3-v4)
   v9 = 0.5*(v1-v2-1j*v3-1j*v4)
   v10 = 0.5*(v1-v2+1j*v3+1j*v4)
   v11 = 0.5*(v1+v2+1j*v3-1j*v4)
   v12 = 0.5*(v1+v2-1j*v3+1j*v4)
   v13 = 0.5*(v1-1j*v2-1j*v3-v4)
   v14 = 0.5*(v1-1j*v2+1j*v3+v4)
   v15 = 0.5*(v1+1j*v2+1j*v3-v4)
   v16 = 0.5*(v1+1j*v2-1j*v3+v4)
   v17 = 0.5*(v1-1j*v2-v3-1j*v4)
   v18 = 0.5*(v1-1j*v2+v3+1j*v4)
   v19 = 0.5*(v1+1j*v2-v3+1j*v4)
   v20 = 0.5*(v1+1j*v2+v3-1j*v4)
   v = [v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,\
        v11,v12,v13,v14,v15,v16,v17,v18,v19,v20]
   vv = []
   for i in v:
       vv.append(dotx(i,daggx(i)))
   return vv

def _mub_5():
   d = 5
   v1 = obasis(d,0)
   v2 = obasis(d,1)
   v3 = obasis(d,2)
   v4 = obasis(d,3)
   v5 = obasis(d,4)

   m1 = dotx(v1,daggx(v1))
   m2 = dotx(v2,daggx(v2))
   m3 = dotx(v3,daggx(v3))
   m4 = dotx(v4,daggx(v4))
   m5 = dotx(v5,daggx(v5))
   m6 = 0.2*np.ones((5,5),complex)
   m7 = _mat_5([0.2000,0.0618+0.1902j,-0.1618+0.1176j,
               -0.1618-0.1176j,0.0618-0.1902j,0.2000,
               0.0618+0.1902j,-0.1618+0.1176j,-0.1618-0.1176j,
               0.2000,0.0618+0.1902j,-0.1618+0.1176j,0.2000,0.0618+0.1902j,0.2000])

   m8 = _mat_5([0.2000,-0.1618+0.1176j,0.0618-0.1902j,0.0618+0.1902j,
                -0.1618-0.1176j,0.2000,-0.1618+0.1176j,0.0618-0.1902j,
                0.0618+0.1902j,0.2000,-0.1618+0.1176j,0.0618-0.1902j,
                0.2000,-0.1618+0.1176j,0.2000])
   m9 = conjx(m8)
   m10 = conjx(m7)

   m11 = _mat_5([0.2000,-0.1618+0.1176j,-0.1618-0.1176j,-0.1618-0.1176j,
                 -0.1618+0.1176j,0.2000,0.0618+0.1902j,0.0618+0.1902j,
                 0.2000,0.2000,0.2000,0.0618-0.1902j,0.2000,0.0618-0.1902j,0.2000])

   m12 = _mat_5([0.2000,-0.1618-0.1176j,0.2000,0.0618+0.1902j,0.0618+0.1902j,
                 0.2000,-0.1618+0.1176j,-0.1618-0.1176j,-0.1618-0.1176j,
                 0.2000,0.0618+0.1902j,0.0618+0.1902j,0.2000,0.2000,0.2000])

   m13 = _mat_5([0.2000,0.0618-0.1902j,-0.1618+0.1176j,0.0618-0.1902j,
                 0.2000,0.2000,-0.1618-0.1176j,0.2000,0.0618+0.1902j,
                 0.2000,-0.1618+0.1176j,-0.1618-0.1176j,0.2000,0.0618+0.1902j,0.2000])

   m14 = _mat_5([0.2000,0.2000,0.0618-0.1902j,-0.1618+0.1176j,0.0618-0.1902j,
                 0.2000,0.0618-0.1902j,-0.1618+0.1176j,0.0618-0.1902j,
                 0.2000,-0.1618-0.1176j,0.2000,0.2000,-0.1618+0.1176j,0.2000])

   m15 = _mat_5([0.2000,0.0618+0.1902j,0.0618+0.1902j,0.2000,-0.1618-0.1176j,
                 0.2000,0.2000,0.0618-0.1902j,-0.1618+0.1176j,0.2000,
                 0.0618-0.1902j,-0.1618+0.1176j,0.2000,-0.1618-0.1176j,0.2000])

   m16 = _mat_5([0.2000,0.0618-0.1902j,0.0618+0.1902j,0.0618+0.1902j,
                 0.0618-0.1902j,0.2000,-0.1618+0.1176j,-0.1618+0.1176j,
                 0.2000,0.2000,0.2000,-0.1618-0.1176j,0.2000,-0.1618-0.1176j,0.2000])

   m17 = _mat_5([0.2000,0.2000,-0.1618-0.1176j,0.0618-0.1902j,-0.1618-0.1176j,
                 0.2000,-0.1618-0.1176j,0.0618-0.1902j,-0.1618-0.1176j,
                 0.2000,0.0618+0.1902j,0.2000,0.2000,0.0618-0.1902j,0.2000])

   m18 = _mat_5([0.2000,0.0618+0.1902j,0.2000,-0.1618+0.1176j,-0.1618+0.1176j,
                 0.2000,0.0618-0.1902j,0.0618+0.1902j,0.0618+0.1902j,0.2000,
                 -0.1618+0.1176j,-0.1618+0.1176j,0.2000,0.2000,0.2000])

   m19 = _mat_5([0.2000,-0.1618+0.1176j,-0.1618+0.1176j,0.2000,0.0618+0.1902j,
                 0.2000,0.2000,-0.1618-0.1176j,0.0618-0.1902j,0.2000,
                 -0.1618-0.1176j,0.0618-0.1902j,0.2000,0.0618+0.1902j,0.2000])

   m20 = _mat_5([0.2000,-0.1618-0.1176j,0.0618-0.1902j,-0.1618-0.1176j,
                 0.2000,0.2000,0.0618+0.1902j,0.2000,-0.1618+0.1176j,
                 0.2000,0.0618-0.1902j,0.0618+0.1902j,0.2000,-0.1618+0.1176j,0.2000])

   m21 = conjx(m16)
   m22 = conjx(m20)
   m23 = conjx(m19)
   m24 = conjx(m18)
   m25 = conjx(m17)
   m26 = conjx(m11)
   m27 = conjx(m15)
   m28 = conjx(m14)
   m29 = conjx(m13)
   m30 = conjx(m12)

   return [m1,m2,m3,m4,m5,m6,m7,m8,m9,m10,
          m11,m12,m13,m14,m15,m16,m17,m18,m19,m20,
          m21,m22,m23,m24,m25,m26,m27,m28,m29,m30]

def _mub_7():
   d = 7
   v1 = obasis(d,0)
   v2 = obasis(d,1)
   v3 = obasis(d,2)
   v4 = obasis(d,3)
   v5 = obasis(d,4)
   v6 = obasis(d,5)
   v7 = obasis(d,6)

   m1 = dotx(v1,daggx(v1))
   m2 = dotx(v2,daggx(v2))
   m3 = dotx(v3,daggx(v3))
   m4 = dotx(v4,daggx(v4))
   m5 = dotx(v5,daggx(v5))
   m6 = dotx(v6,daggx(v6))
   m7 = dotx(v7,daggx(v7))
   m8 = 0.1429*np.ones((7,7),complex)

   m9 = _mat_7([0.1429,0.0891+0.1117j,-0.0318+0.1393j,-0.1287+0.0620j,
                -0.1287-0.0620j,-0.0318-0.1393j,0.0891-0.1117j,0.1429,
                0.0891+0.1117j,-0.0318+0.1393j,-0.1287+0.0620j,
                -0.1287-0.0620j,-0.0318-0.1393j,0.1429,0.0891+0.1117j,
                -0.0318+0.1393j,-0.1287+0.0620j,-0.1287-0.0620j,0.1429,
                0.0891+0.1117j,-0.0318+0.1393j,-0.1287+0.0620j,0.1429,
                0.0891+0.1117j,-0.0318+0.1393j,0.1429,0.0891+0.1117j,0.1429])
    
   m10 = _mat_7([0.1429,-0.0318+0.1393j,-0.1287-0.0620j,0.0891-0.1117j,
                 0.0891+0.1117j,-0.1287+0.0620j,-0.0318-0.1393j,0.1429,
                 -0.0318+0.1393j,-0.1287-0.0620j,0.0891-0.1117j,0.0891+0.1117j,
                 -0.1287+0.0620j,0.1429,-0.0318+0.1393j,-0.1287-0.0620j,
                 0.0891-0.1117j,0.0891+0.1117j,0.1429,-0.0318+0.1393j,
                 -0.1287-0.0620j,0.0891-0.1117j,0.1429,-0.0318+0.1393j,
                 -0.1287-0.0620j,0.1429,-0.0318+0.1393j,0.1429])

   m11 = _mat_7([0.1429,-0.1287+0.0620j,0.0891-0.1117j,-0.0318+0.1393j,
                -0.0318-0.1393j,0.0891+0.1117j,-0.1287-0.0620j,0.1429,
                -0.1287+0.0620j,0.0891-0.1117j,-0.0318+0.1393j,-0.0318-0.1393j,
                0.0891+0.1117j,0.1429,-0.1287+0.0620j,0.0891-0.1117j,
                -0.0318+0.1393j,-0.0318-0.1393j,0.1429,-0.1287+0.0620j,
                0.0891-0.1117j,-0.0318+0.1393j,0.1429,-0.1287+0.0620j,
                0.0891-0.1117j,0.1429,-0.1287+0.0620j,0.1429])

   m12 = conjx(m11)
   m13 = conjx(m10)
   m14 = conjx(m9)
 
   m15 = _mat_7([0.1429,-0.1287+0.0620j,-0.0318-0.1393j,0.0891-0.1117j,
                 0.0891-0.1117j,-0.0318-0.1393j,-0.1287+0.0620j,0.1429,
                 -0.0318+0.1393j,-0.1287+0.0620j,-0.1287+0.0620j,-0.0318+0.1393j,
                 0.1429,0.1429,0.0891+0.1117j,0.0891+0.1117j,0.1429,-0.0318-0.1393j,
                 0.1429,0.1429,0.0891-0.1117j,-0.1287-0.0620j,0.1429,0.0891-0.1117j,
                 -0.1287-0.0620j,0.1429,-0.0318-0.1393j,0.1429])

   m16 = _mat_7([0.1429,-0.1287-0.0620j,0.1429,-0.0318+0.1393j,-0.1287+0.0620j,
                -0.1287+0.0620j,-0.0318+0.1393j,0.1429,-0.1287+0.0620j,
                -0.0318-0.1393j,0.0891-0.1117j,0.0891-0.1117j,-0.0318-0.1393j,
                0.1429,-0.0318+0.1393j,-0.1287+0.0620j,-0.1287+0.0620j,
                -0.0318+0.1393j,0.1429,0.0891+0.1117j,0.0891+0.1117j,0.1429,
                0.1429,0.1429,0.0891-0.1117j,0.1429,0.0891-0.1117j,0.1429])

   m17 = _mat_7([0.1429,-0.0318-0.1393j,-0.0318+0.1393j,-0.0318-0.1393j,
                 0.1429+0.0000j,0.0891+0.1117j,0.0891+0.1117j,0.1429,
                 -0.1287-0.0620j,0.1429,-0.0318+0.1393j,-0.1287+0.0620j,
                 -0.1287+0.0620j,0.1429,-0.1287+0.0620j,-0.0318-0.1393j,
                 0.0891-0.1117j,0.0891-0.1117j,0.1429,-0.0318+0.1393j,
                 -0.1287+0.0620j,-0.1287+0.0620j,0.1429,0.0891+0.1117j,
                 0.0891+0.1117j,0.1429,0.1429,0.1429])

   m18 = _mat_7([0.1429,0.0891-0.1117j,-0.1287-0.0620j,0.0891+0.1117j,
                 -0.1287-0.0620j,0.0891-0.1117j,0.1429,0.1429,-0.0318-0.1393j,
                 -0.0318+0.1393j,-0.0318-0.1393j,0.1429,0.0891+0.1117j,
                 0.1429,-0.1287-0.0620j,0.1429,-0.0318+0.1393j,-0.1287+0.0620j,
                 0.1429,-0.1287+0.0620j,-0.0318-0.1393j,0.0891-0.1117j, 
                 0.1429,-0.0318+0.1393j,-0.1287+0.0620j,0.1429,0.0891+0.1117j,
                 0.1429])

   m19 = _mat_7([0.1429,0.1429,0.0891-0.1117j,-0.1287-0.0620j,0.0891+0.1117j,
                 -0.1287-0.0620j,0.0891-0.1117j,0.1429,0.0891-0.1117j,  
                 -0.1287-0.0620j,0.0891+0.1117j,-0.1287-0.0620j,0.0891-0.1117j,
                 0.1429,-0.0318-0.1393j,-0.0318+0.1393j,-0.0318-0.1393j,   
                 0.1429,0.1429,-0.1287-0.0620j,0.1429,-0.0318+0.1393j, 
                 0.1429,-0.1287+0.0620j,-0.0318-0.1393j,0.1429,-0.0318+0.1393j,
                 0.1429])

   m20 = _mat_7([0.1429,0.0891+0.1117j,0.0891+0.1117j,0.1429,-0.0318-0.1393j,
                 -0.0318+0.1393j,-0.0318-0.1393j,0.1429,0.1429,0.0891-0.1117j,
                 -0.1287-0.0620j,0.0891+0.1117j,-0.1287-0.0620j,0.1429,
                 0.0891-0.1117j,-0.1287-0.0620j,0.0891+0.1117j,-0.1287-0.0620j,
                 0.1429,-0.0318-0.1393j,-0.0318+0.1393j,-0.0318-0.1393j, 
                 0.1429,-0.1287-0.0620j,0.1429,0.1429,-0.1287+0.0620j,0.1429])

   m21 = _mat_7([0.1429,-0.0318+0.1393j,-0.1287+0.0620j,-0.1287+0.0620j,
                 -0.0318+0.1393j,0.1429,-0.1287-0.0620j,0.1429,0.0891+0.1117j,
                 0.0891+0.1117j,0.1429,-0.0318-0.1393j,-0.0318+0.1393j, 
                 0.1429,0.1429,0.0891-0.1117j,-0.1287-0.0620j,0.0891+0.1117j,
                 0.1429,0.0891-0.1117j,-0.1287-0.0620j,0.0891+0.1117j,0.1429,
                 -0.0318-0.1393j,-0.0318+0.1393j,0.1429,-0.1287-0.0620j,0.1429])

   m22 = _mat_7([0.1429,0.0891-0.1117j,-0.1287+0.0620j,-0.0318-0.1393j,
                 -0.0318-0.1393j,-0.1287+0.0620j,0.0891-0.1117j,0.1429,
                 -0.1287-0.0620j,0.0891-0.1117j,0.0891-0.1117j,-0.1287-0.0620j,
                 0.1429,0.1429,-0.0318+0.1393j,-0.0318+0.1393j,0.1429,  
                 -0.1287+0.0620j,0.1429,0.1429,-0.0318-0.1393j,0.0891+0.1117j, 
                 0.1429,-0.0318-0.1393j,0.0891+0.1117j,0.1429,-0.1287+0.0620j,0.1429])

   m23 = _mat_7([0.1429,0.1429,-0.0318-0.1393j,0.0891+0.1117j,-0.0318+0.1393j, 
                 0.0891+0.1117j,-0.0318-0.1393j,0.1429,-0.0318-0.1393j,
                 0.0891+0.1117j,-0.0318+0.1393j,0.0891+0.1117j,-0.0318-0.1393j,
                 0.1429,-0.1287+0.0620j,-0.1287-0.0620j,-0.1287+0.0620j,
                 0.1429,0.1429,0.0891+0.1117j,0.1429,-0.1287-0.0620j,0.1429,
                 0.0891-0.1117j,-0.1287+0.0620j,0.1429,-0.1287-0.0620j,0.1429])

   m24 = _mat_7([0.1429,0.0891+0.1117j,0.1429,-0.1287-0.0620j,0.0891-0.1117j,
                 0.0891-0.1117j,-0.1287-0.0620j,0.1429,0.0891-0.1117j,
                 -0.1287+0.0620j,-0.0318-0.1393j,-0.0318-0.1393j,-0.1287+0.0620j,
                 0.1429,-0.1287-0.0620j,0.0891-0.1117j,0.0891-0.1117j,-0.1287-0.0620j,
                 0.1429,-0.0318+0.1393j,-0.0318+0.1393j,0.1429,0.1429,0.1429,
                 -0.0318-0.1393j,0.1429,-0.0318-0.1393j,0.1429])

   m25 = _mat_7([0.1429,-0.0318+0.1393j,-0.0318+0.1393j,0.1429,-0.1287+0.0620j,
                 -0.1287-0.0620j,-0.1287+0.0620j,0.1429,0.1429,-0.0318-0.1393j,
                 0.0891+0.1117j,-0.0318+0.1393j,0.0891+0.1117j,0.1429,  
                 -0.0318-0.1393j,0.0891+0.1117j,-0.0318+0.1393j,0.0891+0.1117j,
                 0.1429,-0.1287+0.0620j,-0.1287-0.0620j,-0.1287+0.0620j,0.1429,
                 0.0891+0.1117j,0.1429,0.1429,0.0891-0.1117j,0.1429])

   m26 = _mat_7([0.1429,-0.1287+0.0620j,-0.1287-0.0620j,-0.1287+0.0620j,0.1429,
                 -0.0318+0.1393j,-0.0318+0.1393j,0.1429,0.0891+0.1117j,0.1429,
                 -0.1287-0.0620j,0.0891-0.1117j,0.0891-0.1117j,0.1429,0.0891-0.1117j,
                 -0.1287+0.0620j,-0.0318-0.1393j,-0.0318-0.1393j,0.1429,
                 -0.1287-0.0620j,0.0891-0.1117j,0.0891-0.1117j,0.1429,-0.0318+0.1393j,
                 -0.0318+0.1393j,0.1429,0.1429,0.1429])

   m27 = _mat_7([0.1429,-0.1287-0.0620j,0.0891-0.1117j,0.0891-0.1117j,-0.1287-0.0620j,
                 0.1429,0.0891+0.1117j,0.1429,-0.0318+0.1393j,-0.0318+0.1393j,
                 0.1429,-0.1287+0.0620j,-0.1287-0.0620j,0.1429,0.1429,-0.0318-0.1393j,
                 0.0891+0.1117j,-0.0318+0.1393j,0.1429,-0.0318-0.1393j,0.0891+0.1117j,
                 -0.0318+0.1393j,0.1429,-0.1287+0.0620j,-0.1287-0.0620j,0.1429,
                 0.0891+0.1117j,0.1429])

   m28 = _mat_7([0.1429,-0.0318-0.1393j,0.0891+0.1117j,-0.0318+0.1393j,0.0891+0.1117j,
                 -0.0318-0.1393j,0.1429,0.1429,-0.1287+0.0620j,-0.1287-0.0620j,
                 -0.1287+0.0620j,0.1429,-0.0318+0.1393j,0.1429,0.0891+0.1117j,0.1429,
                 -0.1287-0.0620j,0.0891-0.1117j,0.1429,0.0891-0.1117j,-0.1287+0.0620j,
                 -0.0318-0.1393j,0.1429,-0.1287-0.0620j,0.0891-0.1117j,0.1429,
                 -0.0318+0.1393j,0.1429])

   m29 = _mat_7([0.1429,-0.0318+0.1393j,0.0891+0.1117j,-0.1287-0.0620j,
                 -0.1287-0.0620j,0.0891+0.1117j,-0.0318+0.1393j,0.1429,
                 0.0891-0.1117j,-0.0318+0.1393j,-0.0318+0.1393j,0.0891-0.1117j,
                 0.1429,0.1429,-0.1287+0.0620j,-0.1287+0.0620j,0.1429,
                 0.0891+0.1117j,0.1429,0.1429,-0.1287-0.0620j,-0.0318-0.1393j,
                 0.1429,-0.1287-0.0620j,-0.0318-0.1393j,0.1429,0.0891+0.1117j,0.1429])

   m30 = _mat_7([0.1429,-0.1287+0.0620j,-0.1287+0.0620j,0.1429,0.0891+0.1117j,
                 0.0891-0.1117j,0.0891+0.1117j,0.1429,0.1429,-0.1287-0.0620j,
                 -0.0318-0.1393j,-0.1287+0.0620j,-0.0318-0.1393j,0.1429,
                 -0.1287-0.0620j,-0.0318-0.1393j,-0.1287+0.0620j,-0.0318-0.1393j,
                 0.1429,0.0891+0.1117j,0.0891-0.1117j,0.0891+0.1117j,0.1429,
                 -0.0318-0.1393j,0.1429,0.1429,-0.0318+0.1393j,0.1429])

   m31 = _mat_7([0.1429,-0.1287-0.0620j,-0.0318-0.1393j,-0.1287+0.0620j,
                 -0.0318-0.1393j,-0.1287-0.0620j,0.1429,0.1429,0.0891+0.1117j,
                 0.0891-0.1117j,0.0891+0.1117j,0.1429,-0.1287+0.0620j,0.1429,
                 -0.0318-0.1393j,0.1429,0.0891-0.1117j,-0.0318+0.1393j,0.1429,
                 -0.0318+0.1393j,0.0891+0.1117j,-0.1287-0.0620j,0.1429,
                 0.0891-0.1117j,-0.0318+0.1393j,0.1429,-0.1287+0.0620j,0.1429])

   m32 = _mat_7([0.1429,-0.0318-0.1393j,0.1429,0.0891-0.1117j,-0.0318+0.1393j,
                 -0.0318+0.1393j,0.0891-0.1117j,0.1429,-0.0318+0.1393j,
                 0.0891+0.1117j,-0.1287-0.0620j,-0.1287-0.0620j,0.0891+0.1117j,
                 0.1429,0.0891-0.1117j,-0.0318+0.1393j,-0.0318+0.1393j,
                 0.0891-0.1117j,0.1429,-0.1287+0.0620j,-0.1287+0.0620j,0.1429,
                 0.1429,0.1429,-0.1287-0.0620j,0.1429,-0.1287-0.0620j,0.1429])

   m33 = _mat_7([0.1429,0.0891-0.1117j,-0.0318+0.1393j,-0.0318+0.1393j,
                 0.0891-0.1117j,0.1429,-0.0318-0.1393j,0.1429,-0.1287+0.0620j,
                 -0.1287+0.0620j,0.1429,0.0891+0.1117j,0.0891-0.1117j,0.1429,
                 0.1429,-0.1287-0.0620j,-0.0318-0.1393j,-0.1287+0.0620j,0.1429,
                 -0.1287-0.0620j,-0.0318-0.1393j,-0.1287+0.0620j,0.1429,
                 0.0891+0.1117j,0.0891-0.1117j,0.1429,-0.0318-0.1393j,0.1429])

   m34 = _mat_7([0.1429,0.1429,-0.1287-0.0620j,-0.0318-0.1393j,-0.1287+0.0620j, 
                 -0.0318-0.1393j,-0.1287-0.0620j,0.1429,-0.1287-0.0620j,  
                 -0.0318-0.1393j,-0.1287+0.0620j,-0.0318-0.1393j,-0.1287-0.0620j,
                 0.1429,0.0891+0.1117j,0.0891-0.1117j,0.0891+0.1117j,0.1429,
                 0.1429,-0.0318-0.1393j,0.1429,0.0891-0.1117j,0.1429,-0.0318+0.1393j,
                 0.0891+0.1117j,0.1429,0.0891-0.1117j,0.1429])

   m35 = _mat_7([0.1429,0.0891+0.1117j,0.0891-0.1117j,0.0891+0.1117j,0.1429,
                 -0.1287+0.0620j,-0.1287+0.0620j,0.1429,-0.0318-0.1393j,
                 0.1429,0.0891-0.1117j,-0.0318+0.1393j,-0.0318+0.1393j,0.1429,
                 -0.0318+0.1393j,0.0891+0.1117j,-0.1287-0.0620j,-0.1287-0.0620j,
                 0.1429,0.0891-0.1117j,-0.0318+0.1393j,-0.0318+0.1393j,0.1429,
                 -0.1287+0.0620j,-0.1287+0.0620j,0.1429,0.1429,0.1429])

   m36 = conjx(m29)
   m37 = conjx(m35)
   m38 = conjx(m34)
   m39 = conjx(m33)
   m40 = conjx(m32)
   m41 = conjx(m31)
   m42 = conjx(m30)
   m43 = conjx(m22)
   m44 = conjx(m28)
   m45 = conjx(m27)
   m46 = conjx(m26)
   m47 = conjx(m25)
   m48 = conjx(m24)
   m49 = conjx(m23)
   m50 = conjx(m15)
   m51 = conjx(m21)
   m52 = conjx(m20)
   m53 = conjx(m19)
   m54 = conjx(m18)
   m55 = conjx(m17)
   m56 = conjx(m16)

   return [m1,m2,m3,m4,m5,m6,m7,
           m8,m9,m10,m11,m12,m13,m14,
           m15,m16,m17,m18,m19,m20,m21,
           m22,m23,m24,m25,m26,m27,m28,
           m29,m30,m31,m32,m33,m34,m35,
           m36,m37,m38,m39,m40,m41,m42,
           m43,m44,m45,m46,m47,m48,m49,
           m50,m51,m52,m53,m54,m55,m56]

#____________
def _mat_5(a):
    #code for construct matrix 5x5
    # a is an array-line: [a0, a1,...]
      #a[0] = mat[0,0]
      #a[1] = mat[0,1]
      #...
    mat = np.zeros((5,5),complex)
    idx = -1
    for i in range(6):
        for j in range(i,5):
            idx += 1
            mat[i,j] = a[idx]
            mat[j,i] = conjx(mat[i,j])
    return mat

def _mat_7(a):
    #code for construct matrix 7x7
    # a is an array-line: [a0, a1,...]
      #a[0] = mat[0,0]
      #a[1] = mat[0,1]
      #...
    mat = np.zeros((7,7),complex)
    idx = -1
    for i in range(8):
        for j in range(i,7):
            idx += 1
            mat[i,j] = a[idx]
            mat[j,i] = conjx(mat[i,j])
    return mat

