# coding=utf-8
from __future__ import absolute_import, division, print_function, \
  unicode_literals

from unittest import TestCase

from iota import TryteString
from iota.crypto.types import PrivateKey


# noinspection SpellCheckingInspection
class PrivateKeyTestCase(TestCase):
  def test_get_digest_trits_single_fragment(self):
    """
    Generating digest trits from a PrivateKey 1 fragment long.
    """
    key =\
      PrivateKey(
        b'BWFTZWBZVFOSQYHQFXOPYTZ9SWB9RYYHBOUA9NOYSWGALF9MSVNEDW9A9FLGBRWKED'
        b'MPEIPRKBMRXRLLFJCAGVIMXPISRGXIJQ9BOBHKJEUKDEUUWYXJGCGAWHYBQHBPMRTZ'
        b'FPBGNLMKPZYXZPXFSPFUWZNRWYXUEWMP9URKVVJOSWEPJKSMPLWZPIZGOTVAA9QQOC'
        b'YISMGHSBU9YCXZCMSTPJVASDKEVZCSPNSPYOUUWWFTNWZTTZBKGZ9PDNAKNSGNODSB'
        b'IRKUGFYCZXIFHQCDTXQNLMKRVKIFJS9XARBNMJQOTDL9CAOKEXQTMWCKWRNHLLMLYP'
        b'QGTDFNTDBHNAFRBEUWTKPKPECAADKRPEAFDHABMYYXQPQYDSGFRSRFNHFHHHTAH9YF'
        b'OXKRZOTKAHZPRISHZRR9YBVSOZUSKKU9HTCXPTPZFAHFMOQJBKZIACZB9ZRXFPPPMY'
        b'RBCWPBAPRFXLQZOTGXJGMZUUEZIAVWXUEN9UIFLEESVCCGNKDISMEPYWTXDQHOSUWZ'
        b'OEHOCZQJKDCJJNRZVODVNNUOV9FZQEXFGAMDKMV9PVUYMWTFNISYGYKQG9OKNOQUEK'
        b'YDEJ9EGHUXQFCPHTTVBCRTZJLOAWHGDEQHLPLHWTWVOBCCQTCWCNLYDGUV9FKFZENU'
        b'NOCOYNU9CYQDSAQDSMZGRQYB9YOCFSOHQXANMSPYFVCTPTZKUGIGUZMPJIJRZVN9VX'
        b'ADLIVJYJGQWXBOBBAROGNIOIJVRUHWMFLVCGTMZISADLTXVEZLQDYAVQ9OCYQDPCYL'
        b'DD9SUPNTUMUESC9VRSCAYBPXAPTYXZODUUMBNCSLOWJYJA9JBITZLZNHPZFGSPRURJ'
        b'HYFLSFTMEPAEG9DWRFOTFWWPGGDGZWFVEPOHDGNMOXUSR9AVQLNDUMGPYWVN9LKEIZ'
        b'Q9MNIUPJXPTRYMSXRA9GTSZFMNZZT9Z9HJOKVBCHRRIZZN9UYTVRDNHOXYSFRO9FRK'
        b'HWNNZ9DXTLV9D9PNJLGWJXAFUOJZTRVJOLYGSPNVCXYWMTOEEUBLNRGAJPK9HIWGZM'
        b'HMBTHLABTACRYLQIDPOYEFNSYQ9YAQPOYYDCJAAAVDUWCHSS9OKQYH9CQNUPYRTCWK'
        b'CXYDKTAIJKWOQIHSGBZMFJXGOQDODBDZNBOPFYCBLSU9RJYVGXINUDODGHNAGFDAEG'
        b'LPDVSCJPCIZHOFNHCZUTRLQXEZUFDZVROFXVHUNWMYRSZHBZAFCWIY9ULTBTEDSKEC'
        b'CLDGAU9MZXYRAXVY9NIQUYHATJCZXDSAELMCXQMALHNFMEAWHIQAZMQOO9QPEPDOYC'
        b'OJXTUWEJHMPXGZBXFPNXUPOSDINZJNIREYDFZMESFQUPBKSDGTAJHEZSCOVSLYUAUK'
        b'DIWNNLQJTPYYTPRGGN9IXIORWXHJBPYINQZIUXKLKXCTQZYJIRH9MHYBQIFQZCFAKZ'
        b'DUUZTYIMTNNVNKVMFIW9UYRTVRQHMYR9Y9VYFTPBJGSB9VINGTMBKVZJEZUE9RMBDZ'
        b'CQGDHNPW9YIJHLGFOG9YAPXZECSFVXAMPILBIHC9DBGMIE99YEPGTAALOHBUKXSGFZ'
        b'YHHWFOIHMEDXFHIYSUHADOCKFNGHKTNPZHINAWG9YGRJBQGECRCVPXXOG9CNVJNFLC'
        b'LMGC9I9HAGTAGGVRKCXDJWDNHYZBFNQSKH99MFAMLGRSBMIBBMHBDJTVSQ99ZHYPSS'
        b'XLUNFCNOJXITUETNBHIGXFLLEHUKEXGJLO9BBALXMNGJKTETFIZHSSKLOQXPXOSZRW'
        b'QP9A9RIHWEHATMSVMZEQPGAUQBCIAQXZSUUFSU9HYK9RAVASYCVNALKJJXAJF9RLTD'
        b'ZEIIYCFLQVMHBPBFHHQNXVEKPHOOFTQEIVB9IXZMTOFBHTGLPWDYVPO9HHBPVWZYEG'
        b'IDMK9UPWEJDLIPJSIGFKKCZFRJVDN9ENWADNOTFWZGUDJRRUMFPVXHNAJBBCI9WEDK'
        b'RKCQUHRQTCFYFHXPOFBC9BCENMI9HRSIUAKLWEAOUXRBWMHWLGEOCP9NWIJAXODJDS'
        b'P9SKEXEDVUGHZAFPNMR9PXD9THOWNWWTDTWTYMDINGC9EBBVUYZRUQDVSIOXAEVGFP'
        b'XS9CLTHUESMTDWUJNCZSOIOEJG9WKNAZMDJGMRBXGVMLUAN9IGDVFAESJMXNTMNFND'
        b'CAXEBRAU9'
      )

    self.assertEqual(
      TryteString.from_trits(key.get_digest_trits()),

      TryteString(
        b'ABQXVJNER9MPMXMBPNMFBMDGTXRWSYHNZKGAGUOI'
        b'JKOJGZVGHCUXXGFZEMMGDSGWDCKJXO9ILLFAKGGZE'
      ),
    )

  def test_get_digest_trits_multiple_fragments(self):
    """
    Generating digest trits from a PrivateKey longer than 1 fragment.
    """
    key =\
      PrivateKey(
        b'LXZFBGXJCSEHJFVQOJBSBDWVPNHSTKGMNZQYVFKAJTFSIVMXQIRIQYHRCFVDKYCCVK'
        b'VGPRZRZUXXUIV9ZPJSWXZ9FUHBVYFGNWTGMX9LXPTALCML9ASKROTEVORSSQZHWEMF'
        b'UPNFQCEHXTEALKZVSHHALJXAPMGFASSHHCREWFCSYJFWLSKJZOFLLMTGWSSJZLJQOH'
        b'GQAHICAMRHHWZAIAALSUDPWBSRILGBQILJQUGIIOCNDGSYUSXRVPAZFKARRXVBDQLW'
        b'YZFR9FKIDUBODORNUXBOKDURIFHBRLTSIWOTUVQNMKXJGWYEVXCTKVQWDXJ9ZPLTIH'
        b'DEW9ERC9EFNKCWBNSUXGYLPG9PYERCIHBWNGTHWRSNNYPADKIUWMJVNWALHCCVSMYZ'
        b'GFIBFUXULLAJNZYQRLVYZHOQEPEURBITZIF9XWSOTEXEI9DBCM9VZPLURONGEIXMVU'
        b'RPZRUSAOLZPYMIXKPV9SWSXSPQSRALB99IVDBFXJC9SPXPUTMKTEKKJMPNC9SFDGIR'
        b'BVMRQKGG9FWVZMWSCLGANOQENXZZVHESO9TXRRZGGKVGIJYZKULWSBWYFALOXFWHFI'
        b'TTQWIQGJSEYRH9CIYPTYOERARZQVRUTIBR9QTJUIQXZ9FFKGPBBWHUVIGGKSXVBCUP'
        b'YGESTDRCVKDJLHNXJUTGUFPOTTTDYVMOOE9DDXAAJVSULTWCQOJBAWKVZSLKGAEYOV'
        b'WXNULJZPPJGJJXMIEQWKPHBHWZEUJYOZ9FXMKFT9RMBTXTPAKAWMJTPZVPT9SKCRHU'
        b'KOSFPQWLIFQYOVOBISWFKARPKR9JZMQOXHLNZVVUQGZVAWKMI9KZBGELPCCYENZUKX'
        b'FVGZJTDZZIPTJESWSFJUSRU9IHGEJXSHBRRSJZAHCK9STAKIDYTVXEVHZFKYXUSTTM'
        b'ERPQGBIINLMXHZHVWGFKBMQXULTONGQPLHMUACQSIVCYMHKGSVWEHYARSVECJMWBWW'
        b'DLSGVTPZAKCRYXYLEEAHOUNVLNLFPXGNRKAZSSLVTVBDTBVCTEBW9FP9IROYSINOFH'
        b'PZNYPHX9CVWDMTYXUFLHR9R9MCI9BGLIBHKCDENREOEPXCLMSYQZDIDES9KIURUSJQ'
        b'JL9IEUAOLJYKJTLE9UYVBSPRAGMTQYKOHNWGHXUBYZAOMBBTMGOEXKJEYMWUSSIRDO'
        b'IMHNTWWOKHYVDDKOYFTYFOGAZ9MHJVNKRYGFXYEUFBQPMYFCFBAIXXIFHVTPRPDOXS'
        b'QVIKTSNONSNQKYIRULCQRMEOKSAXTDGJGSZKUPLWJITS9ZQOLEFPPSDSSA9DHGDJMT'
        b'MAETSNDB9BSIVVPYIKD9ESAYOSYJSKJBRJOJOWBEJWSI9PJT9BYJDROWYHAZJBLUJX'
        b'GAZGUYJKTRJJIRCRUWRRKVDAKMFGHJQKYDENHJYNLBUTVNKNFYYHEYGPLVGGPLBWZR'
        b'HUMEHELSDRJDLRIYORNSLNOWCDBFKPESBQSNSDZUGCCJHLJJEHUWGOYBBAFJNL9QCF'
        b'ROADVYXELOOO9OFRM9OMJYS9VZLVUONKTPXJBHKYMUDSYKHUJBJCNRZXQBYYVAHDJS'
        b'WOVPGWQUUWKHFWI9PTCKFROSFNSZUKBBNJ9NZWWGXWEMSLTQ9YJFBPBFEACG9WLTK9'
        b'MNBNEYDPCLQVRIHMCIBEHNTQOXQRUXKQFCJYHJREBTSYAHDCWJBDVKAKKHULI99BIS'
        b'9IVUDVCDFWTUUNFAGEKFGTQBEIYYUCOLIBTUSCNTQCJXZWCHQATRPOTJP9LNCEMSVO'
        b'BNGMYVXTJWWLFXPDVNOIVIMBNBPEIGJCONYPLVSHVVDNOPMQMINRXCWFCOSYMDV9S9'
        b'ZA9YFXAAVRWXWSAQLYTKKZAZEZCTWVHMBG9HTTJXYJSGBUJZXRPDGHBQIHWQQVRPNN'
        b'WAYISDZCLKWZLPLUEF9TKCCA9YBUYQBZFVLVDRZ9AHZAEQNAQ9IQWKKXCMVDDJRBKE'
        b'LJHVTLDUUMQLDXYTOWYKPMCQW9YBGD9VUJLCJWQEN9RISZKTNNCDLXVFMNGNBCDWQG'
        b'WRLPWKALPJDRDZFCLTONVQUZPUISJRVYOBVCXEICEQRNOTXMWTPTEHAYROEVQNPO9K'
        b'IFCIBXHL9MJM9JYOXYDKZEF9DLURXGXPQGVUZQB9EKPLBQXQQYCXBYUBAQVCKUJDJA'
        b'CCXQINZTZWMSEBNGBDORPZKMVGGZSPIUKLRAMXGKSIULOJBRBTGXWEVMWQEALSZVLC'
        b'MXQIKZIIMLSVRDGIZWBVZUUIKGYXNTFNSLBXEQKBBUOYPLSDCGJPTVGYAGDD9JNVZY'
        b'UUXWUQJ9DUPDGWCXOEEVVQPOZLRGYBMPAWGMKNUCMWDIKIHHAPPN9BIKCFHDEORXRX'
        b'STBFGBCRDSPNBZDRZHFSMXNXHSKAZF9XYKOWFNTGUUHMUOWXHAROKHZOLWECDVRDXO'
        b'RDHANPIYZFETYBAOPPHTMTZMLDLQXZVYGXYKUDUNFWVPESWBFRTOJRRCPMKIBTQHFG'
        b'SPATWEXLWRFFQI9RKZBY9RZDVMVZCCWTS9PNRCTP9FRCGPOCVUJZIRZPU9WJPBHDTB'
        b'DSZSGI9HYHRBEBRQECBJEIZDXZOGGYZUPSEQLMQBTRQANDWG9RWGXAUYPRBSJRULMS'
        b'BJVPIFJWQPWEMY9YHDULM99VOIIDHRJQMHCZQAZCITZPKNSOBGSQDLOVWCZOLQEHBD'
        b'VIMDRWWXY9LWHTRBWUASPTMA9UPRILCALBIUFUELQDAKSD9WADUZESCBNNNZCQLXBI'
        b'FCNGGUBZTWSKQ9QHQLE9LBLWNKOQJYNSD9SRASRCGLICBCX9VNAGXAP9NFJUGWCZAI'
        b'QLBCQKSLFGXDRMEXKAHLMOE9VKFRFKCBLRNZVIARBRKEZMLEKIMMMGEJRLWMJFCLHT'
        b'LMXYYVKJFX9M9HIDHLBVFUKHMJRJOCWRHHTGLXDEWTTFGSMUHVOK9VDPOABLMZQGGP'
        b'FYIDMQIELYYLOCIXYAASYUFGVQDCEESUEJWOJCNNRMFKHXFCYMLXIEFMAHJRZ9TBZF'
        b'BSZOCDJPUPBLNBTNYHIAUYQKLPMMNNDEIPEFUAMTMYMXCENQCIJRWWZASXIHCMYLMB'
        b'GYRUDEYCYJPYPOEOAWENQLKMGCFMLVRJYMCHEYWBJZMOLSATAVIORHIEAHVPDEKPZW'
        b'KTPPGTTCRWJTDKABHHETSYLXJOQXJSYKMT9OJEEIOKAYWTLIWUTSAYZ9IDNWJLKKOY'
        b'VMGCJQIMROINJVPRKUQJCTDLFHZQDAOMDIAJYY9NQ9WZZIKHBFLYXOOWRHDRGJYNCD'
        b'BIEYCBAZMQNMNBTLGOBUTBMUDFOKTZ9BCBPOVNJXDHGMGITUMSPKAQ9R9PFCNCKPDP'
        b'HZLVTQCSKVJOIEYXUEOOIMWVIKKKNRNENRDFUXP9WJNWXJHBJIXPJQBRNOHOBQGKSY'
        b'UKCAMZKLWJETFNZGYIWBLARTNYHWLUBXRBHOO99RECDLSWBOOVJ9OEAWKPRBVWUUK9'
        b'ASGWAIS9CIPFAJRXFEDCSSMOXFASWKDZZKRGMBLD9GU9CWWBXW9DEU9IKENDNYEWOP'
        b'ZRUJUEK9YMNERGQOXUBGVNIGWDXXUVBKMSQWCGSDSIMKEFOBLIGPFCPNQ9QLNSLK9O'
        b'NMGNJMRI9KUQNTSMFGXAGYJVUQO9JDLDBUIQQJIEZCTFJS9VIKIIIDSQFBBAGUGOTA'
        b'VO9WZQXKBJSZBZDUTUSZ9GZAZQXTUHYTLCZQLRMURZLTYMNBPE9QFZOUVRRDRAEEAI'
        b'9OVJXPEWOWEESPUKMBGGBAYLLTFLBPNM9VVYNWTCRCIHEKKGU9RGQWGKEREBUXTELB'
        b'XTP9VQQMPGZHIJFBIWE9GSPTJHCMSKE9HXU9XISYRVCFXSQZO9CSXGAZUBINTCRKFH'
        b'OPFXUHDTWAZVMQWRZQQVMUVACIIDETVJLUXY9TEJGMWLGMMJ9SWTFNUHRI9SFVHBSJ'
        b'J9MRWCKFRJJJL9DECJL9XDHKWHYHLMSSXRIBBHC9PNWKIIQYITKUHENQWBMNALETH9'
        b'F9KIWDJXHPGSGYIKLJNQEZGXZJDKWCNGPFKSATLYNNYRCKCBBCEH9ADIZICTXOUKSS'
        b'WAPSHQKIBMOZKIPHLNHDSDVNRMWIFDYATUHFJSZFGYCSRKFERXBPVWUU9WKFPHAZJ9'
        b'LQCDSMZJWQGMFTHZNYEFBTNJ9TCNWMEZWQVRYFBVIWNSWDJDVJMFCRRDYLBYECAFW9'
        b'KXMX9LRLWLFIGAHBGF9YJODGYKULATHVYBCHUQTDZXKUKGVVJCDBJUJKRDN9EKCTBY'
        b'NQMGSIPDCTJVCX9INTPUZ9BXITIPKLHO9ESBOFSWLYNYXPCWRQCEOZTM9UYAAZSDHB'
        b'9BTFJNLZA9NTCKSAIZ'
      )

    self.assertEqual(
      TryteString.from_trits(key.get_digest_trits()),

      # Note that the digest is 2 hashes long, because the key
      # is 2 fragments long.
      TryteString(
        b'XCLECABPSBFYWJQNKXJAHB9QPJLAIJJBFUQNGUWDNVCVFQWXECVLYXUYHKW9XQECWC'
        b'IVNEDMSJWL9PDEQGVKTYZQXPAMHIJGJXQIJJRSLPCVNAUUYJSIDOHYXUNDQYVBPYDD'
        b'EZMFJQRAIMPVATMWLFHJXAISQTQYWX'
      ),
    )
