# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_container.configuration import Configuration


class OCIBuildImage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'containerfile_artifact': 'str',
        'containerfile': 'file',
        'tag': 'str',
        'artifacts': 'object'
    }

    attribute_map = {
        'containerfile_artifact': 'containerfile_artifact',
        'containerfile': 'containerfile',
        'tag': 'tag',
        'artifacts': 'artifacts'
    }

    def __init__(self, containerfile_artifact=None, containerfile=None, tag='latest', artifacts=None, local_vars_configuration=None):  # noqa: E501
        """OCIBuildImage - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._containerfile_artifact = None
        self._containerfile = None
        self._tag = None
        self._artifacts = None
        self.discriminator = None

        if containerfile_artifact is not None:
            self.containerfile_artifact = containerfile_artifact
        if containerfile is not None:
            self.containerfile = containerfile
        if tag is not None:
            self.tag = tag
        if artifacts is not None:
            self.artifacts = artifacts

    @property
    def containerfile_artifact(self):
        """Gets the containerfile_artifact of this OCIBuildImage.  # noqa: E501

        Artifact representing the Containerfile that should be used to run buildah.  # noqa: E501

        :return: The containerfile_artifact of this OCIBuildImage.  # noqa: E501
        :rtype: str
        """
        return self._containerfile_artifact

    @containerfile_artifact.setter
    def containerfile_artifact(self, containerfile_artifact):
        """Sets the containerfile_artifact of this OCIBuildImage.

        Artifact representing the Containerfile that should be used to run buildah.  # noqa: E501

        :param containerfile_artifact: The containerfile_artifact of this OCIBuildImage.  # noqa: E501
        :type: str
        """

        self._containerfile_artifact = containerfile_artifact

    @property
    def containerfile(self):
        """Gets the containerfile of this OCIBuildImage.  # noqa: E501

        An uploaded Containerfile that should be used to run buildah.  # noqa: E501

        :return: The containerfile of this OCIBuildImage.  # noqa: E501
        :rtype: file
        """
        return self._containerfile

    @containerfile.setter
    def containerfile(self, containerfile):
        """Sets the containerfile of this OCIBuildImage.

        An uploaded Containerfile that should be used to run buildah.  # noqa: E501

        :param containerfile: The containerfile of this OCIBuildImage.  # noqa: E501
        :type: file
        """

        self._containerfile = containerfile

    @property
    def tag(self):
        """Gets the tag of this OCIBuildImage.  # noqa: E501

        A tag name for the new image being built.  # noqa: E501

        :return: The tag of this OCIBuildImage.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this OCIBuildImage.

        A tag name for the new image being built.  # noqa: E501

        :param tag: The tag of this OCIBuildImage.  # noqa: E501
        :type: str
        """

        self._tag = tag

    @property
    def artifacts(self):
        """Gets the artifacts of this OCIBuildImage.  # noqa: E501

        A JSON string where each key is an artifact href and the value is it's relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.  # noqa: E501

        :return: The artifacts of this OCIBuildImage.  # noqa: E501
        :rtype: object
        """
        return self._artifacts

    @artifacts.setter
    def artifacts(self, artifacts):
        """Sets the artifacts of this OCIBuildImage.

        A JSON string where each key is an artifact href and the value is it's relative path (name) inside the /pulp_working_directory of the build container executing the Containerfile.  # noqa: E501

        :param artifacts: The artifacts of this OCIBuildImage.  # noqa: E501
        :type: object
        """

        self._artifacts = artifacts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OCIBuildImage):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OCIBuildImage):
            return True

        return self.to_dict() != other.to_dict()
