/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
class SemaphoredDelegatingExecutor
extends ForwardingListeningExecutorService {
    private final Semaphore queueingPermits;
    private final ListeningExecutorService executorDelegatee;
    private final int permitCount;

    SemaphoredDelegatingExecutor(ListeningExecutorService executorDelegatee, int permitCount, boolean fair) {
        this.permitCount = permitCount;
        this.queueingPermits = new Semaphore(permitCount, fair);
        this.executorDelegatee = executorDelegatee;
    }

    protected ListeningExecutorService delegate() {
        return this.executorDelegatee;
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("Not implemented");
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("Not implemented");
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task), result);
    }

    public ListenableFuture<?> submit(Runnable task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task));
    }

    public void execute(Runnable command) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute((Runnable)new RunnableWithPermitRelease(command));
    }

    public int getAvailablePermits() {
        return this.queueingPermits.availablePermits();
    }

    public int getWaitingCount() {
        return this.queueingPermits.getQueueLength();
    }

    public int getPermitCount() {
        return this.permitCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SemaphoredDelegatingExecutor{");
        sb.append("permitCount=").append(this.getPermitCount());
        sb.append(", available=").append(this.getAvailablePermits());
        sb.append(", waiting=").append(this.getWaitingCount());
        sb.append('}');
        return sb.toString();
    }

    class CallableWithPermitRelease<T>
    implements Callable<T> {
        private Callable<T> delegatee;

        public CallableWithPermitRelease(Callable<T> delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.delegatee.call();
                return t;
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }

    class RunnableWithPermitRelease
    implements Runnable {
        private Runnable delegatee;

        public RunnableWithPermitRelease(Runnable delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public void run() {
            try {
                this.delegatee.run();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }
}

