# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 project_id: str,
                 activated_apis: Optional[Sequence[str]] = None,
                 billing_account_id: Optional[str] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[str] = None,
                 project_name: Optional[str] = None):
        """
        The set of arguments for constructing a Project resource.
        :param str project_id: The project ID.
        :param Sequence[str] activated_apis: A list of APIs to be managed as part of the project
        :param str billing_account_id: The ID of the billing account this project belongs to. If not specified, then you may not specify APIs to activate for the project.
        :param pulumi.Input[str] folder_id: The numeric ID of the folder this project should be created under. Conflicts with `orgID`.
        :param str org_id: The numeric ID of the organization this project belongs to. Conflicts with `projectID`.
        :param str project_name: The display name of the project. ProjectID will be used as the display name if empty
        """
        pulumi.set(__self__, "project_id", project_id)
        if activated_apis is not None:
            pulumi.set(__self__, "activated_apis", activated_apis)
        if billing_account_id is not None:
            pulumi.set(__self__, "billing_account_id", billing_account_id)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="projectID")
    def project_id(self) -> str:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: str):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="activatedApis")
    def activated_apis(self) -> Optional[Sequence[str]]:
        """
        A list of APIs to be managed as part of the project
        """
        return pulumi.get(self, "activated_apis")

    @activated_apis.setter
    def activated_apis(self, value: Optional[Sequence[str]]):
        pulumi.set(self, "activated_apis", value)

    @property
    @pulumi.getter(name="billingAccountID")
    def billing_account_id(self) -> Optional[str]:
        """
        The ID of the billing account this project belongs to. If not specified, then you may not specify APIs to activate for the project.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: Optional[str]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter(name="folderID")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The numeric ID of the folder this project should be created under. Conflicts with `orgID`.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="orgID")
    def org_id(self) -> Optional[str]:
        """
        The numeric ID of the organization this project belongs to. Conflicts with `projectID`.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The display name of the project. ProjectID will be used as the display name if empty
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[str]):
        pulumi.set(self, "project_name", value)


class Project(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated_apis: Optional[Sequence[str]] = None,
                 billing_account_id: Optional[str] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[str] = None,
                 project_id: Optional[str] = None,
                 project_name: Optional[str] = None,
                 __props__=None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Sequence[str] activated_apis: A list of APIs to be managed as part of the project
        :param str billing_account_id: The ID of the billing account this project belongs to. If not specified, then you may not specify APIs to activate for the project.
        :param pulumi.Input[str] folder_id: The numeric ID of the folder this project should be created under. Conflicts with `orgID`.
        :param str org_id: The numeric ID of the organization this project belongs to. Conflicts with `projectID`.
        :param str project_id: The project ID.
        :param str project_name: The display name of the project. ProjectID will be used as the display name if empty
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Project resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated_apis: Optional[Sequence[str]] = None,
                 billing_account_id: Optional[str] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[str] = None,
                 project_id: Optional[str] = None,
                 project_name: Optional[str] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["activated_apis"] = activated_apis
            __props__.__dict__["billing_account_id"] = billing_account_id
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["org_id"] = org_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["project_name"] = project_name
        super(Project, __self__).__init__(
            'gcp-scaffold:index:project',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="projectID")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The display name of the project.
        """
        return pulumi.get(self, "project_name")

