"""
    VIER Cognitive Voice Recording API

    With the Recording API, client applications can manage recordings that have previously been created using the Call or Assist APIs.  # noqa: E501

    The version of the OpenAPI document: 1.24.4
    Contact: support@vier.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cvg_sdk.api_client import ApiClient, Endpoint as _Endpoint
from cvg_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cvg_sdk.model.dialog_phase import DialogPhase
from cvg_sdk.model.recording_objects_response import RecordingObjectsResponse
from cvg_sdk.model.recording_id import RecordingId


class RecordingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.delete_recording_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/recording/{resellerToken}/{dialogId}',
                'operation_id': 'delete_recording',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'reseller_token',
                    'dialog_id',
                    'phase',
                    'id',
                ],
                'required': [
                    'reseller_token',
                    'dialog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {
                        'max_length': 50,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reseller_token':
                        (str,),
                    'dialog_id':
                        (str,),
                    'phase':
                        (DialogPhase,),
                    'id':
                        (RecordingId,),
                },
                'attribute_map': {
                    'reseller_token': 'resellerToken',
                    'dialog_id': 'dialogId',
                    'phase': 'phase',
                    'id': 'id',
                },
                'location_map': {
                    'reseller_token': 'path',
                    'dialog_id': 'path',
                    'phase': 'query',
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_recording_artifacts_endpoint = _Endpoint(
            settings={
                'response_type': (RecordingObjectsResponse,),
                'auth': [],
                'endpoint_path': '/recording/{resellerToken}/{dialogId}',
                'operation_id': 'get_recording_artifacts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'reseller_token',
                    'dialog_id',
                    'phase',
                    'id',
                ],
                'required': [
                    'reseller_token',
                    'dialog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {
                        'max_length': 50,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'reseller_token':
                        (str,),
                    'dialog_id':
                        (str,),
                    'phase':
                        (DialogPhase,),
                    'id':
                        (RecordingId,),
                },
                'attribute_map': {
                    'reseller_token': 'resellerToken',
                    'dialog_id': 'dialogId',
                    'phase': 'phase',
                    'id': 'id',
                },
                'location_map': {
                    'reseller_token': 'path',
                    'dialog_id': 'path',
                    'phase': 'query',
                    'id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def delete_recording(
        self,
        reseller_token,
        dialog_id,
        **kwargs
    ):
        """Delete recording  # noqa: E501

        Deletes recording artifacts for the dialog.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_recording(reseller_token, dialog_id, async_req=True)
        >>> result = thread.get()

        Args:
            reseller_token (str):
            dialog_id (str):

        Keyword Args:
            phase (DialogPhase): Omitting the phase will select the bot dialog. [optional]
            id (RecordingId): Omitting the recording ID will select the default recording of the selected phase.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['reseller_token'] = \
            reseller_token
        kwargs['dialog_id'] = \
            dialog_id
        return self.delete_recording_endpoint.call_with_http_info(**kwargs)

    def get_recording_artifacts(
        self,
        reseller_token,
        dialog_id,
        **kwargs
    ):
        """Get download URLs for recording  # noqa: E501

        Retrieves recording artifacts for the dialog. Recordings are generally not immediately available after a dialog ends. The bot will receive a notification (see Bot API for endpoint details) once the recording has been processed and is available using this API.  Once the recordings are downloaded you can use the `DELETE` verb on this endpoint to remove the recording, otherwise the recording will be stored until the retention period configured on the project expires.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_recording_artifacts(reseller_token, dialog_id, async_req=True)
        >>> result = thread.get()

        Args:
            reseller_token (str):
            dialog_id (str):

        Keyword Args:
            phase (DialogPhase): Omitting the phase will select the bot dialog. [optional]
            id (RecordingId): Omitting the recording ID will select the default recording of the selected phase.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RecordingObjectsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['reseller_token'] = \
            reseller_token
        kwargs['dialog_id'] = \
            dialog_id
        return self.get_recording_artifacts_endpoint.call_with_http_info(**kwargs)

