# cvg-python-sdk
CVG health

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.24.4
- Package version: 0.5.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cvg_sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cvg_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import cvg_sdk
from pprint import pprint
from cvg_sdk.api import health_api
from cvg_sdk.model.project_health import ProjectHealth
from cvg_sdk.model.time_range import TimeRange
# Defining the host is optional and defaults to https://cognitivevoice.io/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = cvg_sdk.Configuration(
    host = "https://cognitivevoice.io/v1"
)



# Enter a context with an instance of the API client
with cvg_sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = health_api.HealthApi(api_client)
    reseller_token = "eb1c739c-06e0-4f4c-8056-8665e31425e1" # str | 
    project_token = "07c7c91f-16e7-4891-984a-ee421f4c3ffc" # str | 
    time_range = TimeRange("ABSOLUTE") # TimeRange | - For `ABSOLUTE` time ranges, the `start` and `end` query parameters are required. - For `RELATIVE` time ranges, the `delta` query parameter is required. - If unspecified, a relative time range of 10 minutes is used. (optional)
    start = 1535546718115 # int | The start of an `ABSOLUTE` time range in milliseconds since the epoch (1970-01-01). (optional)
    end = 1535546718115 # int | The end of an `ABSOLUTE` time range in milliseconds since the epoch (1970-01-01). (optional)
    delta = 1 # int | The duration (in milliseconds) to subtract from \"now\" to obtain a `RELATIVE` time range. (optional)

    try:
        # Get the health status of a project based on calls within a time range (by default the last 10 minutes). NOTE: this API is still experimental and subject to change.
        api_response = api_instance.get_project_health(reseller_token, project_token, time_range=time_range, start=start, end=end, delta=delta)
        pprint(api_response)
    except cvg_sdk.ApiException as e:
        print("Exception when calling HealthApi->get_project_health: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://cognitivevoice.io/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthApi* | [**get_project_health**](docs/HealthApi.md#get_project_health) | **GET** /health/{resellerToken}/project/{projectToken} | Get the health status of a project based on calls within a time range (by default the last 10 minutes). NOTE: this API is still experimental and subject to change.


## Documentation For Models

 - [AggregatedLatencies](docs/AggregatedLatencies.md)
 - [AudioPlaybackFailed](docs/AudioPlaybackFailed.md)
 - [AudioPlaybackFailedAllOf](docs/AudioPlaybackFailedAllOf.md)
 - [EndpointCall](docs/EndpointCall.md)
 - [EndpointCallAllOf](docs/EndpointCallAllOf.md)
 - [EndpointCallFailed](docs/EndpointCallFailed.md)
 - [EndpointCallFailedAllOf](docs/EndpointCallFailedAllOf.md)
 - [HealthEventStatus](docs/HealthEventStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InternalError](docs/InternalError.md)
 - [InternalErrorAllOf](docs/InternalErrorAllOf.md)
 - [Language](docs/Language.md)
 - [ProjectHealth](docs/ProjectHealth.md)
 - [ProjectHealthEvent](docs/ProjectHealthEvent.md)
 - [ProvisioningTimedOut](docs/ProvisioningTimedOut.md)
 - [SpeechServiceConfiguration](docs/SpeechServiceConfiguration.md)
 - [SpeechServiceFailedProperties](docs/SpeechServiceFailedProperties.md)
 - [Synthesis](docs/Synthesis.md)
 - [SynthesisFailed](docs/SynthesisFailed.md)
 - [TimeRange](docs/TimeRange.md)
 - [Transcription](docs/Transcription.md)
 - [TranscriptionAllOf](docs/TranscriptionAllOf.md)
 - [TranscriptionFailed](docs/TranscriptionFailed.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

support@vier.ai


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in cvg_sdk.apis and cvg_sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from cvg_sdk.api.default_api import DefaultApi`
- `from cvg_sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import cvg_sdk
from cvg_sdk.apis import *
from cvg_sdk.models import *
```

