# coding: utf-8

"""
    Model Catalog

    This is the API of the  Software Description Ontology at [https://mintproject.github.io/Mint-ModelCatalog-Ontology/release/1.3.0/index-en.html](https://w3id.org/okn/o/sdm)  # noqa: E501

    OpenAPI spec version: v1.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class SoftwareConfiguration(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'has_documentation': 'list[str]',
        'keywords': 'list[str]',
        'has_implementation_script_location': 'list[str]',
        'software_requirements': 'list[str]',
        'has_download_url': 'list[str]',
        'type': 'list[str]',
        'has_installation_instructions': 'list[str]',
        'compatible_visualization_software': 'list[Software]',
        'has_faq': 'list[str]',
        'has_contact_person': 'list[object]',
        'logo': 'list[Image]',
        'id': 'str',
        'identifier': 'list[str]',
        'has_sample_execution': 'list[SampleExecution]',
        'has_sample_result': 'list[SampleResource]',
        'author': 'list[object]',
        'has_constraint': 'list[str]',
        'short_description': 'list[str]',
        'has_execution_command': 'list[str]',
        'date_published': 'list[str]',
        'license': 'list[str]',
        'has_source_code': 'list[SourceCode]',
        'has_setup': 'list[ConfigurationSetup]',
        'has_example': 'list[str]',
        'publisher': 'list[object]',
        'has_output': 'list[DatasetSpecification]',
        'has_funding': 'list[FundingInformation]',
        'has_component_location': 'list[str]',
        'support_details': 'list[str]',
        'has_version': 'list[SoftwareVersion]',
        'has_typical_data_source': 'list[str]',
        'description': 'list[str]',
        'reference_publication': 'list[str]',
        'screenshot': 'list[Image]',
        'had_primary_source': 'list[object]',
        'has_software_image': 'list[SoftwareImage]',
        'date_created': 'list[str]',
        'contributor': 'list[Person]',
        'has_purpose': 'list[str]',
        'has_sample_visualization': 'list[Visualization]',
        'memory_requirements': 'list[str]',
        'website': 'list[str]',
        'citation': 'list[str]',
        'processor_requirements': 'list[str]',
        'has_usage_notes': 'list[str]',
        'has_support_script_location': 'list[str]',
        'label': 'list[str]',
        'has_assumption': 'list[str]',
        'has_parameter': 'list[Parameter]',
        'operating_systems': 'list[str]',
        'has_input': 'list[DatasetSpecification]'
    }

    attribute_map = {
        'has_documentation': 'hasDocumentation',
        'keywords': 'keywords',
        'has_implementation_script_location': 'hasImplementationScriptLocation',
        'software_requirements': 'softwareRequirements',
        'has_download_url': 'hasDownloadURL',
        'type': 'type',
        'has_installation_instructions': 'hasInstallationInstructions',
        'compatible_visualization_software': 'compatibleVisualizationSoftware',
        'has_faq': 'hasFAQ',
        'has_contact_person': 'hasContactPerson',
        'logo': 'logo',
        'id': 'id',
        'identifier': 'identifier',
        'has_sample_execution': 'hasSampleExecution',
        'has_sample_result': 'hasSampleResult',
        'author': 'author',
        'has_constraint': 'hasConstraint',
        'short_description': 'shortDescription',
        'has_execution_command': 'hasExecutionCommand',
        'date_published': 'datePublished',
        'license': 'license',
        'has_source_code': 'hasSourceCode',
        'has_setup': 'hasSetup',
        'has_example': 'hasExample',
        'publisher': 'publisher',
        'has_output': 'hasOutput',
        'has_funding': 'hasFunding',
        'has_component_location': 'hasComponentLocation',
        'support_details': 'supportDetails',
        'has_version': 'hasVersion',
        'has_typical_data_source': 'hasTypicalDataSource',
        'description': 'description',
        'reference_publication': 'referencePublication',
        'screenshot': 'screenshot',
        'had_primary_source': 'hadPrimarySource',
        'has_software_image': 'hasSoftwareImage',
        'date_created': 'dateCreated',
        'contributor': 'contributor',
        'has_purpose': 'hasPurpose',
        'has_sample_visualization': 'hasSampleVisualization',
        'memory_requirements': 'memoryRequirements',
        'website': 'website',
        'citation': 'citation',
        'processor_requirements': 'processorRequirements',
        'has_usage_notes': 'hasUsageNotes',
        'has_support_script_location': 'hasSupportScriptLocation',
        'label': 'label',
        'has_assumption': 'hasAssumption',
        'has_parameter': 'hasParameter',
        'operating_systems': 'operatingSystems',
        'has_input': 'hasInput'
    }

    def __init__(self, has_documentation=None, keywords=None, has_implementation_script_location=None, software_requirements=None, has_download_url=None, type=None, has_installation_instructions=None, compatible_visualization_software=None, has_faq=None, has_contact_person=None, logo=None, id=None, identifier=None, has_sample_execution=None, has_sample_result=None, author=None, has_constraint=None, short_description=None, has_execution_command=None, date_published=None, license=None, has_source_code=None, has_setup=None, has_example=None, publisher=None, has_output=None, has_funding=None, has_component_location=None, support_details=None, has_version=None, has_typical_data_source=None, description=None, reference_publication=None, screenshot=None, had_primary_source=None, has_software_image=None, date_created=None, contributor=None, has_purpose=None, has_sample_visualization=None, memory_requirements=None, website=None, citation=None, processor_requirements=None, has_usage_notes=None, has_support_script_location=None, label=None, has_assumption=None, has_parameter=None, operating_systems=None, has_input=None):  # noqa: E501
        """SoftwareConfiguration - a model defined in OpenAPI"""  # noqa: E501

        self._has_documentation = None
        self._keywords = None
        self._has_implementation_script_location = None
        self._software_requirements = None
        self._has_download_url = None
        self._type = None
        self._has_installation_instructions = None
        self._compatible_visualization_software = None
        self._has_faq = None
        self._has_contact_person = None
        self._logo = None
        self._id = None
        self._identifier = None
        self._has_sample_execution = None
        self._has_sample_result = None
        self._author = None
        self._has_constraint = None
        self._short_description = None
        self._has_execution_command = None
        self._date_published = None
        self._license = None
        self._has_source_code = None
        self._has_setup = None
        self._has_example = None
        self._publisher = None
        self._has_output = None
        self._has_funding = None
        self._has_component_location = None
        self._support_details = None
        self._has_version = None
        self._has_typical_data_source = None
        self._description = None
        self._reference_publication = None
        self._screenshot = None
        self._had_primary_source = None
        self._has_software_image = None
        self._date_created = None
        self._contributor = None
        self._has_purpose = None
        self._has_sample_visualization = None
        self._memory_requirements = None
        self._website = None
        self._citation = None
        self._processor_requirements = None
        self._has_usage_notes = None
        self._has_support_script_location = None
        self._label = None
        self._has_assumption = None
        self._has_parameter = None
        self._operating_systems = None
        self._has_input = None
        self.discriminator = None

        if has_documentation is not None:
            self.has_documentation = has_documentation
        else:
            if hasattr(self, '_has_documentation'): del self._has_documentation
            if hasattr(self.attribute_map, 'has_documentation'): del self.attribute_map['has_documentation']
            if hasattr(self.openapi_types, 'has_documentation'): del self.openapi_types['has_documentation']
        if keywords is not None:
            self.keywords = keywords
        else:
            if hasattr(self, '_keywords'): del self._keywords
            if hasattr(self.attribute_map, 'keywords'): del self.attribute_map['keywords']
            if hasattr(self.openapi_types, 'keywords'): del self.openapi_types['keywords']
        if has_implementation_script_location is not None:
            self.has_implementation_script_location = has_implementation_script_location
        else:
            if hasattr(self, '_has_implementation_script_location'): del self._has_implementation_script_location
            if hasattr(self.attribute_map, 'has_implementation_script_location'): del self.attribute_map['has_implementation_script_location']
            if hasattr(self.openapi_types, 'has_implementation_script_location'): del self.openapi_types['has_implementation_script_location']
        if software_requirements is not None:
            self.software_requirements = software_requirements
        else:
            if hasattr(self, '_software_requirements'): del self._software_requirements
            if hasattr(self.attribute_map, 'software_requirements'): del self.attribute_map['software_requirements']
            if hasattr(self.openapi_types, 'software_requirements'): del self.openapi_types['software_requirements']
        if has_download_url is not None:
            self.has_download_url = has_download_url
        else:
            if hasattr(self, '_has_download_url'): del self._has_download_url
            if hasattr(self.attribute_map, 'has_download_url'): del self.attribute_map['has_download_url']
            if hasattr(self.openapi_types, 'has_download_url'): del self.openapi_types['has_download_url']
        if type is not None:
            self.type = type
        else:
            if hasattr(self, '_type'): del self._type
            if hasattr(self.attribute_map, 'type'): del self.attribute_map['type']
            if hasattr(self.openapi_types, 'type'): del self.openapi_types['type']
        if has_installation_instructions is not None:
            self.has_installation_instructions = has_installation_instructions
        else:
            if hasattr(self, '_has_installation_instructions'): del self._has_installation_instructions
            if hasattr(self.attribute_map, 'has_installation_instructions'): del self.attribute_map['has_installation_instructions']
            if hasattr(self.openapi_types, 'has_installation_instructions'): del self.openapi_types['has_installation_instructions']
        if compatible_visualization_software is not None:
            self.compatible_visualization_software = compatible_visualization_software
        else:
            if hasattr(self, '_compatible_visualization_software'): del self._compatible_visualization_software
            if hasattr(self.attribute_map, 'compatible_visualization_software'): del self.attribute_map['compatible_visualization_software']
            if hasattr(self.openapi_types, 'compatible_visualization_software'): del self.openapi_types['compatible_visualization_software']
        if has_faq is not None:
            self.has_faq = has_faq
        else:
            if hasattr(self, '_has_faq'): del self._has_faq
            if hasattr(self.attribute_map, 'has_faq'): del self.attribute_map['has_faq']
            if hasattr(self.openapi_types, 'has_faq'): del self.openapi_types['has_faq']
        if has_contact_person is not None:
            self.has_contact_person = has_contact_person
        else:
            if hasattr(self, '_has_contact_person'): del self._has_contact_person
            if hasattr(self.attribute_map, 'has_contact_person'): del self.attribute_map['has_contact_person']
            if hasattr(self.openapi_types, 'has_contact_person'): del self.openapi_types['has_contact_person']
        if logo is not None:
            self.logo = logo
        else:
            if hasattr(self, '_logo'): del self._logo
            if hasattr(self.attribute_map, 'logo'): del self.attribute_map['logo']
            if hasattr(self.openapi_types, 'logo'): del self.openapi_types['logo']
        if id is not None:
            self.id = id
        if identifier is not None:
            self.identifier = identifier
        else:
            if hasattr(self, '_identifier'): del self._identifier
            if hasattr(self.attribute_map, 'identifier'): del self.attribute_map['identifier']
            if hasattr(self.openapi_types, 'identifier'): del self.openapi_types['identifier']
        if has_sample_execution is not None:
            self.has_sample_execution = has_sample_execution
        else:
            if hasattr(self, '_has_sample_execution'): del self._has_sample_execution
            if hasattr(self.attribute_map, 'has_sample_execution'): del self.attribute_map['has_sample_execution']
            if hasattr(self.openapi_types, 'has_sample_execution'): del self.openapi_types['has_sample_execution']
        if has_sample_result is not None:
            self.has_sample_result = has_sample_result
        else:
            if hasattr(self, '_has_sample_result'): del self._has_sample_result
            if hasattr(self.attribute_map, 'has_sample_result'): del self.attribute_map['has_sample_result']
            if hasattr(self.openapi_types, 'has_sample_result'): del self.openapi_types['has_sample_result']
        if author is not None:
            self.author = author
        else:
            if hasattr(self, '_author'): del self._author
            if hasattr(self.attribute_map, 'author'): del self.attribute_map['author']
            if hasattr(self.openapi_types, 'author'): del self.openapi_types['author']
        if has_constraint is not None:
            self.has_constraint = has_constraint
        else:
            if hasattr(self, '_has_constraint'): del self._has_constraint
            if hasattr(self.attribute_map, 'has_constraint'): del self.attribute_map['has_constraint']
            if hasattr(self.openapi_types, 'has_constraint'): del self.openapi_types['has_constraint']
        if short_description is not None:
            self.short_description = short_description
        else:
            if hasattr(self, '_short_description'): del self._short_description
            if hasattr(self.attribute_map, 'short_description'): del self.attribute_map['short_description']
            if hasattr(self.openapi_types, 'short_description'): del self.openapi_types['short_description']
        if has_execution_command is not None:
            self.has_execution_command = has_execution_command
        else:
            if hasattr(self, '_has_execution_command'): del self._has_execution_command
            if hasattr(self.attribute_map, 'has_execution_command'): del self.attribute_map['has_execution_command']
            if hasattr(self.openapi_types, 'has_execution_command'): del self.openapi_types['has_execution_command']
        if date_published is not None:
            self.date_published = date_published
        else:
            if hasattr(self, '_date_published'): del self._date_published
            if hasattr(self.attribute_map, 'date_published'): del self.attribute_map['date_published']
            if hasattr(self.openapi_types, 'date_published'): del self.openapi_types['date_published']
        if license is not None:
            self.license = license
        else:
            if hasattr(self, '_license'): del self._license
            if hasattr(self.attribute_map, 'license'): del self.attribute_map['license']
            if hasattr(self.openapi_types, 'license'): del self.openapi_types['license']
        if has_source_code is not None:
            self.has_source_code = has_source_code
        else:
            if hasattr(self, '_has_source_code'): del self._has_source_code
            if hasattr(self.attribute_map, 'has_source_code'): del self.attribute_map['has_source_code']
            if hasattr(self.openapi_types, 'has_source_code'): del self.openapi_types['has_source_code']
        if has_setup is not None:
            self.has_setup = has_setup
        else:
            if hasattr(self, '_has_setup'): del self._has_setup
            if hasattr(self.attribute_map, 'has_setup'): del self.attribute_map['has_setup']
            if hasattr(self.openapi_types, 'has_setup'): del self.openapi_types['has_setup']
        if has_example is not None:
            self.has_example = has_example
        else:
            if hasattr(self, '_has_example'): del self._has_example
            if hasattr(self.attribute_map, 'has_example'): del self.attribute_map['has_example']
            if hasattr(self.openapi_types, 'has_example'): del self.openapi_types['has_example']
        if publisher is not None:
            self.publisher = publisher
        else:
            if hasattr(self, '_publisher'): del self._publisher
            if hasattr(self.attribute_map, 'publisher'): del self.attribute_map['publisher']
            if hasattr(self.openapi_types, 'publisher'): del self.openapi_types['publisher']
        if has_output is not None:
            self.has_output = has_output
        else:
            if hasattr(self, '_has_output'): del self._has_output
            if hasattr(self.attribute_map, 'has_output'): del self.attribute_map['has_output']
            if hasattr(self.openapi_types, 'has_output'): del self.openapi_types['has_output']
        if has_funding is not None:
            self.has_funding = has_funding
        else:
            if hasattr(self, '_has_funding'): del self._has_funding
            if hasattr(self.attribute_map, 'has_funding'): del self.attribute_map['has_funding']
            if hasattr(self.openapi_types, 'has_funding'): del self.openapi_types['has_funding']
        if has_component_location is not None:
            self.has_component_location = has_component_location
        else:
            if hasattr(self, '_has_component_location'): del self._has_component_location
            if hasattr(self.attribute_map, 'has_component_location'): del self.attribute_map['has_component_location']
            if hasattr(self.openapi_types, 'has_component_location'): del self.openapi_types['has_component_location']
        if support_details is not None:
            self.support_details = support_details
        else:
            if hasattr(self, '_support_details'): del self._support_details
            if hasattr(self.attribute_map, 'support_details'): del self.attribute_map['support_details']
            if hasattr(self.openapi_types, 'support_details'): del self.openapi_types['support_details']
        if has_version is not None:
            self.has_version = has_version
        else:
            if hasattr(self, '_has_version'): del self._has_version
            if hasattr(self.attribute_map, 'has_version'): del self.attribute_map['has_version']
            if hasattr(self.openapi_types, 'has_version'): del self.openapi_types['has_version']
        if has_typical_data_source is not None:
            self.has_typical_data_source = has_typical_data_source
        else:
            if hasattr(self, '_has_typical_data_source'): del self._has_typical_data_source
            if hasattr(self.attribute_map, 'has_typical_data_source'): del self.attribute_map['has_typical_data_source']
            if hasattr(self.openapi_types, 'has_typical_data_source'): del self.openapi_types['has_typical_data_source']
        if description is not None:
            self.description = description
        else:
            if hasattr(self, '_description'): del self._description
            if hasattr(self.attribute_map, 'description'): del self.attribute_map['description']
            if hasattr(self.openapi_types, 'description'): del self.openapi_types['description']
        if reference_publication is not None:
            self.reference_publication = reference_publication
        else:
            if hasattr(self, '_reference_publication'): del self._reference_publication
            if hasattr(self.attribute_map, 'reference_publication'): del self.attribute_map['reference_publication']
            if hasattr(self.openapi_types, 'reference_publication'): del self.openapi_types['reference_publication']
        if screenshot is not None:
            self.screenshot = screenshot
        else:
            if hasattr(self, '_screenshot'): del self._screenshot
            if hasattr(self.attribute_map, 'screenshot'): del self.attribute_map['screenshot']
            if hasattr(self.openapi_types, 'screenshot'): del self.openapi_types['screenshot']
        if had_primary_source is not None:
            self.had_primary_source = had_primary_source
        else:
            if hasattr(self, '_had_primary_source'): del self._had_primary_source
            if hasattr(self.attribute_map, 'had_primary_source'): del self.attribute_map['had_primary_source']
            if hasattr(self.openapi_types, 'had_primary_source'): del self.openapi_types['had_primary_source']
        if has_software_image is not None:
            self.has_software_image = has_software_image
        else:
            if hasattr(self, '_has_software_image'): del self._has_software_image
            if hasattr(self.attribute_map, 'has_software_image'): del self.attribute_map['has_software_image']
            if hasattr(self.openapi_types, 'has_software_image'): del self.openapi_types['has_software_image']
        if date_created is not None:
            self.date_created = date_created
        else:
            if hasattr(self, '_date_created'): del self._date_created
            if hasattr(self.attribute_map, 'date_created'): del self.attribute_map['date_created']
            if hasattr(self.openapi_types, 'date_created'): del self.openapi_types['date_created']
        if contributor is not None:
            self.contributor = contributor
        else:
            if hasattr(self, '_contributor'): del self._contributor
            if hasattr(self.attribute_map, 'contributor'): del self.attribute_map['contributor']
            if hasattr(self.openapi_types, 'contributor'): del self.openapi_types['contributor']
        if has_purpose is not None:
            self.has_purpose = has_purpose
        else:
            if hasattr(self, '_has_purpose'): del self._has_purpose
            if hasattr(self.attribute_map, 'has_purpose'): del self.attribute_map['has_purpose']
            if hasattr(self.openapi_types, 'has_purpose'): del self.openapi_types['has_purpose']
        if has_sample_visualization is not None:
            self.has_sample_visualization = has_sample_visualization
        else:
            if hasattr(self, '_has_sample_visualization'): del self._has_sample_visualization
            if hasattr(self.attribute_map, 'has_sample_visualization'): del self.attribute_map['has_sample_visualization']
            if hasattr(self.openapi_types, 'has_sample_visualization'): del self.openapi_types['has_sample_visualization']
        if memory_requirements is not None:
            self.memory_requirements = memory_requirements
        else:
            if hasattr(self, '_memory_requirements'): del self._memory_requirements
            if hasattr(self.attribute_map, 'memory_requirements'): del self.attribute_map['memory_requirements']
            if hasattr(self.openapi_types, 'memory_requirements'): del self.openapi_types['memory_requirements']
        if website is not None:
            self.website = website
        else:
            if hasattr(self, '_website'): del self._website
            if hasattr(self.attribute_map, 'website'): del self.attribute_map['website']
            if hasattr(self.openapi_types, 'website'): del self.openapi_types['website']
        if citation is not None:
            self.citation = citation
        else:
            if hasattr(self, '_citation'): del self._citation
            if hasattr(self.attribute_map, 'citation'): del self.attribute_map['citation']
            if hasattr(self.openapi_types, 'citation'): del self.openapi_types['citation']
        if processor_requirements is not None:
            self.processor_requirements = processor_requirements
        else:
            if hasattr(self, '_processor_requirements'): del self._processor_requirements
            if hasattr(self.attribute_map, 'processor_requirements'): del self.attribute_map['processor_requirements']
            if hasattr(self.openapi_types, 'processor_requirements'): del self.openapi_types['processor_requirements']
        if has_usage_notes is not None:
            self.has_usage_notes = has_usage_notes
        else:
            if hasattr(self, '_has_usage_notes'): del self._has_usage_notes
            if hasattr(self.attribute_map, 'has_usage_notes'): del self.attribute_map['has_usage_notes']
            if hasattr(self.openapi_types, 'has_usage_notes'): del self.openapi_types['has_usage_notes']
        if has_support_script_location is not None:
            self.has_support_script_location = has_support_script_location
        else:
            if hasattr(self, '_has_support_script_location'): del self._has_support_script_location
            if hasattr(self.attribute_map, 'has_support_script_location'): del self.attribute_map['has_support_script_location']
            if hasattr(self.openapi_types, 'has_support_script_location'): del self.openapi_types['has_support_script_location']
        if label is not None:
            self.label = label
        else:
            if hasattr(self, '_label'): del self._label
            if hasattr(self.attribute_map, 'label'): del self.attribute_map['label']
            if hasattr(self.openapi_types, 'label'): del self.openapi_types['label']
        if has_assumption is not None:
            self.has_assumption = has_assumption
        else:
            if hasattr(self, '_has_assumption'): del self._has_assumption
            if hasattr(self.attribute_map, 'has_assumption'): del self.attribute_map['has_assumption']
            if hasattr(self.openapi_types, 'has_assumption'): del self.openapi_types['has_assumption']
        if has_parameter is not None:
            self.has_parameter = has_parameter
        else:
            if hasattr(self, '_has_parameter'): del self._has_parameter
            if hasattr(self.attribute_map, 'has_parameter'): del self.attribute_map['has_parameter']
            if hasattr(self.openapi_types, 'has_parameter'): del self.openapi_types['has_parameter']
        if operating_systems is not None:
            self.operating_systems = operating_systems
        else:
            if hasattr(self, '_operating_systems'): del self._operating_systems
            if hasattr(self.attribute_map, 'operating_systems'): del self.attribute_map['operating_systems']
            if hasattr(self.openapi_types, 'operating_systems'): del self.openapi_types['operating_systems']
        if has_input is not None:
            self.has_input = has_input
        else:
            if hasattr(self, '_has_input'): del self._has_input
            if hasattr(self.attribute_map, 'has_input'): del self.attribute_map['has_input']
            if hasattr(self.openapi_types, 'has_input'): del self.openapi_types['has_input']

    @property
    def has_documentation(self):
        """Gets the has_documentation of this SoftwareConfiguration.  # noqa: E501


        :return: The has_documentation of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_documentation

    @has_documentation.setter
    def has_documentation(self, has_documentation):
        """Sets the has_documentation of this SoftwareConfiguration.


        :param has_documentation: The has_documentation of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_documentation = has_documentation

    @property
    def keywords(self):
        """Gets the keywords of this SoftwareConfiguration.  # noqa: E501


        :return: The keywords of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """Sets the keywords of this SoftwareConfiguration.


        :param keywords: The keywords of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._keywords = keywords

    @property
    def has_implementation_script_location(self):
        """Gets the has_implementation_script_location of this SoftwareConfiguration.  # noqa: E501


        :return: The has_implementation_script_location of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_implementation_script_location

    @has_implementation_script_location.setter
    def has_implementation_script_location(self, has_implementation_script_location):
        """Sets the has_implementation_script_location of this SoftwareConfiguration.


        :param has_implementation_script_location: The has_implementation_script_location of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_implementation_script_location = has_implementation_script_location

    @property
    def software_requirements(self):
        """Gets the software_requirements of this SoftwareConfiguration.  # noqa: E501


        :return: The software_requirements of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._software_requirements

    @software_requirements.setter
    def software_requirements(self, software_requirements):
        """Sets the software_requirements of this SoftwareConfiguration.


        :param software_requirements: The software_requirements of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._software_requirements = software_requirements

    @property
    def has_download_url(self):
        """Gets the has_download_url of this SoftwareConfiguration.  # noqa: E501


        :return: The has_download_url of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_download_url

    @has_download_url.setter
    def has_download_url(self, has_download_url):
        """Sets the has_download_url of this SoftwareConfiguration.


        :param has_download_url: The has_download_url of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_download_url = has_download_url

    @property
    def type(self):
        """Gets the type of this SoftwareConfiguration.  # noqa: E501


        :return: The type of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SoftwareConfiguration.


        :param type: The type of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._type = type

    @property
    def has_installation_instructions(self):
        """Gets the has_installation_instructions of this SoftwareConfiguration.  # noqa: E501


        :return: The has_installation_instructions of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_installation_instructions

    @has_installation_instructions.setter
    def has_installation_instructions(self, has_installation_instructions):
        """Sets the has_installation_instructions of this SoftwareConfiguration.


        :param has_installation_instructions: The has_installation_instructions of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_installation_instructions = has_installation_instructions

    @property
    def compatible_visualization_software(self):
        """Gets the compatible_visualization_software of this SoftwareConfiguration.  # noqa: E501


        :return: The compatible_visualization_software of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Software]
        """
        return self._compatible_visualization_software

    @compatible_visualization_software.setter
    def compatible_visualization_software(self, compatible_visualization_software):
        """Sets the compatible_visualization_software of this SoftwareConfiguration.


        :param compatible_visualization_software: The compatible_visualization_software of this SoftwareConfiguration.  # noqa: E501
        :type: list[Software]
        """

        self._compatible_visualization_software = compatible_visualization_software

    @property
    def has_faq(self):
        """Gets the has_faq of this SoftwareConfiguration.  # noqa: E501


        :return: The has_faq of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_faq

    @has_faq.setter
    def has_faq(self, has_faq):
        """Sets the has_faq of this SoftwareConfiguration.


        :param has_faq: The has_faq of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_faq = has_faq

    @property
    def has_contact_person(self):
        """Gets the has_contact_person of this SoftwareConfiguration.  # noqa: E501


        :return: The has_contact_person of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._has_contact_person

    @has_contact_person.setter
    def has_contact_person(self, has_contact_person):
        """Sets the has_contact_person of this SoftwareConfiguration.


        :param has_contact_person: The has_contact_person of this SoftwareConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._has_contact_person = has_contact_person

    @property
    def logo(self):
        """Gets the logo of this SoftwareConfiguration.  # noqa: E501


        :return: The logo of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Image]
        """
        return self._logo

    @logo.setter
    def logo(self, logo):
        """Sets the logo of this SoftwareConfiguration.


        :param logo: The logo of this SoftwareConfiguration.  # noqa: E501
        :type: list[Image]
        """

        self._logo = logo

    @property
    def id(self):
        """Gets the id of this SoftwareConfiguration.  # noqa: E501


        :return: The id of this SoftwareConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SoftwareConfiguration.


        :param id: The id of this SoftwareConfiguration.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def identifier(self):
        """Gets the identifier of this SoftwareConfiguration.  # noqa: E501


        :return: The identifier of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this SoftwareConfiguration.


        :param identifier: The identifier of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._identifier = identifier

    @property
    def has_sample_execution(self):
        """Gets the has_sample_execution of this SoftwareConfiguration.  # noqa: E501


        :return: The has_sample_execution of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[SampleExecution]
        """
        return self._has_sample_execution

    @has_sample_execution.setter
    def has_sample_execution(self, has_sample_execution):
        """Sets the has_sample_execution of this SoftwareConfiguration.


        :param has_sample_execution: The has_sample_execution of this SoftwareConfiguration.  # noqa: E501
        :type: list[SampleExecution]
        """

        self._has_sample_execution = has_sample_execution

    @property
    def has_sample_result(self):
        """Gets the has_sample_result of this SoftwareConfiguration.  # noqa: E501


        :return: The has_sample_result of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[SampleResource]
        """
        return self._has_sample_result

    @has_sample_result.setter
    def has_sample_result(self, has_sample_result):
        """Sets the has_sample_result of this SoftwareConfiguration.


        :param has_sample_result: The has_sample_result of this SoftwareConfiguration.  # noqa: E501
        :type: list[SampleResource]
        """

        self._has_sample_result = has_sample_result

    @property
    def author(self):
        """Gets the author of this SoftwareConfiguration.  # noqa: E501


        :return: The author of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this SoftwareConfiguration.


        :param author: The author of this SoftwareConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._author = author

    @property
    def has_constraint(self):
        """Gets the has_constraint of this SoftwareConfiguration.  # noqa: E501


        :return: The has_constraint of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_constraint

    @has_constraint.setter
    def has_constraint(self, has_constraint):
        """Sets the has_constraint of this SoftwareConfiguration.


        :param has_constraint: The has_constraint of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_constraint = has_constraint

    @property
    def short_description(self):
        """Gets the short_description of this SoftwareConfiguration.  # noqa: E501


        :return: The short_description of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """Sets the short_description of this SoftwareConfiguration.


        :param short_description: The short_description of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._short_description = short_description

    @property
    def has_execution_command(self):
        """Gets the has_execution_command of this SoftwareConfiguration.  # noqa: E501


        :return: The has_execution_command of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_execution_command

    @has_execution_command.setter
    def has_execution_command(self, has_execution_command):
        """Sets the has_execution_command of this SoftwareConfiguration.


        :param has_execution_command: The has_execution_command of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_execution_command = has_execution_command

    @property
    def date_published(self):
        """Gets the date_published of this SoftwareConfiguration.  # noqa: E501


        :return: The date_published of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """Sets the date_published of this SoftwareConfiguration.


        :param date_published: The date_published of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._date_published = date_published

    @property
    def license(self):
        """Gets the license of this SoftwareConfiguration.  # noqa: E501


        :return: The license of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._license

    @license.setter
    def license(self, license):
        """Sets the license of this SoftwareConfiguration.


        :param license: The license of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._license = license

    @property
    def has_source_code(self):
        """Gets the has_source_code of this SoftwareConfiguration.  # noqa: E501


        :return: The has_source_code of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[SourceCode]
        """
        return self._has_source_code

    @has_source_code.setter
    def has_source_code(self, has_source_code):
        """Sets the has_source_code of this SoftwareConfiguration.


        :param has_source_code: The has_source_code of this SoftwareConfiguration.  # noqa: E501
        :type: list[SourceCode]
        """

        self._has_source_code = has_source_code

    @property
    def has_setup(self):
        """Gets the has_setup of this SoftwareConfiguration.  # noqa: E501


        :return: The has_setup of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[ConfigurationSetup]
        """
        return self._has_setup

    @has_setup.setter
    def has_setup(self, has_setup):
        """Sets the has_setup of this SoftwareConfiguration.


        :param has_setup: The has_setup of this SoftwareConfiguration.  # noqa: E501
        :type: list[ConfigurationSetup]
        """

        self._has_setup = has_setup

    @property
    def has_example(self):
        """Gets the has_example of this SoftwareConfiguration.  # noqa: E501


        :return: The has_example of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_example

    @has_example.setter
    def has_example(self, has_example):
        """Sets the has_example of this SoftwareConfiguration.


        :param has_example: The has_example of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_example = has_example

    @property
    def publisher(self):
        """Gets the publisher of this SoftwareConfiguration.  # noqa: E501


        :return: The publisher of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._publisher

    @publisher.setter
    def publisher(self, publisher):
        """Sets the publisher of this SoftwareConfiguration.


        :param publisher: The publisher of this SoftwareConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._publisher = publisher

    @property
    def has_output(self):
        """Gets the has_output of this SoftwareConfiguration.  # noqa: E501


        :return: The has_output of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[DatasetSpecification]
        """
        return self._has_output

    @has_output.setter
    def has_output(self, has_output):
        """Sets the has_output of this SoftwareConfiguration.


        :param has_output: The has_output of this SoftwareConfiguration.  # noqa: E501
        :type: list[DatasetSpecification]
        """

        self._has_output = has_output

    @property
    def has_funding(self):
        """Gets the has_funding of this SoftwareConfiguration.  # noqa: E501


        :return: The has_funding of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[FundingInformation]
        """
        return self._has_funding

    @has_funding.setter
    def has_funding(self, has_funding):
        """Sets the has_funding of this SoftwareConfiguration.


        :param has_funding: The has_funding of this SoftwareConfiguration.  # noqa: E501
        :type: list[FundingInformation]
        """

        self._has_funding = has_funding

    @property
    def has_component_location(self):
        """Gets the has_component_location of this SoftwareConfiguration.  # noqa: E501


        :return: The has_component_location of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_component_location

    @has_component_location.setter
    def has_component_location(self, has_component_location):
        """Sets the has_component_location of this SoftwareConfiguration.


        :param has_component_location: The has_component_location of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_component_location = has_component_location

    @property
    def support_details(self):
        """Gets the support_details of this SoftwareConfiguration.  # noqa: E501


        :return: The support_details of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._support_details

    @support_details.setter
    def support_details(self, support_details):
        """Sets the support_details of this SoftwareConfiguration.


        :param support_details: The support_details of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._support_details = support_details

    @property
    def has_version(self):
        """Gets the has_version of this SoftwareConfiguration.  # noqa: E501


        :return: The has_version of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[SoftwareVersion]
        """
        return self._has_version

    @has_version.setter
    def has_version(self, has_version):
        """Sets the has_version of this SoftwareConfiguration.


        :param has_version: The has_version of this SoftwareConfiguration.  # noqa: E501
        :type: list[SoftwareVersion]
        """

        self._has_version = has_version

    @property
    def has_typical_data_source(self):
        """Gets the has_typical_data_source of this SoftwareConfiguration.  # noqa: E501


        :return: The has_typical_data_source of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_typical_data_source

    @has_typical_data_source.setter
    def has_typical_data_source(self, has_typical_data_source):
        """Sets the has_typical_data_source of this SoftwareConfiguration.


        :param has_typical_data_source: The has_typical_data_source of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_typical_data_source = has_typical_data_source

    @property
    def description(self):
        """Gets the description of this SoftwareConfiguration.  # noqa: E501


        :return: The description of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SoftwareConfiguration.


        :param description: The description of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._description = description

    @property
    def reference_publication(self):
        """Gets the reference_publication of this SoftwareConfiguration.  # noqa: E501


        :return: The reference_publication of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._reference_publication

    @reference_publication.setter
    def reference_publication(self, reference_publication):
        """Sets the reference_publication of this SoftwareConfiguration.


        :param reference_publication: The reference_publication of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._reference_publication = reference_publication

    @property
    def screenshot(self):
        """Gets the screenshot of this SoftwareConfiguration.  # noqa: E501


        :return: The screenshot of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Image]
        """
        return self._screenshot

    @screenshot.setter
    def screenshot(self, screenshot):
        """Sets the screenshot of this SoftwareConfiguration.


        :param screenshot: The screenshot of this SoftwareConfiguration.  # noqa: E501
        :type: list[Image]
        """

        self._screenshot = screenshot

    @property
    def had_primary_source(self):
        """Gets the had_primary_source of this SoftwareConfiguration.  # noqa: E501


        :return: The had_primary_source of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[object]
        """
        return self._had_primary_source

    @had_primary_source.setter
    def had_primary_source(self, had_primary_source):
        """Sets the had_primary_source of this SoftwareConfiguration.


        :param had_primary_source: The had_primary_source of this SoftwareConfiguration.  # noqa: E501
        :type: list[object]
        """

        self._had_primary_source = had_primary_source

    @property
    def has_software_image(self):
        """Gets the has_software_image of this SoftwareConfiguration.  # noqa: E501


        :return: The has_software_image of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[SoftwareImage]
        """
        return self._has_software_image

    @has_software_image.setter
    def has_software_image(self, has_software_image):
        """Sets the has_software_image of this SoftwareConfiguration.


        :param has_software_image: The has_software_image of this SoftwareConfiguration.  # noqa: E501
        :type: list[SoftwareImage]
        """

        self._has_software_image = has_software_image

    @property
    def date_created(self):
        """Gets the date_created of this SoftwareConfiguration.  # noqa: E501


        :return: The date_created of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this SoftwareConfiguration.


        :param date_created: The date_created of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._date_created = date_created

    @property
    def contributor(self):
        """Gets the contributor of this SoftwareConfiguration.  # noqa: E501


        :return: The contributor of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Person]
        """
        return self._contributor

    @contributor.setter
    def contributor(self, contributor):
        """Sets the contributor of this SoftwareConfiguration.


        :param contributor: The contributor of this SoftwareConfiguration.  # noqa: E501
        :type: list[Person]
        """

        self._contributor = contributor

    @property
    def has_purpose(self):
        """Gets the has_purpose of this SoftwareConfiguration.  # noqa: E501


        :return: The has_purpose of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_purpose

    @has_purpose.setter
    def has_purpose(self, has_purpose):
        """Sets the has_purpose of this SoftwareConfiguration.


        :param has_purpose: The has_purpose of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_purpose = has_purpose

    @property
    def has_sample_visualization(self):
        """Gets the has_sample_visualization of this SoftwareConfiguration.  # noqa: E501


        :return: The has_sample_visualization of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Visualization]
        """
        return self._has_sample_visualization

    @has_sample_visualization.setter
    def has_sample_visualization(self, has_sample_visualization):
        """Sets the has_sample_visualization of this SoftwareConfiguration.


        :param has_sample_visualization: The has_sample_visualization of this SoftwareConfiguration.  # noqa: E501
        :type: list[Visualization]
        """

        self._has_sample_visualization = has_sample_visualization

    @property
    def memory_requirements(self):
        """Gets the memory_requirements of this SoftwareConfiguration.  # noqa: E501


        :return: The memory_requirements of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._memory_requirements

    @memory_requirements.setter
    def memory_requirements(self, memory_requirements):
        """Sets the memory_requirements of this SoftwareConfiguration.


        :param memory_requirements: The memory_requirements of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._memory_requirements = memory_requirements

    @property
    def website(self):
        """Gets the website of this SoftwareConfiguration.  # noqa: E501


        :return: The website of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._website

    @website.setter
    def website(self, website):
        """Sets the website of this SoftwareConfiguration.


        :param website: The website of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._website = website

    @property
    def citation(self):
        """Gets the citation of this SoftwareConfiguration.  # noqa: E501


        :return: The citation of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._citation

    @citation.setter
    def citation(self, citation):
        """Sets the citation of this SoftwareConfiguration.


        :param citation: The citation of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._citation = citation

    @property
    def processor_requirements(self):
        """Gets the processor_requirements of this SoftwareConfiguration.  # noqa: E501


        :return: The processor_requirements of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._processor_requirements

    @processor_requirements.setter
    def processor_requirements(self, processor_requirements):
        """Sets the processor_requirements of this SoftwareConfiguration.


        :param processor_requirements: The processor_requirements of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._processor_requirements = processor_requirements

    @property
    def has_usage_notes(self):
        """Gets the has_usage_notes of this SoftwareConfiguration.  # noqa: E501


        :return: The has_usage_notes of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_usage_notes

    @has_usage_notes.setter
    def has_usage_notes(self, has_usage_notes):
        """Sets the has_usage_notes of this SoftwareConfiguration.


        :param has_usage_notes: The has_usage_notes of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_usage_notes = has_usage_notes

    @property
    def has_support_script_location(self):
        """Gets the has_support_script_location of this SoftwareConfiguration.  # noqa: E501


        :return: The has_support_script_location of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_support_script_location

    @has_support_script_location.setter
    def has_support_script_location(self, has_support_script_location):
        """Sets the has_support_script_location of this SoftwareConfiguration.


        :param has_support_script_location: The has_support_script_location of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_support_script_location = has_support_script_location

    @property
    def label(self):
        """Gets the label of this SoftwareConfiguration.  # noqa: E501


        :return: The label of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this SoftwareConfiguration.


        :param label: The label of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._label = label

    @property
    def has_assumption(self):
        """Gets the has_assumption of this SoftwareConfiguration.  # noqa: E501


        :return: The has_assumption of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._has_assumption

    @has_assumption.setter
    def has_assumption(self, has_assumption):
        """Sets the has_assumption of this SoftwareConfiguration.


        :param has_assumption: The has_assumption of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._has_assumption = has_assumption

    @property
    def has_parameter(self):
        """Gets the has_parameter of this SoftwareConfiguration.  # noqa: E501


        :return: The has_parameter of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[Parameter]
        """
        return self._has_parameter

    @has_parameter.setter
    def has_parameter(self, has_parameter):
        """Sets the has_parameter of this SoftwareConfiguration.


        :param has_parameter: The has_parameter of this SoftwareConfiguration.  # noqa: E501
        :type: list[Parameter]
        """

        self._has_parameter = has_parameter

    @property
    def operating_systems(self):
        """Gets the operating_systems of this SoftwareConfiguration.  # noqa: E501


        :return: The operating_systems of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._operating_systems

    @operating_systems.setter
    def operating_systems(self, operating_systems):
        """Sets the operating_systems of this SoftwareConfiguration.


        :param operating_systems: The operating_systems of this SoftwareConfiguration.  # noqa: E501
        :type: list[str]
        """

        self._operating_systems = operating_systems

    @property
    def has_input(self):
        """Gets the has_input of this SoftwareConfiguration.  # noqa: E501


        :return: The has_input of this SoftwareConfiguration.  # noqa: E501
        :rtype: list[DatasetSpecification]
        """
        return self._has_input

    @has_input.setter
    def has_input(self, has_input):
        """Sets the has_input of this SoftwareConfiguration.


        :param has_input: The has_input of this SoftwareConfiguration.  # noqa: E501
        :type: list[DatasetSpecification]
        """

        self._has_input = has_input

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
            else:
                continue                
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SoftwareConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
